/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine.system;

import dev.dominion.ecs.engine.system.Config;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Logging {
    public static final String PROJECT_PROPERTIES = "dominion-ecs-java/project.properties";
    public static final String REVISION = "revision";
    public static final String DEFAULT_LOGGER = "util.logging";
    public static final System.Logger.Level DEFAULT_LOGGING_LEVEL = System.Logger.Level.INFO;
    private static final Level[] spi2JulLevelMapping = new Level[]{Level.ALL, Level.FINER, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final AtomicInteger levelIdx = new AtomicInteger(0);
    private static final System.Logger.Level[] levels = new System.Logger.Level[1024];
    private static int rootLevelOrdinal;

    public static System.Logger getLogger() {
        return System.getLogger("dominion." + STACK_WALKER.getCallerClass().getSimpleName());
    }

    public static int registerLoggingLevel(System.Logger.Level level) {
        int idx = levelIdx.getAndIncrement();
        Logging.levels[idx] = level;
        return idx;
    }

    public static boolean isLoggable(int idx, System.Logger.Level levelToCheck) {
        return levelToCheck.ordinal() >= rootLevelOrdinal && idx >= 0 && levelToCheck.ordinal() >= levels[idx].ordinal() && levels[idx] != System.Logger.Level.OFF;
    }

    public static String format(String subject, String message) {
        return "[" + subject + "] - " + message;
    }

    public static void printPanel(String ... rows) {
        System.out.println("---");
        for (String row : rows) {
            if (row == null) continue;
            System.out.println(". " + row);
        }
        System.out.println("---\n");
    }

    private static boolean isDefaultLogger() {
        return System.getLogger("").getClass().getName().contains(DEFAULT_LOGGER);
    }

    private static void showBanner(String version, System.Logger.Level level, boolean isDefaultLoggingLevel) {
        System.out.println("\n|) () |\\/| | |\\| | () |\\|\n");
        System.out.printf("%25s%n", "ECS v" + version);
        System.out.println();
        Logging.printPanel("Root Logging System", "  Logging-Level: '" + level + "'", isDefaultLoggingLevel ? "  Change the root level with the sys-property '" + Config.getPropertyName("logging-level") + "'." : null, Logging.isDefaultLogger() ? "  Dominion is compatible with all logging systems that support the 'System.Logger' Platform Logging API and Service (JEP 264)." : null);
    }

    private static String fetchPomVersion() throws IOException {
        InputStream is = Logging.class.getClassLoader().getResourceAsStream(PROJECT_PROPERTIES);
        if (is == null) {
            return "?";
        }
        Properties properties = new Properties();
        properties.load(is);
        return properties.getProperty(REVISION);
    }

    private static Optional<System.Logger.Level> setupDefaultLoggingLibrary() {
        Optional<System.Logger.Level> level = Config.fetchLoggingLevel("");
        System.setProperty("java.util.logging.SimpleFormatter.format", (Config.logCaller() ? "[%2$s] " : "") + "%4$4.4s %3$32.32s %5$s %6$s %n");
        Logger dominionRootLogger = Logger.getLogger("dominion.");
        Level julLevel = spi2JulLevelMapping[level.orElse(DEFAULT_LOGGING_LEVEL).ordinal()];
        dominionRootLogger.setLevel(julLevel);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(julLevel);
        dominionRootLogger.addHandler(consoleHandler);
        return level;
    }

    static {
        try {
            String version = Logging.fetchPomVersion();
            Optional<System.Logger.Level> level = Logging.setupDefaultLoggingLibrary();
            System.Logger.Level rootLevel = level.orElse(DEFAULT_LOGGING_LEVEL);
            rootLevelOrdinal = rootLevel.ordinal();
            Logging.registerLoggingLevel(rootLevel);
            if (Config.showBanner()) {
                Logging.showBanner(version, rootLevel, level.isEmpty());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public record Context(String subject, int levelIndex) {
        public static Context TEST = new Context("test", 0);
        public static Context STRESS_TEST = new Context("stress-test", -1);
    }
}

