/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine.system;

import dev.dominion.ecs.engine.system.UnsafeFactory;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class UncheckedUpdater<T> {
    private static final Unsafe unsafe = UnsafeFactory.INSTANCE;
    protected final long offset;

    protected UncheckedUpdater(Class<T> tClass, String fieldName) throws NoSuchFieldException {
        Field field = tClass.getDeclaredField(fieldName);
        this.offset = unsafe.objectFieldOffset(field);
    }

    public static final class Int<T>
    extends UncheckedUpdater<T> {
        public Int(Class<T> tClass, String fieldName) throws NoSuchFieldException {
            super(tClass, fieldName);
        }

        public boolean compareAndSet(T obj, int expect, int update) {
            return unsafe.compareAndSwapInt(obj, this.offset, expect, update);
        }
    }

    public static final class Reference<T, V>
    extends UncheckedUpdater<T> {
        public Reference(Class<T> tClass, String fieldName) throws NoSuchFieldException {
            super(tClass, fieldName);
        }

        public boolean compareAndSet(T obj, V expect, V update) {
            return unsafe.compareAndSwapObject(obj, this.offset, expect, update);
        }
    }
}

