// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package dev.eatsteak.rusaint.ffi

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.ConcurrentHashMap
import android.os.Build
import androidx.annotation.RequiresApi
import dev.eatsteak.rusaint.core.ChapelInformation
import dev.eatsteak.rusaint.core.ClassGrade
import dev.eatsteak.rusaint.core.CourseType
import dev.eatsteak.rusaint.core.FfiConverterTypeChapelInformation
import dev.eatsteak.rusaint.core.FfiConverterTypeClassGrade
import dev.eatsteak.rusaint.core.FfiConverterTypeCourseType
import dev.eatsteak.rusaint.core.FfiConverterTypeGradeSummary
import dev.eatsteak.rusaint.core.FfiConverterTypeGraduationRequirements
import dev.eatsteak.rusaint.core.FfiConverterTypeGraduationStudent
import dev.eatsteak.rusaint.core.FfiConverterTypeLecture
import dev.eatsteak.rusaint.core.FfiConverterTypeLectureAssessmentResult
import dev.eatsteak.rusaint.core.FfiConverterTypeLectureCategory
import dev.eatsteak.rusaint.core.FfiConverterTypePersonalCourseSchedule
import dev.eatsteak.rusaint.core.FfiConverterTypeScholarship
import dev.eatsteak.rusaint.core.FfiConverterTypeSemesterGrade
import dev.eatsteak.rusaint.core.FfiConverterTypeSemesterType
import dev.eatsteak.rusaint.core.FfiConverterTypeStudentAcademicRecords
import dev.eatsteak.rusaint.core.FfiConverterTypeStudentBankAccount
import dev.eatsteak.rusaint.core.FfiConverterTypeStudentFamily
import dev.eatsteak.rusaint.core.FfiConverterTypeStudentGraduation
import dev.eatsteak.rusaint.core.FfiConverterTypeStudentInformation
import dev.eatsteak.rusaint.core.FfiConverterTypeStudentQualification
import dev.eatsteak.rusaint.core.FfiConverterTypeStudentReligion
import dev.eatsteak.rusaint.core.FfiConverterTypeStudentResearchBankAccount
import dev.eatsteak.rusaint.core.FfiConverterTypeStudentTransferRecords
import dev.eatsteak.rusaint.core.FfiConverterTypeStudentWorkInformation
import dev.eatsteak.rusaint.core.GradeSummary
import dev.eatsteak.rusaint.core.GraduationRequirements
import dev.eatsteak.rusaint.core.GraduationStudent
import dev.eatsteak.rusaint.core.Lecture
import dev.eatsteak.rusaint.core.LectureAssessmentResult
import dev.eatsteak.rusaint.core.LectureCategory
import dev.eatsteak.rusaint.core.PersonalCourseSchedule
import dev.eatsteak.rusaint.core.Scholarship
import dev.eatsteak.rusaint.core.SemesterGrade
import dev.eatsteak.rusaint.core.SemesterType
import dev.eatsteak.rusaint.core.StudentAcademicRecords
import dev.eatsteak.rusaint.core.StudentBankAccount
import dev.eatsteak.rusaint.core.StudentFamily
import dev.eatsteak.rusaint.core.StudentGraduation
import dev.eatsteak.rusaint.core.StudentInformation
import dev.eatsteak.rusaint.core.StudentQualification
import dev.eatsteak.rusaint.core.StudentReligion
import dev.eatsteak.rusaint.core.StudentResearchBankAccount
import dev.eatsteak.rusaint.core.StudentTransferRecords
import dev.eatsteak.rusaint.core.StudentWorkInformation
import java.util.concurrent.atomic.AtomicBoolean
import kotlin.coroutines.resume
import kotlinx.coroutines.CancellableContinuation
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.launch
import kotlinx.coroutines.suspendCancellableCoroutine
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferChapelInformation
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferClassGrade
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferCourseType
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferGradeSummary
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferGraduationRequirements
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferGraduationStudent
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferLecture
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferLectureAssessmentResult
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferLectureCategory
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferPersonalCourseSchedule
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferScholarship
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferSemesterGrade
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferSemesterType
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferStudentAcademicRecords
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferStudentBankAccount
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferStudentFamily
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferStudentGraduation
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferStudentInformation
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferStudentQualification
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferStudentReligion
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferStudentResearchBankAccount
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferStudentTransferRecords
import dev.eatsteak.rusaint.core.RustBuffer as RustBufferStudentWorkInformation

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

/**
 * @suppress
 */
@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0
    @JvmField var len: Long = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

   internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) = uniffiRustCall() { status ->
            // Note: need to convert the size to a `Long` value to make this work with JVM.
            UniffiLib.INSTANCE.ffi_rusaint_ffi_rustbuffer_alloc(size.toLong(), status)
        }.also {
            if(it.data == null) {
               throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
           }
        }

        internal fun create(capacity: ULong, len: ULong, data: Pointer?): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) = uniffiRustCall() { status ->
            UniffiLib.INSTANCE.ffi_rusaint_ffi_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 *
 * @suppress
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setLong(0, value.capacity)
        pointer.setLong(8, value.len)
        pointer.setPointer(16, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getLong(0))
        value.writeField("len", pointer.getLong(8))
        value.writeField("data", pointer.getLong(16))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
internal open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
/**
 * The FfiConverter interface handles converter types to and from the FFI
 *
 * All implementing objects should be public to support external types.  When a
 * type is external we need to import it's FfiConverter.
 *
 * @suppress
 */
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

/**
 * FfiConverter that uses `RustBuffer` as the FfiType
 *
 * @suppress
 */
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: UniffiRustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == UNIFFI_CALL_SUCCESS
    }

    fun isError(): Boolean {
        return code == UNIFFI_CALL_ERROR
    }

    fun isPanic(): Boolean {
        return code == UNIFFI_CALL_UNEXPECTED_ERROR
    }

    companion object {
        fun create(code: Byte, errorBuf: RustBuffer.ByValue): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(message: String) : kotlin.Exception(message)

/**
 * Each top-level error class has a companion object that can lift the error from the call status's rust buffer
 *
 * @suppress
 */
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: kotlin.Exception> uniffiRustCallWithError(errorHandler: UniffiRustCallStatusErrorHandler<E>, callback: (UniffiRustCallStatus) -> U): U {
    var status = UniffiRustCallStatus()
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun<E: kotlin.Exception> uniffiCheckCallStatus(errorHandler: UniffiRustCallStatusErrorHandler<E>, status: UniffiRustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

/**
 * UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
 *
 * @suppress
 */
object UniffiNullRustCallStatusErrorHandler: UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U {
    return uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback)
}

internal inline fun<T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun<T, reified E: Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}
// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<Long, T>()
    private val counter = java.util.concurrent.atomic.AtomicLong(0)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(1)
        map.put(handle, obj)
        return handle
    }

    // Get an object from the handle map
    fun get(handle: Long): T {
        return map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")
    }

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T {
        return map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "rusaint_ffi"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(`data`: Long,`pollResult`: Byte,)
}
internal interface UniffiForeignFutureFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFuture(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureFree? = null,
    ): UniffiForeignFuture(`handle`,`free`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFuture) {
        `handle` = other.`handle`
        `free` = other.`free`
    }

}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructPointer(
    @JvmField internal var `returnValue`: Pointer = Pointer.NULL,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Pointer = Pointer.NULL,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructPointer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructPointer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompletePointer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructPointer.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructRustBuffer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructRustBuffer.UniffiByValue,)
}
@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureStructVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructVoid(`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructVoid) {
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructVoid.UniffiByValue,)
}
















































































































































































































// For large crates we prevent `MethodTooLargeException` (see #2340)
// N.B. the name of the extension is very misleading, since it is 
// rather `InterfaceTooLargeException`, caused by too many methods 
// in the interface for large crates.
//
// By splitting the otherwise huge interface into two parts
// * UniffiLib 
// * IntegrityCheckingUniffiLib (this)
// we allow for ~2x as many methods in the UniffiLib interface.
// 
// The `ffi_uniffi_contract_version` method and all checksum methods are put 
// into `IntegrityCheckingUniffiLib` and these methods are called only once,
// when the library is loaded.
internal interface IntegrityCheckingUniffiLib : Library {
    // Integrity check functions only
    fun uniffi_rusaint_ffi_checksum_method_chapelapplication_get_selected_semester(
): Short
fun uniffi_rusaint_ffi_checksum_method_chapelapplication_information(
): Short
fun uniffi_rusaint_ffi_checksum_method_chapelapplicationbuilder_build(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursegradesapplication_certificated_summary(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursegradesapplication_class_detail(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursegradesapplication_classes(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursegradesapplication_get_selected_semester(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursegradesapplication_recorded_summary(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursegradesapplication_semesters(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursegradesapplicationbuilder_build(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_chapel_categories(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_collages(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_connected_majors(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_departments(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_find_lectures(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_get_selected_semester(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_graduated_collages(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_graduated_departments(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_majors(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_optional_elective_categories(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_required_electives(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_united_majors(
): Short
fun uniffi_rusaint_ffi_checksum_method_coursescheduleapplicationbuilder_build(
): Short
fun uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplication_requirements(
): Short
fun uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplication_student_info(
): Short
fun uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplicationbuilder_build(
): Short
fun uniffi_rusaint_ffi_checksum_method_lectureassessmentapplication_find_assessments(
): Short
fun uniffi_rusaint_ffi_checksum_method_lectureassessmentapplication_get_selected_semester(
): Short
fun uniffi_rusaint_ffi_checksum_method_lectureassessmentapplicationbuilder_build(
): Short
fun uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplication_get_selected_semester(
): Short
fun uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplication_schedule(
): Short
fun uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplicationbuilder_build(
): Short
fun uniffi_rusaint_ffi_checksum_method_scholarshipsapplication_scholarships(
): Short
fun uniffi_rusaint_ffi_checksum_method_scholarshipsapplicationbuilder_build(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplication_academic_record(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplication_bank_account(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplication_family(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplication_general(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplication_graduation(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplication_qualifications(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplication_religion(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplication_research_bank_account(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplication_transfer(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplication_work(
): Short
fun uniffi_rusaint_ffi_checksum_method_studentinformationapplicationbuilder_build(
): Short
fun uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_anonymous(
): Short
fun uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_with_password(
): Short
fun uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_with_token(
): Short
fun uniffi_rusaint_ffi_checksum_constructor_chapelapplicationbuilder_new(
): Short
fun uniffi_rusaint_ffi_checksum_constructor_coursegradesapplicationbuilder_new(
): Short
fun uniffi_rusaint_ffi_checksum_constructor_coursescheduleapplicationbuilder_new(
): Short
fun uniffi_rusaint_ffi_checksum_constructor_graduationrequirementsapplicationbuilder_new(
): Short
fun uniffi_rusaint_ffi_checksum_constructor_lectureassessmentapplicationbuilder_new(
): Short
fun uniffi_rusaint_ffi_checksum_constructor_personalcoursescheduleapplicationbuilder_new(
): Short
fun uniffi_rusaint_ffi_checksum_constructor_scholarshipsapplicationbuilder_new(
): Short
fun uniffi_rusaint_ffi_checksum_constructor_studentinformationapplicationbuilder_new(
): Short
fun uniffi_rusaint_ffi_checksum_constructor_usaintsessionbuilder_new(
): Short
fun ffi_rusaint_ffi_uniffi_contract_version(
): Int

}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.
internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            val componentName = "rusaint_ffi"
            // For large crates we prevent `MethodTooLargeException` (see #2340)
            // N.B. the name of the extension is very misleading, since it is 
            // rather `InterfaceTooLargeException`, caused by too many methods 
            // in the interface for large crates.
            //
            // By splitting the otherwise huge interface into two parts
            // * UniffiLib (this)
            // * IntegrityCheckingUniffiLib
            // And all checksum methods are put into `IntegrityCheckingUniffiLib`
            // we allow for ~2x as many methods in the UniffiLib interface.
            // 
            // Thus we first load the library with `loadIndirect` as `IntegrityCheckingUniffiLib`
            // so that we can (optionally!) call `uniffiCheckApiChecksums`...
            loadIndirect<IntegrityCheckingUniffiLib>(componentName)
                .also { lib: IntegrityCheckingUniffiLib ->
                    uniffiCheckContractApiVersion(lib)
                    uniffiCheckApiChecksums(lib)
                }
            // ... and then we load the library as `UniffiLib`
            // N.B. we cannot use `loadIndirect` once and then try to cast it to `UniffiLib`
            // => results in `java.lang.ClassCastException: com.sun.proxy.$Proxy cannot be cast to ...`
            // error. So we must call `loadIndirect` twice. For crates large enough
            // to trigger this issue, the performance impact is negligible, running on
            // a macOS M1 machine the `loadIndirect` call takes ~50ms.
            val lib = loadIndirect<UniffiLib>(componentName)
            // No need to check the contract version and checksums, since 
            // we already did that with `IntegrityCheckingUniffiLib` above.
            dev.eatsteak.rusaint.core.uniffiEnsureInitialized()
            // Loading of library with integrity check done.
            lib
        }
        
        // The Cleaner for the whole library
        internal val CLEANER: UniffiCleaner by lazy {
            UniffiCleaner.create()
        }
    }

    // FFI functions
    fun uniffi_rusaint_ffi_fn_clone_chapelapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_chapelapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_method_chapelapplication_get_selected_semester(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_chapelapplication_information(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_clone_chapelapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_chapelapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_constructor_chapelapplicationbuilder_new(uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_method_chapelapplicationbuilder_build(`ptr`: Pointer,`session`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_coursegradesapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_coursegradesapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_method_coursegradesapplication_certificated_summary(`ptr`: Pointer,`courseType`: RustBufferCourseType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursegradesapplication_class_detail(`ptr`: Pointer,`courseType`: RustBufferCourseType.ByValue,`year`: Int,`semester`: RustBufferSemesterType.ByValue,`code`: RustBuffer.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursegradesapplication_classes(`ptr`: Pointer,`courseType`: RustBufferCourseType.ByValue,`year`: Int,`semester`: RustBufferSemesterType.ByValue,`includeDetails`: Byte,
): Long
fun uniffi_rusaint_ffi_fn_method_coursegradesapplication_get_selected_semester(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_coursegradesapplication_recorded_summary(`ptr`: Pointer,`courseType`: RustBufferCourseType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursegradesapplication_semesters(`ptr`: Pointer,`courseType`: RustBufferCourseType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_clone_coursegradesapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_coursegradesapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_constructor_coursegradesapplicationbuilder_new(uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_method_coursegradesapplicationbuilder_build(`ptr`: Pointer,`session`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_coursescheduleapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_coursescheduleapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_chapel_categories(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_collages(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_connected_majors(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_departments(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,`collage`: RustBuffer.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_find_lectures(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,`lectureCategory`: RustBufferLectureCategory.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_get_selected_semester(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_graduated_collages(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_graduated_departments(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,`collage`: RustBuffer.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_majors(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,`collage`: RustBuffer.ByValue,`department`: RustBuffer.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_optional_elective_categories(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_required_electives(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplication_united_majors(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_clone_coursescheduleapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_coursescheduleapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_constructor_coursescheduleapplicationbuilder_new(uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_method_coursescheduleapplicationbuilder_build(`ptr`: Pointer,`session`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_graduationrequirementsapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_graduationrequirementsapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_method_graduationrequirementsapplication_requirements(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_graduationrequirementsapplication_student_info(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_graduationrequirementsapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_graduationrequirementsapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_constructor_graduationrequirementsapplicationbuilder_new(uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_method_graduationrequirementsapplicationbuilder_build(`ptr`: Pointer,`session`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_lectureassessmentapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_lectureassessmentapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_method_lectureassessmentapplication_find_assessments(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,`lectureName`: RustBuffer.ByValue,`lectureCode`: RustBuffer.ByValue,`professorName`: RustBuffer.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_lectureassessmentapplication_get_selected_semester(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_lectureassessmentapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_lectureassessmentapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_constructor_lectureassessmentapplicationbuilder_new(uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_method_lectureassessmentapplicationbuilder_build(`ptr`: Pointer,`session`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_personalcoursescheduleapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_personalcoursescheduleapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplication_get_selected_semester(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplication_schedule(`ptr`: Pointer,`year`: Int,`semester`: RustBufferSemesterType.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_clone_personalcoursescheduleapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_personalcoursescheduleapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_constructor_personalcoursescheduleapplicationbuilder_new(uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplicationbuilder_build(`ptr`: Pointer,`session`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_scholarshipsapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_scholarshipsapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_method_scholarshipsapplication_scholarships(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_scholarshipsapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_scholarshipsapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_constructor_scholarshipsapplicationbuilder_new(uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_method_scholarshipsapplicationbuilder_build(`ptr`: Pointer,`session`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_studentinformationapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_studentinformationapplication(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_method_studentinformationapplication_academic_record(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_studentinformationapplication_bank_account(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_studentinformationapplication_family(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_studentinformationapplication_general(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_studentinformationapplication_graduation(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_studentinformationapplication_qualifications(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_studentinformationapplication_religion(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_studentinformationapplication_research_bank_account(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_studentinformationapplication_transfer(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_method_studentinformationapplication_work(`ptr`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_studentinformationapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_studentinformationapplicationbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_constructor_studentinformationapplicationbuilder_new(uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_method_studentinformationapplicationbuilder_build(`ptr`: Pointer,`session`: Pointer,
): Long
fun uniffi_rusaint_ffi_fn_clone_usaintsession(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_usaintsession(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_clone_usaintsessionbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_free_usaintsessionbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_rusaint_ffi_fn_constructor_usaintsessionbuilder_new(uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_anonymous(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_with_password(`ptr`: Pointer,`id`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,
): Long
fun uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_with_token(`ptr`: Pointer,`id`: RustBuffer.ByValue,`token`: RustBuffer.ByValue,
): Long
fun ffi_rusaint_ffi_rustbuffer_alloc(`size`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_rusaint_ffi_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_rusaint_ffi_rustbuffer_free(`buf`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun ffi_rusaint_ffi_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_rusaint_ffi_rust_future_poll_u8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_u8(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_u8(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_u8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun ffi_rusaint_ffi_rust_future_poll_i8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_i8(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_i8(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_i8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun ffi_rusaint_ffi_rust_future_poll_u16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_u16(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_u16(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_u16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Short
fun ffi_rusaint_ffi_rust_future_poll_i16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_i16(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_i16(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_i16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Short
fun ffi_rusaint_ffi_rust_future_poll_u32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_u32(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_u32(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_u32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Int
fun ffi_rusaint_ffi_rust_future_poll_i32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_i32(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_i32(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_i32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Int
fun ffi_rusaint_ffi_rust_future_poll_u64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_u64(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_u64(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_u64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun ffi_rusaint_ffi_rust_future_poll_i64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_i64(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_i64(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_i64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun ffi_rusaint_ffi_rust_future_poll_f32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_f32(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_f32(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_f32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Float
fun ffi_rusaint_ffi_rust_future_poll_f64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_f64(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_f64(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_f64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Double
fun ffi_rusaint_ffi_rust_future_poll_pointer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_pointer(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_pointer(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_pointer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun ffi_rusaint_ffi_rust_future_poll_rust_buffer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_rust_buffer(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_rust_buffer(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_rust_buffer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_rusaint_ffi_rust_future_poll_void(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_cancel_void(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_free_void(`handle`: Long,
): Unit
fun ffi_rusaint_ffi_rust_future_complete_void(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Unit

}

private fun uniffiCheckContractApiVersion(lib: IntegrityCheckingUniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 29
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_rusaint_ffi_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}
@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: IntegrityCheckingUniffiLib) {
    if (lib.uniffi_rusaint_ffi_checksum_method_chapelapplication_get_selected_semester() != 6133.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_chapelapplication_information() != 21740.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_chapelapplicationbuilder_build() != 32906.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_certificated_summary() != 8880.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_class_detail() != 3843.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_classes() != 12879.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_get_selected_semester() != 50223.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_recorded_summary() != 3787.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplication_semesters() != 55958.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursegradesapplicationbuilder_build() != 50139.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_chapel_categories() != 21428.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_collages() != 50658.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_connected_majors() != 24954.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_departments() != 10692.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_find_lectures() != 7590.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_get_selected_semester() != 52870.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_graduated_collages() != 29655.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_graduated_departments() != 42882.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_majors() != 356.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_optional_elective_categories() != 63165.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_required_electives() != 46039.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplication_united_majors() != 41228.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_coursescheduleapplicationbuilder_build() != 60808.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplication_requirements() != 63669.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplication_student_info() != 6063.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_graduationrequirementsapplicationbuilder_build() != 18426.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplication_find_assessments() != 53523.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplication_get_selected_semester() != 2234.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_lectureassessmentapplicationbuilder_build() != 52720.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplication_get_selected_semester() != 26180.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplication_schedule() != 58730.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_personalcoursescheduleapplicationbuilder_build() != 42578.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_scholarshipsapplication_scholarships() != 28486.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_scholarshipsapplicationbuilder_build() != 35090.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_academic_record() != 56142.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_bank_account() != 24141.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_family() != 32983.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_general() != 64238.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_graduation() != 31914.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_qualifications() != 24889.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_religion() != 49903.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_research_bank_account() != 7706.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_transfer() != 46555.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplication_work() != 4701.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_studentinformationapplicationbuilder_build() != 12986.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_anonymous() != 59232.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_with_password() != 35896.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_method_usaintsessionbuilder_with_token() != 48669.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_constructor_chapelapplicationbuilder_new() != 52857.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_constructor_coursegradesapplicationbuilder_new() != 45366.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_constructor_coursescheduleapplicationbuilder_new() != 52419.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_constructor_graduationrequirementsapplicationbuilder_new() != 7670.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_constructor_lectureassessmentapplicationbuilder_new() != 61021.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_constructor_personalcoursescheduleapplicationbuilder_new() != 46717.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_constructor_scholarshipsapplicationbuilder_new() != 64614.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_constructor_studentinformationapplicationbuilder_new() != 5527.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_ffi_checksum_constructor_usaintsessionbuilder_new() != 54500.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

/**
 * @suppress
 */
public fun uniffiEnsureInitialized() {
    UniffiLib.INSTANCE
}

// Async support
// Async return type handlers

internal const val UNIFFI_RUST_FUTURE_POLL_READY = 0.toByte()
internal const val UNIFFI_RUST_FUTURE_POLL_MAYBE_READY = 1.toByte()

internal val uniffiContinuationHandleMap = UniffiHandleMap<CancellableContinuation<Byte>>()

// FFI type for Rust future continuations
internal object uniffiRustFutureContinuationCallbackImpl: UniffiRustFutureContinuationCallback {
    override fun callback(data: Long, pollResult: Byte) {
        uniffiContinuationHandleMap.remove(data).resume(pollResult)
    }
}

internal suspend fun<T, F, E: kotlin.Exception> uniffiRustCallAsync(
    rustFuture: Long,
    pollFunc: (Long, UniffiRustFutureContinuationCallback, Long) -> Unit,
    completeFunc: (Long, UniffiRustCallStatus) -> F,
    freeFunc: (Long) -> Unit,
    liftFunc: (F) -> T,
    errorHandler: UniffiRustCallStatusErrorHandler<E>
): T {
    try {
        do {
            val pollResult = suspendCancellableCoroutine<Byte> { continuation ->
                pollFunc(
                    rustFuture,
                    uniffiRustFutureContinuationCallbackImpl,
                    uniffiContinuationHandleMap.insert(continuation)
                )
            }
        } while (pollResult != UNIFFI_RUST_FUTURE_POLL_READY);

        return liftFunc(
            uniffiRustCallWithError(errorHandler, { status -> completeFunc(rustFuture, status) })
        )
    } finally {
        freeFunc(rustFuture)
    }
}

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            for (arg in args) {
                when (arg) {
                    is Disposable -> arg.destroy()
                    is ArrayList<*> -> {
                        for (idx in arg.indices) {
                            val element = arg[idx]
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }
                    is Map<*, *> -> {
                        for (element in arg.values) {
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }
                    is Iterable<*> -> {
                        for (element in arg) {
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }
                }
            }
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/** 
 * Used to instantiate an interface without an actual pointer, for fakes in tests, mostly.
 *
 * @suppress
 * */
object NoPointer
/**
 * The cleaner interface for Object finalization code to run.
 * This is the entry point to any implementation that we're using.
 *
 * The cleaner registers objects and returns cleanables, so now we are
 * defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
 * different implmentations available at compile time.
 *
 * @suppress
 */
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner = com.sun.jna.internal.Cleaner.getCleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}


// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.


private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
        AndroidSystemCleaner()
    } else {
        UniffiJnaCleaner()
    }

// The SystemCleaner, available from API Level 33.
// Some API Level 33 OSes do not support using it, so we require API Level 34.
@RequiresApi(Build.VERSION_CODES.UPSIDE_DOWN_CAKE)
private class AndroidSystemCleaner : UniffiCleaner {
    val cleaner = android.system.SystemCleaner.cleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        AndroidSystemCleanable(cleaner.register(value, cleanUpTask))
}

@RequiresApi(Build.VERSION_CODES.UPSIDE_DOWN_CAKE)
private class AndroidSystemCleanable(
    private val cleanable: java.lang.ref.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

/**
 * @suppress
 */
public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4UL

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

/**
 * @suppress
 */
public object FfiConverterFloat: FfiConverter<Float, Float> {
    override fun lift(value: Float): Float {
        return value
    }

    override fun read(buf: ByteBuffer): Float {
        return buf.getFloat()
    }

    override fun lower(value: Float): Float {
        return value
    }

    override fun allocationSize(value: Float) = 4UL

    override fun write(value: Float, buf: ByteBuffer) {
        buf.putFloat(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

/**
 * @suppress
 */
public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [채플정보조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW3681)
 */
public interface ChapelApplicationInterface {
    
    /**
     * 현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
     * 하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
     */
    suspend fun `getSelectedSemester`(): YearSemester
    
    /**
     * 해당 학기의 채플 정보를 가져옵니다.
     */
    suspend fun `information`(`year`: kotlin.UInt, `semester`: SemesterType): ChapelInformation
    
    companion object
}

/**
 * [채플정보조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW3681)
 */
open class ChapelApplication: Disposable, AutoCloseable, ChapelApplicationInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_chapelapplication(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_chapelapplication(pointer!!, status)
        }
    }

    
    /**
     * 현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
     * 하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getSelectedSemester`() : YearSemester {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_chapelapplication_get_selected_semester(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeYearSemester.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 해당 학기의 채플 정보를 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `information`(`year`: kotlin.UInt, `semester`: SemesterType) : ChapelInformation {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_chapelapplication_information(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferChapelInformation.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeChapelInformation.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeChapelApplication: FfiConverter<ChapelApplication, Pointer> {

    override fun lower(value: ChapelApplication): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ChapelApplication {
        return ChapelApplication(value)
    }

    override fun read(buf: ByteBuffer): ChapelApplication {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ChapelApplication) = 8UL

    override fun write(value: ChapelApplication, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [`ChapelApplication`] 생성을 위한 빌더
 */
public interface ChapelApplicationBuilderInterface {
    
    /**
     * 세션과 함께 [`ChapelApplication`]을 만듭니다.
     */
    suspend fun `build`(`session`: USaintSession): ChapelApplication
    
    companion object
}

/**
 * [`ChapelApplication`] 생성을 위한 빌더
 */
open class ChapelApplicationBuilder: Disposable, AutoCloseable, ChapelApplicationBuilderInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * 새로운 [`ChapelApplicationBuilder`]를 만듭니다.
     */
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_constructor_chapelapplicationbuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_chapelapplicationbuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_chapelapplicationbuilder(pointer!!, status)
        }
    }

    
    /**
     * 세션과 함께 [`ChapelApplication`]을 만듭니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `build`(`session`: USaintSession) : ChapelApplication {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_chapelapplicationbuilder_build(
                thisPtr,
                FfiConverterTypeUSaintSession.lower(`session`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeChapelApplication.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeChapelApplicationBuilder: FfiConverter<ChapelApplicationBuilder, Pointer> {

    override fun lower(value: ChapelApplicationBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ChapelApplicationBuilder {
        return ChapelApplicationBuilder(value)
    }

    override fun read(buf: ByteBuffer): ChapelApplicationBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ChapelApplicationBuilder) = 8UL

    override fun write(value: ChapelApplicationBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [학생 성적 조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMB3W0017)
 */
public interface CourseGradesApplicationInterface {
    
    /**
     * 전체 학기의 증명 평점 정보를 가져옵니다.
     */
    suspend fun `certificatedSummary`(`courseType`: CourseType): GradeSummary
    
    /**
     * 주어진 수업의 상세 성적 정보를 가져옵니다.
     */
    suspend fun `classDetail`(`courseType`: CourseType, `year`: kotlin.UInt, `semester`: SemesterType, `code`: kotlin.String): Map<kotlin.String, kotlin.Float>
    
    /**
     * 주어진 학기의 수업별 성적을 가져옵니다. `include_details`가 `true`인 경우 수업의 상세 성적도 가져옵니다.
     * 수업의 상세 성적까지 가져올 경우 상세 성적이 있는 수업의 수 만큼 서버에 요청을 보내므로 반드시 상세 성적도 한번에 가져와야 할 때에만 사용하십시오.
     *
     * 수업 성적을 가져온 이후 상세 성적 또한 가져오려면 `[class_detail()]`함수를 이용하십시오.
     */
    suspend fun `classes`(`courseType`: CourseType, `year`: kotlin.UInt, `semester`: SemesterType, `includeDetails`: kotlin.Boolean): List<ClassGrade>
    
    /**
     * 현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
     * 하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
     */
    suspend fun `getSelectedSemester`(): YearSemester
    
    /**
     * 전체 학기의 학적부 평점 정보를 가져옵니다.
     */
    suspend fun `recordedSummary`(`courseType`: CourseType): GradeSummary
    
    /**
     * 학기별 평점 정보를 가져옵니다.
     */
    suspend fun `semesters`(`courseType`: CourseType): List<SemesterGrade>
    
    companion object
}

/**
 * [학생 성적 조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMB3W0017)
 */
open class CourseGradesApplication: Disposable, AutoCloseable, CourseGradesApplicationInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_coursegradesapplication(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_coursegradesapplication(pointer!!, status)
        }
    }

    
    /**
     * 전체 학기의 증명 평점 정보를 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `certificatedSummary`(`courseType`: CourseType) : GradeSummary {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursegradesapplication_certificated_summary(
                thisPtr,
                FfiConverterTypeCourseType.lower(`courseType`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferGradeSummary.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeGradeSummary.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 주어진 수업의 상세 성적 정보를 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `classDetail`(`courseType`: CourseType, `year`: kotlin.UInt, `semester`: SemesterType, `code`: kotlin.String) : Map<kotlin.String, kotlin.Float> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursegradesapplication_class_detail(
                thisPtr,
                FfiConverterTypeCourseType.lower(`courseType`),FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),FfiConverterString.lower(`code`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterMapStringFloat.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 주어진 학기의 수업별 성적을 가져옵니다. `include_details`가 `true`인 경우 수업의 상세 성적도 가져옵니다.
     * 수업의 상세 성적까지 가져올 경우 상세 성적이 있는 수업의 수 만큼 서버에 요청을 보내므로 반드시 상세 성적도 한번에 가져와야 할 때에만 사용하십시오.
     *
     * 수업 성적을 가져온 이후 상세 성적 또한 가져오려면 `[class_detail()]`함수를 이용하십시오.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `classes`(`courseType`: CourseType, `year`: kotlin.UInt, `semester`: SemesterType, `includeDetails`: kotlin.Boolean) : List<ClassGrade> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursegradesapplication_classes(
                thisPtr,
                FfiConverterTypeCourseType.lower(`courseType`),FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),FfiConverterBoolean.lower(`includeDetails`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceTypeClassGrade.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
     * 하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getSelectedSemester`() : YearSemester {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursegradesapplication_get_selected_semester(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeYearSemester.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 전체 학기의 학적부 평점 정보를 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `recordedSummary`(`courseType`: CourseType) : GradeSummary {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursegradesapplication_recorded_summary(
                thisPtr,
                FfiConverterTypeCourseType.lower(`courseType`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferGradeSummary.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeGradeSummary.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학기별 평점 정보를 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `semesters`(`courseType`: CourseType) : List<SemesterGrade> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursegradesapplication_semesters(
                thisPtr,
                FfiConverterTypeCourseType.lower(`courseType`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceTypeSemesterGrade.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeCourseGradesApplication: FfiConverter<CourseGradesApplication, Pointer> {

    override fun lower(value: CourseGradesApplication): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): CourseGradesApplication {
        return CourseGradesApplication(value)
    }

    override fun read(buf: ByteBuffer): CourseGradesApplication {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: CourseGradesApplication) = 8UL

    override fun write(value: CourseGradesApplication, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [`CourseGradesApplication`] 생성을 위한 빌더
 */
public interface CourseGradesApplicationBuilderInterface {
    
    /**
     * 세션과 함께 [`CourseGradesApplication`]을 만듭니다.
     */
    suspend fun `build`(`session`: USaintSession): CourseGradesApplication
    
    companion object
}

/**
 * [`CourseGradesApplication`] 생성을 위한 빌더
 */
open class CourseGradesApplicationBuilder: Disposable, AutoCloseable, CourseGradesApplicationBuilderInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * 새로운 [`CourseGradesApplicationBuilder`]를 만듭니다.
     */
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_constructor_coursegradesapplicationbuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_coursegradesapplicationbuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_coursegradesapplicationbuilder(pointer!!, status)
        }
    }

    
    /**
     * 세션과 함께 [`CourseGradesApplication`]을 만듭니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `build`(`session`: USaintSession) : CourseGradesApplication {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursegradesapplicationbuilder_build(
                thisPtr,
                FfiConverterTypeUSaintSession.lower(`session`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeCourseGradesApplication.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeCourseGradesApplicationBuilder: FfiConverter<CourseGradesApplicationBuilder, Pointer> {

    override fun lower(value: CourseGradesApplicationBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): CourseGradesApplicationBuilder {
        return CourseGradesApplicationBuilder(value)
    }

    override fun read(buf: ByteBuffer): CourseGradesApplicationBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: CourseGradesApplicationBuilder) = 8UL

    override fun write(value: CourseGradesApplicationBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [강의시간표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW2100)
 */
public interface CourseScheduleApplicationInterface {
    
    /**
     * 선택한 학기의 채플 과목 분류 목록을 가져옵니다.
     */
    suspend fun `chapelCategories`(`year`: kotlin.UInt, `semester`: SemesterType): List<kotlin.String>
    
    /**
     * 선택한 학기 기준 단과대 목록을 가져옵니다.
     */
    suspend fun `collages`(`year`: kotlin.UInt, `semester`: SemesterType): List<kotlin.String>
    
    /**
     * 선택한 학기의 연계전공 목록을 가져옵니다.
     */
    suspend fun `connectedMajors`(`year`: kotlin.UInt, `semester`: SemesterType): List<kotlin.String>
    
    /**
     * 선택한 학기 기준 주어진 단과대의 학과(부) 목록을 가져옵니다.
     */
    suspend fun `departments`(`year`: kotlin.UInt, `semester`: SemesterType, `collage`: kotlin.String): List<kotlin.String>
    
    /**
     * 학기, 학년도, 강의 분류를 통해 강의를 찾습니다.
     */
    suspend fun `findLectures`(`year`: kotlin.UInt, `semester`: SemesterType, `lectureCategory`: LectureCategory): List<Lecture>
    
    /**
     * 현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
     * 하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
     */
    suspend fun `getSelectedSemester`(): YearSemester
    
    /**
     * 선택한 학기의 대학원 단과대학 목록을 가져옵니다.
     */
    suspend fun `graduatedCollages`(`year`: kotlin.UInt, `semester`: SemesterType): List<kotlin.String>
    
    /**
     * 선택한 학기의 주어진 대학원 단과대의 학과 목록을 가져옵니다.
     */
    suspend fun `graduatedDepartments`(`year`: kotlin.UInt, `semester`: SemesterType, `collage`: kotlin.String): List<kotlin.String>
    
    /**
     * 선택한 학과(부)의 전공 목록을 가져옵니다.
     */
    suspend fun `majors`(`year`: kotlin.UInt, `semester`: SemesterType, `collage`: kotlin.String, `department`: kotlin.String): List<kotlin.String>
    
    /**
     * 선택한 학기의 교양선택 분야 목록을 가져옵니다.
     */
    suspend fun `optionalElectiveCategories`(`year`: kotlin.UInt, `semester`: SemesterType): List<kotlin.String>
    
    /**
     * 선택한 학기의 교양필수 과목명 목록을 가져옵니다.
     */
    suspend fun `requiredElectives`(`year`: kotlin.UInt, `semester`: SemesterType): List<kotlin.String>
    
    /**
     * 선택한 학기의 융합전공 목록을 가져옵니다.
     */
    suspend fun `unitedMajors`(`year`: kotlin.UInt, `semester`: SemesterType): List<kotlin.String>
    
    companion object
}

/**
 * [강의시간표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW2100)
 */
open class CourseScheduleApplication: Disposable, AutoCloseable, CourseScheduleApplicationInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_coursescheduleapplication(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_coursescheduleapplication(pointer!!, status)
        }
    }

    
    /**
     * 선택한 학기의 채플 과목 분류 목록을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `chapelCategories`(`year`: kotlin.UInt, `semester`: SemesterType) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_chapel_categories(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 선택한 학기 기준 단과대 목록을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `collages`(`year`: kotlin.UInt, `semester`: SemesterType) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_collages(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 선택한 학기의 연계전공 목록을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `connectedMajors`(`year`: kotlin.UInt, `semester`: SemesterType) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_connected_majors(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 선택한 학기 기준 주어진 단과대의 학과(부) 목록을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `departments`(`year`: kotlin.UInt, `semester`: SemesterType, `collage`: kotlin.String) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_departments(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),FfiConverterString.lower(`collage`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학기, 학년도, 강의 분류를 통해 강의를 찾습니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `findLectures`(`year`: kotlin.UInt, `semester`: SemesterType, `lectureCategory`: LectureCategory) : List<Lecture> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_find_lectures(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),FfiConverterTypeLectureCategory.lower(`lectureCategory`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceTypeLecture.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
     * 하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getSelectedSemester`() : YearSemester {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_get_selected_semester(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeYearSemester.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 선택한 학기의 대학원 단과대학 목록을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `graduatedCollages`(`year`: kotlin.UInt, `semester`: SemesterType) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_graduated_collages(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 선택한 학기의 주어진 대학원 단과대의 학과 목록을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `graduatedDepartments`(`year`: kotlin.UInt, `semester`: SemesterType, `collage`: kotlin.String) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_graduated_departments(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),FfiConverterString.lower(`collage`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 선택한 학과(부)의 전공 목록을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `majors`(`year`: kotlin.UInt, `semester`: SemesterType, `collage`: kotlin.String, `department`: kotlin.String) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_majors(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),FfiConverterString.lower(`collage`),FfiConverterString.lower(`department`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 선택한 학기의 교양선택 분야 목록을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `optionalElectiveCategories`(`year`: kotlin.UInt, `semester`: SemesterType) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_optional_elective_categories(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 선택한 학기의 교양필수 과목명 목록을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `requiredElectives`(`year`: kotlin.UInt, `semester`: SemesterType) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_required_electives(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 선택한 학기의 융합전공 목록을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `unitedMajors`(`year`: kotlin.UInt, `semester`: SemesterType) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplication_united_majors(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeCourseScheduleApplication: FfiConverter<CourseScheduleApplication, Pointer> {

    override fun lower(value: CourseScheduleApplication): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): CourseScheduleApplication {
        return CourseScheduleApplication(value)
    }

    override fun read(buf: ByteBuffer): CourseScheduleApplication {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: CourseScheduleApplication) = 8UL

    override fun write(value: CourseScheduleApplication, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [`CourseScheduleApplication`] 생성을 위한 빌더
 */
public interface CourseScheduleApplicationBuilderInterface {
    
    /**
     * 세션과 함께 [`CourseScheduleApplication`]을 만듭니다.
     */
    suspend fun `build`(`session`: USaintSession): CourseScheduleApplication
    
    companion object
}

/**
 * [`CourseScheduleApplication`] 생성을 위한 빌더
 */
open class CourseScheduleApplicationBuilder: Disposable, AutoCloseable, CourseScheduleApplicationBuilderInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * 새로운 [`CourseScheduleApplicationBuilder`]를 만듭니다.
     */
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_constructor_coursescheduleapplicationbuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_coursescheduleapplicationbuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_coursescheduleapplicationbuilder(pointer!!, status)
        }
    }

    
    /**
     * 세션과 함께 [`CourseScheduleApplication`]을 만듭니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `build`(`session`: USaintSession) : CourseScheduleApplication {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_coursescheduleapplicationbuilder_build(
                thisPtr,
                FfiConverterTypeUSaintSession.lower(`session`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeCourseScheduleApplication.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeCourseScheduleApplicationBuilder: FfiConverter<CourseScheduleApplicationBuilder, Pointer> {

    override fun lower(value: CourseScheduleApplicationBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): CourseScheduleApplicationBuilder {
        return CourseScheduleApplicationBuilder(value)
    }

    override fun read(buf: ByteBuffer): CourseScheduleApplicationBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: CourseScheduleApplicationBuilder) = 8UL

    override fun write(value: CourseScheduleApplicationBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [졸업사정표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW8015)
 */
public interface GraduationRequirementsApplicationInterface {
    
    /**
     * 졸업사정 결과와 졸업 필요 요건별 충족 여부와 세부 정보를 반환합니다.
     */
    suspend fun `requirements`(): GraduationRequirements
    
    /**
     * 학생 정보를 반환합니다.
     */
    suspend fun `studentInfo`(): GraduationStudent
    
    companion object
}

/**
 * [졸업사정표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW8015)
 */
open class GraduationRequirementsApplication: Disposable, AutoCloseable, GraduationRequirementsApplicationInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_graduationrequirementsapplication(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_graduationrequirementsapplication(pointer!!, status)
        }
    }

    
    /**
     * 졸업사정 결과와 졸업 필요 요건별 충족 여부와 세부 정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `requirements`() : GraduationRequirements {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplication_requirements(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferGraduationRequirements.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeGraduationRequirements.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학생 정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `studentInfo`() : GraduationStudent {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplication_student_info(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferGraduationStudent.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeGraduationStudent.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeGraduationRequirementsApplication: FfiConverter<GraduationRequirementsApplication, Pointer> {

    override fun lower(value: GraduationRequirementsApplication): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): GraduationRequirementsApplication {
        return GraduationRequirementsApplication(value)
    }

    override fun read(buf: ByteBuffer): GraduationRequirementsApplication {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: GraduationRequirementsApplication) = 8UL

    override fun write(value: GraduationRequirementsApplication, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [`GraduationRequirementsApplication`] 생성을 위한 빌더
 */
public interface GraduationRequirementsApplicationBuilderInterface {
    
    /**
     * 세션과 함께 [`GraduationRequirementsApplication`]을 만듭니다.
     */
    suspend fun `build`(`session`: USaintSession): GraduationRequirementsApplication
    
    companion object
}

/**
 * [`GraduationRequirementsApplication`] 생성을 위한 빌더
 */
open class GraduationRequirementsApplicationBuilder: Disposable, AutoCloseable, GraduationRequirementsApplicationBuilderInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * 새로운 [`GraduationRequirementsApplicationBuilder`]를 만듭니다.
     */
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_constructor_graduationrequirementsapplicationbuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_graduationrequirementsapplicationbuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_graduationrequirementsapplicationbuilder(pointer!!, status)
        }
    }

    
    /**
     * 세션과 함께 [`GraduationRequirementsApplication`]을 만듭니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `build`(`session`: USaintSession) : GraduationRequirementsApplication {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_graduationrequirementsapplicationbuilder_build(
                thisPtr,
                FfiConverterTypeUSaintSession.lower(`session`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeGraduationRequirementsApplication.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeGraduationRequirementsApplicationBuilder: FfiConverter<GraduationRequirementsApplicationBuilder, Pointer> {

    override fun lower(value: GraduationRequirementsApplicationBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): GraduationRequirementsApplicationBuilder {
        return GraduationRequirementsApplicationBuilder(value)
    }

    override fun read(buf: ByteBuffer): GraduationRequirementsApplicationBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: GraduationRequirementsApplicationBuilder) = 8UL

    override fun write(value: GraduationRequirementsApplicationBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [강의평가조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMB2W1010)
 */
public interface LectureAssessmentApplicationInterface {
    
    /**
     * 검색 조건에 맞는 강의평가 정보를 가져옵니다.
     */
    suspend fun `findAssessments`(`year`: kotlin.UInt, `semester`: SemesterType, `lectureName`: kotlin.String? = null, `lectureCode`: kotlin.UInt? = null, `professorName`: kotlin.String? = null): List<LectureAssessmentResult>
    
    /**
     * 현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
     * 하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
     */
    suspend fun `getSelectedSemester`(): YearSemester
    
    companion object
}

/**
 * [강의평가조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMB2W1010)
 */
open class LectureAssessmentApplication: Disposable, AutoCloseable, LectureAssessmentApplicationInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_lectureassessmentapplication(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_lectureassessmentapplication(pointer!!, status)
        }
    }

    
    /**
     * 검색 조건에 맞는 강의평가 정보를 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `findAssessments`(`year`: kotlin.UInt, `semester`: SemesterType, `lectureName`: kotlin.String?, `lectureCode`: kotlin.UInt?, `professorName`: kotlin.String?) : List<LectureAssessmentResult> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_lectureassessmentapplication_find_assessments(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),FfiConverterOptionalString.lower(`lectureName`),FfiConverterOptionalUInt.lower(`lectureCode`),FfiConverterOptionalString.lower(`professorName`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceTypeLectureAssessmentResult.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
     * 하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getSelectedSemester`() : YearSemester {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_lectureassessmentapplication_get_selected_semester(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeYearSemester.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeLectureAssessmentApplication: FfiConverter<LectureAssessmentApplication, Pointer> {

    override fun lower(value: LectureAssessmentApplication): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): LectureAssessmentApplication {
        return LectureAssessmentApplication(value)
    }

    override fun read(buf: ByteBuffer): LectureAssessmentApplication {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: LectureAssessmentApplication) = 8UL

    override fun write(value: LectureAssessmentApplication, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [`LectureAssessmentApplication`] 생성을 위한 빌더
 */
public interface LectureAssessmentApplicationBuilderInterface {
    
    /**
     * 세션과 함께 [`LectureAssessmentApplication`]을 만듭니다.
     */
    suspend fun `build`(`session`: USaintSession): LectureAssessmentApplication
    
    companion object
}

/**
 * [`LectureAssessmentApplication`] 생성을 위한 빌더
 */
open class LectureAssessmentApplicationBuilder: Disposable, AutoCloseable, LectureAssessmentApplicationBuilderInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * 새로운 [`LectureAssessmentApplicationBuilder`]를 만듭니다.
     */
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_constructor_lectureassessmentapplicationbuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_lectureassessmentapplicationbuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_lectureassessmentapplicationbuilder(pointer!!, status)
        }
    }

    
    /**
     * 세션과 함께 [`LectureAssessmentApplication`]을 만듭니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `build`(`session`: USaintSession) : LectureAssessmentApplication {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_lectureassessmentapplicationbuilder_build(
                thisPtr,
                FfiConverterTypeUSaintSession.lower(`session`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeLectureAssessmentApplication.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeLectureAssessmentApplicationBuilder: FfiConverter<LectureAssessmentApplicationBuilder, Pointer> {

    override fun lower(value: LectureAssessmentApplicationBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): LectureAssessmentApplicationBuilder {
        return LectureAssessmentApplicationBuilder(value)
    }

    override fun read(buf: ByteBuffer): LectureAssessmentApplicationBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: LectureAssessmentApplicationBuilder) = 8UL

    override fun write(value: LectureAssessmentApplicationBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [개인수업시간표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW2102)
 */
public interface PersonalCourseScheduleApplicationInterface {
    
    /**
     * 현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
     * 하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
     */
    suspend fun `getSelectedSemester`(): YearSemester
    
    /**
     * 해당 학기의 시간표 정보를 가져옵니다.
     */
    suspend fun `schedule`(`year`: kotlin.UInt, `semester`: SemesterType): PersonalCourseSchedule
    
    companion object
}

/**
 * [개인수업시간표](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW2102)
 */
open class PersonalCourseScheduleApplication: Disposable, AutoCloseable, PersonalCourseScheduleApplicationInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_personalcoursescheduleapplication(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_personalcoursescheduleapplication(pointer!!, status)
        }
    }

    
    /**
     * 현재 페이지에 선택된 년도와 학기를 가져옵니다. 최초 로드 시 현재 학기를 가져올 가능성이 있습니다.
     * 하지만 이 애플리케이션의 다른 함수를 호출하여 한번 정보를 가져왔다면 마지막으로 가져온 정보의 학기가 반환되므로 주의하여야 하며, 신뢰할 수 있는 현재 학기의 원천으로 사용되어서는 안됩니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getSelectedSemester`() : YearSemester {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplication_get_selected_semester(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeYearSemester.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 해당 학기의 시간표 정보를 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `schedule`(`year`: kotlin.UInt, `semester`: SemesterType) : PersonalCourseSchedule {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplication_schedule(
                thisPtr,
                FfiConverterUInt.lower(`year`),FfiConverterTypeSemesterType.lower(`semester`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferPersonalCourseSchedule.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypePersonalCourseSchedule.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypePersonalCourseScheduleApplication: FfiConverter<PersonalCourseScheduleApplication, Pointer> {

    override fun lower(value: PersonalCourseScheduleApplication): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): PersonalCourseScheduleApplication {
        return PersonalCourseScheduleApplication(value)
    }

    override fun read(buf: ByteBuffer): PersonalCourseScheduleApplication {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: PersonalCourseScheduleApplication) = 8UL

    override fun write(value: PersonalCourseScheduleApplication, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [`PersonalCourseScheduleApplication`] 생성을 위한 빌더
 */
public interface PersonalCourseScheduleApplicationBuilderInterface {
    
    /**
     * 세션과 함께 [`PersonalCourseScheduleApplication`]을 만듭니다.
     */
    suspend fun `build`(`session`: USaintSession): PersonalCourseScheduleApplication
    
    companion object
}

/**
 * [`PersonalCourseScheduleApplication`] 생성을 위한 빌더
 */
open class PersonalCourseScheduleApplicationBuilder: Disposable, AutoCloseable, PersonalCourseScheduleApplicationBuilderInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * 새로운 [`PersonalCourseScheduleApplicationBuilder`]를 만듭니다.
     */
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_constructor_personalcoursescheduleapplicationbuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_personalcoursescheduleapplicationbuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_personalcoursescheduleapplicationbuilder(pointer!!, status)
        }
    }

    
    /**
     * 세션과 함께 [`PersonalCourseScheduleApplication`]을 만듭니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `build`(`session`: USaintSession) : PersonalCourseScheduleApplication {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_personalcoursescheduleapplicationbuilder_build(
                thisPtr,
                FfiConverterTypeUSaintSession.lower(`session`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypePersonalCourseScheduleApplication.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypePersonalCourseScheduleApplicationBuilder: FfiConverter<PersonalCourseScheduleApplicationBuilder, Pointer> {

    override fun lower(value: PersonalCourseScheduleApplicationBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): PersonalCourseScheduleApplicationBuilder {
        return PersonalCourseScheduleApplicationBuilder(value)
    }

    override fun read(buf: ByteBuffer): PersonalCourseScheduleApplicationBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: PersonalCourseScheduleApplicationBuilder) = 8UL

    override fun write(value: PersonalCourseScheduleApplicationBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [장학금수혜내역조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW7530n)
 */
public interface ScholarshipsApplicationInterface {
    
    /**
     * 장학금 수혜 내역을 가져옵니다.
     */
    suspend fun `scholarships`(): List<Scholarship>
    
    companion object
}

/**
 * [장학금수혜내역조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW7530n)
 */
open class ScholarshipsApplication: Disposable, AutoCloseable, ScholarshipsApplicationInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_scholarshipsapplication(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_scholarshipsapplication(pointer!!, status)
        }
    }

    
    /**
     * 장학금 수혜 내역을 가져옵니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `scholarships`() : List<Scholarship> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_scholarshipsapplication_scholarships(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceTypeScholarship.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeScholarshipsApplication: FfiConverter<ScholarshipsApplication, Pointer> {

    override fun lower(value: ScholarshipsApplication): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ScholarshipsApplication {
        return ScholarshipsApplication(value)
    }

    override fun read(buf: ByteBuffer): ScholarshipsApplication {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ScholarshipsApplication) = 8UL

    override fun write(value: ScholarshipsApplication, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [`ScholarshipsApplication`] 생성을 위한 빌더
 */
public interface ScholarshipsApplicationBuilderInterface {
    
    /**
     * 세션과 함께 [`ScholarshipsApplication`]을 만듭니다.
     */
    suspend fun `build`(`session`: USaintSession): ScholarshipsApplication
    
    companion object
}

/**
 * [`ScholarshipsApplication`] 생성을 위한 빌더
 */
open class ScholarshipsApplicationBuilder: Disposable, AutoCloseable, ScholarshipsApplicationBuilderInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * 새로운 [`ScholarshipsApplicationBuilder`]를 만듭니다.
     */
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_constructor_scholarshipsapplicationbuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_scholarshipsapplicationbuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_scholarshipsapplicationbuilder(pointer!!, status)
        }
    }

    
    /**
     * 세션과 함께 [`ScholarshipsApplication`]을 만듭니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `build`(`session`: USaintSession) : ScholarshipsApplication {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_scholarshipsapplicationbuilder_build(
                thisPtr,
                FfiConverterTypeUSaintSession.lower(`session`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeScholarshipsApplication.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeScholarshipsApplicationBuilder: FfiConverter<ScholarshipsApplicationBuilder, Pointer> {

    override fun lower(value: ScholarshipsApplicationBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ScholarshipsApplicationBuilder {
        return ScholarshipsApplicationBuilder(value)
    }

    override fun read(buf: ByteBuffer): ScholarshipsApplicationBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ScholarshipsApplicationBuilder) = 8UL

    override fun write(value: ScholarshipsApplicationBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [학생 정보 수정 및 조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW1001n)
 */
public interface StudentInformationApplicationInterface {
    
    /**
     * 학생의 학적상태 정보를 반환합니다.
     */
    suspend fun `academicRecord`(): StudentAcademicRecords
    
    /**
     * 학생의 은행계좌 정보를 반환합니다.
     */
    suspend fun `bankAccount`(): StudentBankAccount
    
    /**
     * 학생의 가족관계 정보를 반환합니다.
     */
    suspend fun `family`(): StudentFamily
    
    /**
     * 일반 학생 정보를 반환합니다.
     */
    suspend fun `general`(): StudentInformation
    
    /**
     * 학생의 졸업과 관련된 정보를 반환합니다.
     */
    suspend fun `graduation`(): StudentGraduation
    
    /**
     * 학생의 교직, 평생교육사, 7+1 프로그램 등 자격 관련 정보를 반환합니다.
     */
    suspend fun `qualifications`(): StudentQualification
    
    /**
     * 학생의 종교 정보를 반환합니다.
     */
    suspend fun `religion`(): StudentReligion
    
    /**
     * 학생의 연구비 입금 계좌를 반환합니다.
     */
    suspend fun `researchBankAccount`(): StudentResearchBankAccount
    
    /**
     * 학생의 편입정보를 반환합니다.
     */
    suspend fun `transfer`(): StudentTransferRecords
    
    /**
     * 학생의 직장 정보를 반환합니다.
     */
    suspend fun `work`(): StudentWorkInformation
    
    companion object
}

/**
 * [학생 정보 수정 및 조회](https://ecc.ssu.ac.kr/sap/bc/webdynpro/SAP/ZCMW1001n)
 */
open class StudentInformationApplication: Disposable, AutoCloseable, StudentInformationApplicationInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_studentinformationapplication(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_studentinformationapplication(pointer!!, status)
        }
    }

    
    /**
     * 학생의 학적상태 정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `academicRecord`() : StudentAcademicRecords {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplication_academic_record(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferStudentAcademicRecords.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeStudentAcademicRecords.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학생의 은행계좌 정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `bankAccount`() : StudentBankAccount {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplication_bank_account(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferStudentBankAccount.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeStudentBankAccount.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학생의 가족관계 정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `family`() : StudentFamily {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplication_family(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferStudentFamily.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeStudentFamily.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 일반 학생 정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `general`() : StudentInformation {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplication_general(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferStudentInformation.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeStudentInformation.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학생의 졸업과 관련된 정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `graduation`() : StudentGraduation {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplication_graduation(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferStudentGraduation.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeStudentGraduation.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학생의 교직, 평생교육사, 7+1 프로그램 등 자격 관련 정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `qualifications`() : StudentQualification {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplication_qualifications(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferStudentQualification.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeStudentQualification.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학생의 종교 정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `religion`() : StudentReligion {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplication_religion(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferStudentReligion.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeStudentReligion.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학생의 연구비 입금 계좌를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `researchBankAccount`() : StudentResearchBankAccount {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplication_research_bank_account(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferStudentResearchBankAccount.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeStudentResearchBankAccount.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학생의 편입정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `transfer`() : StudentTransferRecords {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplication_transfer(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferStudentTransferRecords.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeStudentTransferRecords.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * 학생의 직장 정보를 반환합니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `work`() : StudentWorkInformation {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplication_work(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferStudentWorkInformation.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeStudentWorkInformation.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentInformationApplication: FfiConverter<StudentInformationApplication, Pointer> {

    override fun lower(value: StudentInformationApplication): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): StudentInformationApplication {
        return StudentInformationApplication(value)
    }

    override fun read(buf: ByteBuffer): StudentInformationApplication {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: StudentInformationApplication) = 8UL

    override fun write(value: StudentInformationApplication, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [`StudentInformationApplication`] 생성을 위한 빌더
 */
public interface StudentInformationApplicationBuilderInterface {
    
    /**
     * 세션과 함께 [`StudentInformationApplication`]을 만듭니다.
     */
    suspend fun `build`(`session`: USaintSession): StudentInformationApplication
    
    companion object
}

/**
 * [`StudentInformationApplication`] 생성을 위한 빌더
 */
open class StudentInformationApplicationBuilder: Disposable, AutoCloseable, StudentInformationApplicationBuilderInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * 새로운 [`StudentInformationApplicationBuilder`]를 만듭니다.
     */
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_constructor_studentinformationapplicationbuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_studentinformationapplicationbuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_studentinformationapplicationbuilder(pointer!!, status)
        }
    }

    
    /**
     * 세션과 함께 [`StudentInformationApplication`]을 만듭니다.
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `build`(`session`: USaintSession) : StudentInformationApplication {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_studentinformationapplicationbuilder_build(
                thisPtr,
                FfiConverterTypeUSaintSession.lower(`session`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeStudentInformationApplication.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentInformationApplicationBuilder: FfiConverter<StudentInformationApplicationBuilder, Pointer> {

    override fun lower(value: StudentInformationApplicationBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): StudentInformationApplicationBuilder {
        return StudentInformationApplicationBuilder(value)
    }

    override fun read(buf: ByteBuffer): StudentInformationApplicationBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: StudentInformationApplicationBuilder) = 8UL

    override fun write(value: StudentInformationApplicationBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * u-saint에서 사용할 세션
 * [`USaintSessionBuilder`]를 이용해 생성합니다.
 */
public interface USaintSessionInterface {
    
    companion object
}

/**
 * u-saint에서 사용할 세션
 * [`USaintSessionBuilder`]를 이용해 생성합니다.
 */
open class USaintSession: Disposable, AutoCloseable, USaintSessionInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_usaintsession(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_usaintsession(pointer!!, status)
        }
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeUSaintSession: FfiConverter<USaintSession, Pointer> {

    override fun lower(value: USaintSession): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): USaintSession {
        return USaintSession(value)
    }

    override fun read(buf: ByteBuffer): USaintSession {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: USaintSession) = 8UL

    override fun write(value: USaintSession, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * [`USaintSession`]을 생성하기 위한 빌더
 */
public interface USaintSessionBuilderInterface {
    
    /**
     * 익명 세션(비로그인)을 만듭니다.
     * ## Kotlin
     * ```kotlin
     * fun createAnonymousSession() {
     * val anonymous = USaintSessionBuilder().anonymous()
     * }
     * ```
     */
    fun `anonymous`(): USaintSession
    
    /**
     * ID, 비밀번호로 세션을 만듭니다.
     * ## Kotlin
     * ```kotlin
     * suspend fun createSessionWithPassword() {
     * val withPassword = USaintSessionBuilder().withPassword("20211561", "password") // suspend
     * }
     */
    suspend fun `withPassword`(`id`: kotlin.String, `password`: kotlin.String): USaintSession
    
    /**
     * SSO 토큰으로 세션을 만듭니다.
     * ## Kotlin
     * ```kotlin
     * suspend fun createSessionWithSsoToken() {
     * val withToken = USaintSessionBuilder().withToken("<example sso token>") // suspend
     * }
     */
    suspend fun `withToken`(`id`: kotlin.String, `token`: kotlin.String): USaintSession
    
    companion object
}

/**
 * [`USaintSession`]을 생성하기 위한 빌더
 */
open class USaintSessionBuilder: Disposable, AutoCloseable, USaintSessionBuilderInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * 새로운 [`USaintSessionBuilder`]를 만듭니다.
     */
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_constructor_usaintsessionbuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_free_usaintsessionbuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_clone_usaintsessionbuilder(pointer!!, status)
        }
    }

    
    /**
     * 익명 세션(비로그인)을 만듭니다.
     * ## Kotlin
     * ```kotlin
     * fun createAnonymousSession() {
     * val anonymous = USaintSessionBuilder().anonymous()
     * }
     * ```
     */override fun `anonymous`(): USaintSession {
            return FfiConverterTypeUSaintSession.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_anonymous(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * ID, 비밀번호로 세션을 만듭니다.
     * ## Kotlin
     * ```kotlin
     * suspend fun createSessionWithPassword() {
     * val withPassword = USaintSessionBuilder().withPassword("20211561", "password") // suspend
     * }
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `withPassword`(`id`: kotlin.String, `password`: kotlin.String) : USaintSession {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_with_password(
                thisPtr,
                FfiConverterString.lower(`id`),FfiConverterString.lower(`password`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeUSaintSession.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    
    /**
     * SSO 토큰으로 세션을 만듭니다.
     * ## Kotlin
     * ```kotlin
     * suspend fun createSessionWithSsoToken() {
     * val withToken = USaintSessionBuilder().withToken("<example sso token>") // suspend
     * }
     */
    @Throws(RusaintException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `withToken`(`id`: kotlin.String, `token`: kotlin.String) : USaintSession {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_rusaint_ffi_fn_method_usaintsessionbuilder_with_token(
                thisPtr,
                FfiConverterString.lower(`id`),FfiConverterString.lower(`token`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_rusaint_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeUSaintSession.lift(it) },
        // Error FFI converter
        RusaintException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeUSaintSessionBuilder: FfiConverter<USaintSessionBuilder, Pointer> {

    override fun lower(value: USaintSessionBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): USaintSessionBuilder {
        return USaintSessionBuilder(value)
    }

    override fun read(buf: ByteBuffer): USaintSessionBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: USaintSessionBuilder) = 8UL

    override fun write(value: USaintSessionBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}



data class YearSemester (
    val `year`: kotlin.UInt, 
    val `semester`: SemesterType
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeYearSemester: FfiConverterRustBuffer<YearSemester> {
    override fun read(buf: ByteBuffer): YearSemester {
        return YearSemester(
            FfiConverterUInt.read(buf),
            FfiConverterTypeSemesterType.read(buf),
        )
    }

    override fun allocationSize(value: YearSemester) = (
            FfiConverterUInt.allocationSize(value.`year`) +
            FfiConverterTypeSemesterType.allocationSize(value.`semester`)
    )

    override fun write(value: YearSemester, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`year`, buf)
            FfiConverterTypeSemesterType.write(value.`semester`, buf)
    }
}





/**
 * Rusaint에서 반환하는 기본 오류
 */
sealed class RusaintException(message: String): kotlin.Exception(message) {
        
        class General(message: String) : RusaintException(message)
        

    companion object ErrorHandler : UniffiRustCallStatusErrorHandler<RusaintException> {
        override fun lift(error_buf: RustBuffer.ByValue): RusaintException = FfiConverterTypeRusaintError.lift(error_buf)
    }
}

/**
 * @suppress
 */
public object FfiConverterTypeRusaintError : FfiConverterRustBuffer<RusaintException> {
    override fun read(buf: ByteBuffer): RusaintException {
        
            return when(buf.getInt()) {
            1 -> RusaintException.General(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: RusaintException): ULong {
        return 4UL
    }

    override fun write(value: RusaintException, buf: ByteBuffer) {
        when(value) {
            is RusaintException.General -> {
                buf.putInt(1)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




/**
 * @suppress
 */
public object FfiConverterOptionalUInt: FfiConverterRustBuffer<kotlin.UInt?> {
    override fun read(buf: ByteBuffer): kotlin.UInt? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUInt.read(buf)
    }

    override fun allocationSize(value: kotlin.UInt?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterUInt.allocationSize(value)
        }
    }

    override fun write(value: kotlin.UInt?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUInt.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalString: FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: ByteBuffer): kotlin.String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: kotlin.String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceString: FfiConverterRustBuffer<List<kotlin.String>> {
    override fun read(buf: ByteBuffer): List<kotlin.String> {
        val len = buf.getInt()
        return List<kotlin.String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.String>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<kotlin.String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeClassGrade: FfiConverterRustBuffer<List<ClassGrade>> {
    override fun read(buf: ByteBuffer): List<ClassGrade> {
        val len = buf.getInt()
        return List<ClassGrade>(len) {
            FfiConverterTypeClassGrade.read(buf)
        }
    }

    override fun allocationSize(value: List<ClassGrade>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeClassGrade.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ClassGrade>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeClassGrade.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeLecture: FfiConverterRustBuffer<List<Lecture>> {
    override fun read(buf: ByteBuffer): List<Lecture> {
        val len = buf.getInt()
        return List<Lecture>(len) {
            FfiConverterTypeLecture.read(buf)
        }
    }

    override fun allocationSize(value: List<Lecture>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeLecture.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Lecture>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeLecture.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeLectureAssessmentResult: FfiConverterRustBuffer<List<LectureAssessmentResult>> {
    override fun read(buf: ByteBuffer): List<LectureAssessmentResult> {
        val len = buf.getInt()
        return List<LectureAssessmentResult>(len) {
            FfiConverterTypeLectureAssessmentResult.read(buf)
        }
    }

    override fun allocationSize(value: List<LectureAssessmentResult>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeLectureAssessmentResult.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<LectureAssessmentResult>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeLectureAssessmentResult.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeScholarship: FfiConverterRustBuffer<List<Scholarship>> {
    override fun read(buf: ByteBuffer): List<Scholarship> {
        val len = buf.getInt()
        return List<Scholarship>(len) {
            FfiConverterTypeScholarship.read(buf)
        }
    }

    override fun allocationSize(value: List<Scholarship>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeScholarship.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Scholarship>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeScholarship.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeSemesterGrade: FfiConverterRustBuffer<List<SemesterGrade>> {
    override fun read(buf: ByteBuffer): List<SemesterGrade> {
        val len = buf.getInt()
        return List<SemesterGrade>(len) {
            FfiConverterTypeSemesterGrade.read(buf)
        }
    }

    override fun allocationSize(value: List<SemesterGrade>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeSemesterGrade.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<SemesterGrade>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeSemesterGrade.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterMapStringFloat: FfiConverterRustBuffer<Map<kotlin.String, kotlin.Float>> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, kotlin.Float> {
        val len = buf.getInt()
        return buildMap<kotlin.String, kotlin.Float>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterFloat.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<kotlin.String, kotlin.Float>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterFloat.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<kotlin.String, kotlin.Float>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterFloat.write(v, buf)
        }
    }
}























































