// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package dev.eatsteak.rusaint.core

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.ConcurrentHashMap
import android.os.Build
import androidx.annotation.RequiresApi
import java.util.concurrent.atomic.AtomicBoolean

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

/**
 * @suppress
 */
@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0
    @JvmField var len: Long = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

   internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) = uniffiRustCall() { status ->
            // Note: need to convert the size to a `Long` value to make this work with JVM.
            UniffiLib.INSTANCE.ffi_rusaint_rustbuffer_alloc(size.toLong(), status)
        }.also {
            if(it.data == null) {
               throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
           }
        }

        internal fun create(capacity: ULong, len: ULong, data: Pointer?): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) = uniffiRustCall() { status ->
            UniffiLib.INSTANCE.ffi_rusaint_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 *
 * @suppress
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setLong(0, value.capacity)
        pointer.setLong(8, value.len)
        pointer.setPointer(16, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getLong(0))
        value.writeField("len", pointer.getLong(8))
        value.writeField("data", pointer.getLong(16))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
internal open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
/**
 * The FfiConverter interface handles converter types to and from the FFI
 *
 * All implementing objects should be public to support external types.  When a
 * type is external we need to import it's FfiConverter.
 *
 * @suppress
 */
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

/**
 * FfiConverter that uses `RustBuffer` as the FfiType
 *
 * @suppress
 */
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: UniffiRustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == UNIFFI_CALL_SUCCESS
    }

    fun isError(): Boolean {
        return code == UNIFFI_CALL_ERROR
    }

    fun isPanic(): Boolean {
        return code == UNIFFI_CALL_UNEXPECTED_ERROR
    }

    companion object {
        fun create(code: Byte, errorBuf: RustBuffer.ByValue): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(message: String) : kotlin.Exception(message)

/**
 * Each top-level error class has a companion object that can lift the error from the call status's rust buffer
 *
 * @suppress
 */
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: kotlin.Exception> uniffiRustCallWithError(errorHandler: UniffiRustCallStatusErrorHandler<E>, callback: (UniffiRustCallStatus) -> U): U {
    var status = UniffiRustCallStatus()
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun<E: kotlin.Exception> uniffiCheckCallStatus(errorHandler: UniffiRustCallStatusErrorHandler<E>, status: UniffiRustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

/**
 * UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
 *
 * @suppress
 */
object UniffiNullRustCallStatusErrorHandler: UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U {
    return uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback)
}

internal inline fun<T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun<T, reified E: Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}
// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<Long, T>()
    private val counter = java.util.concurrent.atomic.AtomicLong(0)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(1)
        map.put(handle, obj)
        return handle
    }

    // Get an object from the handle map
    fun get(handle: Long): T {
        return map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")
    }

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T {
        return map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "rusaint_ffi"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(`data`: Long,`pollResult`: Byte,)
}
internal interface UniffiForeignFutureFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFuture(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureFree? = null,
    ): UniffiForeignFuture(`handle`,`free`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFuture) {
        `handle` = other.`handle`
        `free` = other.`free`
    }

}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructPointer(
    @JvmField internal var `returnValue`: Pointer = Pointer.NULL,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Pointer = Pointer.NULL,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructPointer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructPointer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompletePointer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructPointer.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructRustBuffer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructRustBuffer.UniffiByValue,)
}
@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureStructVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructVoid(`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructVoid) {
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructVoid.UniffiByValue,)
}






















































































// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            loadIndirect<UniffiLib>(componentName = "rusaint")
            .also { lib: UniffiLib ->
                uniffiCheckContractApiVersion(lib)
                uniffiCheckApiChecksums(lib)
                }
        }
        
        // The Cleaner for the whole library
        internal val CLEANER: UniffiCleaner by lazy {
            UniffiCleaner.create()
        }
    }

    fun uniffi_rusaint_fn_clone_lecturecategorybuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_rusaint_fn_free_lecturecategorybuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_rusaint_fn_constructor_lecturecategorybuilder_new(uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_chapel(`ptr`: Pointer,`lectureName`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_connected_major(`ptr`: Pointer,`major`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_cyber(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_education(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_find_by_lecture(`ptr`: Pointer,`keyword`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_find_by_professor(`ptr`: Pointer,`keyword`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_graduated(`ptr`: Pointer,`collage`: RustBuffer.ByValue,`department`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_major(`ptr`: Pointer,`collage`: RustBuffer.ByValue,`department`: RustBuffer.ByValue,`major`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_optional_elective(`ptr`: Pointer,`category`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_recognized_other_major(`ptr`: Pointer,`collage`: RustBuffer.ByValue,`department`: RustBuffer.ByValue,`major`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_required_elective(`ptr`: Pointer,`lectureName`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_rusaint_fn_method_lecturecategorybuilder_united_major(`ptr`: Pointer,`major`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_rusaint_rustbuffer_alloc(`size`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_rusaint_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_rusaint_rustbuffer_free(`buf`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun ffi_rusaint_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_rusaint_rust_future_poll_u8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_u8(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_u8(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_u8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun ffi_rusaint_rust_future_poll_i8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_i8(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_i8(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_i8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun ffi_rusaint_rust_future_poll_u16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_u16(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_u16(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_u16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Short
    fun ffi_rusaint_rust_future_poll_i16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_i16(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_i16(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_i16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Short
    fun ffi_rusaint_rust_future_poll_u32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_u32(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_u32(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_u32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun ffi_rusaint_rust_future_poll_i32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_i32(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_i32(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_i32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun ffi_rusaint_rust_future_poll_u64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_u64(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_u64(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_u64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun ffi_rusaint_rust_future_poll_i64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_i64(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_i64(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_i64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun ffi_rusaint_rust_future_poll_f32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_f32(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_f32(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_f32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Float
    fun ffi_rusaint_rust_future_poll_f64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_f64(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_f64(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_f64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Double
    fun ffi_rusaint_rust_future_poll_pointer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_pointer(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_pointer(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_pointer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun ffi_rusaint_rust_future_poll_rust_buffer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_rust_buffer(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_rust_buffer(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_rust_buffer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_rusaint_rust_future_poll_void(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_cancel_void(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_free_void(`handle`: Long,
    ): Unit
    fun ffi_rusaint_rust_future_complete_void(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_chapel(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_connected_major(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_cyber(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_education(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_find_by_lecture(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_find_by_professor(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_graduated(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_major(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_optional_elective(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_recognized_other_major(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_required_elective(
    ): Short
    fun uniffi_rusaint_checksum_method_lecturecategorybuilder_united_major(
    ): Short
    fun uniffi_rusaint_checksum_constructor_lecturecategorybuilder_new(
    ): Short
    fun ffi_rusaint_uniffi_contract_version(
    ): Int
    
}

private fun uniffiCheckContractApiVersion(lib: UniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 26
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_rusaint_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: UniffiLib) {
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_chapel() != 36146.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_connected_major() != 23575.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_cyber() != 62603.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_education() != 26923.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_find_by_lecture() != 60430.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_find_by_professor() != 34168.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_graduated() != 33032.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_major() != 62920.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_optional_elective() != 18560.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_recognized_other_major() != 31169.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_required_elective() != 31001.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_united_major() != 40110.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_rusaint_checksum_constructor_lecturecategorybuilder_new() != 19652.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// Async support

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/** 
 * Used to instantiate an interface without an actual pointer, for fakes in tests, mostly.
 *
 * @suppress
 * */
object NoPointer

/**
 * @suppress
 */
public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4UL

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

/**
 * @suppress
 */
public object FfiConverterFloat: FfiConverter<Float, Float> {
    override fun lift(value: Float): Float {
        return value
    }

    override fun read(buf: ByteBuffer): Float {
        return buf.getFloat()
    }

    override fun lower(value: Float): Float {
        return value
    }

    override fun allocationSize(value: Float) = 4UL

    override fun write(value: Float, buf: ByteBuffer) {
        buf.putFloat(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

/**
 * @suppress
 */
public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

/**
 * @suppress
 */
public object FfiConverterByteArray: FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }
    override fun allocationSize(value: ByteArray): ULong {
        return 4UL + value.size.toULong()
    }
    override fun write(value: ByteArray, buf: ByteBuffer) {
        buf.putInt(value.size)
        buf.put(value)
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * The cleaner interface for Object finalization code to run.
 * This is the entry point to any implementation that we're using.
 *
 * The cleaner registers objects and returns cleanables, so now we are
 * defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
 * different implmentations available at compile time.
 *
 * @suppress
 */
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner = com.sun.jna.internal.Cleaner.getCleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.


private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
        AndroidSystemCleaner()
    } else {
        UniffiJnaCleaner()
    }

// The SystemCleaner, available from API Level 33.
// Some API Level 33 OSes do not support using it, so we require API Level 34.
@RequiresApi(Build.VERSION_CODES.UPSIDE_DOWN_CAKE)
private class AndroidSystemCleaner : UniffiCleaner {
    val cleaner = android.system.SystemCleaner.cleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        AndroidSystemCleanable(cleaner.register(value, cleanUpTask))
}

@RequiresApi(Build.VERSION_CODES.UPSIDE_DOWN_CAKE)
private class AndroidSystemCleanable(
    private val cleanable: java.lang.ref.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}
/**
 * 새로운 `LectureCategory`를 만드는 빌더입니다.
 */
public interface LectureCategoryBuilderInterface {
    
    /**
     * 채플 분류의 [`LectureCategory`]를 만듭니다.
     */
    fun `chapel`(`lectureName`: kotlin.String): LectureCategory
    
    /**
     * 연계전공 분류의 [`LectureCategory`]를 만듭니다.
     */
    fun `connectedMajor`(`major`: kotlin.String): LectureCategory
    
    /**
     * 숭실사이버대 분류의 [`LectureCategory`]를 만듭니다.
     */
    fun `cyber`(): LectureCategory
    
    /**
     * 교직 분류의 [`LectureCategory`]를 만듭니다.
     */
    fun `education`(): LectureCategory
    
    /**
     * 과목명으로 찾기 위한 [`LectureCategory`]를 만듭니다.
     */
    fun `findByLecture`(`keyword`: kotlin.String): LectureCategory
    
    /**
     * 교수명으로 찾기 위한 [`LectureCategory`]를 만듭니다.
     */
    fun `findByProfessor`(`keyword`: kotlin.String): LectureCategory
    
    /**
     * 대학원 분류의 [`LectureCategory`]를 만듭니다.
     */
    fun `graduated`(`collage`: kotlin.String, `department`: kotlin.String): LectureCategory
    
    /**
     * 전공과목 분류의 [`LectureCategory`]를 만듭니다.
     */
    fun `major`(`collage`: kotlin.String, `department`: kotlin.String, `major`: kotlin.String?): LectureCategory
    
    /**
     * 교양선택 분류의 [`LectureCategory`]를 만듭니다.
     */
    fun `optionalElective`(`category`: kotlin.String): LectureCategory
    
    /**
     * 타전공인정과목 분류의 [`LectureCategory`]를 만듭니다.
     */
    fun `recognizedOtherMajor`(`collage`: kotlin.String, `department`: kotlin.String, `major`: kotlin.String?): LectureCategory
    
    /**
     * 교양필수 분류의 [`LectureCategory`]를 만듭니다.
     */
    fun `requiredElective`(`lectureName`: kotlin.String): LectureCategory
    
    /**
     * 융합전공 분류의 [`LectureCategory`]를 만듭니다.
     */
    fun `unitedMajor`(`major`: kotlin.String): LectureCategory
    
    companion object
}

/**
 * 새로운 `LectureCategory`를 만드는 빌더입니다.
 */
open class LectureCategoryBuilder: Disposable, AutoCloseable, LectureCategoryBuilderInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * `LectureCategoryBuilder`를 만듭니다.
     */
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_constructor_lecturecategorybuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_rusaint_fn_free_lecturecategorybuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_rusaint_fn_clone_lecturecategorybuilder(pointer!!, status)
        }
    }

    
    /**
     * 채플 분류의 [`LectureCategory`]를 만듭니다.
     */override fun `chapel`(`lectureName`: kotlin.String): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_chapel(
        it, FfiConverterString.lower(`lectureName`),_status)
}
    }
    )
    }
    

    
    /**
     * 연계전공 분류의 [`LectureCategory`]를 만듭니다.
     */override fun `connectedMajor`(`major`: kotlin.String): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_connected_major(
        it, FfiConverterString.lower(`major`),_status)
}
    }
    )
    }
    

    
    /**
     * 숭실사이버대 분류의 [`LectureCategory`]를 만듭니다.
     */override fun `cyber`(): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_cyber(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * 교직 분류의 [`LectureCategory`]를 만듭니다.
     */override fun `education`(): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_education(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * 과목명으로 찾기 위한 [`LectureCategory`]를 만듭니다.
     */override fun `findByLecture`(`keyword`: kotlin.String): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_find_by_lecture(
        it, FfiConverterString.lower(`keyword`),_status)
}
    }
    )
    }
    

    
    /**
     * 교수명으로 찾기 위한 [`LectureCategory`]를 만듭니다.
     */override fun `findByProfessor`(`keyword`: kotlin.String): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_find_by_professor(
        it, FfiConverterString.lower(`keyword`),_status)
}
    }
    )
    }
    

    
    /**
     * 대학원 분류의 [`LectureCategory`]를 만듭니다.
     */override fun `graduated`(`collage`: kotlin.String, `department`: kotlin.String): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_graduated(
        it, FfiConverterString.lower(`collage`),FfiConverterString.lower(`department`),_status)
}
    }
    )
    }
    

    
    /**
     * 전공과목 분류의 [`LectureCategory`]를 만듭니다.
     */override fun `major`(`collage`: kotlin.String, `department`: kotlin.String, `major`: kotlin.String?): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_major(
        it, FfiConverterString.lower(`collage`),FfiConverterString.lower(`department`),FfiConverterOptionalString.lower(`major`),_status)
}
    }
    )
    }
    

    
    /**
     * 교양선택 분류의 [`LectureCategory`]를 만듭니다.
     */override fun `optionalElective`(`category`: kotlin.String): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_optional_elective(
        it, FfiConverterString.lower(`category`),_status)
}
    }
    )
    }
    

    
    /**
     * 타전공인정과목 분류의 [`LectureCategory`]를 만듭니다.
     */override fun `recognizedOtherMajor`(`collage`: kotlin.String, `department`: kotlin.String, `major`: kotlin.String?): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_recognized_other_major(
        it, FfiConverterString.lower(`collage`),FfiConverterString.lower(`department`),FfiConverterOptionalString.lower(`major`),_status)
}
    }
    )
    }
    

    
    /**
     * 교양필수 분류의 [`LectureCategory`]를 만듭니다.
     */override fun `requiredElective`(`lectureName`: kotlin.String): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_required_elective(
        it, FfiConverterString.lower(`lectureName`),_status)
}
    }
    )
    }
    

    
    /**
     * 융합전공 분류의 [`LectureCategory`]를 만듭니다.
     */override fun `unitedMajor`(`major`: kotlin.String): LectureCategory {
            return FfiConverterTypeLectureCategory.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_rusaint_fn_method_lecturecategorybuilder_united_major(
        it, FfiConverterString.lower(`major`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeLectureCategoryBuilder: FfiConverter<LectureCategoryBuilder, Pointer> {

    override fun lower(value: LectureCategoryBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): LectureCategoryBuilder {
        return LectureCategoryBuilder(value)
    }

    override fun read(buf: ByteBuffer): LectureCategoryBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: LectureCategoryBuilder) = 8UL

    override fun write(value: LectureCategoryBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}



/**
 * 채플 결석신청 정보
 */
data class ChapelAbsenceRequest (
    val `year`: kotlin.UInt, 
    val `semester`: SemesterType, 
    val `absenceDetail`: kotlin.String, 
    val `absenceStart`: kotlin.String, 
    val `absenceEnd`: kotlin.String, 
    val `absenceReasonKr`: kotlin.String, 
    val `absenceReasonEn`: kotlin.String, 
    val `applicationDate`: kotlin.String, 
    val `approvalDate`: kotlin.String, 
    val `denialReason`: kotlin.String, 
    val `status`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeChapelAbsenceRequest: FfiConverterRustBuffer<ChapelAbsenceRequest> {
    override fun read(buf: ByteBuffer): ChapelAbsenceRequest {
        return ChapelAbsenceRequest(
            FfiConverterUInt.read(buf),
            FfiConverterTypeSemesterType.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: ChapelAbsenceRequest) = (
            FfiConverterUInt.allocationSize(value.`year`) +
            FfiConverterTypeSemesterType.allocationSize(value.`semester`) +
            FfiConverterString.allocationSize(value.`absenceDetail`) +
            FfiConverterString.allocationSize(value.`absenceStart`) +
            FfiConverterString.allocationSize(value.`absenceEnd`) +
            FfiConverterString.allocationSize(value.`absenceReasonKr`) +
            FfiConverterString.allocationSize(value.`absenceReasonEn`) +
            FfiConverterString.allocationSize(value.`applicationDate`) +
            FfiConverterString.allocationSize(value.`approvalDate`) +
            FfiConverterString.allocationSize(value.`denialReason`) +
            FfiConverterString.allocationSize(value.`status`)
    )

    override fun write(value: ChapelAbsenceRequest, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`year`, buf)
            FfiConverterTypeSemesterType.write(value.`semester`, buf)
            FfiConverterString.write(value.`absenceDetail`, buf)
            FfiConverterString.write(value.`absenceStart`, buf)
            FfiConverterString.write(value.`absenceEnd`, buf)
            FfiConverterString.write(value.`absenceReasonKr`, buf)
            FfiConverterString.write(value.`absenceReasonEn`, buf)
            FfiConverterString.write(value.`applicationDate`, buf)
            FfiConverterString.write(value.`approvalDate`, buf)
            FfiConverterString.write(value.`denialReason`, buf)
            FfiConverterString.write(value.`status`, buf)
    }
}



/**
 * 채플 수업별 출석정보
 */
data class ChapelAttendance (
    val `division`: kotlin.UInt, 
    val `classDate`: kotlin.String, 
    val `category`: kotlin.String, 
    val `instructor`: kotlin.String, 
    val `instructorDepartment`: kotlin.String, 
    val `title`: kotlin.String, 
    val `attendance`: kotlin.String, 
    val `result`: kotlin.String, 
    val `note`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeChapelAttendance: FfiConverterRustBuffer<ChapelAttendance> {
    override fun read(buf: ByteBuffer): ChapelAttendance {
        return ChapelAttendance(
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: ChapelAttendance) = (
            FfiConverterUInt.allocationSize(value.`division`) +
            FfiConverterString.allocationSize(value.`classDate`) +
            FfiConverterString.allocationSize(value.`category`) +
            FfiConverterString.allocationSize(value.`instructor`) +
            FfiConverterString.allocationSize(value.`instructorDepartment`) +
            FfiConverterString.allocationSize(value.`title`) +
            FfiConverterString.allocationSize(value.`attendance`) +
            FfiConverterString.allocationSize(value.`result`) +
            FfiConverterString.allocationSize(value.`note`)
    )

    override fun write(value: ChapelAttendance, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`division`, buf)
            FfiConverterString.write(value.`classDate`, buf)
            FfiConverterString.write(value.`category`, buf)
            FfiConverterString.write(value.`instructor`, buf)
            FfiConverterString.write(value.`instructorDepartment`, buf)
            FfiConverterString.write(value.`title`, buf)
            FfiConverterString.write(value.`attendance`, buf)
            FfiConverterString.write(value.`result`, buf)
            FfiConverterString.write(value.`note`, buf)
    }
}



/**
 * 학기별 채플 정보
 */
data class ChapelInformation (
    val `year`: kotlin.UInt, 
    val `semester`: SemesterType, 
    val `generalInformation`: GeneralChapelInformation, 
    val `attendances`: List<ChapelAttendance>, 
    val `absenceRequests`: List<ChapelAbsenceRequest>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeChapelInformation: FfiConverterRustBuffer<ChapelInformation> {
    override fun read(buf: ByteBuffer): ChapelInformation {
        return ChapelInformation(
            FfiConverterUInt.read(buf),
            FfiConverterTypeSemesterType.read(buf),
            FfiConverterTypeGeneralChapelInformation.read(buf),
            FfiConverterSequenceTypeChapelAttendance.read(buf),
            FfiConverterSequenceTypeChapelAbsenceRequest.read(buf),
        )
    }

    override fun allocationSize(value: ChapelInformation) = (
            FfiConverterUInt.allocationSize(value.`year`) +
            FfiConverterTypeSemesterType.allocationSize(value.`semester`) +
            FfiConverterTypeGeneralChapelInformation.allocationSize(value.`generalInformation`) +
            FfiConverterSequenceTypeChapelAttendance.allocationSize(value.`attendances`) +
            FfiConverterSequenceTypeChapelAbsenceRequest.allocationSize(value.`absenceRequests`)
    )

    override fun write(value: ChapelInformation, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`year`, buf)
            FfiConverterTypeSemesterType.write(value.`semester`, buf)
            FfiConverterTypeGeneralChapelInformation.write(value.`generalInformation`, buf)
            FfiConverterSequenceTypeChapelAttendance.write(value.`attendances`, buf)
            FfiConverterSequenceTypeChapelAbsenceRequest.write(value.`absenceRequests`, buf)
    }
}



/**
 * 과목별 성적
 */
data class ClassGrade (
    /**
     * 이수학년도
     */
    val `year`: kotlin.String, 
    /**
     * 이수학기
     */
    val `semester`: kotlin.String, 
    /**
     * 과목코드
     */
    val `code`: kotlin.String, 
    /**
     * 과목명
     */
    val `className`: kotlin.String, 
    /**
     * 과목학점
     */
    val `gradePoints`: kotlin.Float, 
    /**
     * 성적
     */
    val `score`: ClassScore, 
    /**
     * 등급
     */
    val `rank`: kotlin.String, 
    /**
     * 교수명
     */
    val `professor`: kotlin.String, 
    /**
     * 상세성적
     */
    val `detail`: Map<kotlin.String, kotlin.Float>?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeClassGrade: FfiConverterRustBuffer<ClassGrade> {
    override fun read(buf: ByteBuffer): ClassGrade {
        return ClassGrade(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterTypeClassScore.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalMapStringFloat.read(buf),
        )
    }

    override fun allocationSize(value: ClassGrade) = (
            FfiConverterString.allocationSize(value.`year`) +
            FfiConverterString.allocationSize(value.`semester`) +
            FfiConverterString.allocationSize(value.`code`) +
            FfiConverterString.allocationSize(value.`className`) +
            FfiConverterFloat.allocationSize(value.`gradePoints`) +
            FfiConverterTypeClassScore.allocationSize(value.`score`) +
            FfiConverterString.allocationSize(value.`rank`) +
            FfiConverterString.allocationSize(value.`professor`) +
            FfiConverterOptionalMapStringFloat.allocationSize(value.`detail`)
    )

    override fun write(value: ClassGrade, buf: ByteBuffer) {
            FfiConverterString.write(value.`year`, buf)
            FfiConverterString.write(value.`semester`, buf)
            FfiConverterString.write(value.`code`, buf)
            FfiConverterString.write(value.`className`, buf)
            FfiConverterFloat.write(value.`gradePoints`, buf)
            FfiConverterTypeClassScore.write(value.`score`, buf)
            FfiConverterString.write(value.`rank`, buf)
            FfiConverterString.write(value.`professor`, buf)
            FfiConverterOptionalMapStringFloat.write(value.`detail`, buf)
    }
}



/**
 * 강의의 시간표 정보입니다.
 */
data class CourseScheduleInformation (
    val `name`: kotlin.String, 
    val `professor`: kotlin.String, 
    val `time`: kotlin.String, 
    val `classroom`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeCourseScheduleInformation: FfiConverterRustBuffer<CourseScheduleInformation> {
    override fun read(buf: ByteBuffer): CourseScheduleInformation {
        return CourseScheduleInformation(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: CourseScheduleInformation) = (
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterString.allocationSize(value.`professor`) +
            FfiConverterString.allocationSize(value.`time`) +
            FfiConverterString.allocationSize(value.`classroom`)
    )

    override fun write(value: CourseScheduleInformation, buf: ByteBuffer) {
            FfiConverterString.write(value.`name`, buf)
            FfiConverterString.write(value.`professor`, buf)
            FfiConverterString.write(value.`time`, buf)
            FfiConverterString.write(value.`classroom`, buf)
    }
}



/**
 * 채플 기본 정보(좌석번호, 결석현황, 성적결과)
 */
data class GeneralChapelInformation (
    val `division`: kotlin.UInt, 
    val `chapelTime`: kotlin.String, 
    val `chapelRoom`: kotlin.String, 
    val `floorLevel`: kotlin.UInt, 
    val `seatNumber`: kotlin.String, 
    val `absenceTime`: kotlin.UInt, 
    val `result`: kotlin.String, 
    val `note`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeGeneralChapelInformation: FfiConverterRustBuffer<GeneralChapelInformation> {
    override fun read(buf: ByteBuffer): GeneralChapelInformation {
        return GeneralChapelInformation(
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: GeneralChapelInformation) = (
            FfiConverterUInt.allocationSize(value.`division`) +
            FfiConverterString.allocationSize(value.`chapelTime`) +
            FfiConverterString.allocationSize(value.`chapelRoom`) +
            FfiConverterUInt.allocationSize(value.`floorLevel`) +
            FfiConverterString.allocationSize(value.`seatNumber`) +
            FfiConverterUInt.allocationSize(value.`absenceTime`) +
            FfiConverterString.allocationSize(value.`result`) +
            FfiConverterString.allocationSize(value.`note`)
    )

    override fun write(value: GeneralChapelInformation, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`division`, buf)
            FfiConverterString.write(value.`chapelTime`, buf)
            FfiConverterString.write(value.`chapelRoom`, buf)
            FfiConverterUInt.write(value.`floorLevel`, buf)
            FfiConverterString.write(value.`seatNumber`, buf)
            FfiConverterUInt.write(value.`absenceTime`, buf)
            FfiConverterString.write(value.`result`, buf)
            FfiConverterString.write(value.`note`, buf)
    }
}



/**
 * 전체 성적(학적부, 증명)
 */
data class GradeSummary (
    /**
     * 신청학점
     */
    val `attemptedCredits`: kotlin.Float, 
    /**
     * 취득학점
     */
    val `earnedCredits`: kotlin.Float, 
    /**
     * 평점계
     */
    val `gradePointsSum`: kotlin.Float, 
    /**
     * 평점평균
     */
    val `gradePointsAvarage`: kotlin.Float, 
    /**
     * 산술평균
     */
    val `arithmeticMean`: kotlin.Float, 
    /**
     * P/F 학점계
     */
    val `pfEarnedCredits`: kotlin.Float
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeGradeSummary: FfiConverterRustBuffer<GradeSummary> {
    override fun read(buf: ByteBuffer): GradeSummary {
        return GradeSummary(
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
        )
    }

    override fun allocationSize(value: GradeSummary) = (
            FfiConverterFloat.allocationSize(value.`attemptedCredits`) +
            FfiConverterFloat.allocationSize(value.`earnedCredits`) +
            FfiConverterFloat.allocationSize(value.`gradePointsSum`) +
            FfiConverterFloat.allocationSize(value.`gradePointsAvarage`) +
            FfiConverterFloat.allocationSize(value.`arithmeticMean`) +
            FfiConverterFloat.allocationSize(value.`pfEarnedCredits`)
    )

    override fun write(value: GradeSummary, buf: ByteBuffer) {
            FfiConverterFloat.write(value.`attemptedCredits`, buf)
            FfiConverterFloat.write(value.`earnedCredits`, buf)
            FfiConverterFloat.write(value.`gradePointsSum`, buf)
            FfiConverterFloat.write(value.`gradePointsAvarage`, buf)
            FfiConverterFloat.write(value.`arithmeticMean`, buf)
            FfiConverterFloat.write(value.`pfEarnedCredits`, buf)
    }
}



/**
 * 졸업 요건
 */
data class GraduationRequirement (
    val `name`: kotlin.String, 
    val `requirement`: kotlin.UInt?, 
    val `calcuation`: kotlin.Float?, 
    val `difference`: kotlin.Float?, 
    val `result`: kotlin.Boolean, 
    val `category`: kotlin.String, 
    val `lectures`: List<kotlin.String>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeGraduationRequirement: FfiConverterRustBuffer<GraduationRequirement> {
    override fun read(buf: ByteBuffer): GraduationRequirement {
        return GraduationRequirement(
            FfiConverterString.read(buf),
            FfiConverterOptionalUInt.read(buf),
            FfiConverterOptionalFloat.read(buf),
            FfiConverterOptionalFloat.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: GraduationRequirement) = (
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterOptionalUInt.allocationSize(value.`requirement`) +
            FfiConverterOptionalFloat.allocationSize(value.`calcuation`) +
            FfiConverterOptionalFloat.allocationSize(value.`difference`) +
            FfiConverterBoolean.allocationSize(value.`result`) +
            FfiConverterString.allocationSize(value.`category`) +
            FfiConverterSequenceString.allocationSize(value.`lectures`)
    )

    override fun write(value: GraduationRequirement, buf: ByteBuffer) {
            FfiConverterString.write(value.`name`, buf)
            FfiConverterOptionalUInt.write(value.`requirement`, buf)
            FfiConverterOptionalFloat.write(value.`calcuation`, buf)
            FfiConverterOptionalFloat.write(value.`difference`, buf)
            FfiConverterBoolean.write(value.`result`, buf)
            FfiConverterString.write(value.`category`, buf)
            FfiConverterSequenceString.write(value.`lectures`, buf)
    }
}



/**
 * 전체 졸업 요건 정보
 */
data class GraduationRequirements (
    val `isGraduatable`: kotlin.Boolean, 
    val `requirements`: Map<kotlin.String, GraduationRequirement>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeGraduationRequirements: FfiConverterRustBuffer<GraduationRequirements> {
    override fun read(buf: ByteBuffer): GraduationRequirements {
        return GraduationRequirements(
            FfiConverterBoolean.read(buf),
            FfiConverterMapStringTypeGraduationRequirement.read(buf),
        )
    }

    override fun allocationSize(value: GraduationRequirements) = (
            FfiConverterBoolean.allocationSize(value.`isGraduatable`) +
            FfiConverterMapStringTypeGraduationRequirement.allocationSize(value.`requirements`)
    )

    override fun write(value: GraduationRequirements, buf: ByteBuffer) {
            FfiConverterBoolean.write(value.`isGraduatable`, buf)
            FfiConverterMapStringTypeGraduationRequirement.write(value.`requirements`, buf)
    }
}



/**
 * 졸업 학생 정보
 */
data class GraduationStudent (
    val `number`: kotlin.UInt, 
    val `name`: kotlin.String, 
    val `grade`: kotlin.UInt, 
    val `semester`: kotlin.UInt, 
    val `status`: kotlin.String, 
    val `applyYear`: kotlin.UInt, 
    val `applyType`: kotlin.String, 
    val `department`: kotlin.String, 
    val `majors`: List<kotlin.String>, 
    val `auditDate`: kotlin.String, 
    val `graduationPoints`: kotlin.Float, 
    val `completedPoints`: kotlin.Float
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeGraduationStudent: FfiConverterRustBuffer<GraduationStudent> {
    override fun read(buf: ByteBuffer): GraduationStudent {
        return GraduationStudent(
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
        )
    }

    override fun allocationSize(value: GraduationStudent) = (
            FfiConverterUInt.allocationSize(value.`number`) +
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterUInt.allocationSize(value.`grade`) +
            FfiConverterUInt.allocationSize(value.`semester`) +
            FfiConverterString.allocationSize(value.`status`) +
            FfiConverterUInt.allocationSize(value.`applyYear`) +
            FfiConverterString.allocationSize(value.`applyType`) +
            FfiConverterString.allocationSize(value.`department`) +
            FfiConverterSequenceString.allocationSize(value.`majors`) +
            FfiConverterString.allocationSize(value.`auditDate`) +
            FfiConverterFloat.allocationSize(value.`graduationPoints`) +
            FfiConverterFloat.allocationSize(value.`completedPoints`)
    )

    override fun write(value: GraduationStudent, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`number`, buf)
            FfiConverterString.write(value.`name`, buf)
            FfiConverterUInt.write(value.`grade`, buf)
            FfiConverterUInt.write(value.`semester`, buf)
            FfiConverterString.write(value.`status`, buf)
            FfiConverterUInt.write(value.`applyYear`, buf)
            FfiConverterString.write(value.`applyType`, buf)
            FfiConverterString.write(value.`department`, buf)
            FfiConverterSequenceString.write(value.`majors`, buf)
            FfiConverterString.write(value.`auditDate`, buf)
            FfiConverterFloat.write(value.`graduationPoints`, buf)
            FfiConverterFloat.write(value.`completedPoints`, buf)
    }
}



/**
 * 과목 정보
 */
data class Lecture (
    /**
     * 계획
     */
    val `syllabus`: kotlin.String?, 
    /**
     * 이수구분(주전공)
     */
    val `category`: kotlin.String, 
    /**
     * 이수구분(다전공)
     */
    val `subCategory`: kotlin.String?, 
    /**
     * 공학인증
     */
    val `abeekInfo`: kotlin.String?, 
    /**
     * 교과영역
     */
    val `field`: kotlin.String?, 
    /**
     * 과목번호
     */
    val `code`: kotlin.String, 
    /**
     * 과목명
     */
    val `name`: kotlin.String, 
    /**
     * 분반
     */
    val `division`: kotlin.String?, 
    /**
     * 교수명
     */
    val `professor`: kotlin.String, 
    /**
     * 개설학과
     */
    val `department`: kotlin.String, 
    /**
     * 시간/학점(설계)
     */
    val `timePoints`: kotlin.String, 
    /**
     * 수강인원
     */
    val `personeel`: kotlin.String, 
    /**
     * 여석
     */
    val `remainingSeats`: kotlin.String, 
    /**
     * 강의시간(강의실)
     */
    val `scheduleRoom`: kotlin.String, 
    /**
     * 수강대상
     */
    val `target`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeLecture: FfiConverterRustBuffer<Lecture> {
    override fun read(buf: ByteBuffer): Lecture {
        return Lecture(
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: Lecture) = (
            FfiConverterOptionalString.allocationSize(value.`syllabus`) +
            FfiConverterString.allocationSize(value.`category`) +
            FfiConverterOptionalString.allocationSize(value.`subCategory`) +
            FfiConverterOptionalString.allocationSize(value.`abeekInfo`) +
            FfiConverterOptionalString.allocationSize(value.`field`) +
            FfiConverterString.allocationSize(value.`code`) +
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`division`) +
            FfiConverterString.allocationSize(value.`professor`) +
            FfiConverterString.allocationSize(value.`department`) +
            FfiConverterString.allocationSize(value.`timePoints`) +
            FfiConverterString.allocationSize(value.`personeel`) +
            FfiConverterString.allocationSize(value.`remainingSeats`) +
            FfiConverterString.allocationSize(value.`scheduleRoom`) +
            FfiConverterString.allocationSize(value.`target`)
    )

    override fun write(value: Lecture, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`syllabus`, buf)
            FfiConverterString.write(value.`category`, buf)
            FfiConverterOptionalString.write(value.`subCategory`, buf)
            FfiConverterOptionalString.write(value.`abeekInfo`, buf)
            FfiConverterOptionalString.write(value.`field`, buf)
            FfiConverterString.write(value.`code`, buf)
            FfiConverterString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`division`, buf)
            FfiConverterString.write(value.`professor`, buf)
            FfiConverterString.write(value.`department`, buf)
            FfiConverterString.write(value.`timePoints`, buf)
            FfiConverterString.write(value.`personeel`, buf)
            FfiConverterString.write(value.`remainingSeats`, buf)
            FfiConverterString.write(value.`scheduleRoom`, buf)
            FfiConverterString.write(value.`target`, buf)
    }
}



/**
 * 강의평가 결과
 */
data class LectureAssessmentResult (
    val `year`: kotlin.String, 
    val `semester`: SemesterType, 
    val `lectureCode`: kotlin.UInt, 
    val `lectureName`: kotlin.String, 
    val `points`: kotlin.Float, 
    val `professor`: kotlin.String, 
    val `collage`: kotlin.String, 
    val `department`: kotlin.String, 
    val `position`: kotlin.String, 
    val `score`: kotlin.Float
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeLectureAssessmentResult: FfiConverterRustBuffer<LectureAssessmentResult> {
    override fun read(buf: ByteBuffer): LectureAssessmentResult {
        return LectureAssessmentResult(
            FfiConverterString.read(buf),
            FfiConverterTypeSemesterType.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterFloat.read(buf),
        )
    }

    override fun allocationSize(value: LectureAssessmentResult) = (
            FfiConverterString.allocationSize(value.`year`) +
            FfiConverterTypeSemesterType.allocationSize(value.`semester`) +
            FfiConverterUInt.allocationSize(value.`lectureCode`) +
            FfiConverterString.allocationSize(value.`lectureName`) +
            FfiConverterFloat.allocationSize(value.`points`) +
            FfiConverterString.allocationSize(value.`professor`) +
            FfiConverterString.allocationSize(value.`collage`) +
            FfiConverterString.allocationSize(value.`department`) +
            FfiConverterString.allocationSize(value.`position`) +
            FfiConverterFloat.allocationSize(value.`score`)
    )

    override fun write(value: LectureAssessmentResult, buf: ByteBuffer) {
            FfiConverterString.write(value.`year`, buf)
            FfiConverterTypeSemesterType.write(value.`semester`, buf)
            FfiConverterUInt.write(value.`lectureCode`, buf)
            FfiConverterString.write(value.`lectureName`, buf)
            FfiConverterFloat.write(value.`points`, buf)
            FfiConverterString.write(value.`professor`, buf)
            FfiConverterString.write(value.`collage`, buf)
            FfiConverterString.write(value.`department`, buf)
            FfiConverterString.write(value.`position`, buf)
            FfiConverterFloat.write(value.`score`, buf)
    }
}



/**
 * 개인의 수업 시간표 정보를 조회합니다.
 */
data class PersonalCourseSchedule (
    val `schedule`: Map<Weekday, List<CourseScheduleInformation>>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypePersonalCourseSchedule: FfiConverterRustBuffer<PersonalCourseSchedule> {
    override fun read(buf: ByteBuffer): PersonalCourseSchedule {
        return PersonalCourseSchedule(
            FfiConverterMapTypeWeekdaySequenceTypeCourseScheduleInformation.read(buf),
        )
    }

    override fun allocationSize(value: PersonalCourseSchedule) = (
            FfiConverterMapTypeWeekdaySequenceTypeCourseScheduleInformation.allocationSize(value.`schedule`)
    )

    override fun write(value: PersonalCourseSchedule, buf: ByteBuffer) {
            FfiConverterMapTypeWeekdaySequenceTypeCourseScheduleInformation.write(value.`schedule`, buf)
    }
}



/**
 * 학기별 성적
 */
data class SemesterGrade (
    /**
     * 학년도
     */
    val `year`: kotlin.UInt, 
    /**
     * 학기
     */
    val `semester`: kotlin.String, 
    /**
     * 신청학점
     */
    val `attemptedCredits`: kotlin.Float, 
    /**
     * 취득학점
     */
    val `earnedCredits`: kotlin.Float, 
    /**
     * P/F학점
     */
    val `pfEarnedCredits`: kotlin.Float, 
    /**
     * 평점평균
     */
    val `gradePointsAvarage`: kotlin.Float, 
    /**
     * 평점계
     */
    val `gradePointsSum`: kotlin.Float, 
    /**
     * 산술평균
     */
    val `arithmeticMean`: kotlin.Float, 
    /**
     * 학기별석차
     */
    val `semesterRank`: U32Pair, 
    /**
     * 전체석차
     */
    val `generalRank`: U32Pair, 
    /**
     * 학사경고
     */
    val `academicProbation`: kotlin.Boolean, 
    /**
     * 상담여부
     */
    val `consult`: kotlin.Boolean, 
    /**
     * 유급
     */
    val `flunked`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSemesterGrade: FfiConverterRustBuffer<SemesterGrade> {
    override fun read(buf: ByteBuffer): SemesterGrade {
        return SemesterGrade(
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterTypeU32Pair.read(buf),
            FfiConverterTypeU32Pair.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: SemesterGrade) = (
            FfiConverterUInt.allocationSize(value.`year`) +
            FfiConverterString.allocationSize(value.`semester`) +
            FfiConverterFloat.allocationSize(value.`attemptedCredits`) +
            FfiConverterFloat.allocationSize(value.`earnedCredits`) +
            FfiConverterFloat.allocationSize(value.`pfEarnedCredits`) +
            FfiConverterFloat.allocationSize(value.`gradePointsAvarage`) +
            FfiConverterFloat.allocationSize(value.`gradePointsSum`) +
            FfiConverterFloat.allocationSize(value.`arithmeticMean`) +
            FfiConverterTypeU32Pair.allocationSize(value.`semesterRank`) +
            FfiConverterTypeU32Pair.allocationSize(value.`generalRank`) +
            FfiConverterBoolean.allocationSize(value.`academicProbation`) +
            FfiConverterBoolean.allocationSize(value.`consult`) +
            FfiConverterBoolean.allocationSize(value.`flunked`)
    )

    override fun write(value: SemesterGrade, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`year`, buf)
            FfiConverterString.write(value.`semester`, buf)
            FfiConverterFloat.write(value.`attemptedCredits`, buf)
            FfiConverterFloat.write(value.`earnedCredits`, buf)
            FfiConverterFloat.write(value.`pfEarnedCredits`, buf)
            FfiConverterFloat.write(value.`gradePointsAvarage`, buf)
            FfiConverterFloat.write(value.`gradePointsSum`, buf)
            FfiConverterFloat.write(value.`arithmeticMean`, buf)
            FfiConverterTypeU32Pair.write(value.`semesterRank`, buf)
            FfiConverterTypeU32Pair.write(value.`generalRank`, buf)
            FfiConverterBoolean.write(value.`academicProbation`, buf)
            FfiConverterBoolean.write(value.`consult`, buf)
            FfiConverterBoolean.write(value.`flunked`, buf)
    }
}



/**
 * 학생의 학적상태 기록
 */
data class StudentAcademicRecord (
    val `startDate`: kotlin.String, 
    val `endDate`: kotlin.String, 
    val `year`: kotlin.String, 
    val `term`: kotlin.String, 
    val `category`: kotlin.String, 
    val `reason`: kotlin.String, 
    val `processDate`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentAcademicRecord: FfiConverterRustBuffer<StudentAcademicRecord> {
    override fun read(buf: ByteBuffer): StudentAcademicRecord {
        return StudentAcademicRecord(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: StudentAcademicRecord) = (
            FfiConverterString.allocationSize(value.`startDate`) +
            FfiConverterString.allocationSize(value.`endDate`) +
            FfiConverterString.allocationSize(value.`year`) +
            FfiConverterString.allocationSize(value.`term`) +
            FfiConverterString.allocationSize(value.`category`) +
            FfiConverterString.allocationSize(value.`reason`) +
            FfiConverterString.allocationSize(value.`processDate`)
    )

    override fun write(value: StudentAcademicRecord, buf: ByteBuffer) {
            FfiConverterString.write(value.`startDate`, buf)
            FfiConverterString.write(value.`endDate`, buf)
            FfiConverterString.write(value.`year`, buf)
            FfiConverterString.write(value.`term`, buf)
            FfiConverterString.write(value.`category`, buf)
            FfiConverterString.write(value.`reason`, buf)
            FfiConverterString.write(value.`processDate`, buf)
    }
}



/**
 * 학생의 학적상태 정보
 */
data class StudentAcademicRecords (
    val `records`: List<StudentAcademicRecord>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentAcademicRecords: FfiConverterRustBuffer<StudentAcademicRecords> {
    override fun read(buf: ByteBuffer): StudentAcademicRecords {
        return StudentAcademicRecords(
            FfiConverterSequenceTypeStudentAcademicRecord.read(buf),
        )
    }

    override fun allocationSize(value: StudentAcademicRecords) = (
            FfiConverterSequenceTypeStudentAcademicRecord.allocationSize(value.`records`)
    )

    override fun write(value: StudentAcademicRecords, buf: ByteBuffer) {
            FfiConverterSequenceTypeStudentAcademicRecord.write(value.`records`, buf)
    }
}



/**
 * 학생의 은행 계좌 정보
 */
data class StudentBankAccount (
    val `bank`: kotlin.String?, 
    val `accountNumber`: kotlin.String?, 
    val `holder`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentBankAccount: FfiConverterRustBuffer<StudentBankAccount> {
    override fun read(buf: ByteBuffer): StudentBankAccount {
        return StudentBankAccount(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: StudentBankAccount) = (
            FfiConverterOptionalString.allocationSize(value.`bank`) +
            FfiConverterOptionalString.allocationSize(value.`accountNumber`) +
            FfiConverterOptionalString.allocationSize(value.`holder`)
    )

    override fun write(value: StudentBankAccount, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`bank`, buf)
            FfiConverterOptionalString.write(value.`accountNumber`, buf)
            FfiConverterOptionalString.write(value.`holder`, buf)
    }
}



/**
 * 학생의 가족관계 정보
 */
data class StudentFamily (
    val `members`: List<StudentFamilyMember>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentFamily: FfiConverterRustBuffer<StudentFamily> {
    override fun read(buf: ByteBuffer): StudentFamily {
        return StudentFamily(
            FfiConverterSequenceTypeStudentFamilyMember.read(buf),
        )
    }

    override fun allocationSize(value: StudentFamily) = (
            FfiConverterSequenceTypeStudentFamilyMember.allocationSize(value.`members`)
    )

    override fun write(value: StudentFamily, buf: ByteBuffer) {
            FfiConverterSequenceTypeStudentFamilyMember.write(value.`members`, buf)
    }
}



/**
 * 학생의 가족 구성원
 */
data class StudentFamilyMember (
    val `relationType`: kotlin.String?, 
    val `telNumber`: kotlin.String?, 
    val `name`: kotlin.String?, 
    val `mobileNumber`: kotlin.String?, 
    val `office`: kotlin.String?, 
    val `job`: kotlin.String?, 
    val `position`: kotlin.String?, 
    val `isGuardian`: kotlin.Boolean, 
    val `isCohabit`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentFamilyMember: FfiConverterRustBuffer<StudentFamilyMember> {
    override fun read(buf: ByteBuffer): StudentFamilyMember {
        return StudentFamilyMember(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: StudentFamilyMember) = (
            FfiConverterOptionalString.allocationSize(value.`relationType`) +
            FfiConverterOptionalString.allocationSize(value.`telNumber`) +
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`mobileNumber`) +
            FfiConverterOptionalString.allocationSize(value.`office`) +
            FfiConverterOptionalString.allocationSize(value.`job`) +
            FfiConverterOptionalString.allocationSize(value.`position`) +
            FfiConverterBoolean.allocationSize(value.`isGuardian`) +
            FfiConverterBoolean.allocationSize(value.`isCohabit`)
    )

    override fun write(value: StudentFamilyMember, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`relationType`, buf)
            FfiConverterOptionalString.write(value.`telNumber`, buf)
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`mobileNumber`, buf)
            FfiConverterOptionalString.write(value.`office`, buf)
            FfiConverterOptionalString.write(value.`job`, buf)
            FfiConverterOptionalString.write(value.`position`, buf)
            FfiConverterBoolean.write(value.`isGuardian`, buf)
            FfiConverterBoolean.write(value.`isCohabit`, buf)
    }
}



/**
 * 7+1 프로그램 정보를 반환합니다.
 */
data class StudentForignStudyInformation (
    val `approvalDate`: kotlin.String?, 
    val `authenticationNumber`: kotlin.String?, 
    val `issueDate`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentForignStudyInformation: FfiConverterRustBuffer<StudentForignStudyInformation> {
    override fun read(buf: ByteBuffer): StudentForignStudyInformation {
        return StudentForignStudyInformation(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: StudentForignStudyInformation) = (
            FfiConverterOptionalString.allocationSize(value.`approvalDate`) +
            FfiConverterOptionalString.allocationSize(value.`authenticationNumber`) +
            FfiConverterOptionalString.allocationSize(value.`issueDate`)
    )

    override fun write(value: StudentForignStudyInformation, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`approvalDate`, buf)
            FfiConverterOptionalString.write(value.`authenticationNumber`, buf)
            FfiConverterOptionalString.write(value.`issueDate`, buf)
    }
}



/**
 * 학생의 졸업 정보를 반환합니다. 졸업하지 않았다면 반환되지 않습니다.
 */
data class StudentGraduation (
    val `graduationCardinal`: kotlin.UInt, 
    val `graduationCertificationNumber`: kotlin.UInt, 
    val `graduationYear`: kotlin.UInt, 
    val `graduationTerms`: kotlin.UInt, 
    val `graduationDate`: kotlin.String, 
    val `academicDegreeNumber`: kotlin.UInt, 
    val `academicDegreeName`: kotlin.String, 
    val `earlyGraduation`: kotlin.Boolean, 
    val `graduationRank`: kotlin.UInt, 
    val `graduationPersonnelNumber`: kotlin.UInt
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentGraduation: FfiConverterRustBuffer<StudentGraduation> {
    override fun read(buf: ByteBuffer): StudentGraduation {
        return StudentGraduation(
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
        )
    }

    override fun allocationSize(value: StudentGraduation) = (
            FfiConverterUInt.allocationSize(value.`graduationCardinal`) +
            FfiConverterUInt.allocationSize(value.`graduationCertificationNumber`) +
            FfiConverterUInt.allocationSize(value.`graduationYear`) +
            FfiConverterUInt.allocationSize(value.`graduationTerms`) +
            FfiConverterString.allocationSize(value.`graduationDate`) +
            FfiConverterUInt.allocationSize(value.`academicDegreeNumber`) +
            FfiConverterString.allocationSize(value.`academicDegreeName`) +
            FfiConverterBoolean.allocationSize(value.`earlyGraduation`) +
            FfiConverterUInt.allocationSize(value.`graduationRank`) +
            FfiConverterUInt.allocationSize(value.`graduationPersonnelNumber`)
    )

    override fun write(value: StudentGraduation, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`graduationCardinal`, buf)
            FfiConverterUInt.write(value.`graduationCertificationNumber`, buf)
            FfiConverterUInt.write(value.`graduationYear`, buf)
            FfiConverterUInt.write(value.`graduationTerms`, buf)
            FfiConverterString.write(value.`graduationDate`, buf)
            FfiConverterUInt.write(value.`academicDegreeNumber`, buf)
            FfiConverterString.write(value.`academicDegreeName`, buf)
            FfiConverterBoolean.write(value.`earlyGraduation`, buf)
            FfiConverterUInt.write(value.`graduationRank`, buf)
            FfiConverterUInt.write(value.`graduationPersonnelNumber`, buf)
    }
}



/**
 * 기본 학생 정보
 */
data class StudentInformation (
    val `applyYear`: kotlin.UInt, 
    val `studentNumber`: kotlin.UInt, 
    val `name`: kotlin.String, 
    val `rrn`: kotlin.UInt, 
    val `collage`: kotlin.String, 
    val `department`: kotlin.String, 
    val `major`: kotlin.String?, 
    val `division`: kotlin.String?, 
    val `grade`: kotlin.UInt, 
    val `term`: kotlin.UInt, 
    val `image`: kotlin.ByteArray, 
    val `alias`: kotlin.String?, 
    val `kanjiName`: kotlin.String?, 
    val `email`: kotlin.String?, 
    val `telNumber`: kotlin.String?, 
    val `mobileNumber`: kotlin.String?, 
    val `postCode`: kotlin.String?, 
    val `address`: kotlin.String?, 
    val `specificAddress`: kotlin.String?, 
    val `isTransferStudent`: kotlin.Boolean, 
    val `applyDate`: kotlin.String, 
    val `appliedCollage`: kotlin.String, 
    val `appliedDepartment`: kotlin.String, 
    val `pluralMajor`: kotlin.String?, 
    val `subMajor`: kotlin.String?, 
    val `connectedMajor`: kotlin.String?, 
    val `abeek`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentInformation: FfiConverterRustBuffer<StudentInformation> {
    override fun read(buf: ByteBuffer): StudentInformation {
        return StudentInformation(
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: StudentInformation) = (
            FfiConverterUInt.allocationSize(value.`applyYear`) +
            FfiConverterUInt.allocationSize(value.`studentNumber`) +
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterUInt.allocationSize(value.`rrn`) +
            FfiConverterString.allocationSize(value.`collage`) +
            FfiConverterString.allocationSize(value.`department`) +
            FfiConverterOptionalString.allocationSize(value.`major`) +
            FfiConverterOptionalString.allocationSize(value.`division`) +
            FfiConverterUInt.allocationSize(value.`grade`) +
            FfiConverterUInt.allocationSize(value.`term`) +
            FfiConverterByteArray.allocationSize(value.`image`) +
            FfiConverterOptionalString.allocationSize(value.`alias`) +
            FfiConverterOptionalString.allocationSize(value.`kanjiName`) +
            FfiConverterOptionalString.allocationSize(value.`email`) +
            FfiConverterOptionalString.allocationSize(value.`telNumber`) +
            FfiConverterOptionalString.allocationSize(value.`mobileNumber`) +
            FfiConverterOptionalString.allocationSize(value.`postCode`) +
            FfiConverterOptionalString.allocationSize(value.`address`) +
            FfiConverterOptionalString.allocationSize(value.`specificAddress`) +
            FfiConverterBoolean.allocationSize(value.`isTransferStudent`) +
            FfiConverterString.allocationSize(value.`applyDate`) +
            FfiConverterString.allocationSize(value.`appliedCollage`) +
            FfiConverterString.allocationSize(value.`appliedDepartment`) +
            FfiConverterOptionalString.allocationSize(value.`pluralMajor`) +
            FfiConverterOptionalString.allocationSize(value.`subMajor`) +
            FfiConverterOptionalString.allocationSize(value.`connectedMajor`) +
            FfiConverterOptionalString.allocationSize(value.`abeek`)
    )

    override fun write(value: StudentInformation, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`applyYear`, buf)
            FfiConverterUInt.write(value.`studentNumber`, buf)
            FfiConverterString.write(value.`name`, buf)
            FfiConverterUInt.write(value.`rrn`, buf)
            FfiConverterString.write(value.`collage`, buf)
            FfiConverterString.write(value.`department`, buf)
            FfiConverterOptionalString.write(value.`major`, buf)
            FfiConverterOptionalString.write(value.`division`, buf)
            FfiConverterUInt.write(value.`grade`, buf)
            FfiConverterUInt.write(value.`term`, buf)
            FfiConverterByteArray.write(value.`image`, buf)
            FfiConverterOptionalString.write(value.`alias`, buf)
            FfiConverterOptionalString.write(value.`kanjiName`, buf)
            FfiConverterOptionalString.write(value.`email`, buf)
            FfiConverterOptionalString.write(value.`telNumber`, buf)
            FfiConverterOptionalString.write(value.`mobileNumber`, buf)
            FfiConverterOptionalString.write(value.`postCode`, buf)
            FfiConverterOptionalString.write(value.`address`, buf)
            FfiConverterOptionalString.write(value.`specificAddress`, buf)
            FfiConverterBoolean.write(value.`isTransferStudent`, buf)
            FfiConverterString.write(value.`applyDate`, buf)
            FfiConverterString.write(value.`appliedCollage`, buf)
            FfiConverterString.write(value.`appliedDepartment`, buf)
            FfiConverterOptionalString.write(value.`pluralMajor`, buf)
            FfiConverterOptionalString.write(value.`subMajor`, buf)
            FfiConverterOptionalString.write(value.`connectedMajor`, buf)
            FfiConverterOptionalString.write(value.`abeek`, buf)
    }
}



/**
 * 평생교육사 정보
 */
data class StudentLifelongInformation (
    val `applyDate`: kotlin.String?, 
    val `lifelongType`: kotlin.String?, 
    val `qualificationNumber`: kotlin.String?, 
    val `qualificationDate`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentLifelongInformation: FfiConverterRustBuffer<StudentLifelongInformation> {
    override fun read(buf: ByteBuffer): StudentLifelongInformation {
        return StudentLifelongInformation(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: StudentLifelongInformation) = (
            FfiConverterOptionalString.allocationSize(value.`applyDate`) +
            FfiConverterOptionalString.allocationSize(value.`lifelongType`) +
            FfiConverterOptionalString.allocationSize(value.`qualificationNumber`) +
            FfiConverterOptionalString.allocationSize(value.`qualificationDate`)
    )

    override fun write(value: StudentLifelongInformation, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`applyDate`, buf)
            FfiConverterOptionalString.write(value.`lifelongType`, buf)
            FfiConverterOptionalString.write(value.`qualificationNumber`, buf)
            FfiConverterOptionalString.write(value.`qualificationDate`, buf)
    }
}



/**
 * 학생의 자격(교직이수, 평생교육사, 7+1 프로그램) 정보
 */
data class StudentQualification (
    val `teachingMajor`: StudentTeachingMajorInformation?, 
    val `teachingPluralMajor`: StudentTeachingPluralMajorInformation?, 
    val `lifelong`: StudentLifelongInformation?, 
    val `forignStudy`: StudentForignStudyInformation?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentQualification: FfiConverterRustBuffer<StudentQualification> {
    override fun read(buf: ByteBuffer): StudentQualification {
        return StudentQualification(
            FfiConverterOptionalTypeStudentTeachingMajorInformation.read(buf),
            FfiConverterOptionalTypeStudentTeachingPluralMajorInformation.read(buf),
            FfiConverterOptionalTypeStudentLifelongInformation.read(buf),
            FfiConverterOptionalTypeStudentForignStudyInformation.read(buf),
        )
    }

    override fun allocationSize(value: StudentQualification) = (
            FfiConverterOptionalTypeStudentTeachingMajorInformation.allocationSize(value.`teachingMajor`) +
            FfiConverterOptionalTypeStudentTeachingPluralMajorInformation.allocationSize(value.`teachingPluralMajor`) +
            FfiConverterOptionalTypeStudentLifelongInformation.allocationSize(value.`lifelong`) +
            FfiConverterOptionalTypeStudentForignStudyInformation.allocationSize(value.`forignStudy`)
    )

    override fun write(value: StudentQualification, buf: ByteBuffer) {
            FfiConverterOptionalTypeStudentTeachingMajorInformation.write(value.`teachingMajor`, buf)
            FfiConverterOptionalTypeStudentTeachingPluralMajorInformation.write(value.`teachingPluralMajor`, buf)
            FfiConverterOptionalTypeStudentLifelongInformation.write(value.`lifelong`, buf)
            FfiConverterOptionalTypeStudentForignStudyInformation.write(value.`forignStudy`, buf)
    }
}



/**
 * 학생의 종교 정보
 */
data class StudentReligion (
    val `religionType`: kotlin.String?, 
    val `startDate`: kotlin.String?, 
    val `church`: kotlin.String?, 
    val `churchMan`: kotlin.String?, 
    val `baptismLevel`: kotlin.String?, 
    val `baptismGrp`: kotlin.String?, 
    val `serviceDepartment`: kotlin.String?, 
    val `serviceDepartmentTitle`: kotlin.String?, 
    val `churchAddress`: kotlin.String?, 
    val `singeub`: kotlin.String?, 
    val `baptismDate`: kotlin.String?, 
    val `baptismChurch`: kotlin.String?, 
    val `baptismMan`: kotlin.String?, 
    val `churchGrp`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentReligion: FfiConverterRustBuffer<StudentReligion> {
    override fun read(buf: ByteBuffer): StudentReligion {
        return StudentReligion(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: StudentReligion) = (
            FfiConverterOptionalString.allocationSize(value.`religionType`) +
            FfiConverterOptionalString.allocationSize(value.`startDate`) +
            FfiConverterOptionalString.allocationSize(value.`church`) +
            FfiConverterOptionalString.allocationSize(value.`churchMan`) +
            FfiConverterOptionalString.allocationSize(value.`baptismLevel`) +
            FfiConverterOptionalString.allocationSize(value.`baptismGrp`) +
            FfiConverterOptionalString.allocationSize(value.`serviceDepartment`) +
            FfiConverterOptionalString.allocationSize(value.`serviceDepartmentTitle`) +
            FfiConverterOptionalString.allocationSize(value.`churchAddress`) +
            FfiConverterOptionalString.allocationSize(value.`singeub`) +
            FfiConverterOptionalString.allocationSize(value.`baptismDate`) +
            FfiConverterOptionalString.allocationSize(value.`baptismChurch`) +
            FfiConverterOptionalString.allocationSize(value.`baptismMan`) +
            FfiConverterOptionalString.allocationSize(value.`churchGrp`)
    )

    override fun write(value: StudentReligion, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`religionType`, buf)
            FfiConverterOptionalString.write(value.`startDate`, buf)
            FfiConverterOptionalString.write(value.`church`, buf)
            FfiConverterOptionalString.write(value.`churchMan`, buf)
            FfiConverterOptionalString.write(value.`baptismLevel`, buf)
            FfiConverterOptionalString.write(value.`baptismGrp`, buf)
            FfiConverterOptionalString.write(value.`serviceDepartment`, buf)
            FfiConverterOptionalString.write(value.`serviceDepartmentTitle`, buf)
            FfiConverterOptionalString.write(value.`churchAddress`, buf)
            FfiConverterOptionalString.write(value.`singeub`, buf)
            FfiConverterOptionalString.write(value.`baptismDate`, buf)
            FfiConverterOptionalString.write(value.`baptismChurch`, buf)
            FfiConverterOptionalString.write(value.`baptismMan`, buf)
            FfiConverterOptionalString.write(value.`churchGrp`, buf)
    }
}



/**
 * 연구비 입금 계좌 정보
 */
data class StudentResearchBankAccount (
    val `bank`: kotlin.String?, 
    val `accountNumber`: kotlin.String?, 
    val `holder`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentResearchBankAccount: FfiConverterRustBuffer<StudentResearchBankAccount> {
    override fun read(buf: ByteBuffer): StudentResearchBankAccount {
        return StudentResearchBankAccount(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: StudentResearchBankAccount) = (
            FfiConverterOptionalString.allocationSize(value.`bank`) +
            FfiConverterOptionalString.allocationSize(value.`accountNumber`) +
            FfiConverterOptionalString.allocationSize(value.`holder`)
    )

    override fun write(value: StudentResearchBankAccount, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`bank`, buf)
            FfiConverterOptionalString.write(value.`accountNumber`, buf)
            FfiConverterOptionalString.write(value.`holder`, buf)
    }
}



/**
 * 교직이수(주전공) 정보
 */
data class StudentTeachingMajorInformation (
    val `majorName`: kotlin.String?, 
    val `qualificationNumber`: kotlin.String?, 
    val `initiationDate`: kotlin.String?, 
    val `qualificationDate`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentTeachingMajorInformation: FfiConverterRustBuffer<StudentTeachingMajorInformation> {
    override fun read(buf: ByteBuffer): StudentTeachingMajorInformation {
        return StudentTeachingMajorInformation(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: StudentTeachingMajorInformation) = (
            FfiConverterOptionalString.allocationSize(value.`majorName`) +
            FfiConverterOptionalString.allocationSize(value.`qualificationNumber`) +
            FfiConverterOptionalString.allocationSize(value.`initiationDate`) +
            FfiConverterOptionalString.allocationSize(value.`qualificationDate`)
    )

    override fun write(value: StudentTeachingMajorInformation, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`majorName`, buf)
            FfiConverterOptionalString.write(value.`qualificationNumber`, buf)
            FfiConverterOptionalString.write(value.`initiationDate`, buf)
            FfiConverterOptionalString.write(value.`qualificationDate`, buf)
    }
}



/**
 * 교직이수(복수전공) 정보
 */
data class StudentTeachingPluralMajorInformation (
    val `majorName`: kotlin.String?, 
    val `qualificationNumber`: kotlin.String?, 
    val `qualificationDate`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentTeachingPluralMajorInformation: FfiConverterRustBuffer<StudentTeachingPluralMajorInformation> {
    override fun read(buf: ByteBuffer): StudentTeachingPluralMajorInformation {
        return StudentTeachingPluralMajorInformation(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: StudentTeachingPluralMajorInformation) = (
            FfiConverterOptionalString.allocationSize(value.`majorName`) +
            FfiConverterOptionalString.allocationSize(value.`qualificationNumber`) +
            FfiConverterOptionalString.allocationSize(value.`qualificationDate`)
    )

    override fun write(value: StudentTeachingPluralMajorInformation, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`majorName`, buf)
            FfiConverterOptionalString.write(value.`qualificationNumber`, buf)
            FfiConverterOptionalString.write(value.`qualificationDate`, buf)
    }
}



/**
 * 편입정보 내 기록
 */
data class StudentTransferRecord (
    val `isTransfer`: kotlin.String, 
    val `admissionDate`: kotlin.String, 
    val `admissionGrade`: kotlin.String, 
    val `admissionTerm`: kotlin.String, 
    val `acceptedCredit`: kotlin.String, 
    val `acceptedTerms`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentTransferRecord: FfiConverterRustBuffer<StudentTransferRecord> {
    override fun read(buf: ByteBuffer): StudentTransferRecord {
        return StudentTransferRecord(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: StudentTransferRecord) = (
            FfiConverterString.allocationSize(value.`isTransfer`) +
            FfiConverterString.allocationSize(value.`admissionDate`) +
            FfiConverterString.allocationSize(value.`admissionGrade`) +
            FfiConverterString.allocationSize(value.`admissionTerm`) +
            FfiConverterString.allocationSize(value.`acceptedCredit`) +
            FfiConverterString.allocationSize(value.`acceptedTerms`)
    )

    override fun write(value: StudentTransferRecord, buf: ByteBuffer) {
            FfiConverterString.write(value.`isTransfer`, buf)
            FfiConverterString.write(value.`admissionDate`, buf)
            FfiConverterString.write(value.`admissionGrade`, buf)
            FfiConverterString.write(value.`admissionTerm`, buf)
            FfiConverterString.write(value.`acceptedCredit`, buf)
            FfiConverterString.write(value.`acceptedTerms`, buf)
    }
}



/**
 * 학생 편입 정보
 */
data class StudentTransferRecords (
    val `records`: List<StudentTransferRecord>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentTransferRecords: FfiConverterRustBuffer<StudentTransferRecords> {
    override fun read(buf: ByteBuffer): StudentTransferRecords {
        return StudentTransferRecords(
            FfiConverterSequenceTypeStudentTransferRecord.read(buf),
        )
    }

    override fun allocationSize(value: StudentTransferRecords) = (
            FfiConverterSequenceTypeStudentTransferRecord.allocationSize(value.`records`)
    )

    override fun write(value: StudentTransferRecords, buf: ByteBuffer) {
            FfiConverterSequenceTypeStudentTransferRecord.write(value.`records`, buf)
    }
}



/**
 * 학생의 직업 정보
 */
data class StudentWorkInformation (
    val `job`: kotlin.String?, 
    val `publicOfficial`: kotlin.String?, 
    val `companyName`: kotlin.String?, 
    val `departmentName`: kotlin.String?, 
    val `title`: kotlin.String?, 
    val `zipCode`: kotlin.String?, 
    val `address`: kotlin.String?, 
    val `specificAddress`: kotlin.String?, 
    val `telNumber`: kotlin.String?, 
    val `faxNumber`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStudentWorkInformation: FfiConverterRustBuffer<StudentWorkInformation> {
    override fun read(buf: ByteBuffer): StudentWorkInformation {
        return StudentWorkInformation(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: StudentWorkInformation) = (
            FfiConverterOptionalString.allocationSize(value.`job`) +
            FfiConverterOptionalString.allocationSize(value.`publicOfficial`) +
            FfiConverterOptionalString.allocationSize(value.`companyName`) +
            FfiConverterOptionalString.allocationSize(value.`departmentName`) +
            FfiConverterOptionalString.allocationSize(value.`title`) +
            FfiConverterOptionalString.allocationSize(value.`zipCode`) +
            FfiConverterOptionalString.allocationSize(value.`address`) +
            FfiConverterOptionalString.allocationSize(value.`specificAddress`) +
            FfiConverterOptionalString.allocationSize(value.`telNumber`) +
            FfiConverterOptionalString.allocationSize(value.`faxNumber`)
    )

    override fun write(value: StudentWorkInformation, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`job`, buf)
            FfiConverterOptionalString.write(value.`publicOfficial`, buf)
            FfiConverterOptionalString.write(value.`companyName`, buf)
            FfiConverterOptionalString.write(value.`departmentName`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
            FfiConverterOptionalString.write(value.`zipCode`, buf)
            FfiConverterOptionalString.write(value.`address`, buf)
            FfiConverterOptionalString.write(value.`specificAddress`, buf)
            FfiConverterOptionalString.write(value.`telNumber`, buf)
            FfiConverterOptionalString.write(value.`faxNumber`, buf)
    }
}



/**
 * uniffi 지원을 위한 u32 Pair입니다.
 */
data class UnsignedIntPair (
    val `first`: kotlin.UInt, 
    val `second`: kotlin.UInt
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeUnsignedIntPair: FfiConverterRustBuffer<UnsignedIntPair> {
    override fun read(buf: ByteBuffer): UnsignedIntPair {
        return UnsignedIntPair(
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
        )
    }

    override fun allocationSize(value: UnsignedIntPair) = (
            FfiConverterUInt.allocationSize(value.`first`) +
            FfiConverterUInt.allocationSize(value.`second`)
    )

    override fun write(value: UnsignedIntPair, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`first`, buf)
            FfiConverterUInt.write(value.`second`, buf)
    }
}



/**
 * 과목 점수
 */
sealed class ClassScore {
    
    /**
     * P/F 과목의 Pass
     */
    object Pass : ClassScore()
    
    
    /**
     * P/F 과목의 Failed
     */
    object Failed : ClassScore()
    
    
    /**
     * 일반 과목의 점수
     */
    data class Score(
        val v1: kotlin.UInt) : ClassScore() {
        companion object
    }
    
    /**
     * 성적 없음
     */
    object Empty : ClassScore()
    
    

    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeClassScore : FfiConverterRustBuffer<ClassScore>{
    override fun read(buf: ByteBuffer): ClassScore {
        return when(buf.getInt()) {
            1 -> ClassScore.Pass
            2 -> ClassScore.Failed
            3 -> ClassScore.Score(
                FfiConverterUInt.read(buf),
                )
            4 -> ClassScore.Empty
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: ClassScore) = when(value) {
        is ClassScore.Pass -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is ClassScore.Failed -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is ClassScore.Score -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterUInt.allocationSize(value.v1)
            )
        }
        is ClassScore.Empty -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
    }

    override fun write(value: ClassScore, buf: ByteBuffer) {
        when(value) {
            is ClassScore.Pass -> {
                buf.putInt(1)
                Unit
            }
            is ClassScore.Failed -> {
                buf.putInt(2)
                Unit
            }
            is ClassScore.Score -> {
                buf.putInt(3)
                FfiConverterUInt.write(value.v1, buf)
                Unit
            }
            is ClassScore.Empty -> {
                buf.putInt(4)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}





/**
 * 학위과정
 */

enum class CourseType {
    
    /**
     * 박사과정
     */
    PHD,
    /**
     * 석사과정
     */
    MASTER,
    /**
     * 석박과정
     */
    PHD_INTERGRATED,
    /**
     * 연구과정
     */
    RESEARCH,
    /**
     * 학사과정
     */
    BACHELOR;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeCourseType: FfiConverterRustBuffer<CourseType> {
    override fun read(buf: ByteBuffer) = try {
        CourseType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: CourseType) = 4UL

    override fun write(value: CourseType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}





/**
 * 강의를 찾을 때 사용하는 강의 카테고리
 */
sealed class LectureCategory {
    
    /**
     * 전공 강의
     */
    data class Major(
        /**
         * 단과대명
         */
        val `collage`: kotlin.String, 
        /**
         * 학부명
         */
        val `department`: kotlin.String, 
        /**
         * 전공명
         */
        val `major`: kotlin.String?) : LectureCategory() {
        companion object
    }
    
    /**
     * 교양필수
     */
    data class RequiredElective(
        /**
         * 과목명
         */
        val `lectureName`: kotlin.String) : LectureCategory() {
        companion object
    }
    
    /**
     * 교양선택
     */
    data class OptionalElective(
        /**
         * 교양 분류
         */
        val `category`: kotlin.String) : LectureCategory() {
        companion object
    }
    
    /**
     * 채플
     */
    data class Chapel(
        /**
         * 과목명
         */
        val `lectureName`: kotlin.String) : LectureCategory() {
        companion object
    }
    
    /**
     * 교직
     */
    object Education : LectureCategory()
    
    
    /**
     * 대학원
     */
    data class Graduated(
        /**
         * 단과대명
         */
        val `collage`: kotlin.String, 
        /**
         * 학부명
         */
        val `department`: kotlin.String) : LectureCategory() {
        companion object
    }
    
    /**
     * 연계전공
     */
    data class ConnectedMajor(
        /**
         * 전공명
         */
        val `major`: kotlin.String) : LectureCategory() {
        companion object
    }
    
    /**
     * 융합전공
     */
    data class UnitedMajor(
        /**
         * 전공명
         */
        val `major`: kotlin.String) : LectureCategory() {
        companion object
    }
    
    /**
     * 교수명 검색
     */
    data class FindByProfessor(
        /**
         * 교수명
         */
        val `keyword`: kotlin.String) : LectureCategory() {
        companion object
    }
    
    /**
     * 과목명 검색
     */
    data class FindByLecture(
        /**
         * 과목명
         */
        val `keyword`: kotlin.String) : LectureCategory() {
        companion object
    }
    
    /**
     * 타전공인정과목
     */
    data class RecognizedOtherMajor(
        /**
         * 단과대명
         */
        val `collage`: kotlin.String, 
        /**
         * 학부명
         */
        val `department`: kotlin.String, 
        /**
         * 전공명
         */
        val `major`: kotlin.String?) : LectureCategory() {
        companion object
    }
    
    /**
     * 숭실사이버대
     */
    object Cyber : LectureCategory()
    
    

    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeLectureCategory : FfiConverterRustBuffer<LectureCategory>{
    override fun read(buf: ByteBuffer): LectureCategory {
        return when(buf.getInt()) {
            1 -> LectureCategory.Major(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                FfiConverterOptionalString.read(buf),
                )
            2 -> LectureCategory.RequiredElective(
                FfiConverterString.read(buf),
                )
            3 -> LectureCategory.OptionalElective(
                FfiConverterString.read(buf),
                )
            4 -> LectureCategory.Chapel(
                FfiConverterString.read(buf),
                )
            5 -> LectureCategory.Education
            6 -> LectureCategory.Graduated(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            7 -> LectureCategory.ConnectedMajor(
                FfiConverterString.read(buf),
                )
            8 -> LectureCategory.UnitedMajor(
                FfiConverterString.read(buf),
                )
            9 -> LectureCategory.FindByProfessor(
                FfiConverterString.read(buf),
                )
            10 -> LectureCategory.FindByLecture(
                FfiConverterString.read(buf),
                )
            11 -> LectureCategory.RecognizedOtherMajor(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                FfiConverterOptionalString.read(buf),
                )
            12 -> LectureCategory.Cyber
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: LectureCategory) = when(value) {
        is LectureCategory.Major -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`collage`)
                + FfiConverterString.allocationSize(value.`department`)
                + FfiConverterOptionalString.allocationSize(value.`major`)
            )
        }
        is LectureCategory.RequiredElective -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`lectureName`)
            )
        }
        is LectureCategory.OptionalElective -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`category`)
            )
        }
        is LectureCategory.Chapel -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`lectureName`)
            )
        }
        is LectureCategory.Education -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is LectureCategory.Graduated -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`collage`)
                + FfiConverterString.allocationSize(value.`department`)
            )
        }
        is LectureCategory.ConnectedMajor -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`major`)
            )
        }
        is LectureCategory.UnitedMajor -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`major`)
            )
        }
        is LectureCategory.FindByProfessor -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`keyword`)
            )
        }
        is LectureCategory.FindByLecture -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`keyword`)
            )
        }
        is LectureCategory.RecognizedOtherMajor -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterString.allocationSize(value.`collage`)
                + FfiConverterString.allocationSize(value.`department`)
                + FfiConverterOptionalString.allocationSize(value.`major`)
            )
        }
        is LectureCategory.Cyber -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
    }

    override fun write(value: LectureCategory, buf: ByteBuffer) {
        when(value) {
            is LectureCategory.Major -> {
                buf.putInt(1)
                FfiConverterString.write(value.`collage`, buf)
                FfiConverterString.write(value.`department`, buf)
                FfiConverterOptionalString.write(value.`major`, buf)
                Unit
            }
            is LectureCategory.RequiredElective -> {
                buf.putInt(2)
                FfiConverterString.write(value.`lectureName`, buf)
                Unit
            }
            is LectureCategory.OptionalElective -> {
                buf.putInt(3)
                FfiConverterString.write(value.`category`, buf)
                Unit
            }
            is LectureCategory.Chapel -> {
                buf.putInt(4)
                FfiConverterString.write(value.`lectureName`, buf)
                Unit
            }
            is LectureCategory.Education -> {
                buf.putInt(5)
                Unit
            }
            is LectureCategory.Graduated -> {
                buf.putInt(6)
                FfiConverterString.write(value.`collage`, buf)
                FfiConverterString.write(value.`department`, buf)
                Unit
            }
            is LectureCategory.ConnectedMajor -> {
                buf.putInt(7)
                FfiConverterString.write(value.`major`, buf)
                Unit
            }
            is LectureCategory.UnitedMajor -> {
                buf.putInt(8)
                FfiConverterString.write(value.`major`, buf)
                Unit
            }
            is LectureCategory.FindByProfessor -> {
                buf.putInt(9)
                FfiConverterString.write(value.`keyword`, buf)
                Unit
            }
            is LectureCategory.FindByLecture -> {
                buf.putInt(10)
                FfiConverterString.write(value.`keyword`, buf)
                Unit
            }
            is LectureCategory.RecognizedOtherMajor -> {
                buf.putInt(11)
                FfiConverterString.write(value.`collage`, buf)
                FfiConverterString.write(value.`department`, buf)
                FfiConverterOptionalString.write(value.`major`, buf)
                Unit
            }
            is LectureCategory.Cyber -> {
                buf.putInt(12)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}





/**
 * 학기 종류
 *
 * 각 애플리케이션에서의 변환은 애플리케이션 내에서 직접 처리하여야 합니다.
 */

enum class SemesterType {
    
    /**
     * 1학기
     */
    ONE,
    /**
     * 여름학기
     */
    SUMMER,
    /**
     * 2학기
     */
    TWO,
    /**
     * 겨울학기
     */
    WINTER;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeSemesterType: FfiConverterRustBuffer<SemesterType> {
    override fun read(buf: ByteBuffer) = try {
        SemesterType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: SemesterType) = 4UL

    override fun write(value: SemesterType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}





/**
 * 한 주의 요일을 표현합니다.
 */

enum class Weekday {
    
    /**
     * 월요일
     */
    MON,
    /**
     * 화요일
     */
    TUE,
    /**
     * 수요일
     */
    WED,
    /**
     * 목요일
     */
    THU,
    /**
     * 금요일
     */
    FRI,
    /**
     * 토요일
     */
    SAT,
    /**
     * 일요일
     */
    SUN;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeWeekday: FfiConverterRustBuffer<Weekday> {
    override fun read(buf: ByteBuffer) = try {
        Weekday.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: Weekday) = 4UL

    override fun write(value: Weekday, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






/**
 * @suppress
 */
public object FfiConverterOptionalUInt: FfiConverterRustBuffer<kotlin.UInt?> {
    override fun read(buf: ByteBuffer): kotlin.UInt? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUInt.read(buf)
    }

    override fun allocationSize(value: kotlin.UInt?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterUInt.allocationSize(value)
        }
    }

    override fun write(value: kotlin.UInt?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUInt.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalFloat: FfiConverterRustBuffer<kotlin.Float?> {
    override fun read(buf: ByteBuffer): kotlin.Float? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterFloat.read(buf)
    }

    override fun allocationSize(value: kotlin.Float?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterFloat.allocationSize(value)
        }
    }

    override fun write(value: kotlin.Float?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterFloat.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalString: FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: ByteBuffer): kotlin.String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: kotlin.String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeStudentForignStudyInformation: FfiConverterRustBuffer<StudentForignStudyInformation?> {
    override fun read(buf: ByteBuffer): StudentForignStudyInformation? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeStudentForignStudyInformation.read(buf)
    }

    override fun allocationSize(value: StudentForignStudyInformation?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeStudentForignStudyInformation.allocationSize(value)
        }
    }

    override fun write(value: StudentForignStudyInformation?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeStudentForignStudyInformation.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeStudentLifelongInformation: FfiConverterRustBuffer<StudentLifelongInformation?> {
    override fun read(buf: ByteBuffer): StudentLifelongInformation? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeStudentLifelongInformation.read(buf)
    }

    override fun allocationSize(value: StudentLifelongInformation?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeStudentLifelongInformation.allocationSize(value)
        }
    }

    override fun write(value: StudentLifelongInformation?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeStudentLifelongInformation.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeStudentTeachingMajorInformation: FfiConverterRustBuffer<StudentTeachingMajorInformation?> {
    override fun read(buf: ByteBuffer): StudentTeachingMajorInformation? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeStudentTeachingMajorInformation.read(buf)
    }

    override fun allocationSize(value: StudentTeachingMajorInformation?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeStudentTeachingMajorInformation.allocationSize(value)
        }
    }

    override fun write(value: StudentTeachingMajorInformation?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeStudentTeachingMajorInformation.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeStudentTeachingPluralMajorInformation: FfiConverterRustBuffer<StudentTeachingPluralMajorInformation?> {
    override fun read(buf: ByteBuffer): StudentTeachingPluralMajorInformation? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeStudentTeachingPluralMajorInformation.read(buf)
    }

    override fun allocationSize(value: StudentTeachingPluralMajorInformation?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeStudentTeachingPluralMajorInformation.allocationSize(value)
        }
    }

    override fun write(value: StudentTeachingPluralMajorInformation?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeStudentTeachingPluralMajorInformation.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalMapStringFloat: FfiConverterRustBuffer<Map<kotlin.String, kotlin.Float>?> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, kotlin.Float>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterMapStringFloat.read(buf)
    }

    override fun allocationSize(value: Map<kotlin.String, kotlin.Float>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterMapStringFloat.allocationSize(value)
        }
    }

    override fun write(value: Map<kotlin.String, kotlin.Float>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterMapStringFloat.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceString: FfiConverterRustBuffer<List<kotlin.String>> {
    override fun read(buf: ByteBuffer): List<kotlin.String> {
        val len = buf.getInt()
        return List<kotlin.String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.String>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<kotlin.String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeChapelAbsenceRequest: FfiConverterRustBuffer<List<ChapelAbsenceRequest>> {
    override fun read(buf: ByteBuffer): List<ChapelAbsenceRequest> {
        val len = buf.getInt()
        return List<ChapelAbsenceRequest>(len) {
            FfiConverterTypeChapelAbsenceRequest.read(buf)
        }
    }

    override fun allocationSize(value: List<ChapelAbsenceRequest>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeChapelAbsenceRequest.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ChapelAbsenceRequest>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeChapelAbsenceRequest.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeChapelAttendance: FfiConverterRustBuffer<List<ChapelAttendance>> {
    override fun read(buf: ByteBuffer): List<ChapelAttendance> {
        val len = buf.getInt()
        return List<ChapelAttendance>(len) {
            FfiConverterTypeChapelAttendance.read(buf)
        }
    }

    override fun allocationSize(value: List<ChapelAttendance>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeChapelAttendance.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ChapelAttendance>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeChapelAttendance.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeCourseScheduleInformation: FfiConverterRustBuffer<List<CourseScheduleInformation>> {
    override fun read(buf: ByteBuffer): List<CourseScheduleInformation> {
        val len = buf.getInt()
        return List<CourseScheduleInformation>(len) {
            FfiConverterTypeCourseScheduleInformation.read(buf)
        }
    }

    override fun allocationSize(value: List<CourseScheduleInformation>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeCourseScheduleInformation.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<CourseScheduleInformation>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeCourseScheduleInformation.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeStudentAcademicRecord: FfiConverterRustBuffer<List<StudentAcademicRecord>> {
    override fun read(buf: ByteBuffer): List<StudentAcademicRecord> {
        val len = buf.getInt()
        return List<StudentAcademicRecord>(len) {
            FfiConverterTypeStudentAcademicRecord.read(buf)
        }
    }

    override fun allocationSize(value: List<StudentAcademicRecord>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeStudentAcademicRecord.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<StudentAcademicRecord>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeStudentAcademicRecord.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeStudentFamilyMember: FfiConverterRustBuffer<List<StudentFamilyMember>> {
    override fun read(buf: ByteBuffer): List<StudentFamilyMember> {
        val len = buf.getInt()
        return List<StudentFamilyMember>(len) {
            FfiConverterTypeStudentFamilyMember.read(buf)
        }
    }

    override fun allocationSize(value: List<StudentFamilyMember>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeStudentFamilyMember.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<StudentFamilyMember>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeStudentFamilyMember.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeStudentTransferRecord: FfiConverterRustBuffer<List<StudentTransferRecord>> {
    override fun read(buf: ByteBuffer): List<StudentTransferRecord> {
        val len = buf.getInt()
        return List<StudentTransferRecord>(len) {
            FfiConverterTypeStudentTransferRecord.read(buf)
        }
    }

    override fun allocationSize(value: List<StudentTransferRecord>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeStudentTransferRecord.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<StudentTransferRecord>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeStudentTransferRecord.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterMapStringFloat: FfiConverterRustBuffer<Map<kotlin.String, kotlin.Float>> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, kotlin.Float> {
        val len = buf.getInt()
        return buildMap<kotlin.String, kotlin.Float>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterFloat.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<kotlin.String, kotlin.Float>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterFloat.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<kotlin.String, kotlin.Float>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterFloat.write(v, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterMapStringTypeGraduationRequirement: FfiConverterRustBuffer<Map<kotlin.String, GraduationRequirement>> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, GraduationRequirement> {
        val len = buf.getInt()
        return buildMap<kotlin.String, GraduationRequirement>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterTypeGraduationRequirement.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<kotlin.String, GraduationRequirement>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterTypeGraduationRequirement.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<kotlin.String, GraduationRequirement>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterTypeGraduationRequirement.write(v, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterMapTypeWeekdaySequenceTypeCourseScheduleInformation: FfiConverterRustBuffer<Map<Weekday, List<CourseScheduleInformation>>> {
    override fun read(buf: ByteBuffer): Map<Weekday, List<CourseScheduleInformation>> {
        val len = buf.getInt()
        return buildMap<Weekday, List<CourseScheduleInformation>>(len) {
            repeat(len) {
                val k = FfiConverterTypeWeekday.read(buf)
                val v = FfiConverterSequenceTypeCourseScheduleInformation.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<Weekday, List<CourseScheduleInformation>>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterTypeWeekday.allocationSize(k) +
            FfiConverterSequenceTypeCourseScheduleInformation.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<Weekday, List<CourseScheduleInformation>>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterTypeWeekday.write(k, buf)
            FfiConverterSequenceTypeCourseScheduleInformation.write(v, buf)
        }
    }
}



/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias U32Pair = UnsignedIntPair
public typealias FfiConverterTypeU32Pair = FfiConverterTypeUnsignedIntPair

