/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide.gradle;

import dev.equo.solstice.NestedJars;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

class DepsResolve {
    static final String METADATA_PATH = "build/pluginUnderTestMetadata/plugin-under-test-metadata.properties";

    DepsResolve() {
    }

    static List<Object> resolveSolsticeAndTransitives() throws IOException {
        String implVersion = NestedJars.solsticeVersion();
        if (!implVersion.endsWith("-SNAPSHOT") || !"true".equals(System.getenv("EQUO_GRADLE_HARNESS"))) {
            return Collections.singletonList("dev.equo.ide:solstice:" + implVersion);
        }
        File file = new File(METADATA_PATH);
        if (!file.exists()) {
            file = new File("../../build/pluginUnderTestMetadata/plugin-under-test-metadata.properties");
        }
        Properties props = new Properties();
        try (FileInputStream input = new FileInputStream(file);){
            props.load(input);
        }
        String[] cp = props.get("implementation-classpath").toString().split(File.pathSeparator);
        ArrayList<Object> result = new ArrayList<Object>();
        for (String jarOrFolder : cp) {
            if (!jarOrFolder.endsWith(".jar")) continue;
            result.add(new File(jarOrFolder));
        }
        return result;
    }
}

