/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide.gradle;

import dev.equo.ide.BuildPluginIdeMain;
import dev.equo.ide.IdeHook;
import dev.equo.ide.WorkspaceInit;
import dev.equo.solstice.p2.P2QueryResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class EquoIdeTask
extends DefaultTask {
    @Internal
    IdeHook.List ideHooks;
    @Internal
    WorkspaceInit workspace;
    private boolean clean = false;
    private boolean initOnly = false;
    private boolean showConsole = false;
    private BuildPluginIdeMain.DebugClasspath debugClasspath = BuildPluginIdeMain.DebugClasspath.disabled;
    private Boolean useAtomosOverride = null;
    private boolean debugIde = false;

    @Internal
    public abstract Property<P2QueryResult> getQuery();

    @Internal
    public abstract Property<FileCollection> getMavenDeps();

    @Internal
    public abstract Property<File> getProjectDir();

    @Internal
    public abstract Property<Boolean> getUseAtomos();

    @Internal
    public abstract Property<Boolean> getEquoIdeWasCalledDirectly();

    public IdeHook.List getIdeHooks() {
        return this.ideHooks;
    }

    public WorkspaceInit getWorkspace() {
        return this.workspace;
    }

    @Option(option="clean", description="Wipes all IDE settings and state before rebuilding and launching.")
    void clean(boolean clean) {
        this.clean = clean;
    }

    @Option(option="init-only", description="Initializes the runtime to check for errors then exits.")
    void setInitOnly(boolean initOnly) {
        this.initOnly = initOnly;
    }

    @Option(option="show-console", description="Adds a visible console to the launched application.")
    void showConsole(boolean showConsole) {
        this.showConsole = showConsole;
    }

    @Option(option="debug-classpath", description="Dumps the classpath (in order) without starting the application.")
    void debugClasspath(BuildPluginIdeMain.DebugClasspath debugClasspath) {
        this.debugClasspath = debugClasspath;
    }

    @Option(option="use-atomos", description="Determines whether to use Atomos+Equinox or only Solstice's built-in OSGi shim")
    void useAtomos(String useAtomos) {
        this.useAtomosOverride = Boolean.parseBoolean(useAtomos);
    }

    @Option(option="debug-ide", description="The IDE will suspend until you attach a debugger.")
    void debugIde(boolean debugIde) {
        this.debugIde = debugIde;
    }

    @Inject
    public abstract ObjectFactory getObjectFactory();

    @TaskAction
    public void launch() throws IOException, InterruptedException {
        if (!((Boolean)this.getEquoIdeWasCalledDirectly().get()).booleanValue()) {
            throw new GradleException("You must call `equoIde` directly, you cannot call a task which depends on `equoIde`.");
        }
        BuildPluginIdeMain.Caller caller = BuildPluginIdeMain.Caller.forProjectDir((File)((File)this.getProjectDir().get()), (boolean)this.clean);
        ArrayList classpath = new ArrayList();
        try {
            ConfigurableFileCollection jarsNotOnMaven = this.getObjectFactory().fileCollection().from(new Object[]{((P2QueryResult)this.getQuery().get()).getJarsNotOnMavenCentral()});
            FileCollection p2AndMavenDeps = jarsNotOnMaven.plus((FileCollection)this.getMavenDeps().get());
            p2AndMavenDeps.forEach(classpath::add);
        }
        catch (Exception e) {
            throw new GradleException("Unable to download Equo dependencies. You probably need to add\n`repositories { mavenCentral() }` or something similar to your `build.gradle`.", (Throwable)e);
        }
        if (classpath.isEmpty()) {
            throw new GradleException("EquoIDE has nothing to install!\n\nWe recommend starting with this:\nequoIde {\n  gradleBuildship()\n}");
        }
        caller.ideHooks = this.ideHooks;
        caller.workspaceInit = this.workspace;
        caller.classpath = classpath;
        caller.debugClasspath = this.debugClasspath;
        caller.initOnly = this.initOnly;
        caller.showConsole = this.showConsole;
        caller.useAtomos = this.useAtomosOverride != null ? this.useAtomosOverride : (Boolean)this.getUseAtomos().get();
        caller.debugIde = this.debugIde;
        caller.showConsoleFlag = "--show-console";
        caller.cleanFlag = "--clean";
        caller.launch();
    }
}

