/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide.gradle;

import dev.equo.ide.IdeHook;
import dev.equo.ide.Launcher;
import dev.equo.ide.WorkspaceInit;
import dev.equo.ide.gradle.P2ModelDsl;
import dev.equo.ide.gradle.P2ModelDslWithCatalog;
import dev.equo.solstice.NestedJars;
import dev.equo.solstice.SignedJars;
import dev.equo.solstice.p2.P2ClientCache;
import dev.equo.solstice.p2.P2Model;
import dev.equo.solstice.p2.P2QueryCache;
import dev.equo.solstice.p2.P2QueryResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;

public class P2DepsExtension {
    private final Project project;
    private final Map<String, P2Model> configurations = new HashMap<String, P2Model>();
    private static final String $_OSGI_PLATFORM = "${osgi.platform}";

    public P2DepsExtension(Project project) {
        this.project = project;
    }

    public void into(String configuration, Action<P2ModelDslWithCatalog> p2) {
        this.into(List.of(configuration), p2);
    }

    public void into(Configuration configuration, Action<P2ModelDslWithCatalog> p2) {
        this.into(List.of(configuration), p2);
    }

    public void into(Collection<?> configs, Action<P2ModelDslWithCatalog> p2) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (Object config : configs) {
            if (config instanceof Configuration) {
                configurations.add((Configuration)config);
                continue;
            }
            if (config instanceof String) {
                configurations.add((Configuration)this.project.getConfigurations().maybeCreate((String)config));
                continue;
            }
            throw new IllegalArgumentException("Expected Configuration or String, got " + config);
        }
        P2ModelDslWithCatalog dsl = new P2ModelDslWithCatalog(this.project);
        p2.execute((Object)dsl);
        WorkspaceInit workspaceInitUnused = new WorkspaceInit();
        dsl.catalog.putInto(dsl.model, new IdeHook.List(), workspaceInitUnused);
        dsl.model.applyNativeFilterIfNoPlatformFilter();
        dsl.model.validateFilters();
        for (Configuration config : configurations) {
            P2Model existing = this.configurations.put(config.getName(), dsl.model);
            if (existing == null) continue;
            throw new IllegalArgumentException("Configuration " + config.getName() + " has multiple extensions.\n  existing=" + existing + "\n  new=" + dsl.model);
        }
    }

    void configure() {
        P2ClientCache clientCaching = P2ModelDsl.clientCaching(this.project);
        P2QueryCache queryCaching = P2ModelDsl.queryCaching(this.project);
        for (Map.Entry<String, P2Model> entry : this.configurations.entrySet()) {
            String config = entry.getKey();
            P2Model model = entry.getValue();
            P2DepsExtension.addPureMavenDeps(model, this.project, config);
            P2QueryResult query = model.query(clientCaching, queryCaching);
            for (String mavenCoord : query.getJarsOnMavenCentral()) {
                ModuleDependency dep = (ModuleDependency)this.project.getDependencies().add(config, (Object)mavenCoord);
                dep.setTransitive(false);
            }
            ArrayList nonMavenClasspath = new ArrayList();
            nonMavenClasspath.addAll(query.getJarsNotOnMavenCentral());
            ArrayList classpathSorted = Launcher.copyAndSortClasspath(nonMavenClasspath);
            SignedJars.stripIfNecessary((ArrayList)classpathSorted);
            for (Map.Entry nested : NestedJars.inFiles((Iterable)classpathSorted).extractAllNestedJars()) {
                classpathSorted.add((File)nested.getValue());
            }
            SignedJars.stripIfNecessary((ArrayList)classpathSorted);
            this.project.getDependencies().add(config, (Object)this.project.files(new Object[]{classpathSorted}));
            P2DepsExtension.replace$osgiplatformWith(this.project.getConfigurations().getByName(config), "");
        }
    }

    static void addPureMavenDeps(P2Model model, Project project, String configuration) {
        for (String mavenCoord : model.getPureMaven()) {
            project.getDependencies().add(configuration, P2DepsExtension.convertPureMaven(project, mavenCoord));
        }
    }

    private static Object convertPureMaven(Project project, String coordinate) {
        if (coordinate.startsWith(":")) {
            return project.project(coordinate);
        }
        return coordinate;
    }

    static void replace$osgiplatformWith(Configuration config, String replacement) {
        config.getResolutionStrategy().eachDependency(details -> {
            ModuleVersionSelector req = details.getRequested();
            if (req.getName().contains($_OSGI_PLATFORM)) {
                details.useTarget((Object)(req.getGroup() + ":" + req.getName().replace($_OSGI_PLATFORM, replacement) + ":" + req.getVersion()));
            }
        });
    }
}

