/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide.gradle;

import dev.equo.ide.gradle.EquoIdeGradlePlugin;
import dev.equo.solstice.p2.P2ClientCache;
import dev.equo.solstice.p2.P2Model;
import dev.equo.solstice.p2.P2QueryCache;
import org.gradle.api.Action;
import org.gradle.api.Project;

public class P2ModelDsl {
    protected final P2Model model;
    private static final String CLEAN_FLAG = "--clean";
    private static final String REFRESH_DEPENDENCIES = "--refresh-dependencies";

    public P2ModelDsl(P2Model model) {
        this.model = model;
    }

    public P2ModelDsl() {
        this(new P2Model());
    }

    public void p2repo(String p2) {
        this.model.addP2Repo(p2);
    }

    public void install(String target) {
        this.model.getInstall().add(target);
    }

    public void addFilter(String name, Action<P2Model.Filter> filterSetup) {
        P2Model.Filter filter = new P2Model.Filter();
        filterSetup.execute((Object)filter);
        this.model.addFilterAndValidate(name, filter);
    }

    public void removeFilter(String name) {
        this.model.removeFilter(name);
    }

    public void clearFilters() {
        this.model.getFilters().clear();
    }

    static P2ClientCache clientCaching(Project project) {
        boolean forceRecalculate = EquoIdeGradlePlugin.anyArgEquals(project, CLEAN_FLAG) || EquoIdeGradlePlugin.anyArgEquals(project, REFRESH_DEPENDENCIES);
        return P2ClientCache.defaultIfOfflineIsAndForceRecalculateIs((boolean)project.getGradle().getStartParameter().isOffline(), (boolean)forceRecalculate);
    }

    static P2QueryCache queryCaching(Project project) {
        boolean forceRecalculate = EquoIdeGradlePlugin.anyArgEquals(project, CLEAN_FLAG) || EquoIdeGradlePlugin.anyArgEquals(project, REFRESH_DEPENDENCIES);
        return forceRecalculate ? P2QueryCache.FORCE_RECALCULATE : P2QueryCache.ALLOW;
    }
}

