/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide.gradle;

import com.diffplug.common.swt.os.SwtPlatform;
import dev.equo.ide.Catalog;
import dev.equo.ide.WorkspaceInit;
import dev.equo.ide.gradle.DepsResolve;
import dev.equo.ide.gradle.EquoIdeExtension;
import dev.equo.ide.gradle.EquoIdeTask;
import dev.equo.ide.gradle.EquoListTask;
import dev.equo.ide.gradle.P2DepsExtension;
import dev.equo.ide.gradle.P2ModelDsl;
import dev.equo.solstice.NestedJars;
import dev.equo.solstice.p2.CacheLocations;
import dev.equo.solstice.p2.P2Model;
import dev.equo.solstice.p2.P2QueryResult;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.tasks.TaskProvider;

public class EquoIdeGradlePlugin
implements Plugin<Project> {
    static final String MINIMUM_GRADLE = "6.0";
    private static final String TASK_GROUP = "IDE";
    static final String EQUO_IDE = "equoIde";
    private static final String EQUO_LIST = "equoList";
    private static final String USE_ATOMOS_FLAG = "--use-atomos=";
    private static final Pattern BAD_SEMVER = Pattern.compile("(\\d+)\\.(\\d+)");

    public void apply(Project project) {
        if (EquoIdeGradlePlugin.gradleIsTooOld(project)) {
            throw new GradleException("equoIde requires Gradle 6.0 or later");
        }
        EquoIdeGradlePlugin.setCacheLocations(project);
        EquoIdeExtension extension = (EquoIdeExtension)project.getExtensions().create(EQUO_IDE, EquoIdeExtension.class, new Object[]{project});
        extension.branding.title(project.getName());
        boolean equoIdeWasCalledDirectly = EquoIdeGradlePlugin.anyArgEquals(project, EQUO_IDE);
        Configuration equoIde = this.createConfiguration(project, EQUO_IDE);
        TaskProvider equoIdeTask = project.getTasks().register(EQUO_IDE, EquoIdeTask.class, task -> {
            task.setGroup(TASK_GROUP);
            task.setDescription("Launches an Eclipse-based IDE for this project");
            task.getEquoIdeWasCalledDirectly().set((Object)equoIdeWasCalledDirectly);
        });
        project.getTasks().register(EQUO_LIST, EquoListTask.class, task -> {
            task.setGroup(TASK_GROUP);
            task.setDescription("Lists the p2 dependencies of an Eclipse application");
            task.getClientCaching().set((Object)P2ModelDsl.clientCaching(project));
            task.getExtension().set((Object)extension);
        });
        if (equoIdeWasCalledDirectly) {
            EquoIdeGradlePlugin.configureEquoTasks(project, extension, equoIde, (TaskProvider<EquoIdeTask>)equoIdeTask);
        }
    }

    private static void configureEquoTasks(Project project, EquoIdeExtension extension, Configuration equoIde, TaskProvider<EquoIdeTask> equoIdeTask) {
        try {
            for (Object dep : DepsResolve.resolveSolsticeAndTransitives()) {
                if (dep instanceof File) {
                    project.getDependencies().add(EQUO_IDE, (Object)project.files(new Object[]{dep}));
                    continue;
                }
                if (dep instanceof String) {
                    project.getDependencies().add(EQUO_IDE, dep);
                    continue;
                }
                throw new IllegalArgumentException("Expected String or File, got " + dep);
            }
        }
        catch (IOException e) {
            throw new GradleException("Unable to determine solstice version", (Throwable)e);
        }
        project.afterEvaluate(unused -> {
            try {
                WorkspaceInit workspace = new WorkspaceInit();
                P2Model model = extension.prepareModel(workspace);
                P2QueryResult query = model.query(P2ModelDsl.clientCaching(project), P2ModelDsl.queryCaching(project));
                workspace.copyAllFrom(extension.workspace);
                boolean useAtomosOverrideTrue = EquoIdeGradlePlugin.anyArgMatching(project, arg -> arg.startsWith(USE_ATOMOS_FLAG) && Boolean.parseBoolean(arg.substring(USE_ATOMOS_FLAG.length())));
                boolean useAtomos = extension.useAtomos || useAtomosOverrideTrue;
                for (String dep : NestedJars.transitiveDeps((boolean)useAtomos, (NestedJars.CoordFormat)NestedJars.CoordFormat.GRADLE, (P2QueryResult)query)) {
                    project.getDependencies().add(EQUO_IDE, (Object)dep);
                }
                P2DepsExtension.addPureMavenDeps(model, project, EQUO_IDE);
                for (String coordinate : query.getJarsOnMavenCentral()) {
                    ModuleDependency dep = (ModuleDependency)project.getDependencies().add(EQUO_IDE, (Object)coordinate);
                    dep.setTransitive(false);
                }
                if (Catalog.EQUO_CHROMIUM.isEnabled(model)) {
                    project.getRepositories().maven(a -> a.setUrl((Object)Catalog.EQUO_CHROMIUM.mavenRepo()));
                }
                equoIdeTask.configure(task -> {
                    task.getQuery().set((Object)query);
                    task.getMavenDeps().set((Object)equoIde);
                    task.getProjectDir().set((Object)project.getProjectDir());
                    task.getUseAtomos().set((Object)extension.useAtomos);
                    task.ideHooks = extension.getIdeHooks();
                    task.workspace = workspace;
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    static boolean anyArgMatching(Project project, Predicate<String> predicate) {
        return project.getGradle().getStartParameter().getTaskRequests().stream().flatMap(taskReq -> taskReq.getArgs().stream()).filter(predicate).findAny().isPresent();
    }

    static boolean anyArgEquals(Project project, String arg) {
        return EquoIdeGradlePlugin.anyArgMatching(project, a -> a.equals(arg));
    }

    private Configuration createConfiguration(Project project, String name) {
        return (Configuration)project.getConfigurations().create(name, config -> {
            config.attributes(attr -> attr.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)project.getObjects().named(Bundling.class, "external"))));
            config.setCanBeConsumed(false);
            config.setVisible(false);
            P2DepsExtension.replace$osgiplatformWith(config, SwtPlatform.getRunning().toString());
        });
    }

    static void setCacheLocations(Project project) {
        for (Field field : CacheLocations.class.getFields()) {
            Object value = project.findProperty("equo_" + field.getName());
            if (value == null) continue;
            try {
                field.set(null, new File(value.toString()));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static boolean gradleIsTooOld(Project project) {
        return EquoIdeGradlePlugin.badSemver(project.getGradle().getGradleVersion()) < EquoIdeGradlePlugin.badSemver(MINIMUM_GRADLE);
    }

    private static int badSemver(String input) {
        Matcher matcher = BAD_SEMVER.matcher(input);
        if (!matcher.find() || matcher.start() != 0) {
            throw new IllegalArgumentException("Version must start with " + BAD_SEMVER.pattern());
        }
        String major = matcher.group(1);
        String minor = matcher.group(2);
        return EquoIdeGradlePlugin.badSemver(Integer.parseInt(major), Integer.parseInt(minor));
    }

    private static int badSemver(int major, int minor) {
        return major * 1000000 + minor;
    }
}

