/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide.maven;

import dev.equo.ide.IdeHook;
import dev.equo.ide.WorkspaceInit;
import dev.equo.solstice.p2.P2Model;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractP2Mojo
extends AbstractMojo {
    @Parameter
    private List<Filter> filters = new ArrayList<Filter>();
    @Parameter
    private List<String> p2repos = new ArrayList<String>();
    @Parameter
    private List<String> installs = new ArrayList<String>();

    protected void modifyModel(P2Model model, IdeHook.List ideHooks, WorkspaceInit workspaceInit) {
    }

    protected P2Model prepareModel(IdeHook.List ideHooks, WorkspaceInit workspaceInit) throws MojoFailureException {
        P2Model model = new P2Model();
        this.modifyModel(model, ideHooks, workspaceInit);
        this.p2repos.forEach(arg_0 -> ((P2Model)model).addP2Repo(arg_0));
        this.installs.forEach(model.getInstall()::add);
        for (Filter filterModel : this.filters) {
            P2Model.Filter filter = filterModel.toFilter();
            model.addFilterAndValidate("maven-filter-unnamed-" + Integer.toString(filter.hashCode()), filter);
        }
        if (model.isEmpty()) {
            throw new MojoFailureException("EquoIDE has nothing to install!\n\nWe recommend starting with this:\n<configuration>\n  <jdt/>\n</configuration>\n");
        }
        model.applyNativeFilterIfNoPlatformFilter();
        return model;
    }

    public static class Filter {
        @Parameter
        private List<String> excludes = Collections.emptyList();
        @Parameter
        private List<String> excludePrefixes = Collections.emptyList();
        @Parameter
        private List<String> excludeSuffixes = Collections.emptyList();
        @Parameter
        private boolean platformNone = false;

        private P2Model.Filter toFilter() {
            P2Model.Filter filter = new P2Model.Filter();
            if (this.platformNone) {
                filter.platformNone();
            }
            this.excludes.forEach(arg_0 -> ((P2Model.Filter)filter).exclude(arg_0));
            this.excludePrefixes.forEach(arg_0 -> ((P2Model.Filter)filter).excludePrefix(arg_0));
            this.excludeSuffixes.forEach(arg_0 -> ((P2Model.Filter)filter).excludeSuffix(arg_0));
            return filter;
        }
    }
}

