/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide.maven;

import dev.equo.ide.Catalog;
import dev.equo.ide.CatalogDsl;
import dev.equo.ide.IdeHook;
import dev.equo.ide.IdeHookAssistAI;
import dev.equo.ide.IdeHookM2E;
import dev.equo.ide.WorkspaceInit;
import dev.equo.ide.maven.AbstractP2Mojo;
import dev.equo.solstice.p2.P2Model;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractP2MojoWithCatalog
extends AbstractP2Mojo {
    @Parameter
    private Platform platform;
    @Parameter
    private Jdt jdt;
    @Parameter
    private GradleBuildship gradleBuildship;
    @Parameter
    private Pde pde;
    @Parameter
    private EGit egit;
    @Parameter
    EquoChromium equoChromium;
    @Parameter
    ChatGPT chatGPT;
    @Parameter
    private AssistAI assistAI;
    @Parameter
    private Tabnine tabnine;
    @Parameter
    private M2E m2e;
    @Parameter
    private Kotlin kotlin;
    @Parameter
    private TmTerminal tmTerminal;
    @Parameter
    private Cdt cdt;
    @Parameter
    private Rust rust;
    @Parameter
    private Groovy groovy;

    @Override
    protected void modifyModel(P2Model model, IdeHook.List ideHooks, WorkspaceInit workspace) {
        CatalogDsl.TransitiveAwareList catalog = new CatalogDsl.TransitiveAwareList();
        Stream.of(new MavenCatalogDsl[]{this.platform, this.jdt, this.gradleBuildship, this.pde, this.egit, this.equoChromium, this.chatGPT, this.assistAI, this.tabnine, this.m2e, this.kotlin, this.tmTerminal, this.cdt, this.rust, this.groovy}).filter(Objects::nonNull).forEach(dsl -> {
            dsl.processVersionOverrides();
            catalog.add((CatalogDsl)dsl);
        });
        catalog.putInto(model, ideHooks, workspace);
    }

    public static class MavenCatalogDsl
    extends CatalogDsl {
        @Parameter
        private String version;
        @Parameter
        private String url;

        protected MavenCatalogDsl(Catalog catalog) {
            super(catalog);
        }

        protected void processVersionOverrides() {
            if (this.version != null && this.url != null) {
                throw new IllegalArgumentException("You must set only one of <version> or <url>, not both.");
            }
            if (this.version != null) {
                this.setUrlOverride(this.version);
            } else if (this.url != null) {
                this.setUrlOverride(this.url);
            }
        }
    }

    public static class Groovy
    extends MavenCatalogDsl {
        public Groovy() {
            super(Catalog.GROOVY);
        }
    }

    public static class Rust
    extends MavenCatalogDsl {
        public Rust() {
            super(Catalog.RUST);
        }
    }

    public static class Cdt
    extends MavenCatalogDsl {
        public Cdt() {
            super(Catalog.CDT);
        }
    }

    public static class TmTerminal
    extends MavenCatalogDsl {
        public TmTerminal() {
            super(Catalog.TM_TERMINAL);
        }
    }

    public static class Kotlin
    extends MavenCatalogDsl {
        public Kotlin() {
            super(Catalog.KOTLIN);
        }
    }

    public static class M2E
    extends MavenCatalogDsl {
        @Parameter
        private File autoImport;

        public M2E() {
            super(Catalog.M2E);
        }

        protected List<IdeHook> ideHooks() {
            if (this.autoImport == null) {
                return List.of();
            }
            return List.of(new IdeHookM2E(this.autoImport));
        }
    }

    public static class Tabnine
    extends MavenCatalogDsl {
        public Tabnine() {
            super(Catalog.TABNINE);
        }
    }

    public static class AssistAI
    extends MavenCatalogDsl {
        @Parameter(required=false)
        private String apiKey;
        @Parameter(required=false)
        private String modelName;

        public AssistAI() {
            super((Catalog)Catalog.ASSIST_AI);
        }

        protected List<IdeHook> ideHooks() {
            return List.of(new IdeHookAssistAI());
        }

        @Override
        protected void processVersionOverrides() {
            super.processVersionOverrides();
            if (this.apiKey != null) {
                Catalog.ASSIST_AI.apiKey(this.workspaceInit(), this.apiKey);
            }
            if (this.modelName != null) {
                Catalog.ASSIST_AI.modelName(this.workspaceInit(), this.modelName);
            }
        }
    }

    public static class ChatGPT
    extends MavenCatalogDsl {
        public ChatGPT() {
            super(Catalog.CHATGPT);
        }
    }

    public static class EquoChromium
    extends MavenCatalogDsl {
        public EquoChromium() {
            super((Catalog)Catalog.EQUO_CHROMIUM);
        }
    }

    public static class EGit
    extends MavenCatalogDsl {
        public EGit() {
            super(Catalog.EGIT);
        }
    }

    public static class Pde
    extends MavenCatalogDsl {
        @Parameter(required=false)
        private String missingApiBaseline;

        public Pde() {
            super((Catalog)Catalog.PDE);
        }

        @Override
        protected void processVersionOverrides() {
            super.processVersionOverrides();
            if (this.missingApiBaseline != null) {
                Catalog.PDE.missingApiBaseline(this.workspaceInit(), this.missingApiBaseline);
            }
        }
    }

    public static class GradleBuildship
    extends MavenCatalogDsl {
        public GradleBuildship() {
            super(Catalog.GRADLE_BUILDSHIP);
        }
    }

    public static class Jdt
    extends MavenCatalogDsl {
        @Parameter(required=false)
        private Map<String, String> classpathVariable;

        public Jdt() {
            super((Catalog)Catalog.JDT);
        }

        @Override
        protected void processVersionOverrides() {
            super.processVersionOverrides();
            if (this.classpathVariable != null) {
                this.classpathVariable.forEach((name, value) -> Catalog.JDT.classpathVariable(this.workspaceInit(), name, value));
            }
        }
    }

    public static class Platform
    extends MavenCatalogDsl {
        @Parameter(required=false)
        private Boolean showLineNumbers;
        @Parameter(required=false)
        private Boolean showWhitespace;
        @Parameter(required=false)
        private Boolean showLineEndings;

        public Platform() {
            super((Catalog)Catalog.PLATFORM);
        }

        @Override
        protected void processVersionOverrides() {
            super.processVersionOverrides();
            if (this.showLineNumbers != null) {
                Catalog.PLATFORM.showLineNumbers(this.workspaceInit(), this.showLineNumbers.booleanValue());
            }
            if (this.showWhitespace != null) {
                Catalog.PLATFORM.showWhitespace(this.workspaceInit(), this.showWhitespace.booleanValue());
            }
            if (this.showLineEndings != null) {
                Catalog.PLATFORM.showLineEndings(this.workspaceInit(), this.showLineEndings.booleanValue());
            }
        }
    }
}

