/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide.maven;

import com.diffplug.common.swt.os.OS;
import dev.equo.ide.BuildPluginIdeMain;
import dev.equo.ide.Catalog;
import dev.equo.ide.IdeHook;
import dev.equo.ide.IdeHookBranding;
import dev.equo.ide.IdeHookWelcome;
import dev.equo.ide.WorkspaceInit;
import dev.equo.ide.maven.AbstractP2MojoWithCatalog;
import dev.equo.ide.maven.Branding;
import dev.equo.ide.maven.Welcome;
import dev.equo.ide.maven.WorkspaceProp;
import dev.equo.solstice.NestedJars;
import dev.equo.solstice.p2.P2ClientCache;
import dev.equo.solstice.p2.P2Model;
import dev.equo.solstice.p2.P2QueryCache;
import dev.equo.solstice.p2.P2QueryResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

@Mojo(name="launch", aggregator=true)
public class LaunchMojo
extends AbstractP2MojoWithCatalog {
    @Parameter
    private Branding branding = new Branding();
    @Parameter
    private Welcome welcome = new Welcome();
    @Parameter(property="clean", defaultValue="false")
    private boolean clean;
    @Parameter(property="initOnly", defaultValue="false")
    private boolean initOnly;
    @Parameter(property="showConsole", defaultValue="false")
    private boolean showConsole;
    @Deprecated
    @Parameter(property="useChromium", defaultValue="false")
    private boolean useChromium;
    @Parameter(property="debugClasspath", defaultValue="disabled")
    private BuildPluginIdeMain.DebugClasspath debugClasspath;
    @Parameter(property="useAtomos", defaultValue="false")
    private boolean useAtomos;
    @Parameter(property="debugIde", defaultValue="false")
    private boolean debugIde;
    @Parameter(property="workspaceProps")
    private List<WorkspaceProp> workspaceProps = new ArrayList<WorkspaceProp>();
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    protected File baseDir;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    protected RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remotePluginRepositories}", required=true, readonly=true)
    protected List<RemoteRepository> repositories;
    private static final List<Exclusion> EXCLUDE_ALL_TRANSITIVES = Collections.singletonList(new Exclusion("*", "*", "*", "*"));

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.useChromium) {
                this.getLog().warn((CharSequence)"<useChromium>true</useChromium> is deprecated, use <equoChromium/> instead");
                if (this.equoChromium == null) {
                    this.equoChromium = new AbstractP2MojoWithCatalog.EquoChromium();
                }
            }
            BuildPluginIdeMain.Caller caller = BuildPluginIdeMain.Caller.forProjectDir((File)this.baseDir, (boolean)this.clean);
            IdeHook.List ideHooks = new IdeHook.List();
            ideHooks.add((Object)new IdeHookBranding().title(this.branding.title).icon(this.branding.icon).splash(this.branding.splash));
            if (this.welcome != null) {
                IdeHookWelcome welcomeHook = new IdeHookWelcome();
                welcomeHook.openUrl(this.welcome.openUrl).perspective(this.welcome.perspective);
                ideHooks.add((Object)welcomeHook);
            }
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            deps.add(new Dependency((Artifact)new DefaultArtifact("dev.equo.ide:solstice:" + NestedJars.solsticeVersion()), null));
            WorkspaceInit workspaceInit = new WorkspaceInit();
            boolean isOffline = false;
            P2ClientCache clientCaching = P2ClientCache.defaultIfOfflineIsAndForceRecalculateIs((boolean)isOffline, (boolean)this.clean);
            P2Model model = super.prepareModel(ideHooks, workspaceInit);
            P2QueryResult query = model.query(clientCaching, this.clean ? P2QueryCache.FORCE_RECALCULATE : P2QueryCache.ALLOW);
            for (String dep : NestedJars.transitiveDeps((boolean)this.useAtomos, (NestedJars.CoordFormat)NestedJars.CoordFormat.MAVEN, (P2QueryResult)query)) {
                deps.add(new Dependency((Artifact)new DefaultArtifact(dep), null, null, EXCLUDE_ALL_TRANSITIVES));
            }
            for (String coord : model.getPureMaven()) {
                deps.add(new Dependency((Artifact)new DefaultArtifact(coord), null));
            }
            for (String dep : query.getJarsOnMavenCentral()) {
                deps.add(new Dependency((Artifact)new DefaultArtifact(dep), null, null, EXCLUDE_ALL_TRANSITIVES));
            }
            if (Catalog.EQUO_CHROMIUM.isEnabled(model)) {
                this.repositories.add(new RemoteRepository.Builder("chromium", "default", Catalog.EQUO_CHROMIUM.mavenRepo()).build());
            }
            CollectRequest collectRequest = new CollectRequest(deps, null, this.repositories);
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest);
            for (WorkspaceProp workspaceProp : this.workspaceProps) {
                workspaceInit.setProperty(workspaceProp.path, workspaceProp.key, workspaceProp.value);
            }
            ArrayList<File> files = new ArrayList<File>();
            for (ArtifactResult artifact : dependencyResult.getArtifactResults()) {
                files.add(artifact.getArtifact().getFile());
            }
            for (File downloadedJar : query.getJarsNotOnMavenCentral()) {
                files.add(downloadedJar);
            }
            if (!OS.getNative().isMac()) {
                System.setProperty("equo-ide-maven-workarounds", "true");
            }
            caller.ideHooks = ideHooks;
            caller.workspaceInit = workspaceInit;
            caller.classpath = files;
            caller.debugClasspath = this.debugClasspath;
            caller.initOnly = this.initOnly;
            caller.showConsole = this.showConsole;
            caller.useAtomos = this.useAtomos;
            caller.debugIde = this.debugIde;
            caller.showConsoleFlag = "-DshowConsole";
            caller.cleanFlag = "-Dclean";
            caller.launch();
        }
        catch (IOException | InterruptedException | DependencyResolutionException e) {
            throw new RuntimeException(e);
        }
    }
}

