/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import com.google.common.collect.ImmutableList;
import dev.equo.ide.IdeHookBuildship;
import dev.equo.ide.IdeHookInstantiated;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.SynchronizationResult;
import org.eclipse.buildship.core.WrapperGradleDistribution;
import org.eclipse.buildship.core.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.buildship.ui.internal.util.gradle.GradleDistributionViewModel;
import org.eclipse.buildship.ui.internal.util.workbench.WorkbenchUtils;
import org.eclipse.buildship.ui.internal.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.gradle.tooling.GradleConnector;
import org.osgi.framework.BundleContext;

class BuildshipImpl
implements IdeHookInstantiated {
    IdeHookBuildship data;
    boolean isClean;
    BundleContext context;

    BuildshipImpl(IdeHookBuildship data) {
        this.data = data;
    }

    @Override
    public void isClean(boolean isClean) {
        this.isClean = isClean;
    }

    @Override
    public void afterOsgi(BundleContext context) {
        this.context = context;
    }

    @Override
    public void postStartup() throws Exception {
        if (!this.isClean) {
            return;
        }
        Workbench.getInstance().getActiveWorkbenchWindow().run(true, true, this::doImport);
    }

    private void doImport(IProgressMonitor monitor) throws InvocationTargetException {
        ProjectImportConfiguration importCfg = new ProjectImportConfiguration();
        importCfg.setProjectDir(this.data.rootDir);
        importCfg.setOfflineMode(this.data.isOffline);
        WrapperGradleDistribution distribution = GradleDistribution.fromBuild();
        importCfg.setDistribution(GradleDistributionViewModel.from((GradleDistribution)distribution));
        importCfg.setAutoSync(true);
        importCfg.setApplyWorkingSets(Boolean.valueOf(true));
        importCfg.setBuildScansEnabled(false);
        importCfg.setShowConsoleView(true);
        importCfg.setShowExecutionsView(true);
        importCfg.setOverwriteWorkspaceSettings(true);
        importCfg.setWorkingSets(Collections.emptyList());
        BuildConfiguration buildCfg = importCfg.toBuildConfiguration();
        GradleBuild gradleBuild = GradleCore.getWorkspace().createBuild(buildCfg);
        ImportWizardNewProjectHandler workingSetsAddingNewProjectHandler = new ImportWizardNewProjectHandler(NewProjectHandler.IMPORT_AND_MERGE, importCfg, (Boolean)importCfg.getShowExecutionsView().getValue());
        SynchronizationResult result = ((DefaultGradleBuild)gradleBuild).synchronize((NewProjectHandler)workingSetsAddingNewProjectHandler, GradleConnector.newCancellationTokenSource(), monitor);
        if (!result.getStatus().isOK()) {
            throw new InvocationTargetException((Throwable)new CoreException(result.getStatus()));
        }
    }

    private static final class ImportWizardNewProjectHandler
    implements NewProjectHandler {
        private final ProjectImportConfiguration configuration;
        private final NewProjectHandler importedBuildDelegate;
        private final boolean showExecutionsView;
        private volatile boolean gradleViewsVisible;

        private ImportWizardNewProjectHandler(NewProjectHandler delegate, ProjectImportConfiguration configuration, boolean showExecutionsView) {
            this.importedBuildDelegate = delegate;
            this.configuration = configuration;
            this.showExecutionsView = showExecutionsView;
        }

        public boolean shouldImportNewProjects() {
            return this.importedBuildDelegate.shouldImportNewProjects();
        }

        public void afterProjectImported(IProject project) {
            this.importedBuildDelegate.afterProjectImported(project);
            this.addWorkingSets(project);
            this.ensureGradleViewsAreVisible();
        }

        private void addWorkingSets(IProject project) {
            ImmutableList workingSetNames = (Boolean)this.configuration.getApplyWorkingSets().getValue() != false ? ImmutableList.copyOf((Collection)((Collection)this.configuration.getWorkingSets().getValue())) : ImmutableList.of();
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSet[] workingSets = WorkingSetUtils.toWorkingSets((List)workingSetNames);
            workingSetManager.addToWorkingSets((IAdaptable)project, workingSets);
        }

        private void ensureGradleViewsAreVisible() {
            Display.getDefault().asyncExec(() -> {
                WorkbenchUtils.showView((String)"org.eclipse.buildship.ui.views.taskview", (String)null, (int)1);
                WorkbenchUtils.showView((String)"org.eclipse.buildship.ui.views.executionview", (String)null, (int)2);
            });
        }
    }
}

