/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import com.diffplug.common.swt.os.SwtPlatform;
import dev.equo.solstice.Capability;
import dev.equo.solstice.ServiceRegistry;
import dev.equo.solstice.ShimBundle;
import dev.equo.solstice.ShimBundleCapability;
import dev.equo.solstice.ShimIdeBootstrapServices;
import dev.equo.solstice.ShimStorage;
import dev.equo.solstice.Solstice;
import dev.equo.solstice.SolsticeFrameworkUtilHelper;
import dev.equo.solstice.SolsticeManifest;
import dev.equo.solstice.Unimplemented;
import dev.equo.solstice.platform.Handler;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleContextShim
extends ServiceRegistry {
    final Logger logger = LoggerFactory.getLogger(BundleContextShim.class);
    static final Set<String> DONT_ACTIVATE = Set.of("org.eclipse.osgi");
    private static BundleContextShim instance;
    final EquinoxContainer container;
    private final Map<String, String> props;
    final ShimStorage storage;
    private ShimBundle systemBundle;
    private final List<ShimBundle> bundles = new ArrayList<ShimBundle>();
    final PackageAdmin packageAdmin = new Unimplemented.PackageAdmin(){

        @Override
        public int getBundleType(Bundle bundle) {
            if (bundle instanceof ShimBundle && ((ShimBundle)bundle).manifest.fragmentHost() != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public Bundle[] getBundles(String symbolicName, String versionRange) {
            Bundle[] bundleArray;
            ShimBundle bundle = BundleContextShim.this.bundleForSymbolicName(symbolicName);
            if (bundle == null) {
                bundleArray = new Bundle[]{};
            } else {
                Bundle[] bundleArray2 = new Bundle[1];
                bundleArray = bundleArray2;
                bundleArray2[0] = bundle;
            }
            return bundleArray;
        }

        @Override
        public Bundle[] getHosts(Bundle bundle) {
            String fragmentHost;
            if (bundle instanceof ShimBundle && (fragmentHost = ((ShimBundle)bundle).manifest.fragmentHost()) != null) {
                return this.getBundles(fragmentHost, null);
            }
            return new Bundle[0];
        }

        @Override
        public Bundle[] getFragments(Bundle bundle) {
            ArrayList<ShimBundle> fragments = new ArrayList<ShimBundle>();
            for (ShimBundle candidate : BundleContextShim.this.bundles) {
                if (!Objects.equals(candidate.manifest.fragmentHost(), bundle.getSymbolicName())) continue;
                fragments.add(candidate);
            }
            return fragments.toArray(new Bundle[0]);
        }
    };
    Capability.SupersetMap<ShimBundle> capabilities = new Capability.SupersetMap();
    final FrameworkWiring frameworkWiring = new Unimplemented.FrameworkWiring(){

        @Override
        public Collection<BundleCapability> findProviders(Requirement req) {
            if (!Set.of("filter").equals(req.getDirectives().keySet())) {
                throw Unimplemented.onPurpose("Solstice supports only filter, this was " + req.getDirectives());
            }
            String filterRaw = (String)req.getDirectives().get("filter");
            Map.Entry<String, String> filter = SolsticeManifest.parseSingleFilter(filterRaw);
            if (req.getNamespace().equals("osgi.identity")) {
                if (!filter.getKey().equals("osgi.identity")) {
                    throw Unimplemented.onPurpose("Solstice expected osgi.identity, was " + filter);
                }
                ShimBundle bundle = BundleContextShim.this.bundleForSymbolicName(filter.getValue());
                if (bundle == null) {
                    return Collections.emptyList();
                }
                Objects.requireNonNull(bundle, filter.getValue());
                return Collections.singleton(new ShimBundleCapability(bundle));
            }
            Capability cap = new Capability(req.getNamespace(), filter.getKey(), filter.getValue());
            ShimBundle result = BundleContextShim.this.capabilities.getAnySupersetOf(cap);
            if (result == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(new ShimBundleCapability(result));
        }
    };
    private final CopyOnWriteArrayList<BundleListener> bundleListeners = new CopyOnWriteArrayList();

    public static BundleContextShim hydrate(Solstice bundleSet, Map<String, String> props) {
        if (instance != null) {
            throw new IllegalStateException("Solstice has already been initialized");
        }
        EquinoxContainer container = new EquinoxContainer(props, null);
        EquinoxBundle fakeBundle = new EquinoxBundle(Long.valueOf(-1L), "FAKE LOCATION", null, null, -1, container);
        instance = new BundleContextShim(bundleSet, props, container, fakeBundle);
        return instance;
    }

    private BundleContextShim(Solstice bundleSet, Map<String, String> props, EquinoxContainer fakeContainer, EquinoxBundle fakeBundle) {
        super(fakeBundle, fakeContainer);
        this.container = fakeContainer;
        this.props = new TreeMap<String, String>(props);
        this.props.replaceAll((key, value) -> {
            if (ShimIdeBootstrapServices.locationKeys().contains(key)) {
                if (!((String)value).startsWith("file:")) {
                    value = new File((String)value).toURI().toString();
                }
                if (!((String)value).endsWith("/")) {
                    value = (String)value + "/";
                }
            }
            return value;
        });
        this.storage = new ShimStorage(props, this.logger);
        Handler.install(this);
        SolsticeFrameworkUtilHelper.initialize(this);
        bundleSet.hydrateFrom(manifest -> {
            long bundleId = "org.eclipse.osgi".equals(manifest.getSymbolicName()) ? 0L : (long)(manifest.classpathOrder + 1);
            ShimBundle bundle = new ShimBundle(bundleId, this, (SolsticeManifest)manifest);
            this.bundles.add(bundle);
            if (bundleId == 0L) {
                this.systemBundle = bundle;
            }
            return bundle;
        });
        Objects.requireNonNull(this.systemBundle);
        for (ShimBundle b : this.bundles) {
            this.notifyBundleListeners(1, b);
            b.state = 2;
        }
        for (ShimBundle b : this.bundles) {
            this.notifyBundleListeners(32, b);
            b.state = 4;
        }
        for (ShimBundle b : this.bundles) {
            if (!b.manifest.lazy) continue;
            this.notifyBundleListeners(512, b);
            b.state = 8;
        }
    }

    @Override
    public Bundle systemBundle() {
        return this.systemBundle;
    }

    public ShimBundle bundleForSymbolicName(String name) {
        for (ShimBundle bundle : this.bundles) {
            if (!name.equals(bundle.getSymbolicName())) continue;
            return bundle;
        }
        return null;
    }

    public Bundle bundleForUrl(URL source) {
        String sourceString = "jar:" + source.toExternalForm() + "!";
        for (ShimBundle bundle : this.bundles) {
            if (!sourceString.equals(bundle.manifest.getJarUrl())) continue;
            return bundle;
        }
        return null;
    }

    public Bundle getBundle() {
        return this.systemBundle;
    }

    public File getDataFile(String filename) {
        return this.storage.getDataFileBundle(this.systemBundle, filename);
    }

    public Bundle installBundle(String location, InputStream input) {
        throw Unimplemented.onPurpose();
    }

    public Bundle installBundle(String location) {
        throw Unimplemented.onPurpose();
    }

    public Bundle getBundle(String location) {
        if ("System Bundle".equals(location)) {
            return this.systemBundle;
        }
        throw Unimplemented.onPurpose();
    }

    public Bundle[] getBundles() {
        return this.bundles.toArray(new Bundle[0]);
    }

    public String getProperty(String key) {
        if ("osgi.os".equals(key)) {
            return SwtPlatform.getRunning().getOs();
        }
        if ("osgi.ws".equals(key)) {
            return SwtPlatform.getRunning().getWs();
        }
        String prop = this.props.get(key);
        if (prop != null) {
            return prop;
        }
        return System.getProperty(key);
    }

    public synchronized void addBundleListener(BundleListener listener) {
        this.bundleListeners.add(listener);
    }

    public synchronized void removeBundleListener(BundleListener listener) {
        this.bundleListeners.remove(listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
    }

    public void removeFrameworkListener(FrameworkListener listener) {
    }

    synchronized void notifyBundleListeners(int type, ShimBundle bundle) {
        BundleEvent event = new BundleEvent(type, (Bundle)bundle);
        for (BundleListener listener : this.bundleListeners) {
            try {
                boolean synchronousOnly;
                boolean bl = synchronousOnly = type == 128 || type == 512 || type == 256;
                if (synchronousOnly) {
                    if (!(listener instanceof SynchronousBundleListener)) continue;
                    listener.bundleChanged(event);
                    continue;
                }
                listener.bundleChanged(event);
            }
            catch (Exception e) {
                this.getService(this.getServiceReference(FrameworkLog.class)).log(new FrameworkEvent(2, (Bundle)bundle, (Throwable)e));
            }
        }
    }

    public Bundle getBundle(long id) {
        if (id == 0L) {
            return this.systemBundle;
        }
        for (ShimBundle bundle : this.bundles) {
            if (bundle.getBundleId() != id) continue;
            return bundle;
        }
        return null;
    }
}

