/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.Unimplemented;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Capability
implements Comparable<Capability> {
    static final String LIST_STR = ":List<String>";
    static final Set<String> IGNORED_NAMESPACES = Set.of("osgi.ee");
    static final Set<String> IGNORED_ATTRIBUTES = Set.of("version:Version");
    final String namespace;
    final ArrayList<String> keyValue = new ArrayList(2);

    public Capability(String namespace, String key, String value) {
        this(namespace);
        this.add(key, value);
    }

    public Capability(String namespace) {
        this.namespace = namespace;
    }

    public void add(String key, String value) {
        this.keyValue.add(key);
        this.keyValue.add(value);
    }

    public int size() {
        return this.keyValue.size() / 2;
    }

    @Override
    public int compareTo(@NotNull Capability o) {
        int result = this.namespace.compareTo(o.namespace);
        if (result != 0) {
            return result;
        }
        for (int i = 0; i < Math.min(this.keyValue.size(), o.keyValue.size()); ++i) {
            result = this.keyValue.get(i).compareTo(o.keyValue.get(i));
            if (result == 0) continue;
            return result;
        }
        return this.keyValue.size() - o.keyValue.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Capability ? this.compareTo((Capability)o) == 0 : false;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.keyValue);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.namespace);
        builder.append(':');
        for (int i = 0; i < this.keyValue.size() / 2; ++i) {
            builder.append(this.keyValue.get(2 * i));
            builder.append('=');
            builder.append(this.keyValue.get(2 * i + 1));
            builder.append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private Capability swap(int ... indices) {
        Capability copy = new Capability(this.namespace);
        for (int i = 0; i < indices.length; ++i) {
            copy.add(this.keyValue.get(2 * indices[i]), this.keyValue.get(2 * indices[i] + 1));
        }
        return copy;
    }

    public boolean isSubsetOfElementIn(Iterable<Capability> other) {
        for (Capability cap : other) {
            if (!this.isSubsetOf(cap)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubsetOf(Capability other) {
        return other.isSupersetOf(this);
    }

    public boolean isSupersetOf(Capability shorter) {
        if (this.size() < shorter.size()) {
            return false;
        }
        for (int i = 0; i < shorter.keyValue.size() / 2; ++i) {
            String key = shorter.keyValue.get(2 * i);
            String value = shorter.keyValue.get(2 * i + 1);
            int longerKeyIdx = this.keyIdxShortcut(key);
            if (longerKeyIdx == -1) {
                return false;
            }
            String longerValue = this.keyValue.get(longerKeyIdx + 1);
            if (value.equals(longerValue)) continue;
            return false;
        }
        return true;
    }

    public String getValue(String key) {
        int idx = this.keyIdxShortcut(key);
        if (idx == -1) {
            return null;
        }
        return this.keyValue.get(idx + 1);
    }

    private int keyIdxShortcut(String key) {
        int idx = this.keyValue.indexOf(key);
        if (idx == -1) {
            return -1;
        }
        if (idx % 2 == 1) {
            throw Unimplemented.onPurpose("Key has the same content as a value, unlikely to ever happen, straight-forward to fix if it does, please file an issue at https://github.com/equodev/equo-ide");
        }
        return idx;
    }

    public static class SupersetSet {
        private final SupersetMap<Capability> map = new SupersetMap();

        public void add(Capability cap) {
            this.map.put(cap, cap);
        }

        public void addAll(Iterable<Capability> capProvides) {
            capProvides.forEach(this::add);
        }

        public Capability getAnySupersetOf(Capability cap) {
            return this.map.getAnySupersetOf(cap);
        }

        public boolean containsAnySupersetOf(Capability cap) {
            return this.getAnySupersetOf(cap) != null;
        }

        public String toString() {
            return this.map.toStringMap.keySet().toString();
        }
    }

    public static class SupersetMap<T> {
        @Nullable
        private Capability lookingForSupersetOf;
        private final TreeMap<Capability, T> map = new TreeMap((a, b) -> {
            if (this.lookingForSupersetOf == null) {
                return a.compareTo((Capability)b);
            }
            if (this.lookingForSupersetOf == a && b.isSupersetOf(this.lookingForSupersetOf)) {
                return 0;
            }
            if (this.lookingForSupersetOf == b && a.isSupersetOf(this.lookingForSupersetOf)) {
                return 0;
            }
            return a.compareTo((Capability)b);
        });
        private final TreeMap<Capability, T> toStringMap = new TreeMap();

        public void put(Capability cap, T value) {
            if (this.lookingForSupersetOf != null) {
                throw new IllegalStateException();
            }
            this.toStringMap.put(cap, value);
            switch (cap.size()) {
                case 0: {
                    throw new IllegalArgumentException("Must have at least one key/value");
                }
                case 1: {
                    this.map.put(cap, value);
                    break;
                }
                case 2: {
                    this.map.put(cap, value);
                    this.map.put(cap.swap(1, 0), value);
                    break;
                }
                case 3: {
                    this.map.put(cap, value);
                    this.map.put(cap.swap(0, 2, 1), value);
                    this.map.put(cap.swap(1, 0, 2), value);
                    this.map.put(cap.swap(1, 2, 0), value);
                    this.map.put(cap.swap(2, 0, 1), value);
                    this.map.put(cap.swap(2, 1, 0), value);
                    break;
                }
                default: {
                    throw Unimplemented.onPurpose("Solstice only supports Capabilities with at most 3 properties, see Capabilities javadoc for how to remove this limitation");
                }
            }
        }

        public T getAnySupersetOf(Capability cap) {
            if (this.lookingForSupersetOf != null) {
                throw new IllegalStateException();
            }
            this.lookingForSupersetOf = cap;
            T value = this.map.get(cap);
            this.lookingForSupersetOf = null;
            return value;
        }

        public String toString() {
            return this.toStringMap.toString();
        }
    }
}

