/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.FileMisc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

class LockFile
implements AutoCloseable {
    final FileOutputStream lock;
    final File lockFile;

    LockFile(File dir) throws IOException {
        FileMisc.mkdirs(dir);
        this.lockFile = new File(dir, ".lock");
        FileMisc.retry(this.lockFile, f -> {
            if (f.exists()) {
                throw new IllegalStateException("P2 operation already in progress, close other clients or delete stale lockfile at " + this.lockFile.getAbsolutePath());
            }
        });
        this.lock = new FileOutputStream(this.lockFile);
        this.lock.write(Long.toString(ProcessHandle.current().pid()).getBytes());
        this.lock.flush();
    }

    @Override
    public void close() throws IOException {
        this.lock.close();
        FileMisc.delete(this.lockFile);
    }
}

