/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.FileMisc;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nullable;

class OfflineCache {
    final File rootDir;
    private static final String VERSION = "version";
    private static final String VERSION_VALUE = "1";
    private static final int MAX_FILE_LENGTH = 92;
    private static final int ABBREVIATED = 40;
    private static final String URL = "url";
    private static final String CONTENT = "content";
    private static final byte[] _404 = new byte[]{4, 0, 4};

    OfflineCache(File rootDir) {
        this.rootDir = rootDir;
        if (FileMisc.readToken(rootDir, VERSION).equals(Optional.of(VERSION_VALUE))) {
            if (rootDir.exists()) {
                FileMisc.delete(rootDir);
            }
            FileMisc.mkdirs(rootDir);
            FileMisc.writeToken(rootDir, VERSION, VERSION_VALUE);
        }
    }

    static String filenameSafe(String url) {
        byte[] hash;
        String allSafeCharacters = url.replaceAll("[^a-zA-Z0-9-+_.]", "-");
        String noDuplicateDash = allSafeCharacters.replaceAll("-+", "-");
        if (noDuplicateDash.length() <= 92) {
            return noDuplicateDash;
        }
        int secondPoint = noDuplicateDash.length() - 40;
        String first = noDuplicateDash.substring(0, 40);
        String middle = noDuplicateDash.substring(40, secondPoint);
        String end = noDuplicateDash.substring(secondPoint);
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(middle.getBytes(StandardCharsets.UTF_8));
            hash = md5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String hashed = Base64.getEncoder().encodeToString(hash).replace('/', '-').replace('=', '-');
        return first + "--" + hashed + end;
    }

    public void put(String url, byte[] data) throws IOException {
        File dir = new File(this.rootDir, OfflineCache.filenameSafe(url));
        FileMisc.mkdirs(dir);
        FileMisc.writeToken(dir, URL, url);
        Files.write(new File(dir, CONTENT).toPath(), data, new OpenOption[0]);
    }

    public void put404(String url) throws IOException {
        this.put(url, _404);
    }

    @Nullable
    public byte[] get(String url) throws IOException {
        File dir = new File(this.rootDir, OfflineCache.filenameSafe(url));
        if (dir.isDirectory() && FileMisc.readToken(dir, URL).equals(Optional.of(url))) {
            return Files.readAllBytes(new File(dir, CONTENT).toPath());
        }
        return null;
    }

    public static boolean is404(byte[] data) {
        return Arrays.equals(_404, data);
    }
}

