/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.MavenCentralMapping;
import dev.equo.solstice.p2.P2Unit;

public class RepoStatus
implements Comparable<RepoStatus> {
    public static String MAVEN_ = "maven ";
    public static String MAVEN_CENTRAL = MAVEN_ + "central";
    public static String MAVEN_CENTRAL_INFERRED = MAVEN_ + "central?";
    public static String P2_ = "p2 ";
    private final String coordinate;
    private final String repo;

    private RepoStatus(String coordinate, String repo) {
        this.coordinate = coordinate;
        this.repo = repo;
    }

    public boolean isOnMavenCentral() {
        return this.repo.equals(MAVEN_CENTRAL) || this.repo.equals(MAVEN_CENTRAL_INFERRED);
    }

    public String coordinate() {
        return this.coordinate;
    }

    public String repo() {
        return this.repo;
    }

    public static RepoStatus forUnit(P2Unit unit) {
        String group = unit.properties.get("maven-groupId");
        String artifact = unit.properties.get("maven-artifactId");
        String version = unit.properties.get("maven-version");
        if (group != null && artifact != null && version != null) {
            String repo = unit.properties.get("maven-repository");
            if ("eclipse.maven.central.mirror".equals(repo)) {
                return new RepoStatus(group + ":" + artifact + ":" + version, MAVEN_CENTRAL);
            }
            String coord = MavenCentralMapping.getMavenCentralCoord(unit);
            if (coord != null) {
                return new RepoStatus(coord, MAVEN_CENTRAL_INFERRED);
            }
        }
        return new RepoStatus(unit.id + ":" + unit.version, P2_ + unit.getRepoUrlLastSegment());
    }

    @Override
    public int compareTo(RepoStatus o) {
        int repoCompare = this.repo.compareTo(o.repo);
        if (repoCompare == 0) {
            return this.coordinate.compareTo(o.coordinate);
        }
        return repoCompare;
    }
}

