/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.CacheLocations;
import dev.equo.solstice.p2.FileMisc;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WorkspaceRegistry {
    final File root;
    final Map<File, File> ownerToWorkspace = new HashMap<File, File>();
    static final String OWNER_PATH = "-owner";

    public static WorkspaceRegistry instance() {
        return new WorkspaceRegistry(CacheLocations.ideWorkspaces());
    }

    WorkspaceRegistry(File root) {
        this.root = Objects.requireNonNull(root);
        FileMisc.mkdirs(root);
        for (File workspace : root.listFiles()) {
            if (!workspace.isDirectory()) continue;
            Optional<String> ownerPath = FileMisc.readToken(root, workspace.getName() + OWNER_PATH);
            if (!ownerPath.isPresent()) {
                this.deleteWorkspace(workspace, "missing token -owner.");
                continue;
            }
            this.ownerToWorkspace.put(new File(ownerPath.get()), workspace);
        }
    }

    public File workspaceDirForProjectDir(File ideDir) {
        return this.ownerToWorkspace.computeIfAbsent(ideDir, owner -> {
            File workspace = new File(this.root, ideDir.getName() + "-" + owner.getAbsolutePath().hashCode());
            FileMisc.mkdirs(workspace);
            FileMisc.writeToken(this.root, workspace.getName() + OWNER_PATH, ideDir.getAbsolutePath());
            return workspace;
        });
    }

    public void cleanWorkspaceDir(File workspaceDir) {
        File[] files = workspaceDir.listFiles();
        String tokenFilename = workspaceDir.getName() + OWNER_PATH;
        for (File file : files) {
            if (file.getName().equals(tokenFilename)) continue;
            FileMisc.delete(file);
        }
    }

    public void removeAbandoned() {
        Iterator<Map.Entry<File, File>> iter = this.ownerToWorkspace.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<File, File> entry = iter.next();
            File ownerDir = entry.getKey();
            File workspaceDir = entry.getValue();
            if (ownerDir.exists()) continue;
            this.deleteWorkspace(workspaceDir, "owner " + ownerDir + " no longer exists.");
            iter.remove();
        }
    }

    private void deleteWorkspace(File workspace, String reason) {
        try {
            FileMisc.delete(workspace);
            File token = new File(this.root, workspace.getName() + OWNER_PATH);
            FileMisc.delete(token);
        }
        catch (Exception e) {
            System.err.println("Tried to delete workspace " + workspace.getAbsolutePath() + " because " + reason);
            e.printStackTrace();
        }
    }
}

