/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import dev.equo.ide.IdeHook;
import dev.equo.ide.IdeHookInstantiated;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class IdeHookBranding
implements IdeHook {
    private static String DEFAULT_TITLE = "Equo IDE";
    private String title = DEFAULT_TITLE;
    @Nullable
    private File icon;
    @Nullable
    private File splash;

    public IdeHookBranding title(String title) {
        this.title = title == null ? DEFAULT_TITLE : title;
        return this;
    }

    public IdeHookBranding icon(File iconImg) {
        this.icon = iconImg;
        return this;
    }

    public IdeHookBranding splash(File splashImg) {
        this.splash = splashImg;
        return this;
    }

    @Override
    public IdeHookInstantiated instantiate() {
        return new Instantiated();
    }

    class Instantiated
    implements IdeHookInstantiated {
        private Shell splash;

        Instantiated() {
        }

        private Image loadImage(Display display, File file, String defaultResource) {
            Image image;
            block11: {
                try {
                    if (file != null) {
                        ImageData imageData = new ImageData(file.getAbsolutePath());
                        return new Image((Device)display, imageData);
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(IdeHookBranding.class).warn("Unable to load image " + file.getAbsolutePath() + ", falling back to default.", (Throwable)e);
                }
                InputStream input = IdeHookBranding.class.getClassLoader().getResource(defaultResource).openStream();
                try {
                    ImageData imageData = new ImageData(input);
                    image = new Image((Device)display, imageData);
                    if (input == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                input.close();
            }
            return image;
        }

        @Override
        public void afterDisplay(Display display) {
            Point cursor = display.getCursorLocation();
            Monitor[] monitors = display.getMonitors();
            Rectangle bestMonitor = Arrays.stream(monitors).filter(monitor -> monitor.getBounds().contains(cursor)).findAny().orElse(monitors[0]).getBounds();
            Image image = this.loadImage(display, IdeHookBranding.this.splash, "dev/equo/ide/equo_splash.png");
            int imgX = image.getBounds().width;
            int imgY = image.getBounds().height;
            this.splash = new Shell(display, 16392);
            this.splash.setText("Branding");
            this.splash.setBounds(bestMonitor.x + (bestMonitor.width - imgX / 2) / 2, bestMonitor.y + (bestMonitor.height - imgY / 2) / 2, imgX / 2, imgY / 2);
            this.splash.setBackground(display.getSystemColor(1));
            this.splash.addListener(9, e -> {
                e.gc.setAdvanced(true);
                e.gc.setAntialias(1);
                e.gc.drawImage(image, 0, 0, imgX, imgY, 0, 0, imgX / 2, imgY / 2);
            });
            this.splash.open();
            this.splash.forceActive();
            Display.setAppName((String)IdeHookBranding.this.title);
            while (display.readAndDispatch()) {
            }
        }

        @Override
        public void postStartup() {
            this.splash.dispose();
            this.splash = null;
            Display.getDefault().asyncExec(() -> {
                Shell[] shells;
                Display display = Display.getCurrent();
                if (display == null) {
                    return;
                }
                Display.setAppName((String)IdeHookBranding.this.title);
                Image icon = this.loadImage(Display.getDefault(), IdeHookBranding.this.icon, "dev/equo/ide/equo_icon.png");
                for (Shell shell : shells = display.getShells()) {
                    shell.setText(IdeHookBranding.this.title);
                    shell.setImage(icon);
                    shell.forceActive();
                }
            });
        }
    }
}

