/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.Unchecked;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public abstract class NestedJars {
    public static final String DIR = "nested-jars";
    private static final Attributes.Name CLASSPATH = new Attributes.Name("Bundle-ClassPath");
    private static final String JAR_COLON_FILE_COLON = "jar:file:";
    private static boolean warnOnly = false;

    public static String solsticeVersion() throws IOException {
        String solsticeJar = NestedJars.class.getResource(NestedJars.class.getSimpleName() + ".class").toString();
        if (!solsticeJar.startsWith("jar")) {
            throw new IllegalArgumentException("");
        }
        URL url = new URL(solsticeJar);
        JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
        Manifest manifest = jarConnection.getManifest();
        return manifest.getMainAttributes().getValue("Implementation-Version");
    }

    public static Collection<String> transitiveDeps(boolean useAtomos, CoordFormat format) {
        ArrayList<String> coords = new ArrayList<String>();
        String VER_SLF4J = "1.7.36";
        coords.add(format.format("org.slf4j", "slf4j-api", VER_SLF4J, null));
        coords.add(format.format("org.slf4j", "slf4j-simple", VER_SLF4J, null));
        if (useAtomos) {
            coords.add(format.format("org.apache.felix", "org.apache.felix.atomos", "1.0.0", null));
            coords.add(format.format("org.apache.felix.atomos", "osgi.core", "8.0.0", "AtomosEquinox"));
        }
        return coords;
    }

    private static void addNestedJarsFromManifest(List<URL> nestedJars, String jarUrl, InputStream stream) throws IOException {
        Manifest manifest = new Manifest(stream);
        String cp = manifest.getMainAttributes().getValue(CLASSPATH);
        if (cp != null) {
            String[] lines;
            for (String line : lines = cp.split(",")) {
                if (line.startsWith("../")) {
                    LoggerFactory.getLogger(NestedJars.class).warn("Ignoring unexpected nested jar " + line + " inside " + jarUrl);
                    continue;
                }
                if (line.equals(".")) continue;
                URL nestedJar = Unchecked.get(() -> new URL(jarUrl + "/" + line));
                nestedJars.add(nestedJar);
            }
        }
    }

    public static NestedJars onClassPath() {
        return new NestedJars(){

            @Override
            protected List<URL> listNestedJars() {
                ArrayList<URL> nestedJars = new ArrayList<URL>();
                Enumeration manifests = Unchecked.get(() -> NestedJars.class.getClassLoader().getResources("META-INF/MANIFEST.MF"));
                while (manifests.hasMoreElements()) {
                    URL manifestUrl = (URL)manifests.nextElement();
                    String fullUrl = manifestUrl.toExternalForm();
                    String jarUrl = fullUrl.substring(0, fullUrl.length() - "/META-INF/MANIFEST.MF".length());
                    try {
                        InputStream stream = manifestUrl.openStream();
                        try {
                            NestedJars.addNestedJarsFromManifest(nestedJars, jarUrl, stream);
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        throw Unchecked.wrap(e);
                    }
                }
                return nestedJars;
            }
        };
    }

    public static NestedJars inFiles(final Iterable<File> files) {
        return new NestedJars(){

            @Override
            protected List<URL> listNestedJars() {
                ArrayList<URL> nestedJars = new ArrayList<URL>();
                for (File file : files) {
                    try (JarFile jarFile = new JarFile(file);){
                        ZipEntry zipEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                        if (zipEntry == null) continue;
                        String jarUrl = "jar:" + file.toURI().toURL().toExternalForm() + "!";
                        InputStream input = jarFile.getInputStream(zipEntry);
                        try {
                            NestedJars.addNestedJarsFromManifest(nestedJars, jarUrl, input);
                        }
                        finally {
                            if (input == null) continue;
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        throw Unchecked.wrap(e);
                    }
                }
                return nestedJars;
            }
        };
    }

    protected abstract List<URL> listNestedJars();

    public List<Map.Entry<URL, File>> extractAllNestedJars(File nestedJarFolder) {
        ArrayList<Map.Entry<URL, File>> files = new ArrayList<Map.Entry<URL, File>>();
        for (URL url : this.listNestedJars()) {
            int lastExclamation = url.getPath().indexOf(33);
            int slashBeforeThat = url.getPath().lastIndexOf(47, lastExclamation);
            files.add(NestedJars.extractNestedJar(url.getPath().substring(slashBeforeThat + 1, lastExclamation), url, nestedJarFolder));
        }
        files.sort(Comparator.comparing(e -> ((URL)e.getKey()).getPath()));
        return files;
    }

    public void confirmAllNestedJarsArePresentOnClasspath(File nestedJarFolder) {
        List<Map.Entry<URL, File>> entries = this.extractAllNestedJars(nestedJarFolder);
        Enumeration manifests = Unchecked.get(() -> NestedJars.class.getClassLoader().getResources("META-INF/MANIFEST.MF"));
        while (manifests.hasMoreElements()) {
            String fullUrl = ((URL)manifests.nextElement()).toExternalForm();
            String jarUrl = fullUrl.substring(0, fullUrl.length() - "/META-INF/MANIFEST.MF".length());
            if (!jarUrl.endsWith("!")) {
                throw new IllegalArgumentException("Expected " + jarUrl + " to end with !");
            }
            if (!jarUrl.startsWith(JAR_COLON_FILE_COLON)) {
                throw new IllegalArgumentException("Expected " + jarUrl + " to start with jar:file:");
            }
            File jarFile = new File(jarUrl.substring(JAR_COLON_FILE_COLON.length(), jarUrl.length() - 1));
            entries.removeIf(e -> ((File)e.getValue()).equals(jarFile));
        }
        if (!entries.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append("The following nested jars are missing:\n");
            for (Map.Entry<URL, File> entry : entries) {
                msg.append("  ");
                msg.append(entry.getKey().toExternalForm());
                msg.append('\n');
            }
            if (warnOnly) {
                System.err.println(msg);
            } else {
                throw new IllegalStateException(msg.toString());
            }
        }
    }

    public static void setToWarnOnly() {
        warnOnly = true;
    }

    private static Map.Entry<URL, File> extractNestedJar(String parentJar, URL entry, File nestedJarFolder) {
        Map.Entry<URL, File> entry2;
        block15: {
            InputStream toRead = entry.openStream();
            try {
                byte[] content = toRead.readAllBytes();
                String jarPath = entry.getPath();
                int lastSep = Math.max(jarPath.lastIndexOf(33), jarPath.lastIndexOf(47));
                String jarSimpleName = jarPath.substring(lastSep + 1);
                String filename = parentJar + "__" + jarSimpleName + "__" + NestedJars.filenameSafeHash(content) + ".jar";
                File jarToAdd = new File(nestedJarFolder, filename);
                if (!jarToAdd.exists() || jarToAdd.length() != (long)content.length) {
                    nestedJarFolder.mkdirs();
                    try (FileOutputStream output = new FileOutputStream(jarToAdd);){
                        output.write(content);
                    }
                }
                entry2 = Map.entry(entry, jarToAdd);
                if (toRead == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (toRead != null) {
                        try {
                            toRead.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Unchecked.wrap(e);
                }
            }
            toRead.close();
        }
        return entry2;
    }

    static String filenameSafeHash(String content) {
        return NestedJars.filenameSafeHash(content.getBytes(StandardCharsets.UTF_8));
    }

    static String filenameSafeHash(byte[] content) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(content);
            String encoded = new String(Base64.getEncoder().encode(md5.digest()), StandardCharsets.US_ASCII);
            return encoded.replace('/', '-').replace('=', '-');
        }
        catch (NoSuchAlgorithmException e) {
            throw Unchecked.wrap(e);
        }
    }

    public static enum CoordFormat {
        GRADLE,
        MAVEN;


        private String format(String g, String a, String version, @Nullable String c) {
            if (c == null) {
                return g + ":" + a + ":" + version;
            }
            if (this == GRADLE) {
                return g + ":" + a + ":" + version + ":" + c;
            }
            if (this == MAVEN) {
                return g + ":" + a + ":jar:" + c + ":" + version;
            }
            throw new IllegalArgumentException("Unknown format " + this);
        }
    }
}

