/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.Dictionaries;
import dev.equo.solstice.ListenerList;
import dev.equo.solstice.Unchecked;
import dev.equo.solstice.Unimplemented;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ServiceRegistry
extends BundleContextImpl {
    private final Logger logger = LoggerFactory.getLogger(ServiceRegistry.class);
    final Map<String, List<AbstractServiceReference<?>>> services = new HashMap();
    private final ListenerList<ListenerEntry> serviceListeners = new ListenerList();
    static AtomicLong globalId = new AtomicLong();

    ServiceRegistry(EquinoxBundle bundle, EquinoxContainer container) {
        super(bundle, container);
    }

    protected abstract Bundle systemBundle();

    public final ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        return this.registerService(new String[]{clazz}, service, properties);
    }

    public final <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> factory, Dictionary<String, ?> properties) {
        return this.registerService(new String[]{clazz.getName()}, factory, properties);
    }

    public synchronized ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        this.logger.debug("{} implemented by service {} with {}", new Object[]{Arrays.asList(clazzes), service.getClass(), ServiceRegistry.propertiesToString(properties)});
        AbstractServiceReference newService = service instanceof ServiceFactory ? new ShimServiceFactoryReference((ServiceFactory)service, clazzes, properties) : new ShimServiceReference<Object>(service, clazzes, properties);
        for (String clazz : clazzes) {
            this.services.computeIfAbsent(clazz, k -> new ArrayList()).add(newService);
        }
        this.notifyListeners(1, newService);
        return newService;
    }

    private static String propertiesToString(Dictionary<String, ?> dict) {
        if (dict == null) {
            return "{null}";
        }
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        Enumeration<String> keys = dict.keys();
        while (keys.hasMoreElements()) {
            String key2 = keys.nextElement();
            Object value = dict.get(key2);
            String valueStr2 = value instanceof String[] ? Arrays.asList((String[])value).toString() : value.toString();
            sorted.put(key2, valueStr2);
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        sorted.forEach((key, valueStr) -> {
            builder.append((String)key);
            builder.append('=');
            builder.append((String)valueStr);
            builder.append(',');
        });
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    public synchronized void removeServiceListener(ServiceListener listener) {
        this.serviceListeners.removeIf(entry -> entry.listener == listener);
    }

    public final synchronized void addServiceListener(ServiceListener listener, String filter) {
        this.logger.debug("add listener {} with {}", listener.getClass(), (Object)filter);
        this.serviceListeners.add(new ListenerEntry(listener, Unchecked.get(() -> FilterImpl.newInstance((String)filter))));
    }

    public final synchronized void addServiceListener(ServiceListener listener) {
        this.logger.debug("add listener {} with no filter", (Object)listener);
        this.serviceListeners.add(new ListenerEntry(listener, null));
    }

    private synchronized void notifyListeners(int type, AbstractServiceReference<?> serviceReference) {
        ServiceEvent event = new ServiceEvent(type, serviceReference);
        for (ListenerEntry listener : this.serviceListeners) {
            if (listener.filter != null && !listener.filter.match(serviceReference)) continue;
            try {
                listener.listener.serviceChanged(event);
            }
            catch (Exception e) {
                this.getService(this.getServiceReference(FrameworkLog.class)).log(new FrameworkEvent(2, serviceReference.getBundle(), (Throwable)e));
            }
        }
    }

    public final <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        return this.registerService(clazz.getName(), service, properties);
    }

    public final <S> S getService(ServiceReference<S> reference) {
        if (reference instanceof ShimServiceReference) {
            return ((ShimServiceReference)reference).service;
        }
        if (reference instanceof ShimServiceFactoryReference) {
            ShimServiceFactoryReference cast = (ShimServiceFactoryReference)reference;
            return (S)cast.factory.getService(this.systemBundle(), (ServiceRegistration)cast);
        }
        throw new IllegalArgumentException("Unexpected class " + reference);
    }

    public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> reference) {
        throw Unimplemented.onPurpose();
    }

    public final boolean ungetService(ServiceReference<?> reference) {
        return true;
    }

    public final synchronized ServiceReference<?> getServiceReference(String clazz) {
        List<AbstractServiceReference<?>> servicesForClazz = this.services.get(clazz);
        return servicesForClazz == null || servicesForClazz.isEmpty() ? null : (ServiceReference)servicesForClazz.get(0);
    }

    public final synchronized <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        return this.getServiceReference(clazz.getName());
    }

    public final ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.getServiceReferences(clazz, filter);
    }

    public final synchronized ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        String interfaze;
        if (clazz != null && filter == null) {
            return this.services.getOrDefault(clazz, Collections.emptyList()).toArray(new ServiceReference[0]);
        }
        FilterImpl filterParsed = FilterImpl.newInstance((String)filter);
        String string = interfaze = clazz != null ? clazz : filterParsed.getRequiredObjectClass();
        if (interfaze != null) {
            return (ServiceReference[])this.services.getOrDefault(interfaze, Collections.emptyList()).stream().filter(arg_0 -> ((FilterImpl)filterParsed).match(arg_0)).toArray(ServiceReference[]::new);
        }
        return (ServiceReference[])this.services.values().stream().flatMap(Collection::stream).filter(arg_0 -> ((FilterImpl)filterParsed).match(arg_0)).toArray(ServiceReference[]::new);
    }

    public final <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        return Arrays.asList(this.getServiceReferences(clazz.getName(), filter));
    }

    public final Filter createFilter(String filter) throws InvalidSyntaxException {
        return FilterImpl.newInstance((String)filter);
    }

    abstract class AbstractServiceReference<S>
    implements ServiceReference<S>,
    ServiceRegistration<S> {
        final String[] objectClass;
        final long id = globalId.getAndIncrement();
        Dictionary<String, ?> properties;

        AbstractServiceReference(String[] objectClass, Dictionary<String, ?> properties) {
            this.objectClass = objectClass;
            this.properties = properties != null ? Dictionaries.copy(properties) : Dictionaries.empty();
        }

        public synchronized Object getProperty(String key) {
            if (key.equals("objectClass")) {
                return this.objectClass;
            }
            if (key.equals("service.id")) {
                return this.id;
            }
            return this.properties.get(key);
        }

        public synchronized String[] getPropertyKeys() {
            ArrayList<String> keys = new ArrayList<String>();
            Enumeration<String> keysEnum = this.properties.keys();
            while (keysEnum.hasMoreElements()) {
                keys.add(keysEnum.nextElement());
            }
            return keys.toArray(new String[0]);
        }

        public synchronized Dictionary<String, Object> getProperties() {
            return this.properties;
        }

        public synchronized void setProperties(Dictionary<String, ?> properties) {
            this.properties = properties;
            ServiceRegistry.this.notifyListeners(2, this);
        }

        public Bundle getBundle() {
            return ServiceRegistry.this.systemBundle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            ServiceRegistry.this.notifyListeners(4, this);
            ServiceRegistry serviceRegistry = ServiceRegistry.this;
            synchronized (serviceRegistry) {
                for (String clazz : this.objectClass) {
                    ServiceRegistry.this.services.get(clazz).remove(this);
                }
            }
        }

        public int compareTo(Object reference) {
            if (reference instanceof AbstractServiceReference) {
                return (int)(this.id - ((AbstractServiceReference)reference).id);
            }
            throw Unimplemented.onPurpose();
        }

        public Bundle[] getUsingBundles() {
            throw Unimplemented.onPurpose();
        }

        public <A> A adapt(Class<A> type) {
            throw Unimplemented.onPurpose();
        }

        public ServiceReference<S> getReference() {
            return this;
        }
    }

    class ShimServiceFactoryReference<S>
    extends AbstractServiceReference<S> {
        final Class<?>[] clazzes;
        final ServiceFactory<S> factory;

        ShimServiceFactoryReference(ServiceFactory<S> factory, String[] clazzes, Dictionary<String, ?> properties) {
            super(clazzes, properties);
            this.factory = factory;
            this.clazzes = new Class[clazzes.length];
            for (int i = 0; i < clazzes.length; ++i) {
                try {
                    this.clazzes[i] = Class.forName(clazzes[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    ServiceRegistry.this.logger.warn("unable to resolve class {} for ServiceFactory {}", (Object)clazzes[i], factory);
                    this.clazzes[i] = ShimServiceFactoryReference.class;
                }
            }
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            for (String clazz : this.objectClass) {
                if (!clazz.equals(className)) continue;
                return true;
            }
            Class<?> target = Unchecked.classForName(className);
            for (Class<?> clazz : this.clazzes) {
                if (!target.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
    }

    class ShimServiceReference<S>
    extends AbstractServiceReference<S> {
        final S service;

        ShimServiceReference(S service, String[] clazzes, Dictionary<String, ?> properties) {
            super(clazzes, properties);
            this.service = service;
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            return Unchecked.classForName(className).isInstance(this.service);
        }

        public String toString() {
            return this.service.toString();
        }
    }

    static class ListenerEntry {
        final ServiceListener listener;
        final FilterImpl filter;

        ListenerEntry(ServiceListener listener, FilterImpl filter) {
            this.listener = listener;
            this.filter = filter;
        }

        public String toString() {
            return this.filter.toString();
        }
    }
}

