/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.Capability;
import dev.equo.solstice.Unchecked;
import dev.equo.solstice.Unimplemented;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SolsticeManifest {
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String SLASH_MANIFEST_PATH = "/META-INF/MANIFEST.MF";
    private final String jarUrl;
    final int classpathOrder;
    @Nullable
    private final String symbolicName;
    private final LinkedHashMap<String, String> headersOriginal = new LinkedHashMap();
    final ArrayList<String> requiredBundles;
    final ArrayList<String> pkgImports;
    final ArrayList<String> pkgExports;
    final List<Capability> capProvides;
    final List<Capability> capRequires;
    final boolean lazy;
    final List<SolsticeManifest> fragments = new ArrayList<SolsticeManifest>();
    Bundle hydrated;
    private List<ManifestElement> pkgExportsRaw;

    SolsticeManifest(URL manifestURL, int classpathOrder) {
        Manifest manifest;
        this.classpathOrder = classpathOrder;
        String externalForm = manifestURL.toExternalForm();
        if (!externalForm.endsWith(SLASH_MANIFEST_PATH)) {
            throw new IllegalArgumentException("Expected manifest to end with /META-INF/MANIFEST.MF but was " + externalForm);
        }
        this.jarUrl = externalForm.substring(0, externalForm.length() - SLASH_MANIFEST_PATH.length());
        if (!this.jarUrl.endsWith("!") && !this.jarUrl.endsWith("build/resources/main")) {
            throw new IllegalArgumentException("Must end with !  SEE getEntry if this changes  " + this.jarUrl);
        }
        try (InputStream stream = manifestURL.openStream();){
            manifest = new Manifest(stream);
        }
        catch (IOException e) {
            throw Unchecked.wrap(e);
        }
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            this.headersOriginal.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this.headersOriginal.remove("Bundle-ClassPath");
        ArrayList<String> symbolicNameRaw = this.parseAndStrip("Bundle-SymbolicName");
        this.symbolicName = symbolicNameRaw.isEmpty() ? null : symbolicNameRaw.get(0);
        this.requiredBundles = this.parseAndStrip("Require-Bundle");
        this.pkgExports = this.parseAndStrip("Export-Package");
        this.pkgImports = this.parseAndStrip("Import-Package");
        this.capProvides = this.parseCapability("Provide-Capability", SolsticeManifest::parseProvide);
        this.capRequires = this.parseCapability("Require-Capability", SolsticeManifest::parseRequire);
        if (!(!this.headersOriginal.containsKey("Fragment-Host") || this.capRequires.isEmpty() && this.capProvides.isEmpty())) {
            throw Unimplemented.onPurpose("Solstice does not currently support OSGi capabilities in fragment bundles, but a PR is welcome.");
        }
        String legacyLazyStart = this.headersOriginal.get("Eclipse-LazyStart");
        if (legacyLazyStart != null) {
            this.lazy = legacyLazyStart.toLowerCase(Locale.ROOT).contains("true");
        } else {
            boolean noActivator = !this.headersOriginal.containsKey("Bundle-Activator");
            String activationPolicy = this.headersOriginal.get("Bundle-ActivationPolicy");
            this.lazy = activationPolicy == null ? noActivator : activationPolicy.contains("lazy");
        }
    }

    private static void parseProvide(CapabilityParsed parsed, ArrayList<Capability> total) {
        if (parsed.attributes.size() == 1) {
            Map.Entry<String, String> attr = parsed.attributes.entrySet().iterator().next();
            String key = attr.getKey();
            if (key.endsWith(":List<String>")) {
                String[] values;
                key = key.substring(0, key.length() - ":List<String>".length());
                for (String value : values = attr.getValue().split(",")) {
                    total.add(new Capability(parsed.namespace, key, value));
                }
            } else {
                total.add(new Capability(parsed.namespace, key, attr.getValue()));
            }
        } else {
            Capability cap = new Capability(parsed.namespace);
            for (Map.Entry<String, String> attr : parsed.attributes.entrySet()) {
                String key = attr.getKey();
                if (key.endsWith(":List<String>")) {
                    key = key.substring(0, key.length() - ":List<String>".length());
                    if (attr.getValue().indexOf(44) != -1) {
                        throw Unimplemented.onPurpose("Solstice does not support :List<String> unless that is the only property, this had " + parsed);
                    }
                }
                cap.add(key, attr.getValue());
            }
            total.add(cap);
        }
    }

    private static void parseRequire(CapabilityParsed parsed, ArrayList<Capability> total) {
        Map.Entry<String, String> filter = SolsticeManifest.parseSingleFilter(parsed.directives.get("filter"));
        total.add(new Capability(parsed.namespace, filter.getKey(), filter.getValue()));
    }

    static Map.Entry<String, String> parseSingleFilter(String filter) {
        int equalsSpot = filter.indexOf(61);
        if (!filter.startsWith("(") || !filter.endsWith(")") || equalsSpot == -1 || filter.indexOf(61, equalsSpot + 1) != -1) {
            throw Unimplemented.onPurpose("Require-Capability supports (key=value) only, this was " + filter);
        }
        String key = filter.substring(1, equalsSpot);
        String value = filter.substring(equalsSpot + 1, filter.length() - 1);
        return Map.entry(key, value);
    }

    void removeRequiredCapabilities(Set<Capability> missingCapabilities) {
        this.capRequires.removeAll(missingCapabilities);
    }

    private List<Capability> parseCapability(String header, BiConsumer<CapabilityParsed, ArrayList<Capability>> parser) {
        List<CapabilityParsed> parsed = this.parseAndStripCapability(header);
        if (parsed.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        List<CapabilityParsed> raws = this.parseAndStripCapability(header);
        for (CapabilityParsed raw : raws) {
            parser.accept(raw, capabilities);
        }
        return capabilities;
    }

    private List<CapabilityParsed> parseAndStripCapability(String header) {
        try {
            String capability = this.headersOriginal.get(header);
            if (capability == null) {
                return Collections.emptyList();
            }
            capability = capability.replace('\u201d', '\"');
            ManifestElement[] elements = ManifestElement.parseHeader((String)header, (String)capability);
            ArrayList<CapabilityParsed> capabilities = new ArrayList<CapabilityParsed>(elements.length);
            for (ManifestElement element : elements) {
                if (Capability.IGNORED_NAMESPACES.contains(element.getValue())) continue;
                capabilities.add(new CapabilityParsed(element));
            }
            if (capabilities.isEmpty()) {
                return Collections.emptyList();
            }
            return capabilities;
        }
        catch (BundleException e) {
            throw Unchecked.wrap((Exception)((Object)e));
        }
    }

    List<ManifestElement> pkgExportsRaw() {
        if (this.pkgExportsRaw == null) {
            this.pkgExportsRaw = Arrays.asList(Unchecked.get(() -> ManifestElement.parseHeader((String)"Export-Package", (String)this.headersOriginal.get("Export-Package"))));
        }
        return this.pkgExportsRaw;
    }

    boolean isFragment() {
        return this.headersOriginal.containsKey("Fragment-Host");
    }

    String fragmentHost() {
        String host = this.headersOriginal.get("Fragment-Host");
        if (host == null) {
            return null;
        }
        int idx = host.indexOf(59);
        return idx == -1 ? host : host.substring(0, idx);
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getJarUrl() {
        return this.jarUrl;
    }

    private ArrayList<String> parseAndStrip(String key) {
        String attribute = this.headersOriginal.get(key);
        if (attribute == null) {
            return new ArrayList<String>();
        }
        return SolsticeManifest.parseAndStripManifestHeader(key, attribute);
    }

    public String toString() {
        if (this.symbolicName != null) {
            return this.symbolicName;
        }
        return this.jarUrl;
    }

    static ArrayList<String> parseAndStripManifestHeader(String key, String in) {
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)key, (String)in);
            ArrayList<String> stripped = new ArrayList<String>(elements.length);
            for (ManifestElement e : elements) {
                if ("optional".equals(e.getDirective("resolution"))) continue;
                stripped.add(e.getValue());
            }
            if (stripped.size() > 1) {
                stripped.sort(Comparator.naturalOrder());
                Iterator<String> iter = stripped.iterator();
                String prev = iter.next();
                while (iter.hasNext()) {
                    String next = iter.next();
                    if (prev.equals(next)) {
                        iter.remove();
                        continue;
                    }
                    prev = next;
                }
            }
            return stripped;
        }
        catch (BundleException e) {
            throw Unchecked.wrap((Exception)((Object)e));
        }
    }

    public List<String> totalRequiredBundles() {
        return this.total(m -> m.requiredBundles);
    }

    public List<String> totalPkgImports() {
        return this.total(m -> m.pkgImports);
    }

    public List<String> totalPkgExports() {
        return this.total(m -> m.pkgExports);
    }

    private List<String> total(Function<SolsticeManifest, List<String>> getter) {
        if (this.isFragment()) {
            throw new IllegalStateException("You cannot call this method on a fragment, this bundle " + this.symbolicName + " is a fragment to " + this.fragmentHost());
        }
        if (this.fragments.isEmpty()) {
            return Collections.unmodifiableList(getter.apply(this));
        }
        ArrayList<String> total = new ArrayList<String>();
        total.addAll((Collection)getter.apply(this));
        for (SolsticeManifest fragment : this.fragments) {
            List<String> toAdd = getter.apply(fragment);
            for (String e : toAdd) {
                if (total.contains(e)) continue;
                total.add(e);
            }
        }
        return total;
    }

    public Map<String, String> getHeadersOriginal() {
        return Collections.unmodifiableMap(this.headersOriginal);
    }

    void removeFromRequiredBundles(Collection<String> toRemove) {
        this.requiredBundles.removeAll(toRemove);
    }

    void removeFromPkgImports(Collection<String> toRemove) {
        this.pkgImports.removeAll(toRemove);
    }

    private static class CapabilityParsed {
        String namespace;
        Map<String, String> attributes = new TreeMap<String, String>();
        Map<String, String> directives = new TreeMap<String, String>();

        public CapabilityParsed(ManifestElement element) {
            Enumeration directives;
            this.namespace = element.getValue();
            Enumeration keys = element.getKeys();
            if (keys != null) {
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (Capability.IGNORED_ATTRIBUTES.contains(key)) continue;
                    this.attributes.put(key, element.getAttribute(key));
                }
            }
            if ((directives = element.getDirectiveKeys()) != null) {
                while (directives.hasMoreElements()) {
                    String key = (String)directives.nextElement();
                    if (key.equals("filter")) {
                        this.directives.put("filter", this.stripVersionsFromFilter(element.getDirective("filter")));
                        continue;
                    }
                    this.directives.put(key, element.getDirective(key));
                }
            }
        }

        private String stripVersionsFromFilter(String filter) {
            String removeVersionGt = filter.replaceAll("\\(version>=(.*?)\\)", "");
            String removeEmptyNots = removeVersionGt.replace("(!)", "");
            if (removeEmptyNots.startsWith("(&(") && removeEmptyNots.endsWith("))")) {
                return removeEmptyNots.substring(2, removeEmptyNots.length() - 1);
            }
            return removeEmptyNots;
        }

        public String toString() {
            return this.namespace + ": " + this.attributes + " " + this.directives;
        }
    }
}

