/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.Unchecked;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

class FileMisc {
    private static final int MS_RETRY = 500;

    FileMisc() {
    }

    static void delete(File fileOrDir) {
        FileMisc.retry(fileOrDir, f -> {
            if (f.isDirectory()) {
                Files.walkFileTree(f.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc != null) {
                            throw exc;
                        }
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                Files.deleteIfExists(f.toPath());
            }
        });
    }

    static Optional<String> readToken(File dir, String name) {
        try {
            File token = new File(dir, name);
            if (!token.isFile()) {
                return Optional.empty();
            }
            return Optional.of(new String(Files.readAllBytes(token.toPath()), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    static void writeToken(File dir, String name, String value) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Need to create directory first! " + dir.getAbsolutePath());
        }
        File token = new File(dir, name);
        FileMisc.retry(token, f -> Files.write(f.toPath(), value.getBytes(StandardCharsets.UTF_8), new OpenOption[0]));
    }

    static void mkdirs(File file) {
        FileMisc.retry(file, dir -> Files.createDirectories(dir.toPath(), new FileAttribute[0]));
    }

    static void retry(File input, ThrowingConsumer<File> function) {
        FileMisc.retry(input, function, 500);
    }

    static void retry(File input, ThrowingConsumer<File> function, int retry) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                function.accept(input);
                return;
            }
            catch (Exception e) {
                Exception lastException = e;
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - start < (long)retry) continue;
                throw Unchecked.wrap(lastException);
            }
            break;
        }
    }

    static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

