/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.ConsoleTable;
import dev.equo.solstice.p2.P2Client;
import dev.equo.solstice.p2.P2Model;
import dev.equo.solstice.p2.P2Query;
import dev.equo.solstice.p2.P2Unit;
import java.util.List;
import javax.xml.transform.TransformerException;

public class P2Multitool {
    public ConsoleTable.Format format = ConsoleTable.Format.ascii;
    public boolean request = false;
    public boolean installed = false;
    public boolean problems = false;
    public boolean optional = false;
    public All all;
    public String detail;
    public String raw;

    public boolean argsAreValid() {
        int numArgs = 0;
        if (this.request) {
            ++numArgs;
        }
        if (this.installed) {
            ++numArgs;
        }
        if (this.problems) {
            ++numArgs;
        }
        if (this.optional) {
            ++numArgs;
        }
        if (this.all != null) {
            ++numArgs;
        }
        if (this.detail != null) {
            ++numArgs;
        }
        if (this.raw != null) {
            ++numArgs;
        }
        return numArgs == 1;
    }

    public void dump(P2Model model, P2Client.Caching caching) throws Exception {
        if (this.request) {
            this.request(model);
        } else {
            P2Query query = model.queryRaw(caching);
            if (this.installed) {
                this.installed(query);
            } else if (this.problems) {
                this.problems(query);
            } else if (this.optional) {
                this.optional(query);
            } else if (this.all != null) {
                this.all(query, this.all);
            } else if (this.detail != null) {
                this.detail(query, this.detail);
            } else if (this.raw != null) {
                this.raw(query, this.raw);
            } else {
                throw new UnsupportedOperationException("Programming error");
            }
        }
    }

    private void detail(P2Query query, String detail) {
        P2Unit resolved = query.getInstalledUnitById(detail);
        List<P2Unit> allAvailable = query.getAllAvailableUnitsById(detail);
        if (allAvailable.size() == 1) {
            System.out.println("1 unit available with id " + detail);
        } else {
            System.out.println(allAvailable.size() + " units available with id " + detail);
        }
        for (P2Unit v : allAvailable) {
            System.out.print("  " + v.getVersion());
            if (v == resolved) {
                System.out.println("  [x] included by install");
                continue;
            }
            System.out.println("  [ ] not included by install");
        }
        System.out.println(ConsoleTable.detail(allAvailable, this.format));
    }

    private void optional(P2Query query) {
        System.out.println(ConsoleTable.optionalRequirementsNotInstalled(query, this.format));
    }

    private void problems(P2Query query) {
        System.out.println(ConsoleTable.unmetRequirements(query, this.format));
        System.out.println(ConsoleTable.ambiguousRequirements(query, this.format));
    }

    private void installed(P2Query query) {
        if (query.getJars().isEmpty()) {
            System.out.println(ConsoleTable.mavenStatus(query.getJars(), this.format));
            return;
        }
        int numUnmet = query.getUnmetRequirements().size();
        int numAmbiguous = query.getAmbiguousRequirements().size();
        if (numUnmet > 0) {
            System.out.println("WARNING!!! " + numUnmet + " unmet requirement(s), " + numAmbiguous + " ambigous requirement(s).");
            System.out.println("WARNING!!!  For more info: `gradlew equoList --problems`");
        } else {
            System.out.println(numUnmet + " unmet requirement(s), " + numAmbiguous + " ambigous requirement(s). For more info: `gradlew equoList --problems`");
        }
        int numOptional = query.getOptionalRequirementsNotInstalled().size();
        if (numOptional > 0) {
            System.out.println(numOptional + " optional requirement(s) were not installed. For more info: `gradlew equoList --optional`");
        } else {
            System.out.println("Every optional requirement was installed. For more info: `gradlew equoList --optional`");
        }
        System.out.println(ConsoleTable.mavenStatus(query.getJars(), this.format));
    }

    private void raw(P2Query query, String raw) throws TransformerException {
        List<P2Unit> allAvailable = query.getAllAvailableUnitsById(raw);
        for (P2Unit unit : allAvailable) {
            System.out.println(unit.getRawXml());
        }
    }

    private void all(P2Query query, All all) {
        List<P2Unit> unitsToList;
        query.addAllUnits();
        switch (all) {
            case categories: {
                unitsToList = query.getCategories();
                break;
            }
            case features: {
                unitsToList = query.getFeatures();
                break;
            }
            case jars: {
                unitsToList = query.getJars();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown " + all);
            }
        }
        System.out.println(ConsoleTable.nameAndDescription(unitsToList, this.format));
    }

    private void request(P2Model model) {
        System.out.println(ConsoleTable.request(model, this.format));
    }

    public static enum All {
        categories,
        features,
        jars;

    }
}

