/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.P2Client;
import dev.equo.solstice.p2.P2Session;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class P2Unit
implements Comparable<P2Unit> {
    final Node rootNode;
    final P2Client.Folder index;
    final String id;
    final Version version;
    Filter filter;
    final TreeMap<String, String> properties = new TreeMap();
    final TreeSet<P2Session.Requirement> requires = new TreeSet();
    private static final String df_LT = "df_LT.";
    public static final String MAVEN_GROUP_ID = "maven-groupId";
    public static final String MAVEN_ARTIFACT_ID = "maven-artifactId";
    public static final String MAVEN_VERSION = "maven-version";
    public static final String MAVEN_REPOSITORY = "maven-repository";
    public static final String MAVEN_TYPE = "maven-type";
    public static final String P2_NAME = "org.eclipse.equinox.p2.name";
    public static final String P2_DESC = "org.eclipse.equinox.p2.description";
    public static final String P2_TYPE_CATEGORY = "org.eclipse.equinox.p2.type.category";
    public static final String P2_TYPE_FEATURE = "org.eclipse.equinox.p2.type.group";
    public static final String ARTIFACT_CLASSIFIER = "artifact-classifier";
    public static final String ARTIFACT_CLASSIFIER_BUNDLE = "osgi.bundle";
    public static final String ARTIFACT_CLASSIFIER_FEATURE = "org.eclipse.update.feature";
    public static final String ARTIFACT_CLASSIFIER_BINARY = "binary";
    private static final List<String> PROP_FILTER = Arrays.asList("maven-groupId", "maven-artifactId", "maven-version", "maven-repository", "maven-type", "org.eclipse.equinox.p2.name", "org.eclipse.equinox.p2.description", "org.eclipse.equinox.p2.type.category", "org.eclipse.equinox.p2.type.group");
    private static List<String> EXCLUDED_REQUIRE_PROVIDE_NAMESPACES = Arrays.asList("org.eclipse.equinox.p2.eclipse.type", "osgi.ee");

    P2Unit(P2Session session, P2Client.Folder index, Node rootNode) {
        this.rootNode = rootNode;
        this.index = index;
        this.id = rootNode.getAttributes().getNamedItem("id").getNodeValue();
        this.version = Version.parseVersion((String)rootNode.getAttributes().getNamedItem("version").getNodeValue());
        NodeList nodeList = rootNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if ("filter".equals(node.getNodeName())) {
                this.filter = session.parseFilter(node.getTextContent().trim());
                continue;
            }
            if ("properties".equals(node.getNodeName())) {
                this.parseProperties(node);
                continue;
            }
            if ("provides".equals(node.getNodeName())) {
                this.parseProvides(session, node);
                continue;
            }
            if ("requires".equals(node.getNodeName())) {
                this.parseRequires(session, node);
                continue;
            }
            if (!"artifacts".equals(node.getNodeName())) continue;
            this.parseArtifact(node);
        }
    }

    private void parseArtifact(Node node) {
        String artifactClassifier = null;
        NodeList artifactNodes = node.getChildNodes();
        for (int i = 0; i < artifactNodes.getLength(); ++i) {
            Node propNode = artifactNodes.item(i);
            if (!"artifact".equals(propNode.getNodeName())) continue;
            String classifier = propNode.getAttributes().getNamedItem("classifier").getNodeValue();
            if (artifactClassifier != null && !artifactClassifier.equals(classifier)) {
                throw new IllegalArgumentException(this.id + ":" + this.version + " has multiple artifacts, first was " + artifactClassifier + " second was " + classifier);
            }
            artifactClassifier = classifier;
        }
        if (artifactClassifier != null) {
            this.properties.put(ARTIFACT_CLASSIFIER, artifactClassifier);
        }
    }

    private void parseProperties(Node node) {
        String name;
        Node propNode;
        int i;
        NodeList propertyNodes = node.getChildNodes();
        TreeMap<String, String> needsReplacing = new TreeMap<String, String>();
        for (i = 0; i < propertyNodes.getLength(); ++i) {
            int idx;
            propNode = propertyNodes.item(i);
            if (!"property".equals(propNode.getNodeName()) || (idx = PROP_FILTER.indexOf(name = propNode.getAttributes().getNamedItem("name").getNodeValue())) == -1) continue;
            String value = propNode.getAttributes().getNamedItem("value").getNodeValue();
            this.properties.put(PROP_FILTER.get(idx), value);
            if (!value.startsWith("%")) continue;
            needsReplacing.put(value, name);
        }
        if (!needsReplacing.isEmpty()) {
            for (i = 0; i < propertyNodes.getLength(); ++i) {
                String replaceKey;
                String keyThatNeedsReplacement;
                propNode = propertyNodes.item(i);
                if (!"property".equals(propNode.getNodeName()) || !(name = propNode.getAttributes().getNamedItem("name").getNodeValue()).startsWith(df_LT) || needsReplacing.isEmpty() || (keyThatNeedsReplacement = (String)needsReplacing.remove(replaceKey = "%" + name.substring(df_LT.length()))) == null) continue;
                String value = propNode.getAttributes().getNamedItem("value").getNodeValue();
                this.properties.put(keyThatNeedsReplacement, value);
                if (needsReplacing.isEmpty()) break;
            }
        }
    }

    private void parseProvides(P2Session session, Node providesRoot) {
        NodeList providesNodes = providesRoot.getChildNodes();
        for (int i = 0; i < providesNodes.getLength(); ++i) {
            String namespace;
            Node node = providesNodes.item(i);
            if (!"provided".equals(node.getNodeName()) || EXCLUDED_REQUIRE_PROVIDE_NAMESPACES.contains(namespace = node.getAttributes().getNamedItem("namespace").getNodeValue())) continue;
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            session.provides(namespace, name, this);
        }
    }

    private void parseRequires(P2Session session, Node providesRoot) {
        NodeList providesNodes = providesRoot.getChildNodes();
        for (int i = 0; i < providesNodes.getLength(); ++i) {
            String namespace;
            Node namespaceNode;
            Node node = providesNodes.item(i);
            if (!"required".equals(node.getNodeName()) || (namespaceNode = node.getAttributes().getNamedItem("namespace")) == null || EXCLUDED_REQUIRE_PROVIDE_NAMESPACES.contains(namespace = namespaceNode.getNodeValue())) continue;
            boolean isOptional = false;
            Node optionalNode = node.getAttributes().getNamedItem("optional");
            if (optionalNode != null) {
                isOptional = "true".equals(optionalNode.getNodeValue().trim());
            }
            FilterImpl filter = null;
            NodeList filterNodes = node.getChildNodes();
            for (int f = 0; f < filterNodes.getLength(); ++f) {
                Node filterNode = filterNodes.item(f);
                if (!"filter".equals(filterNode.getNodeName())) continue;
                if (filter != null) {
                    throw new IllegalArgumentException("We don't support multiple filters: " + this);
                }
                filter = session.parseFilter(filterNode.getTextContent().trim());
            }
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            this.requires.add(session.requires(namespace, name, isOptional, filter));
        }
    }

    public String toString() {
        return this.id + ":" + this.version;
    }

    @Override
    public int compareTo(P2Unit o) {
        if (this.id.equals(o.id)) {
            return -this.version.compareTo(o.version);
        }
        return this.id.compareTo(o.id);
    }

    public String getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getRawXml() throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(this.rootNode), new StreamResult(writer));
        String raw = writer.toString();
        String unixEndings = raw.replace("\r", "");
        String[] lines = unixEndings.split("\n");
        StringBuilder result = new StringBuilder(unixEndings.length());
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            result.append(line);
            result.append('\n');
        }
        return result.toString();
    }

    public String getRepoUrl() {
        return this.index.url;
    }

    public String getRepoUrlLastSegment() {
        char lastChar = this.index.url.charAt(this.index.url.length() - 1);
        if (lastChar != '/') {
            throw new IllegalArgumentException("p2 repo must end with /");
        }
        int lastSlash = this.index.url.lastIndexOf(47, this.index.url.length() - 2);
        return this.index.url.substring(lastSlash + 1, this.index.url.length() - 1);
    }

    public String getJarUrl() {
        return this.index.url + "plugins/" + this.id + "_" + this.version + ".jar";
    }
}

