/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.ConsoleTable;
import dev.equo.solstice.p2.TableColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class Table {
    Table() {
    }

    @SafeVarargs
    public static <T> String getTable(ConsoleTable.Format kind, Collection<T> objects, TableColumn.Data<T> ... columns) {
        if (kind == ConsoleTable.Format.csv) {
            TableColumn[] rawColumns = (TableColumn[])Arrays.stream(columns).map(c -> c.column).toArray(TableColumn[]::new);
            Iterator<T> iter = objects.iterator();
            String[][] rows = new String[objects.size()][];
            for (int r = 0; r < rows.length; ++r) {
                String[] row = new String[columns.length];
                rows[r] = row;
                T o = iter.next();
                for (int c2 = 0; c2 < row.length; ++c2) {
                    row[c2] = columns[c2].getter.apply(o);
                }
            }
            return Table.getTable(kind, rawColumns, rows);
        }
        if (kind == ConsoleTable.Format.ascii) {
            return Table.getTable(objects, Arrays.asList(columns));
        }
        throw new IllegalArgumentException("Unknown kind " + kind);
    }

    public static String getTable(ConsoleTable.Format format, TableColumn[] columns, String[][] data) {
        if (format == ConsoleTable.Format.csv) {
            StringBuilder builder = new StringBuilder();
            for (TableColumn column : columns) {
                builder.append(column.header);
                builder.append(',');
            }
            builder.setCharAt(builder.length() - 1, '\n');
            TableColumn[] tableColumnArray = data;
            int n = tableColumnArray.length;
            for (int i = 0; i < n; ++i) {
                TableColumn row;
                for (Object cell : row = tableColumnArray[i]) {
                    if (((String)cell).indexOf(44) != -1 || ((String)cell).indexOf(34) != -1) {
                        cell = ((String)cell).replace("\"", "\"\"");
                        cell = "\"" + (String)cell + "\"";
                    }
                    builder.append((String)cell);
                    builder.append(',');
                }
                builder.setCharAt(builder.length() - 1, '\n');
            }
            return builder.toString();
        }
        if (format == ConsoleTable.Format.ascii) {
            return Table.getTable(columns, data);
        }
        throw new IllegalArgumentException("Unknown format " + format);
    }

    private static <T> String getTable(Collection<T> objects, List<TableColumn.Data<T>> columns) {
        String[][] data = new String[objects.size()][];
        Iterator<T> iter = objects.iterator();
        for (int i = 0; i < objects.size(); ++i) {
            T object = iter.next();
            data[i] = new String[columns.size()];
            for (int j = 0; j < columns.size(); ++j) {
                data[i][j] = columns.get((int)j).getter.apply(object);
            }
        }
        TableColumn[] rawColumns = (TableColumn[])columns.stream().map(c -> c.column).toArray(TableColumn[]::new);
        return Table.getTable(rawColumns, data);
    }

    private static String getTable(TableColumn[] headerObjs, String[][] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Please provide valid data : " + data);
        }
        StringBuilder tableBuf = new StringBuilder();
        String[] header = Table.getHeaders(headerObjs);
        int colCount = Table.getMaxColumns(header, data);
        List<Integer> colMaxLenList = Table.getMaxColLengths(colCount, header, data);
        if (header != null && header.length > 0) {
            tableBuf.append(Table.getRowLineBuf(colCount, colMaxLenList, data));
            tableBuf.append(Table.getRowDataBuf(colCount, colMaxLenList, header, headerObjs, true));
        }
        tableBuf.append(Table.getRowLineBuf(colCount, colMaxLenList, data));
        String[] rowData = null;
        for (int i = 0; i < data.length; ++i) {
            rowData = new String[colCount];
            for (int j = 0; j < colCount; ++j) {
                rowData[j] = j < data[i].length ? data[i][j] : "";
            }
            tableBuf.append(Table.getRowDataBuf(colCount, colMaxLenList, rowData, headerObjs, false));
        }
        tableBuf.append(Table.getRowLineBuf(colCount, colMaxLenList, data));
        return tableBuf.toString();
    }

    private static String getRowDataBuf(int colCount, List<Integer> colMaxLenList, String[] row, TableColumn[] headerObjs, boolean isHeader) {
        StringBuilder rowBuilder = new StringBuilder();
        Object formattedData = null;
        for (int i = 0; i < colCount; ++i) {
            Align align = Align.LEFT;
            if (headerObjs != null && i < headerObjs.length) {
                align = isHeader ? headerObjs[i].headerAlign : headerObjs[i].dataAlign;
            }
            formattedData = i < row.length ? row[i] : "";
            formattedData = "| " + Table.getFormattedData(colMaxLenList.get(i), (String)formattedData, align) + " ";
            if (i + 1 == colCount) {
                formattedData = (String)formattedData + "|";
            }
            rowBuilder.append((String)formattedData);
        }
        return rowBuilder.append("\n").toString();
    }

    private static String getFormattedData(int maxLength, String data, Align align) {
        if (((String)data).length() > maxLength) {
            return data;
        }
        boolean toggle = true;
        while (((String)data).length() < maxLength) {
            if (align == Align.LEFT) {
                data = (String)data + " ";
                continue;
            }
            if (align == Align.RIGHT) {
                data = " " + (String)data;
                continue;
            }
            if (align != Align.CENTER) continue;
            if (toggle) {
                data = " " + (String)data;
                toggle = false;
                continue;
            }
            data = (String)data + " ";
            toggle = true;
        }
        return data;
    }

    private static String getRowLineBuf(int colCount, List<Integer> colMaxLenList, String[][] data) {
        StringBuilder rowBuilder = new StringBuilder();
        int colWidth = 0;
        for (int i = 0; i < colCount; ++i) {
            colWidth = colMaxLenList.get(i) + 3;
            for (int j = 0; j < colWidth; ++j) {
                if (j == 0) {
                    rowBuilder.append("+");
                    continue;
                }
                if (i + 1 == colCount && j + 1 == colWidth) {
                    rowBuilder.append("-+");
                    continue;
                }
                rowBuilder.append("-");
            }
        }
        return rowBuilder.append("\n").toString();
    }

    private static int getMaxItemLength(List<String> colData) {
        int maxLength = 0;
        for (int i = 0; i < colData.size(); ++i) {
            maxLength = Math.max(colData.get(i).length(), maxLength);
        }
        return maxLength;
    }

    private static int getMaxColumns(String[] header, String[][] data) {
        int maxColumns = 0;
        for (int i = 0; i < data.length; ++i) {
            maxColumns = Math.max(data[i].length, maxColumns);
        }
        maxColumns = Math.max(header.length, maxColumns);
        return maxColumns;
    }

    private static List<Integer> getMaxColLengths(int colCount, String[] header, String[][] data) {
        ArrayList<Integer> colMaxLenList = new ArrayList<Integer>(colCount);
        ArrayList<String> colData = null;
        for (int i = 0; i < colCount; ++i) {
            colData = new ArrayList<String>();
            if (header != null && i < header.length) {
                colData.add(header[i]);
            }
            for (int j = 0; j < data.length; ++j) {
                if (i < data[j].length) {
                    colData.add(data[j][i]);
                    continue;
                }
                colData.add("");
            }
            int maxLength = Table.getMaxItemLength(colData);
            colMaxLenList.add(maxLength);
        }
        return colMaxLenList;
    }

    private static String[] getHeaders(TableColumn[] headerObjs) {
        String[] header = new String[]{};
        if (headerObjs != null && headerObjs.length > 0) {
            header = new String[headerObjs.length];
            for (int i = 0; i < headerObjs.length; ++i) {
                header[i] = headerObjs[i].header;
            }
        }
        return header;
    }

    static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

