/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import dev.equo.ide.Catalog;
import dev.equo.ide.IdeHook;
import dev.equo.solstice.p2.P2Model;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class CatalogDsl {
    protected final Catalog catalog;
    @Nullable
    private final CatalogDsl addedAsTransitiveOf;
    @Nullable
    private String urlOverride;

    protected CatalogDsl(Catalog catalog) {
        this(catalog, null);
    }

    private CatalogDsl(Catalog catalog, @Nullable CatalogDsl addedAsTransitiveOf) {
        this.catalog = catalog;
        this.addedAsTransitiveOf = addedAsTransitiveOf;
    }

    protected List<IdeHook> ideHooks() {
        return List.of();
    }

    private String url() {
        return this.catalog.getUrlForOverride(this.urlOverride);
    }

    private List<String> installs() {
        return this.catalog.getTargetsFor(this.urlOverride);
    }

    protected void setUrlOverride(String urlOverride) {
        this.urlOverride = urlOverride;
    }

    void syncUrlWith(CatalogDsl other) {
        if (!this.catalog.getP2UrlTemplate().equals(other.catalog.getP2UrlTemplate())) {
            return;
        }
        if (Objects.equals(this.urlOverride, other.urlOverride)) {
            return;
        }
        if (this.urlOverride == null) {
            this.urlOverride = other.urlOverride;
        } else if (other.urlOverride == null) {
            other.urlOverride = this.urlOverride;
        } else {
            throw new IllegalArgumentException(this.catalog.getName() + " " + other.catalog.getName() + " must have the exact same URL, but\n" + this.urlReasoning() + "\n" + other.urlReasoning());
        }
    }

    private String urlReasoning() {
        if (this.addedAsTransitiveOf != null) {
            return this.catalog.getName() + " is using " + this.url() + " (was added automatically as a transitive of " + this.addedAsTransitiveOf.catalog.getName() + ")";
        }
        return this.catalog.getName() + " is using " + this.url();
    }

    public static class TransitiveAwareList<T extends CatalogDsl> {
        private final TreeMap<Catalog, CatalogDsl> catalogEntries = new TreeMap();

        public void add(T dsl) {
            CatalogDsl existing = this.catalogEntries.get(((CatalogDsl)dsl).catalog);
            if (existing != null) {
                if (existing.addedAsTransitiveOf != null) {
                    throw new IllegalArgumentException(((CatalogDsl)dsl).catalog.getName() + " was already added as a transitive dependency of " + existing.addedAsTransitiveOf.catalog.getName() + ".\nYou can fix this by moving the <" + ((CatalogDsl)dsl).catalog.getName() + "> block above the <" + existing.addedAsTransitiveOf.catalog.getName() + "> block.");
                }
                throw new IllegalArgumentException("You can only add " + ((CatalogDsl)dsl).catalog.getName() + " once.");
            }
            this.catalogEntries.put(((CatalogDsl)dsl).catalog, (CatalogDsl)dsl);
            for (Catalog required : ((CatalogDsl)dsl).catalog.getRequires()) {
                CatalogDsl transitive = this.addAsTransitiveOf(required, (CatalogDsl)dsl);
                transitive.syncUrlWith((CatalogDsl)dsl);
            }
        }

        private CatalogDsl addAsTransitiveOf(Catalog transitive, CatalogDsl originalRequest) {
            CatalogDsl dsl = this.catalogEntries.get(transitive);
            if (dsl == null) {
                dsl = new CatalogDsl(transitive, originalRequest);
                this.catalogEntries.put(transitive, dsl);
            }
            for (Catalog required : transitive.getRequires()) {
                CatalogDsl transitiveDsl = this.addAsTransitiveOf(required, originalRequest);
                transitiveDsl.syncUrlWith(dsl);
            }
            return dsl;
        }

        public void putInto(P2Model model, IdeHook.List hooks) {
            for (CatalogDsl dsl : this.catalogEntries.values()) {
                model.addP2Repo(dsl.url());
                model.getInstall().addAll(dsl.installs());
                hooks.addAll(dsl.ideHooks());
            }
        }
    }
}

