/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import com.diffplug.common.swt.os.OS;
import dev.equo.ide.IdeHook;
import dev.equo.ide.IdeHookInstantiated;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdeHookBranding
implements IdeHook {
    private static final String DEFAULT_TITLE = "Equo IDE";
    private String title = "Equo IDE";
    @Nullable
    private File icon;
    @Nullable
    private File splash;

    public IdeHookBranding title(String title) {
        this.title = title == null ? DEFAULT_TITLE : title;
        return this;
    }

    public IdeHookBranding icon(File iconImg) {
        this.icon = iconImg;
        return this;
    }

    public IdeHookBranding splash(File splashImg) {
        this.splash = splashImg;
        return this;
    }

    @Override
    public IdeHookInstantiated instantiate() {
        return new Instantiated();
    }

    class Instantiated
    implements IdeHookInstantiated {
        Logger logger = LoggerFactory.getLogger(IdeHookBranding.class);
        private Shell splash;

        Instantiated() {
        }

        @Override
        public void isClean(boolean isClean) throws Exception {
            if (OS.getRunning().isMac()) {
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", IdeHookBranding.this.title);
            }
        }

        private Image loadImage(Display display, File file, String defaultResource) {
            Image image;
            block11: {
                try {
                    if (file != null) {
                        ImageData imageData = new ImageData(file.getAbsolutePath());
                        return new Image((Device)display, imageData);
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(IdeHookBranding.class).warn("Unable to load image " + file.getAbsolutePath() + ", falling back to default.", (Throwable)e);
                }
                InputStream input = IdeHookBranding.class.getClassLoader().getResource(defaultResource).openStream();
                try {
                    ImageData imageData = new ImageData(input);
                    image = new Image((Device)display, imageData);
                    if (input == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                input.close();
            }
            return image;
        }

        @Override
        public void afterOsgi(final BundleContext context) {
            InternalPlatform internal = InternalPlatform.getDefault();
            try {
                Field product = internal.getClass().getDeclaredField("product");
                product.setAccessible(true);
                product.set(internal, new IProduct(){

                    public String getApplication() {
                        return IdeHookBranding.this.title;
                    }

                    public String getName() {
                        return IdeHookBranding.this.title;
                    }

                    public String getDescription() {
                        return IdeHookBranding.this.title;
                    }

                    public String getId() {
                        return IdeHookBranding.this.title;
                    }

                    public String getProperty(String key) {
                        return null;
                    }

                    public Bundle getDefiningBundle() {
                        return Arrays.stream(context.getBundles()).filter(bundle -> bundle.getSymbolicName().equals("dev.equo.ide")).findFirst().get();
                    }
                });
                IPreferenceStore ps = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
                ps.setValue("SHOW_LOCATION", false);
                ps.setValue("SHOW_LOCATION_NAME", false);
                ps.setValue("SHOW_PERSPECTIVE_IN_TITLE", false);
                ps.setValue("SHOW_PRODUCT_IN_TITLE", true);
            }
            catch (Exception e) {
                this.logger.warn("problem defining product", (Throwable)e);
            }
        }

        @Override
        public void afterDisplay(Display display) {
            Point cursor = display.getCursorLocation();
            Monitor[] monitors = display.getMonitors();
            Rectangle bestMonitor = Arrays.stream(monitors).filter(monitor -> monitor.getBounds().contains(cursor)).findAny().orElse(monitors[0]).getBounds();
            Image image = this.loadImage(display, IdeHookBranding.this.splash, "dev/equo/ide/equo_splash.png");
            int imgX = image.getBounds().width;
            int imgY = image.getBounds().height;
            this.splash = new Shell(display, 16392);
            this.splash.setText(IdeHookBranding.this.title);
            this.splash.setBounds(bestMonitor.x + (bestMonitor.width - imgX / 2) / 2, bestMonitor.y + (bestMonitor.height - imgY / 2) / 2, imgX / 2, imgY / 2);
            this.splash.setBackground(display.getSystemColor(1));
            this.splash.addListener(9, e -> {
                e.gc.setAdvanced(true);
                e.gc.setAntialias(1);
                e.gc.drawImage(image, 0, 0, imgX, imgY, 0, 0, imgX / 2, imgY / 2);
            });
            this.splash.open();
            this.splash.forceActive();
            while (display.readAndDispatch()) {
            }
            Image icon = this.loadImage(Display.getDefault(), IdeHookBranding.this.icon, "dev/equo/ide/equo_icon.png");
            Rectangle bounds = icon.getBounds();
            if (bounds.width != bounds.height) {
                LoggerFactory.getLogger(IdeHookBranding.class).warn("Icon should be square, but is instead {} by {}", (Object)bounds.width, (Object)bounds.height);
            }
            Window.setDefaultImage((Image)icon);
        }

        @Override
        public void postStartup() {
            TaskItem item;
            this.splash.dispose();
            this.splash = null;
            TaskBar taskBar = Display.getDefault().getSystemTaskBar();
            if (taskBar != null && (item = taskBar.getItem(null)) != null) {
                item.setText(IdeHookBranding.this.title);
            }
        }
    }
}

