/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.Dictionaries;
import dev.equo.solstice.Solstice;
import dev.equo.solstice.SolsticeManifest;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.felix.atomos.Atomos;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleContextAtomos
implements Atomos.HeaderProvider {
    final Map<String, List<SolsticeManifest>> bySymbolicName;
    final Logger logger;

    BundleContextAtomos(Solstice bundleSet, Logger logger) {
        this.bySymbolicName = bundleSet.bySymbolicName();
        this.logger = logger;
    }

    public Optional<Map<String, String>> apply(String location, Map<String, String> existingHeaders) {
        String symbolicNameHeader = existingHeaders.get("Bundle-SymbolicName");
        if (symbolicNameHeader == null) {
            return Optional.empty();
        }
        String symbolicName = SolsticeManifest.parseAndStripManifestHeader("Bundle-SymbolicName", existingHeaders.get("Bundle-SymbolicName")).get(0);
        List<SolsticeManifest> candidates = this.bySymbolicName.get(symbolicName);
        if (candidates == null || candidates.isEmpty()) {
            if (!symbolicName.startsWith("java.") && !symbolicName.startsWith("jdk.")) {
                this.logger.warn("No manifest for bundle " + symbolicName + " at " + location);
            }
            return Optional.empty();
        }
        SolsticeManifest manifest = this.bySymbolicName.get(symbolicName).get(0);
        return Optional.of(this.atomosHeaders(manifest));
    }

    public Map<String, String> atomosHeaders(SolsticeManifest manifest) {
        LinkedHashMap<String, String> atomos = new LinkedHashMap<String, String>(manifest.getHeadersOriginal());
        BundleContextAtomos.setHeader(atomos, "Import-Package", manifest.pkgImports);
        BundleContextAtomos.setHeader(atomos, "Export-Package", manifest.pkgExports);
        BundleContextAtomos.setHeader(atomos, "Require-Bundle", manifest.requiredBundles);
        BundleContextAtomos.setHeader(atomos, "Bundle-ClassPath", Collections.emptyList());
        return atomos;
    }

    private static void setHeader(Map<String, String> map, String key, List<String> values) {
        if (values.isEmpty()) {
            map.remove(key);
        } else {
            map.put(key, String.join((CharSequence)",", values));
        }
    }

    public static BundleContext hydrate(Solstice bundleSet, Map<String, String> props) throws BundleException {
        Logger logger = LoggerFactory.getLogger(BundleContextAtomos.class);
        Atomos atomos = Atomos.newAtomos((Atomos.HeaderProvider)new BundleContextAtomos(bundleSet, logger));
        Framework framework = atomos.newFramework(props);
        framework.start();
        BundleContext bundleContext = framework.getBundleContext();
        bundleSet.hydrateFrom(manifest -> {
            for (Bundle bundle : bundleContext.getBundles()) {
                if (!bundle.getSymbolicName().equals(manifest.getSymbolicName())) continue;
                return bundle;
            }
            throw new IllegalArgumentException("No bundle for " + manifest.getSymbolicName());
        });
        return bundleContext;
    }

    public static void urlWorkaround(BundleContext bundleContext) throws InvalidSyntaxException {
        Collection converters = bundleContext.getServiceReferences(URLConverter.class, "(protocol=platform)");
        for (ServiceReference toRemove : converters) {
            ((ServiceReferenceImpl)toRemove).getRegistration().unregister();
        }
        bundleContext.registerService(URLConverter.class, (Object)new URLConverter(){

            public URL toFileURL(URL url) {
                return url;
            }

            public URL resolve(URL url) {
                return url;
            }
        }, Dictionaries.of("protocol", "platform"));
    }
}

