/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import com.diffplug.common.swt.os.OS;
import dev.equo.ide.Catalog;
import dev.equo.ide.Fudge;
import dev.equo.ide.IdeHook;
import dev.equo.ide.IdeHookInstantiated;
import dev.equo.ide.IdeHookLockFile;
import dev.equo.ide.IdeHookReflected;
import dev.equo.ide.IdeLockFile;
import dev.equo.ide.IdeMainUi;
import dev.equo.ide.Launcher;
import dev.equo.ide.Patch;
import dev.equo.ide.WorkspaceInit;
import dev.equo.solstice.BundleContextAtomos;
import dev.equo.solstice.NestedJars;
import dev.equo.solstice.SerializableMisc;
import dev.equo.solstice.ShimIdeBootstrapServices;
import dev.equo.solstice.SignedJars;
import dev.equo.solstice.Solstice;
import dev.equo.solstice.SolsticeManifest;
import dev.equo.solstice.p2.WorkspaceRegistry;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

public class BuildPluginIdeMain {
    private static String bundlesDotInfo(List<File> cp) {
        StringBuilder buffer = new StringBuilder();
        String newline = "\n";
        String startLevel = "0";
        String markedAsStarted = "false";
        buffer.append("#encoding=UTF-8");
        buffer.append(newline);
        buffer.append("#version=1");
        buffer.append(newline);
        for (File file : cp) {
            try {
                SolsticeManifest manifest = SolsticeManifest.parseJar(file);
                if (manifest == null || manifest.getSymbolicName() == null || manifest.getVersion() == null) continue;
                buffer.append(manifest.getSymbolicName());
                buffer.append(',');
                buffer.append(manifest.getVersion());
                buffer.append(',');
                buffer.append(file.toURI());
                buffer.append(',');
                buffer.append(startLevel);
                buffer.append(',');
                buffer.append(markedAsStarted);
                buffer.append(newline);
            }
            catch (Exception exception) {}
        }
        return buffer.toString();
    }

    private static <T> T parseArg(String[] args, String arg, Function<String, T> parser, T defaultValue) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!arg.equals(args[i])) continue;
            return parser.apply(args[i + 1]);
        }
        return defaultValue;
    }

    static File defaultDir() {
        String userDir = System.getProperty("user.dir");
        if (userDir.endsWith("equo-ide")) {
            return new File(userDir + "/solstice/build/testSetup");
        }
        return new File(userDir + "/build/testSetup");
    }

    public static void main(String[] args) throws InvalidSyntaxException, BundleException, IOException {
        boolean isClean;
        File installDir = BuildPluginIdeMain.parseArg(args, "-installDir", File::new, BuildPluginIdeMain.defaultDir());
        boolean useAtomos = BuildPluginIdeMain.parseArg(args, "-useAtomos", Boolean::parseBoolean, false);
        boolean initOnly = BuildPluginIdeMain.parseArg(args, "-initOnly", Boolean::parseBoolean, false);
        DebugClasspath debugClasspath = BuildPluginIdeMain.parseArg(args, "-debugClasspath", DebugClasspath::valueOf, DebugClasspath.disabled);
        File hookListFile = BuildPluginIdeMain.parseArg(args, "-ideHooks", File::new, null);
        IdeHook.List ideHooksParsed = hookListFile == null ? new IdeHook.List() : SerializableMisc.fromFile(IdeHook.List.class, hookListFile);
        debugClasspath.printAndExitIfEnabled();
        NestedJars.onClassPath().confirmAllNestedJarsArePresentOnClasspath(new File(installDir, "nested-jars"));
        Solstice solstice = Solstice.findBundlesOnClasspath();
        solstice.warnAndModifyManifestsToFix();
        IdeHook.InstantiatedList ideHooks = ideHooksParsed.instantiate();
        IdeHookLockFile.Instantiated lockFileHook = ideHooks.find(IdeHookLockFile.Instantiated.class);
        boolean bl = isClean = lockFileHook == null || lockFileHook.isClean();
        if (!initOnly) {
            ideHooks.forEach(IdeHookInstantiated::isClean, isClean);
            Display display = Display.getDefault();
            ideHooks.forEach(IdeHookInstantiated::afterDisplay, display);
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("org.eclipse.equinox.simpleconfigurator.configUrl", "file: broken on purpose to disable simpleconfigurator");
        props.put("gosh.args", "--quiet --noshutdown");
        props.put("osgi.nl", "en_US");
        props.put("eclipse.noRegistryFlushing", "true");
        props.put("org.osgi.framework.storage.clean", "onFirstInit");
        props.put("osgi.instance.area", new File(installDir, "instance").getAbsolutePath());
        props.put("osgi.install.area", new File(installDir, "install").getAbsolutePath());
        props.put("osgi.configuration.area", new File(installDir, "config").getAbsolutePath());
        props.put("osgi.user.area", new File(installDir, "user").getAbsolutePath());
        File eclipseHome = new File(installDir, "eclipse-home");
        props.put("eclipse.home.location", eclipseHome.getAbsolutePath());
        System.setProperty("eclipse.home.location", eclipseHome.toURI().toString());
        if (useAtomos) {
            props.put("atomos.content.start", "false");
            solstice.openAtomos(props);
        } else {
            solstice.openShim(props);
            ShimIdeBootstrapServices.apply(props, solstice.getContext());
        }
        ShimIdeBootstrapServices.shimAndAtomos(props, solstice.getContext());
        solstice.start("org.apache.felix.scr");
        solstice.startAllWithLazy(false);
        for (String eagerStart : solstice.bundlesOnClasspathOutOf(Fudge.activateEagerWithoutTransitives())) {
            solstice.startWithoutTransitives(eagerStart);
        }
        solstice.start("org.eclipse.ui.ide.application");
        if (useAtomos) {
            BundleContextAtomos.urlWorkaround(solstice);
        }
        if (!initOnly) {
            ideHooks.forEach(IdeHookInstantiated::afterOsgi, solstice.getContext());
        }
        if (initOnly) {
            System.out.println("Loaded " + solstice.getContext().getBundles().length + " bundles " + (useAtomos ? "using Atomos" : "not using Atomos"));
            System.exit(0);
            return;
        }
        int exitCode = IdeMainUi.main(solstice, ideHooks);
        if (exitCode == 0) {
            System.exit(0);
        } else {
            System.err.println("Unexpected exit code: " + exitCode);
            System.exit(1);
        }
    }

    public static enum DebugClasspath {
        disabled,
        names,
        paths;


        public void printWithHead(String header, Stream<String> paths) {
            switch (this) {
                case disabled: {
                    return;
                }
                case names: 
                case paths: {
                    System.out.println("/ " + header);
                    if (this == names) {
                        paths = paths.map(path -> {
                            int lastSlash = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
                            return path.substring(lastSlash + 1);
                        });
                    }
                    paths.forEach(System.out::println);
                    System.out.println("\\ " + header);
                    return;
                }
            }
            throw new IllegalArgumentException("Unexpected enum value " + this);
        }

        private void printAndExitIfEnabled() throws IOException {
            switch (this) {
                case disabled: {
                    return;
                }
                case names: 
                case paths: {
                    Enumeration<URL> manifestURLs = SolsticeManifest.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                    ArrayList<String> paths = new ArrayList<String>();
                    while (manifestURLs.hasMoreElements()) {
                        String url = manifestURLs.nextElement().toExternalForm();
                        paths.add(url.substring(0, url.length() - ("/META-INF/MANIFEST.MF".length() + 1)));
                    }
                    this.printWithHead("jars with manifests inside runtime", paths.stream());
                    System.exit(0);
                }
            }
            throw new IllegalArgumentException("Unexpected enum value " + this);
        }
    }

    public static class Caller {
        public File workspaceDir;
        public IdeLockFile lockFile;
        public IdeHook.List ideHooks;
        public WorkspaceInit workspaceInit;
        public ArrayList<File> classpath;
        public DebugClasspath debugClasspath;
        public Boolean initOnly;
        public Boolean showConsole;
        public Boolean useAtomos;
        public Boolean debugIde;
        public String showConsoleFlag;
        public String cleanFlag;

        public static Caller forProjectDir(File projectDir, boolean clean) throws IOException, InterruptedException {
            Caller caller = new Caller();
            WorkspaceRegistry workspaceRegistry = WorkspaceRegistry.instance();
            caller.workspaceDir = workspaceRegistry.workspaceDirForProjectDir(projectDir);
            workspaceRegistry.removeAbandoned();
            caller.lockFile = IdeLockFile.forWorkspaceDir(caller.workspaceDir);
            ProcessHandle alreadyRunning = caller.lockFile.ideAlreadyRunning();
            if (IdeLockFile.alreadyRunningAndUserRequestsAbort(alreadyRunning)) {
                return null;
            }
            if (clean) {
                workspaceRegistry.cleanWorkspaceDir(caller.workspaceDir);
            }
            return caller;
        }

        private Caller() {
        }

        public void launch() throws IOException, InterruptedException {
            Consumer<Process> monitorProcess;
            boolean isBlocking;
            String version;
            Objects.requireNonNull(this.workspaceDir);
            Objects.requireNonNull(this.lockFile);
            Objects.requireNonNull(this.ideHooks);
            Objects.requireNonNull(this.workspaceInit);
            Objects.requireNonNull(this.classpath);
            Objects.requireNonNull(this.debugClasspath);
            Objects.requireNonNull(this.initOnly);
            Objects.requireNonNull(this.showConsole);
            Objects.requireNonNull(this.useAtomos);
            Objects.requireNonNull(this.debugIde);
            Objects.requireNonNull(this.showConsoleFlag);
            Objects.requireNonNull(this.cleanFlag);
            ArrayList<File> classpathSorted = Launcher.copyAndSortClasspath(this.classpath);
            SignedJars.stripIfNecessary(classpathSorted);
            File nestedJarFolder = new File(this.workspaceDir, "nested-jars");
            for (Map.Entry<URL, File> nested : NestedJars.inFiles(classpathSorted).extractAllNestedJars(nestedJarFolder)) {
                classpathSorted.add(nested.getValue());
            }
            ArrayList<String> vmArgs = new ArrayList<String>();
            LinkedHashMap<String, String> environmentVars = new LinkedHashMap<String, String>();
            if (Catalog.EQUO_CHROMIUM.isEnabled(this.classpath)) {
                vmArgs.add("-Dchromium.args=--disable-site-isolation-trials");
                vmArgs.add("-Dchromium.setTextAsUrl=file:");
                if (OS.getRunning().isLinux()) {
                    environmentVars.put("GDK_BACKEND", "x11");
                }
                Patch.patch(classpathSorted, nestedJarFolder, "patch-chromium-swt");
                SignedJars.stripIf(classpathSorted, fileName -> fileName.startsWith("org.eclipse.swt."));
                vmArgs.add("-Dchromium.activate_equo_chromium=This distribution of the Equo browser is licensed only for use with an IDE launched by the EquoIDE build plugin");
            }
            if (this.useAtomos.booleanValue() && "3.18.300".equals(version = Patch.detectVersion(classpathSorted, "org.eclipse.osgi"))) {
                Patch.patch(classpathSorted, nestedJarFolder, "patch-equinox-4.27");
                SignedJars.stripIf(classpathSorted, jarName -> jarName.startsWith("org.eclipse.osgi"));
            }
            SignedJars.stripIfNecessary(classpathSorted);
            if (this.lockFile.hasClasspath() && !classpathSorted.equals(this.lockFile.readClasspath())) {
                System.out.println("WARNING! The classpath has changed since this IDE was setup.");
                System.out.println("         Recommend closing the IDE and retrying with this flag: " + this.cleanFlag);
            }
            File ideHooksFile = new File(this.workspaceDir, "ide-hooks");
            IdeHook.List ideHooksCopy = this.ideHooks.copy();
            for (File jar : classpathSorted) {
                String ideHook = SolsticeManifest.parseJar(jar).getHeadersOriginal().get("Bundle-IdeHook");
                if (ideHook == null) continue;
                ideHooksCopy.add(new IdeHookReflected(ideHook));
            }
            ideHooksCopy.add(IdeHookLockFile.forWorkspaceDirAndClasspath(this.workspaceDir, classpathSorted));
            SerializableMisc.toFile(ideHooksCopy, ideHooksFile);
            this.workspaceInit.applyTo(this.workspaceDir);
            Path installDir = this.workspaceDir.toPath().resolve("install");
            Files.createDirectories(installDir, new FileAttribute[0]);
            Path bundlesInfo = this.workspaceDir.toPath().resolve("config/org.eclipse.equinox.simpleconfigurator/bundles.info");
            Files.createDirectories(bundlesInfo.getParent(), new FileAttribute[0]);
            Files.writeString(bundlesInfo, (CharSequence)BuildPluginIdeMain.bundlesDotInfo(classpathSorted), new OpenOption[0]);
            this.debugClasspath.printWithHead("jars about to be launched", classpathSorted.stream().map(File::getAbsolutePath));
            boolean bl = isBlocking = this.initOnly != false || this.showConsole != false || this.debugClasspath != DebugClasspath.disabled || this.debugIde != false;
            if (OS.getRunning().isMac()) {
                vmArgs.add("-XstartOnFirstThread");
            }
            vmArgs.add("-Dorg.slf4j.simpleLogger.defaultLogLevel=" + (isBlocking ? "info" : "error"));
            if (this.debugIde.booleanValue()) {
                vmArgs.add("-Xdebug");
                vmArgs.add("-Xrunjdwp:transport=dt_socket,address=8000,server=y,suspend=y");
                System.out.println("IDE will block until you attach a jdb debugger to port 8000");
                System.out.println("  e.g. jdb -attach localhost:8000");
            }
            if (isBlocking) {
                monitorProcess = null;
            } else {
                long lockFileBeforeLaunch = this.lockFile.readPidToken();
                monitorProcess = process -> {
                    while (this.lockFile.readPidToken() == lockFileBeforeLaunch) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    process.destroyForcibly();
                };
            }
            int exitCode = Launcher.launchJavaBlocking(isBlocking, classpathSorted, vmArgs, BuildPluginIdeMain.class.getName(), monitorProcess, "-installDir", this.workspaceDir.getAbsolutePath(), "-useAtomos", Boolean.toString(this.useAtomos), "-initOnly", Boolean.toString(this.initOnly), "-debugClasspath", this.debugClasspath.name(), "-ideHooks", ideHooksFile.getAbsolutePath());
            if (!isBlocking) {
                System.out.println("NEED HELP? If the IDE doesn't appear, try adding " + this.showConsoleFlag);
            }
            if (exitCode != 0) {
                System.out.println("WARNING! Exit code: " + exitCode);
            }
        }
    }
}

