/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import dev.equo.solstice.NestedJars;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;

class Patch {
    private static final String DOT_JAR = ".jar";

    Patch() {
    }

    static String detectVersion(List<File> classpath, String symbolicName) {
        String prefix = symbolicName + "-";
        for (File jar : classpath) {
            String name = jar.getName();
            if (!name.endsWith(DOT_JAR) || !name.startsWith(prefix)) continue;
            return name.substring(prefix.length(), name.length() - DOT_JAR.length());
        }
        return null;
    }

    static void patch(List<File> classpathSorted, File nestedJarFolder, final String patchJar) {
        List<Map.Entry<URL, File>> overrides = new NestedJars(){

            @Override
            protected List<URL> listNestedJars() {
                return List.of(this.getClass().getResource("/" + patchJar + Patch.DOT_JAR));
            }
        }.extractAllNestedJars(nestedJarFolder);
        if (overrides.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one element, had " + overrides);
        }
        classpathSorted.add(0, overrides.get(0).getValue());
    }
}

