/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.spi.FrameworkException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Property;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class BundleManagement {
    private static final Log logger = LogFactory.getLog(BundleManagement.class);

    public static void loadBundle(RepositoryAdmin repositoryAdmin, BundleContext bundleContext, String bundleSymbolicName) throws FrameworkException {
        logger.trace((Object)("Installing bundle " + bundleSymbolicName));
        Resolver resolver = repositoryAdmin.resolver();
        String filterString = "(symbolicname=" + bundleSymbolicName + ")";
        Resource[] resources = null;
        try {
            resources = repositoryAdmin.discoverResources(filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new FrameworkException("Unable to discover repoistory resources", (Throwable)e);
        }
        try {
            if (resources.length == 0) {
                throw new FrameworkException("Unable to locate bundle \"" + bundleSymbolicName + "\" in OBR repository");
            }
            BundleManagement.addResource(bundleContext, bundleSymbolicName, resolver, resources[0]);
        }
        catch (FrameworkException e) {
            throw new FrameworkException("Unable to install bundle \"" + bundleSymbolicName + "\" from OBR repository", (Throwable)e);
        }
    }

    public static void loadAllGherkinManagerBundles(RepositoryAdmin repositoryAdmin, BundleContext bundleContext) throws FrameworkException {
        logger.trace((Object)"Installing manager bundles");
        Resolver resolver = repositoryAdmin.resolver();
        String filterString = "(symbolicname=*)";
        Resource[] resources = null;
        try {
            resources = repositoryAdmin.discoverResources(filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new FrameworkException("Unable to discover repoistory resources", (Throwable)e);
        }
        try {
            if (resources.length == 0) {
                throw new FrameworkException("Unable to locate manager bundles in OBR repository");
            }
            for (Resource resource : resources) {
                Capability[] capabilities;
                boolean gherkinSupport = false;
                for (Capability capability : capabilities = resource.getCapabilities()) {
                    if (!capability.getName().equals("service")) continue;
                    for (Property prop : capability.getProperties()) {
                        if (!prop.getValue().contains("dev.galasa.framework.spi.IGherkinManager") || !prop.getValue().contains("dev.galasa.framework.spi.IManager")) continue;
                        gherkinSupport = true;
                    }
                }
                if (!gherkinSupport || BundleManagement.isBundleActive(bundleContext, resource.getSymbolicName())) continue;
                BundleManagement.addResource(bundleContext, resource.getSymbolicName(), resolver, resource);
            }
        }
        catch (FrameworkException e) {
            throw new FrameworkException("Unable to install manager bundles from OBR repository", (Throwable)e);
        }
    }

    private static void addResource(BundleContext bundleContext, String bundleSymbolicName, Resolver resolver, Resource resource) throws FrameworkException {
        logger.trace((Object)("Resouce: " + resource));
        resolver.add(resource);
        boolean resourceHasReferenceUrl = false;
        if (resource.getURI().startsWith("reference:")) {
            resourceHasReferenceUrl = true;
        }
        if (resolver.resolve()) {
            Resource[] optionalResources;
            Resource[] requiredResources;
            for (Resource requiredResource : requiredResources = resolver.getRequiredResources()) {
                if (requiredResource.getURI().startsWith("reference:")) {
                    resourceHasReferenceUrl = true;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("  RequiredResource: " + requiredResource.getSymbolicName()));
            }
            for (Resource optionalResource : optionalResources = resolver.getOptionalResources()) {
                if (optionalResource.getURI().startsWith("reference:")) {
                    resourceHasReferenceUrl = true;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("  OptionalResource: " + optionalResource.getSymbolicName()));
            }
            if (!resourceHasReferenceUrl) {
                resolver.deploy(16);
            } else {
                ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
                try {
                    Resource[] startRequiredResources;
                    for (Resource requiredResource : startRequiredResources = resolver.getRequiredResources()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("  startRequiredResource: adding resource" + requiredResource.getURI().toString()));
                        }
                        bundlesToStart.add(bundleContext.installBundle(requiredResource.getURI().toString()));
                    }
                    Resource[] startOptionalResources = resolver.getOptionalResources();
                    for (Resource optionalResource : startOptionalResources) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("  getOptionalResources: adding resource" + optionalResource.getURI().toString()));
                        }
                        bundlesToStart.add(bundleContext.installBundle(optionalResource.getURI().toString()));
                    }
                    bundlesToStart.add(bundleContext.installBundle(resource.getURI().toString()));
                    for (Bundle bundle : bundlesToStart) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("  bundlesToStart: starting" + bundle.getClass().toString()));
                        }
                        bundle.start();
                    }
                }
                catch (Exception e) {
                    throw new FrameworkException("Unable to install bundles outside of resolver", (Throwable)e);
                }
            }
            if (!BundleManagement.isBundleActive(bundleContext, bundleSymbolicName)) {
                String msg = MessageFormat.format("Bundle ''{0}'' failed to install and activate", bundleSymbolicName);
                throw new FrameworkException(msg);
            }
        } else {
            Reason[] unsatisfiedRequirements;
            logger.error((Object)("Unable to resolve " + resource.toString()));
            for (Reason reason : unsatisfiedRequirements = resolver.getUnsatisfiedRequirements()) {
                logger.error((Object)("Unsatisfied requirement: " + reason.getRequirement()));
            }
            throw new FrameworkException("Unable to resolve bundle " + bundleSymbolicName);
        }
        BundleManagement.printBundles(bundleContext);
    }

    public static boolean isBundleActive(BundleContext bundleContext, String bundleSymbolicName) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = bundleContext.getBundles()) {
            if (!bundle.getSymbolicName().equals(bundleSymbolicName) || bundle.getState() != 32) continue;
            return true;
        }
        return false;
    }

    private static void printBundles(BundleContext bundleContext) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        Bundle[] bundles = bundleContext.getBundles();
        StringBuilder messageBuffer = new StringBuilder(2048);
        messageBuffer.append("Bundle status:");
        for (Bundle bundle : bundles) {
            Object gitHash;
            block10: {
                gitHash = "";
                try {
                    URL githashUrl = bundle.getEntry("/META-INF/git.hash");
                    if (githashUrl == null) break block10;
                    try (InputStream is = githashUrl.openStream();){
                        gitHash = "-" + IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    }
                }
                catch (Exception githashUrl) {
                    // empty catch block
                }
            }
            String bundleId = String.valueOf(bundle.getBundleId());
            messageBuffer.append("\n").append(String.format("%5s", bundleId)).append("|").append(String.format("%-11s", BundleManagement.getBundleStateLabel(bundle))).append("|     |").append(bundle.getSymbolicName()).append(" (").append(bundle.getVersion()).append((String)gitHash).append(")");
        }
        logger.trace((Object)messageBuffer.toString());
    }

    private static String getBundleStateLabel(Bundle bundle) {
        switch (bundle.getState()) {
            case 1: {
                return "Uninstalled";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 16: {
                return "Stopping";
            }
            case 32: {
                return "Active";
            }
        }
        return "<Unknown (" + bundle.getState() + ")>";
    }
}

