/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.FrameworkRuns;
import dev.galasa.framework.FrameworkVersion;
import dev.galasa.framework.ManagerServiceListener;
import dev.galasa.framework.TestRunLogCapture;
import dev.galasa.framework.internal.auth.FrameworkAuthStoreService;
import dev.galasa.framework.internal.cps.FrameworkConfigurationPropertyService;
import dev.galasa.framework.internal.creds.FrameworkCredentialsService;
import dev.galasa.framework.internal.dss.FrameworkDynamicStatusStoreService;
import dev.galasa.framework.internal.ras.FrameworkMultipleResultArchiveStore;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.Api;
import dev.galasa.framework.spi.ConfidentialTextException;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.EventsException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.FrameworkResourcePoolingService;
import dev.galasa.framework.spi.ICertificateStoreService;
import dev.galasa.framework.spi.IConfidentialTextService;
import dev.galasa.framework.spi.IConfigurationPropertyStore;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStore;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IEventsService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IFrameworkRuns;
import dev.galasa.framework.spi.IResourcePoolingService;
import dev.galasa.framework.spi.IResultArchiveStore;
import dev.galasa.framework.spi.IResultArchiveStoreService;
import dev.galasa.framework.spi.IRun;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.SharedEnvironmentRunType;
import dev.galasa.framework.spi.auth.AuthStoreException;
import dev.galasa.framework.spi.auth.IAuthStore;
import dev.galasa.framework.spi.auth.IAuthStoreService;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.framework.spi.creds.ICredentialsService;
import dev.galasa.framework.spi.creds.ICredentialsStore;
import java.net.URL;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.ServiceScope;

@Component(immediate=true, scope=ServiceScope.SINGLETON)
public class Framework
implements IFramework {
    private static final Log logger = LogFactory.getLog(Framework.class);
    private static final Pattern namespacePattern = Pattern.compile("[a-z0-9]+");
    private static final String ERROR_MESSAGE_TEMPLATE_NAMESPACE_INVALID_CHARACTERS = "Invalid namespace '%s'. Valid namespaces are 1 or more characters of 'a'-'z' and '0'-'9'.";
    private Properties overrideProperties;
    private final Properties recordProperties = new Properties();
    private IConfigurationPropertyStore cpsStore;
    private IDynamicStatusStore dssStore;
    private IResultArchiveStoreService rasService;
    private IConfidentialTextService ctsService;
    private ICredentialsStore credsStore;
    private IEventsService eventsService;
    private IAuthStore authStore;
    private IConfigurationPropertyStoreService cpsFramework;
    private ICredentialsService credsFramework;
    private String runName;
    private final Random random = new Random();
    private FrameworkRuns frameworkRuns;
    private TestRunLogCapture testRunLogCapture;
    private IRun run;

    @Activate
    public void activate(BundleContext bundleContext) {
        logger.info((Object)"Framework service activated");
        logger.info((Object)("Framework version = " + FrameworkVersion.getBundleVersion()));
        logger.info((Object)("Framework build   = " + FrameworkVersion.getBundleBuild()));
        try {
            bundleContext.addServiceListener((ServiceListener)new ManagerServiceListener(), "(objectClass=dev.galasa.framework.spi.IManager)");
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)"Unable to add ManagerServiceListener", (Throwable)e);
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.testRunLogCapture != null) {
            this.testRunLogCapture.shutdown();
        }
        logger.info((Object)"Framework service deactivated");
    }

    @Override
    public void setFrameworkProperties(Properties overridesProperties) {
        this.overrideProperties = overridesProperties;
    }

    @Override
    public boolean isInitialised() {
        return this.cpsStore != null && this.dssStore != null && this.rasService != null && this.ctsService != null && this.credsStore != null;
    }

    public boolean isShutdown() {
        return this.cpsStore == null && this.dssStore == null && this.rasService == null && this.ctsService == null && this.credsStore == null;
    }

    @Override
    @NotNull
    public IConfigurationPropertyStoreService getConfigurationPropertyService(@NotNull String namespace) throws ConfigurationPropertyStoreException {
        if (this.cpsStore == null) {
            throw new ConfigurationPropertyStoreException("The Configuration Property Store has not been initialised");
        }
        try {
            this.validateNamespace(namespace);
        }
        catch (FrameworkException e) {
            throw new ConfigurationPropertyStoreException("Unable to provide Configuration Property Store", (Throwable)e);
        }
        return new FrameworkConfigurationPropertyService(this, this.cpsStore, this.overrideProperties, this.recordProperties, namespace);
    }

    @Override
    @NotNull
    public IDynamicStatusStoreService getDynamicStatusStoreService(@NotNull String namespace) throws DynamicStatusStoreException {
        if (this.dssStore == null) {
            throw new DynamicStatusStoreException("The Dynamic Status Store has not been initialised");
        }
        try {
            this.validateNamespace(namespace);
        }
        catch (FrameworkException e) {
            throw new DynamicStatusStoreException("Unable to provide Dynamic Status Store", (Throwable)e);
        }
        return new FrameworkDynamicStatusStoreService(this, this.dssStore, namespace);
    }

    private void validateNamespace(String namespace) throws FrameworkException {
        if (namespace == null) {
            throw new FrameworkException("Namespace has not been provided");
        }
        Matcher matcher = namespacePattern.matcher(namespace);
        if (!matcher.matches()) {
            throw new FrameworkException(String.format(ERROR_MESSAGE_TEMPLATE_NAMESPACE_INVALID_CHARACTERS, namespace));
        }
    }

    @Override
    @NotNull
    public IResultArchiveStore getResultArchiveStore() {
        return this.rasService;
    }

    protected IResultArchiveStoreService getResultArchiveStoreService() {
        return this.rasService;
    }

    @Override
    @NotNull
    public IResourcePoolingService getResourcePoolingService() {
        return new FrameworkResourcePoolingService();
    }

    @Override
    @NotNull
    public IConfidentialTextService getConfidentialTextService() {
        return this.ctsService;
    }

    @Override
    @NotNull
    public ICredentialsService getCredentialsService() throws CredentialsException {
        if (this.credsStore == null) {
            throw new CredentialsException("The Credentials Store has not been initialised");
        }
        return new FrameworkCredentialsService(this, this.credsStore);
    }

    @Override
    public IEventsService getEventsService() {
        return this.eventsService;
    }

    protected void setConfigurationPropertyStore(@NotNull IConfigurationPropertyStore cpsStore) throws ConfigurationPropertyStoreException {
        if (this.cpsStore != null) {
            throw new ConfigurationPropertyStoreException("Invalid 2nd registration of the Config Property Store Service detected");
        }
        this.cpsStore = cpsStore;
        this.cpsFramework = this.getConfigurationPropertyService("framework");
    }

    public void setDynamicStatusStore(@NotNull IDynamicStatusStore dssStore) throws DynamicStatusStoreException {
        if (this.dssStore != null) {
            throw new DynamicStatusStoreException("Invalid 2nd registration of the Dynamic Status Store Service detected");
        }
        this.dssStore = dssStore;
    }

    public void setAuthStore(@NotNull IAuthStore authStore) throws AuthStoreException {
        if (this.authStore != null) {
            throw new AuthStoreException("Invalid second registration of the Auth Store Service detected");
        }
        this.authStore = authStore;
    }

    public void addResultArchiveStoreService(@NotNull IResultArchiveStoreService resultArchiveStoreService) throws ResultArchiveStoreException {
        if (this.rasService == null) {
            this.rasService = resultArchiveStoreService;
            return;
        }
        if (this.rasService instanceof FrameworkMultipleResultArchiveStore) {
            ((FrameworkMultipleResultArchiveStore)this.rasService).addResultArchiveStoreService(resultArchiveStoreService);
            return;
        }
        this.rasService = new FrameworkMultipleResultArchiveStore(this, this.rasService);
        ((FrameworkMultipleResultArchiveStore)this.rasService).addResultArchiveStoreService(resultArchiveStoreService);
    }

    public void setEventsService(@NotNull IEventsService eventsService) throws EventsException {
        if (this.eventsService != null) {
            throw new EventsException("Invalid 2nd registration of the Events Service detected");
        }
        this.eventsService = eventsService;
    }

    public void setConfidentialTextService(@NotNull IConfidentialTextService confidentialTextService) throws ConfidentialTextException {
        if (this.ctsService != null) {
            throw new ConfidentialTextException("Invalid 2nd registration of the Confidential Text Service detected");
        }
        this.ctsService = confidentialTextService;
    }

    public void setCredentialsStore(@NotNull ICredentialsStore credsStore) throws CredentialsException {
        if (this.credsStore != null) {
            throw new CredentialsException("Invalid 2nd registration of the Credentials Store Service detected");
        }
        this.credsStore = credsStore;
    }

    protected IConfigurationPropertyStore getConfigurationPropertyStore() {
        return this.cpsStore;
    }

    protected IDynamicStatusStore getDynamicStatusStore() {
        return this.dssStore;
    }

    protected ICredentialsStore getCredentialsStore() {
        return this.credsStore;
    }

    @Override
    public IAuthStore getAuthStore() {
        return this.authStore;
    }

    @Override
    public IAuthStoreService getAuthStoreService() {
        return new FrameworkAuthStoreService(this.authStore);
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public String getTestRunName() {
        return this.runName;
    }

    public void setTestRunName(String runName) throws FrameworkException {
        this.runName = runName;
        this.run = this.getFrameworkRuns().getRun(runName);
    }

    @Override
    public IRun getTestRun() {
        return this.run;
    }

    @Override
    public IFrameworkRuns getFrameworkRuns() throws FrameworkException {
        if (this.frameworkRuns == null) {
            this.frameworkRuns = new FrameworkRuns(this);
        }
        return this.frameworkRuns;
    }

    @Override
    public Properties getRecordProperties() {
        Properties clone = (Properties)this.recordProperties.clone();
        return clone;
    }

    public void installLogCapture() {
        if (this.testRunLogCapture != null) {
            return;
        }
        this.testRunLogCapture = new TestRunLogCapture(this);
    }

    public void shutdown(Log shutdownLogger) throws FrameworkException {
        if (this.isShutdown()) {
            return;
        }
        if (shutdownLogger == null) {
            shutdownLogger = logger;
        }
        boolean error = false;
        shutdownLogger.info((Object)"Shutting down the framework");
        if (this.eventsService != null) {
            try {
                shutdownLogger.trace((Object)"Shutting down the Events Service");
                this.eventsService.shutdown();
                this.eventsService = null;
            }
            catch (Throwable t) {
                error = true;
                shutdownLogger.error((Object)"Failed to shutdown the Events Service", t);
            }
        }
        if (this.ctsService != null) {
            try {
                shutdownLogger.trace((Object)"Shutting down the Confidential Text Service");
                this.ctsService.shutdown();
                this.ctsService = null;
            }
            catch (Throwable t) {
                error = true;
                shutdownLogger.error((Object)"Failed to shutdown the Confidential Text Service", t);
            }
        }
        if (this.credsStore != null) {
            try {
                shutdownLogger.trace((Object)"Shutting down the Credentials Service");
                this.credsStore.shutdown();
                this.credsStore = null;
            }
            catch (Throwable t) {
                error = true;
                shutdownLogger.error((Object)"Failed to shutdown the Credentials Service", t);
            }
        }
        if (this.rasService != null) {
            try {
                shutdownLogger.trace((Object)"Shutting down the Result Archive Store");
                this.rasService.shutdown();
                this.rasService = null;
            }
            catch (Throwable t) {
                error = true;
                shutdownLogger.error((Object)"Failed to shutdown the Result Archive Store", t);
            }
        }
        if (this.dssStore != null) {
            try {
                shutdownLogger.trace((Object)"Shutting down the Dynamic Status Store");
                this.dssStore.shutdown();
                this.dssStore = null;
            }
            catch (Throwable t) {
                error = true;
                shutdownLogger.error((Object)"Failed to shutdown the Dynamic Status Store", t);
            }
        }
        if (this.cpsStore != null) {
            try {
                shutdownLogger.trace((Object)"Shutting down the Configuration Properties Store");
                this.cpsStore.shutdown();
                this.cpsStore = null;
            }
            catch (Throwable t) {
                error = true;
                shutdownLogger.error((Object)"Failed to shutdown the Configuration Property Store", t);
            }
        }
        if (error) {
            throw new FrameworkException("Shutdown did not complete successfully, see log");
        }
        shutdownLogger.info((Object)"Framework shutdown");
    }

    @Override
    public URL getApiUrl(Api api) throws FrameworkException {
        if (api == null) {
            throw new FrameworkException("api has not been provided");
        }
        try {
            Object urlProperty = AbstractManager.nulled(this.cpsFramework.getProperty(api.getProperty(), "url", new String[0]));
            if (urlProperty != null) {
                return new URL((String)urlProperty);
            }
            String bootstrapProperty = AbstractManager.nulled(this.cpsFramework.getProperty("bootstrap", "url", new String[0]));
            if (bootstrapProperty == null) {
                throw new FrameworkException("Unable to derive the URL for api " + api + " as the framework.bootstrap.url property is missing");
            }
            if (!bootstrapProperty.endsWith("/bootstrap")) {
                throw new FrameworkException("Unable to derive the URL for api " + api + " as the framework.bootstrap.url property does not end with /bootstrap");
            }
            urlProperty = bootstrapProperty.substring(0, bootstrapProperty.length() - 10) + "/" + api.getSuffix();
            return new URL((String)urlProperty);
        }
        catch (Exception e) {
            throw new FrameworkException("Unable to determine URL of API " + api, (Throwable)e);
        }
    }

    @Override
    public SharedEnvironmentRunType getSharedEnvironmentRunType() throws ConfigurationPropertyStoreException {
        String sePhase = AbstractManager.nulled(this.cpsFramework.getProperty("run", "shared.environment.phase", new String[0]));
        if (sePhase == null) {
            return null;
        }
        switch (sePhase) {
            case "BUILD": {
                return SharedEnvironmentRunType.BUILD;
            }
            case "DISCARD": {
                return SharedEnvironmentRunType.DISCARD;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public ICertificateStoreService getCertificateStoreService() {
        return null;
    }
}

