/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.RunImpl;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IFrameworkRuns;
import dev.galasa.framework.spi.IRun;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FrameworkRuns
implements IFrameworkRuns {
    private static final Log logger = LogFactory.getLog(FrameworkRuns.class);
    private final Pattern runPattern = Pattern.compile("^\\Qrun.\\E(\\w+)\\Q.\\E.*$");
    private final IFramework framework;
    private final IDynamicStatusStoreService dss;
    private final IConfigurationPropertyStoreService cps;
    private final String NO_GROUP = "none";
    private final String NO_BUNDLE = "none";
    private final String NO_RUNTYPE = "UNKNOWN";
    private final String RUN_PREFIX = "run.";

    public FrameworkRuns(IFramework framework) throws FrameworkException {
        this.framework = framework;
        this.dss = framework.getDynamicStatusStoreService("framework");
        this.cps = framework.getConfigurationPropertyService("framework");
    }

    @Override
    public List<IRun> getActiveRuns() throws FrameworkException {
        List<IRun> runs = this.getAllRuns();
        Iterator<IRun> iruns = runs.iterator();
        while (iruns.hasNext()) {
            IRun run = iruns.next();
            if (run.getHeartbeat() != null || "allocated".equals(run.getStatus()) || run.isSharedEnvironment()) continue;
            iruns.remove();
        }
        return runs;
    }

    @Override
    @NotNull
    public List<IRun> getQueuedRuns() throws FrameworkException {
        List<IRun> runs = this.getAllRuns();
        Iterator<IRun> iruns = runs.iterator();
        while (iruns.hasNext()) {
            IRun run = iruns.next();
            if ("queued".equals(run.getStatus())) continue;
            iruns.remove();
        }
        return runs;
    }

    @Override
    public List<IRun> getAllRuns() throws FrameworkException {
        HashMap<String, RunImpl> runs = new HashMap<String, RunImpl>();
        logger.trace((Object)"Fetching all runs from DSS");
        Map<String, String> runProperties = this.dss.getPrefix("run.");
        logger.trace((Object)"Fetched all runs from DSS");
        for (String key : runProperties.keySet()) {
            String runName;
            Matcher matcher = this.runPattern.matcher(key);
            if (!matcher.find() || runs.containsKey(runName = matcher.group(1))) continue;
            runs.put(runName, new RunImpl(runName, this.dss));
        }
        LinkedList<IRun> returnRuns = new LinkedList<IRun>(runs.values());
        return returnRuns;
    }

    @Override
    public List<IRun> getAllGroupedRuns(@NotNull String groupName) throws FrameworkException {
        List<IRun> allRuns = this.getAllRuns();
        LinkedList<IRun> groupedRuns = new LinkedList<IRun>();
        for (IRun run : allRuns) {
            if (!groupName.equals(run.getGroup())) continue;
            groupedRuns.add(run);
        }
        return groupedRuns;
    }

    @Override
    @NotNull
    public Set<String> getActiveRunNames() throws FrameworkException {
        List<IRun> runs = this.getActiveRuns();
        HashSet<String> runNames = new HashSet<String>();
        for (IRun run : runs) {
            runNames.add(run.getName());
        }
        return runNames;
    }

    @Override
    @NotNull.List(value={@NotNull, @NotNull})
    public @NotNull.List(value={@NotNull, @NotNull}) IRun submitRun(String runType, String requestor, String bundleName, @NotNull String testName, String groupName, String mavenRepository, String obr, String stream, boolean local, boolean trace, Properties overrides, IFrameworkRuns.SharedEnvironmentPhase sharedEnvironmentPhase, String sharedEnvironmentRunName, String language) throws FrameworkException {
        if (testName == null) {
            throw new FrameworkException("Missing test name");
        }
        String bundleTest = null;
        if (language == null) {
            language = "java";
        }
        if (language.equals("java")) {
            if (bundleName == null) {
                throw new FrameworkException("Missing bundle name");
            }
            bundleTest = bundleName + "/" + testName;
        }
        if ((groupName = AbstractManager.nulled(groupName)) == null) {
            groupName = "none";
        }
        if ((runType = AbstractManager.nulled(runType)) == null) {
            runType = "UNKNOWN";
        }
        runType = runType.toUpperCase();
        if ((requestor = AbstractManager.nulled(requestor)) == null && (requestor = AbstractManager.nulled(this.cps.getProperty("run", "requestor", new String[0]))) == null) {
            requestor = "unknown";
        }
        stream = AbstractManager.nulled(stream);
        String runName = null;
        if (sharedEnvironmentPhase != null && sharedEnvironmentPhase == IFrameworkRuns.SharedEnvironmentPhase.BUILD) {
            if (sharedEnvironmentRunName == null || sharedEnvironmentRunName.trim().isEmpty()) {
                throw new FrameworkException("Missing run name for shared environment");
            }
            if (!this.storeRun(sharedEnvironmentRunName = sharedEnvironmentRunName.trim().toUpperCase(), bundleTest, bundleName, testName, runType, trace, local, mavenRepository, obr, stream, groupName, requestor, overrides, sharedEnvironmentPhase, language)) {
                throw new FrameworkException("Unable to submit shared environment run " + sharedEnvironmentRunName + ", is there a duplicate runname?");
            }
            return new RunImpl(sharedEnvironmentRunName, this.dss);
        }
        if (sharedEnvironmentPhase != null && sharedEnvironmentPhase == IFrameworkRuns.SharedEnvironmentPhase.DISCARD) {
            if (sharedEnvironmentRunName == null || sharedEnvironmentRunName.trim().isEmpty()) {
                throw new FrameworkException("Missing run name for shared environment");
            }
            RunImpl run = new RunImpl(sharedEnvironmentRunName = sharedEnvironmentRunName.trim().toUpperCase(), this.dss);
            if (!run.isSharedEnvironment()) {
                throw new FrameworkException("Run " + sharedEnvironmentRunName + " is not a shared environment");
            }
            if (!"UP".equalsIgnoreCase(run.getStatus())) {
                throw new FrameworkException("Shared Environment " + sharedEnvironmentRunName + " is not up and running");
            }
            HashMap<String, String> otherProperties = new HashMap<String, String>();
            otherProperties.put("run." + sharedEnvironmentRunName + ".override.framework.run.shared.environment.phase", sharedEnvironmentPhase.toString());
            if (groupName != null) {
                otherProperties.put("run." + sharedEnvironmentRunName + ".group", groupName);
            }
            if (!this.dss.putSwap("run." + sharedEnvironmentRunName + ".status", "up", "queued", otherProperties)) {
                throw new FrameworkException("Failed to switch Shared Environment " + sharedEnvironmentRunName + " to discard");
            }
            return new RunImpl(sharedEnvironmentRunName, this.dss);
        }
        String typePrefix = AbstractManager.nulled(this.cps.getProperty("request.type." + runType, "prefix", new String[0]));
        if (typePrefix == null) {
            typePrefix = "local".equals(runType) ? "L" : "U";
        }
        int maxNumber = Integer.MAX_VALUE;
        String sMaxNumber = AbstractManager.nulled(this.cps.getProperty("request.prefix", "maximum", typePrefix));
        if (sMaxNumber != null) {
            maxNumber = Integer.parseInt(sMaxNumber);
        }
        try {
            boolean maxlooped = false;
            while (runName == null) {
                String sNewNumber;
                String pLastused = "request.prefix." + typePrefix + ".lastused";
                String sLatestNumber = this.dss.get(pLastused);
                int latestNumber = 0;
                if (sLatestNumber != null && !sLatestNumber.trim().isEmpty()) {
                    latestNumber = Integer.parseInt(sLatestNumber);
                }
                if (++latestNumber > maxNumber) {
                    if (maxlooped) {
                        throw new FrameworkException("Not enough request type numbers available, looped twice");
                    }
                    latestNumber = 1;
                    maxlooped = true;
                }
                if (!this.dss.putSwap(pLastused, sLatestNumber, sNewNumber = Integer.toString(latestNumber))) {
                    Thread.sleep(this.framework.getRandom().nextInt(200));
                    continue;
                }
                String tempRunName = typePrefix + sNewNumber;
                if (!this.storeRun(tempRunName, bundleTest, bundleName, testName, runType, trace, local, mavenRepository, obr, stream, groupName, requestor, overrides, null, language)) {
                    Thread.sleep(this.framework.getRandom().nextInt(200));
                    continue;
                }
                runName = tempRunName;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FrameworkException("Interrupted", (Throwable)e);
        }
        catch (Exception e) {
            throw new FrameworkException("Problem submitting job", (Throwable)e);
        }
        return new RunImpl(runName, this.dss);
    }

    private boolean storeRun(String runName, String bundleTest, String bundleName, String testName, String runType, boolean trace, boolean local, String mavenRepository, String obr, String stream, String groupName, String requestor, Properties overrides, IFrameworkRuns.SharedEnvironmentPhase sharedEnvironmentPhase, String language) throws DynamicStatusStoreException {
        if (overrides == null) {
            overrides = new Properties();
        }
        String gherkinTest = null;
        if (language.equals("gherkin")) {
            bundleTest = "none";
            gherkinTest = testName;
            bundleName = "none";
        }
        HashMap<String, String> otherRunProperties = new HashMap<String, String>();
        otherRunProperties.put("run." + runName + ".status", "queued");
        otherRunProperties.put("run." + runName + ".queued", Instant.now().toString());
        otherRunProperties.put("run." + runName + ".testbundle", bundleName);
        otherRunProperties.put("run." + runName + ".testclass", testName);
        otherRunProperties.put("run." + runName + ".request.type", runType);
        otherRunProperties.put("run." + runName + ".local", Boolean.toString(local));
        if (trace) {
            otherRunProperties.put("run." + runName + ".trace", "true");
        }
        if (mavenRepository != null) {
            otherRunProperties.put("run." + runName + ".repository", mavenRepository);
        }
        if (obr != null) {
            otherRunProperties.put("run." + runName + ".obr", obr);
        }
        if (stream != null) {
            otherRunProperties.put("run." + runName + ".stream", stream);
        }
        if (groupName != null) {
            otherRunProperties.put("run." + runName + ".group", groupName);
        } else {
            otherRunProperties.put("run." + runName + ".group", UUID.randomUUID().toString());
        }
        otherRunProperties.put("run." + runName + ".requestor", requestor.toLowerCase());
        if (sharedEnvironmentPhase != null) {
            otherRunProperties.put("run." + runName + ".shared.environment", "true");
            overrides.put("framework.run.shared.environment.phase", sharedEnvironmentPhase.toString());
        }
        if (gherkinTest != null) {
            otherRunProperties.put("run." + runName + ".gherkin", gherkinTest);
        }
        if (overrides != null) {
            for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                otherRunProperties.put("run." + runName + ".override." + key, value);
            }
        }
        return this.dss.putSwap("run." + runName + ".test", null, bundleTest, otherRunProperties);
    }

    @Override
    public boolean delete(String runname) throws DynamicStatusStoreException {
        String prefix = "run." + runname + ".";
        Map<String, String> properties = this.dss.getPrefix(prefix);
        if (properties.isEmpty()) {
            return false;
        }
        this.dss.deletePrefix(prefix);
        return true;
    }

    @Override
    public boolean reset(String runname) throws DynamicStatusStoreException {
        String prefix = "run." + runname + ".";
        Map<String, String> properties = this.dss.getPrefix(prefix);
        if (properties.isEmpty()) {
            return false;
        }
        if ("true".equals(properties.get(prefix + "local"))) {
            return false;
        }
        this.dss.delete(prefix + "heartbeat");
        this.dss.put(prefix + "status", "queued");
        return true;
    }

    @Override
    public IRun getRun(String runname) throws DynamicStatusStoreException {
        String prefix = "run." + runname + ".";
        Map<String, String> properties = this.dss.getPrefix(prefix);
        if (properties.isEmpty()) {
            return null;
        }
        return new RunImpl(runname, this.dss);
    }
}

