/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.TestClassWrapper;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.TestRunManagers;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.language.GalasaMethod;
import dev.galasa.framework.spi.teststructure.TestMethod;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericMethodWrapper {
    public static final String LOG_METHOD_BEFORE_CLASS = " type=BeforeClass";
    public static final String LOG_METHOD_BEFORE = " type=Before";
    public static final String LOG_METHOD_TEST = " type=Test";
    public static final String LOG_METHOD_AFTER = " type=After";
    public static final String LOG_METHOD_AFTER_CLASS = " type=AfterClass";
    private Log logger = LogFactory.getLog(GenericMethodWrapper.class);
    private Method excecutionMethod;
    private Class<?> testClass;
    private Type type;
    private Result result;
    private TestMethod testStructureMethod;

    public GenericMethodWrapper(Method excecutionMethod, Class<?> testClass, Type type) {
        this.excecutionMethod = excecutionMethod;
        this.testClass = testClass;
        this.type = type;
    }

    public void invoke(@NotNull TestRunManagers managers, Object testClassObject, GenericMethodWrapper testMethod) throws TestRunException {
        try {
            String methodType = ",type=" + this.type.toString();
            Result ignored = managers.anyReasonTestMethodShouldBeIgnored(new GalasaMethod(this.excecutionMethod, null));
            if (ignored != null) {
                this.logger.info((Object)("Starting" + TestClassWrapper.LOG_START_LINE + TestClassWrapper.LOG_ASTERS + TestClassWrapper.LOG_START_LINE + "*** Ignoring test method " + this.testClass.getName() + "#" + this.excecutionMethod.getName() + methodType + TestClassWrapper.LOG_START_LINE + TestClassWrapper.LOG_ASTERS));
                this.logger.info((Object)("Ignoring " + this.excecutionMethod.getName() + " due to " + ignored.getReason()));
                this.result = ignored;
                this.testStructureMethod.setResult(this.result.getName());
                return;
            }
            managers.fillAnnotatedFields(testClassObject);
            managers.startOfTestMethod(new GalasaMethod(this.excecutionMethod, testMethod != null ? testMethod.excecutionMethod : null));
            this.logger.info((Object)("Starting" + TestClassWrapper.LOG_START_LINE + TestClassWrapper.LOG_ASTERS + TestClassWrapper.LOG_START_LINE + "*** Start of test method " + this.testClass.getName() + "#" + this.excecutionMethod.getName() + methodType + TestClassWrapper.LOG_START_LINE + TestClassWrapper.LOG_ASTERS));
            this.testStructureMethod.setStartTime(Instant.now());
            this.testStructureMethod.setStatus("started");
            try {
                this.excecutionMethod.invoke(testClassObject, new Object[0]);
                this.result = Result.passed();
            }
            catch (InvocationTargetException e) {
                this.result = Result.failed(e.getCause());
            }
            catch (Throwable e) {
                this.result = Result.failed(e);
            }
            Result overrideResult = managers.endOfTestMethod(new GalasaMethod(this.excecutionMethod, null), this.result, this.result.getThrowable());
            if (overrideResult != null) {
                this.result = overrideResult;
            }
            this.testStructureMethod.setResult(this.result.getName());
            if (this.result.getThrowable() != null) {
                Throwable t = this.getResult().getThrowable();
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    this.testStructureMethod.setException(sw.toString());
                }
                catch (Exception e) {
                    this.testStructureMethod.setException("Unable to report exception because of " + e.getMessage());
                }
            }
            if (this.result.isPassed()) {
                String resname = this.result.getName();
                if (this.type != Type.Test) {
                    resname = "Ok";
                }
                this.logger.info((Object)("Ending" + TestClassWrapper.LOG_START_LINE + TestClassWrapper.LOG_ASTERS + TestClassWrapper.LOG_START_LINE + "*** " + resname + " - Test method " + this.testClass.getName() + "#" + this.excecutionMethod.getName() + methodType + TestClassWrapper.LOG_START_LINE + TestClassWrapper.LOG_ASTERS));
            } else {
                Object exception = "";
                if (this.testStructureMethod.getException() != null) {
                    exception = "\n" + this.testStructureMethod.getException();
                }
                this.logger.info((Object)("Ending" + TestClassWrapper.LOG_START_LINE + TestClassWrapper.LOG_ASTERS + TestClassWrapper.LOG_START_LINE + "*** " + this.result.getName() + " - Test method " + this.testClass.getName() + "#" + this.excecutionMethod.getName() + methodType + TestClassWrapper.LOG_START_LINE + TestClassWrapper.LOG_ASTERS + (String)exception));
            }
            this.testStructureMethod.setEndTime(Instant.now());
            this.testStructureMethod.setStatus("finished");
        }
        catch (FrameworkException e) {
            throw new TestRunException("There was a problem with the framework, please check stacktrace", e);
        }
    }

    public boolean fullStop() {
        return this.result.isFailed();
    }

    public Result getResult() {
        return this.result;
    }

    public TestMethod getStructure() {
        this.testStructureMethod = new TestMethod(this.testClass);
        this.testStructureMethod.setMethodName(this.excecutionMethod.getName());
        this.testStructureMethod.setType(this.type.toString());
        return this.testStructureMethod;
    }

    public String getName() {
        return this.excecutionMethod.getName();
    }

    public static enum Type {
        BeforeClass,
        AfterClass,
        Before,
        After,
        Test;

    }
}

