/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.ResultArchiveStoreContentType;
import dev.galasa.framework.BundleManagement;
import dev.galasa.framework.FrameworkInitialisation;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.TestRunHeartbeat;
import dev.galasa.framework.TestRunLifecycleStatus;
import dev.galasa.framework.TestRunManagers;
import dev.galasa.framework.maven.repository.spi.IMavenRepository;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.FrameworkResourceUnavailableException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IGherkinExecutable;
import dev.galasa.framework.spi.IResultArchiveStore;
import dev.galasa.framework.spi.IRun;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.language.GalasaTest;
import dev.galasa.framework.spi.language.gherkin.GherkinMethod;
import dev.galasa.framework.spi.language.gherkin.GherkinTest;
import dev.galasa.framework.spi.teststructure.TestStructure;
import dev.galasa.framework.spi.utils.DssUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={GherkinTestRunner.class})
public class GherkinTestRunner {
    private Log logger = LogFactory.getLog(GherkinTestRunner.class);
    private BundleContext bundleContext;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private RepositoryAdmin repositoryAdmin;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private IMavenRepository mavenRepository;
    private TestRunHeartbeat heartbeat;
    private IConfigurationPropertyStoreService cps;
    private IDynamicStatusStoreService dss;
    private IResultArchiveStore ras;
    private IRun run;
    private TestStructure testStructure = new TestStructure();
    private GherkinTest gherkinTest;
    private boolean runOk = true;
    private boolean resourcesUnavailable = false;

    public void runTest(Properties bootstrapProperties, Properties overrideProperties) throws TestRunException {
        String overrideOBR;
        String overrideRepo;
        FrameworkInitialisation frameworkInitialisation = null;
        try {
            frameworkInitialisation = new FrameworkInitialisation(bootstrapProperties, overrideProperties, true);
            this.cps = frameworkInitialisation.getFramework().getConfigurationPropertyService("framework");
            this.dss = frameworkInitialisation.getFramework().getDynamicStatusStoreService("framework");
            this.run = frameworkInitialisation.getFramework().getTestRun();
            this.ras = frameworkInitialisation.getFramework().getResultArchiveStore();
        }
        catch (Exception e) {
            throw new TestRunException("Unable to initialise the Framework Services", e);
        }
        IRun run = frameworkInitialisation.getFramework().getTestRun();
        if (run == null) {
            throw new TestRunException("Unable to locate run properties");
        }
        this.gherkinTest = new GherkinTest(run, this.testStructure);
        try {
            String prefix = this.getDSSKeyString("override.");
            Map<String, String> runOverrides = this.dss.getPrefix(prefix);
            for (Map.Entry<String, String> entry : runOverrides.entrySet()) {
                String key = entry.getKey().substring(prefix.length());
                String value = entry.getValue();
                overrideProperties.put(key, value);
            }
        }
        catch (Exception e) {
            throw new TestRunException("Problem loading overrides from the run properties", e);
        }
        String testRepository = null;
        String testOBR = null;
        String stream = AbstractManager.nulled(run.getStream());
        this.testStructure.setRunName(run.getName());
        this.testStructure.setTestName(this.gherkinTest.getName());
        this.testStructure.setQueued(run.getQueued());
        this.testStructure.setStartTime(Instant.now());
        this.testStructure.setRequestor(AbstractManager.defaultString(run.getRequestor(), "unknown"));
        this.writeTestStructure();
        if (stream != null) {
            this.logger.debug((Object)("Loading test stream " + stream));
            try {
                testRepository = this.cps.getProperty("test.stream", "repo", stream);
                testOBR = this.cps.getProperty("test.stream", "obr", stream);
                if (testRepository == null) {
                    testRepository = this.cps.getProperty("stream", "repo", stream);
                }
                if (testOBR == null) {
                    testOBR = this.cps.getProperty("stream", "obr", stream);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to load stream " + stream + " settings"), (Throwable)e);
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                frameworkInitialisation.shutdownFramework();
                return;
            }
        }
        if ((overrideRepo = AbstractManager.nulled(run.getRepository())) != null) {
            testRepository = overrideRepo;
        }
        if ((overrideOBR = AbstractManager.nulled(run.getOBR())) != null) {
            testOBR = overrideOBR;
        }
        if (testRepository != null) {
            this.logger.debug((Object)("Loading test maven repository " + testRepository));
            try {
                String[] repos;
                for (String repo : repos = testRepository.split("\\,")) {
                    if ((repo = repo.trim()).isEmpty()) continue;
                    this.mavenRepository.addRemoteRepository(new URL(repo));
                }
            }
            catch (MalformedURLException e) {
                this.logger.error((Object)("Unable to add remote maven repository " + testRepository), (Throwable)e);
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                frameworkInitialisation.shutdownFramework();
                return;
            }
        }
        if (testOBR != null) {
            this.logger.debug((Object)("Loading test obr repository " + testOBR));
            try {
                String[] testOBRs;
                for (String obr : testOBRs = testOBR.split("\\,")) {
                    if ((obr = obr.trim()).isEmpty()) continue;
                    this.repositoryAdmin.addRepository(obr);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to load specified OBR " + testOBR), (Throwable)e);
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                frameworkInitialisation.shutdownFramework();
                return;
            }
        }
        try {
            BundleManagement.loadAllGherkinManagerBundles(this.repositoryAdmin, this.bundleContext);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to load the managers obr", (Throwable)e);
            this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
            frameworkInitialisation.shutdownFramework();
            return;
        }
        if (this.gherkinTest.getName() == null || this.gherkinTest.getMethods().size() == 0) {
            throw new TestRunException("Feature file is invalid at URI: " + run.getGherkin());
        }
        this.logger.info((Object)("Run test: " + this.gherkinTest.getName()));
        try {
            this.heartbeat = new TestRunHeartbeat(frameworkInitialisation.getFramework());
            this.heartbeat.start();
        }
        catch (DynamicStatusStoreException e1) {
            frameworkInitialisation.shutdownFramework();
            throw new TestRunException("Unable to initialise the heartbeat");
        }
        if (run.isLocal()) {
            DssUtils.incrementMetric(this.dss, "metrics.runs.local");
        } else {
            DssUtils.incrementMetric(this.dss, "metrics.runs.automated");
        }
        this.updateStatus(TestRunLifecycleStatus.STARTED, "started");
        TestRunManagers managers = null;
        try {
            managers = new TestRunManagers(frameworkInitialisation.getFramework(), new GalasaTest(this.gherkinTest));
        }
        catch (FrameworkException e) {
            frameworkInitialisation.shutdownFramework();
            throw new TestRunException("Problem initialising the Managers for a test run", e);
        }
        if (!this.gherkinTest.allMethodsRegistered().booleanValue()) {
            this.logStatementsNotRecognisedByAnyManager(this.gherkinTest);
            this.stopHeartbeat();
            this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
            frameworkInitialisation.shutdownFramework();
            throw new TestRunException("Not all methods in test are registered to a Manager");
        }
        try {
            if (managers.anyReasonTestClassShouldBeIgnored()) {
                this.stopHeartbeat();
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                frameworkInitialisation.shutdownFramework();
                return;
            }
        }
        catch (FrameworkException e) {
            throw new TestRunException("Problem asking Managers for an ignore reason", e);
        }
        try {
            this.generateEnvironment(this.gherkinTest, managers);
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Error within test runner", (Throwable)e);
            this.runOk = false;
        }
        this.updateStatus(TestRunLifecycleStatus.ENDING, null);
        managers.endOfTestRun();
        boolean markedWaiting = false;
        if (this.resourcesUnavailable && !run.isLocal()) {
            this.markWaiting(frameworkInitialisation.getFramework());
            this.logger.info((Object)"Placing queue on the waiting list");
            markedWaiting = true;
        } else {
            this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
        }
        this.stopHeartbeat();
        this.recordCPSProperties(frameworkInitialisation);
        if (!markedWaiting) {
            this.deleteRunProperties(frameworkInitialisation.getFramework());
        }
        managers.shutdown();
        frameworkInitialisation.shutdownFramework();
    }

    private void logStatementsNotRecognisedByAnyManager(GherkinTest gherkinTest) {
        this.logger.error((Object)"The following Gherkin statements have not been registered to a Manager");
        for (GherkinMethod scenario : gherkinTest.getMethods()) {
            this.logger.info((Object)("    Scenario: " + scenario.getName()));
            for (IGherkinExecutable executable : scenario.getExecutables()) {
                Object owner = executable.getOwner();
                if (owner != null) {
                    this.logger.info((Object)("        OK - " + executable.getKeyword() + " " + executable.getValue()));
                    continue;
                }
                this.logger.error((Object)("        MISSING - " + executable.getKeyword() + " " + executable.getValue()));
            }
        }
    }

    private void generateEnvironment(GherkinTest testObject, TestRunManagers managers) throws TestRunException {
        if (!this.runOk) {
            return;
        }
        try {
            this.updateStatus(TestRunLifecycleStatus.GENERATING, null);
            this.logger.info((Object)"Starting Provision Generate phase");
            managers.provisionGenerate();
        }
        catch (Exception e) {
            this.logger.info((Object)"Provision Generate failed", (Throwable)e);
            if (e instanceof FrameworkResourceUnavailableException) {
                this.resourcesUnavailable = true;
            }
            testObject.setResult(Result.envfail(e));
            this.testStructure.setResult(testObject.getResult().getName());
            this.runOk = false;
            return;
        }
        this.createEnvironment(testObject, managers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEnvironment(GherkinTest testObject, TestRunManagers managers) throws TestRunException {
        if (!this.runOk) {
            return;
        }
        try {
            try {
                this.updateStatus(TestRunLifecycleStatus.BUILDING, null);
                this.logger.info((Object)"Starting Provision Build phase");
                managers.provisionBuild();
            }
            catch (FrameworkException e) {
                this.runOk = false;
                this.logger.error((Object)"Provision build failed", (Throwable)e);
                if (e instanceof FrameworkResourceUnavailableException) {
                    this.resourcesUnavailable = true;
                }
                testObject.setResult(Result.envfail(e));
                this.testStructure.setResult(testObject.getResult().getName());
                this.discardEnvironment(managers);
                return;
            }
            this.runEnvironment(testObject, managers);
        }
        finally {
            this.discardEnvironment(managers);
        }
    }

    private void discardEnvironment(TestRunManagers managers) {
        this.logger.info((Object)"Starting Provision Discard phase");
        managers.provisionDiscard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEnvironment(GherkinTest testObject, TestRunManagers managers) throws TestRunException {
        if (!this.runOk) {
            return;
        }
        try {
            try {
                this.updateStatus(TestRunLifecycleStatus.PROVSTART, null);
                this.logger.info((Object)"Starting Provision Start phase");
                managers.provisionStart();
            }
            catch (FrameworkException e) {
                this.runOk = false;
                this.logger.error((Object)"Provision start failed", (Throwable)e);
                if (e instanceof FrameworkResourceUnavailableException) {
                    this.resourcesUnavailable = true;
                }
                testObject.setResult(Result.envfail(e));
                this.testStructure.setResult(testObject.getResult().getName());
                this.stopEnvironment(managers);
                return;
            }
            this.runGherkinTest(testObject, managers);
        }
        finally {
            this.stopEnvironment(managers);
        }
    }

    private void stopEnvironment(TestRunManagers managers) {
        this.logger.info((Object)"Starting Provision Stop phase");
        managers.provisionStop();
    }

    private void runGherkinTest(GherkinTest testObject, TestRunManagers managers) throws TestRunException {
        if (!this.runOk) {
            return;
        }
        this.updateStatus(TestRunLifecycleStatus.RUNNING, null);
        try {
            this.logger.info((Object)"Running the test class");
            testObject.runTestMethods(managers);
        }
        finally {
            this.updateStatus(TestRunLifecycleStatus.RUNDONE, null);
        }
    }

    private void markWaiting(@NotNull IFramework framework) throws TestRunException {
        int initialDelay = 600;
        int randomDelay = 180;
        DssUtils.incrementMetric(this.dss, "metrics.runs.made.to.wait");
        try {
            String sInitialDelay = AbstractManager.nulled(this.cps.getProperty("waiting.initial", "delay", new String[0]));
            String sRandomDelay = AbstractManager.nulled(this.cps.getProperty("waiting.random", "delay", new String[0]));
            if (sInitialDelay != null) {
                initialDelay = Integer.parseInt(sInitialDelay);
            }
            if (sRandomDelay != null) {
                randomDelay = Integer.parseInt(sRandomDelay);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Problem reading delay properties", (Throwable)e);
        }
        int totalDelay = initialDelay + framework.getRandom().nextInt(randomDelay);
        this.logger.info((Object)("Placing this run on waiting for " + totalDelay + " seconds"));
        Instant until = Instant.now();
        until = until.plus((long)totalDelay, ChronoUnit.SECONDS);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(this.getDSSKeyString("status"), "waiting");
        properties.put(this.getDSSKeyString("wait.until"), until.toString());
        try {
            this.dss.put(properties);
        }
        catch (DynamicStatusStoreException e) {
            throw new TestRunException("Unable to place run in waiting state", e);
        }
    }

    private void updateStatus(TestRunLifecycleStatus status, String timestamp) throws TestRunException {
        Instant time = Instant.now();
        this.testStructure.setStatus(status.toString());
        if (status == TestRunLifecycleStatus.FINISHED) {
            this.updateResult();
            this.testStructure.setEndTime(time);
        }
        this.writeTestStructure();
        try {
            this.dss.put(this.getDSSKeyString("status"), status.toString());
            if (timestamp != null) {
                this.dss.put(this.getDSSKeyString(timestamp), time.toString());
            }
        }
        catch (DynamicStatusStoreException e) {
            throw new TestRunException("Failed to update status", e);
        }
    }

    private void updateResult() throws TestRunException {
        try {
            if (this.testStructure.getResult() == null) {
                this.testStructure.setResult("UNKNOWN");
            }
            this.dss.put(this.getDSSKeyString("result"), this.testStructure.getResult());
        }
        catch (DynamicStatusStoreException e) {
            throw new TestRunException("Failed to update result", e);
        }
    }

    private void stopHeartbeat() {
        if (this.heartbeat == null) {
            return;
        }
        this.heartbeat.shutdown();
        try {
            this.heartbeat.join(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dss.delete(this.getDSSKeyString("heartbeat"));
        }
        catch (DynamicStatusStoreException e) {
            this.logger.error((Object)"Unable to delete heartbeat", (Throwable)e);
        }
    }

    private void writeTestStructure() {
        try {
            this.ras.updateTestStructure(this.testStructure);
        }
        catch (ResultArchiveStoreException e) {
            this.logger.warn((Object)"Unable to write the test structure to the RAS", (Throwable)e);
        }
    }

    private void deleteRunProperties(@NotNull IFramework framework) {
        IRun run = framework.getTestRun();
        if (!run.isLocal()) {
            return;
        }
        try {
            framework.getFrameworkRuns().delete(run.getName());
        }
        catch (FrameworkException e) {
            this.logger.error((Object)"Failed to delete run properties");
        }
    }

    @Activate
    public void activate(BundleContext context) {
        this.bundleContext = context;
    }

    private void recordCPSProperties(FrameworkInitialisation frameworkInitialisation) {
        try {
            Properties record = frameworkInitialisation.getFramework().getRecordProperties();
            ArrayList<String> propertyNames = new ArrayList<String>();
            propertyNames.addAll(record.stringPropertyNames());
            Collections.sort(propertyNames);
            StringBuilder sb = new StringBuilder();
            String currentNamespace = null;
            for (String propertyName : propertyNames) {
                if ((propertyName = propertyName.trim()).isEmpty()) continue;
                String[] parts = propertyName.split("\\.");
                if (!parts[0].equals(currentNamespace)) {
                    if (currentNamespace != null) {
                        sb.append("\n");
                    }
                    currentNamespace = parts[0];
                }
                sb.append(propertyName);
                sb.append("=");
                sb.append(record.getProperty(propertyName));
                sb.append("\n");
            }
            IResultArchiveStore ras = frameworkInitialisation.getFramework().getResultArchiveStore();
            Path rasRoot = ras.getStoredArtifactsRoot();
            Path rasProperties = rasRoot.resolve("framework").resolve("cps_record.properties");
            Files.createFile(rasProperties, new FileAttribute[]{ResultArchiveStoreContentType.TEXT});
            Files.write(rasProperties, sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to save the recorded properties", (Throwable)e);
        }
    }

    private String getDSSKeyString(String keySuffix) {
        return "run." + this.run.getName() + "." + keySuffix;
    }
}

