/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.api.run.Run;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IRun;
import java.time.Instant;
import java.util.Map;

public class RunImpl
implements IRun {
    private final String name;
    private final Instant heartbeat;
    private final String type;
    private final String group;
    private final String test;
    private final String bundleName;
    private final String testName;
    private final String gherkin;
    private final String status;
    private final String result;
    private final Instant queued;
    private final Instant finished;
    private final Instant waitUntil;
    private final String requestor;
    private final String stream;
    private final String repo;
    private final String obr;
    private final boolean local;
    private final boolean trace;
    private final boolean sharedEnvironment;
    private final String rasRunId;

    public RunImpl(String name, IDynamicStatusStoreService dss) throws DynamicStatusStoreException {
        this.name = name;
        String prefix = "run." + name + ".";
        Map<String, String> runProperties = dss.getPrefix("run." + this.name);
        String sHeartbeat = runProperties.get(prefix + "heartbeat");
        this.heartbeat = sHeartbeat != null ? Instant.parse(sHeartbeat) : null;
        this.type = runProperties.get(prefix + "request.type");
        this.test = runProperties.get(prefix + "test");
        this.status = runProperties.get(prefix + "status");
        this.result = runProperties.get(prefix + "result");
        this.requestor = runProperties.get(prefix + "requestor");
        this.stream = runProperties.get(prefix + "stream");
        this.repo = runProperties.get(prefix + "repository");
        this.obr = runProperties.get(prefix + "obr");
        this.group = runProperties.get(prefix + "group");
        this.rasRunId = runProperties.get(prefix + "rasrunid");
        this.local = Boolean.parseBoolean(runProperties.get(prefix + "local"));
        this.trace = Boolean.parseBoolean(runProperties.get(prefix + "trace"));
        this.sharedEnvironment = Boolean.parseBoolean(runProperties.get(prefix + "shared.environment"));
        this.gherkin = runProperties.get(prefix + "gherkin");
        String sQueued = runProperties.get(prefix + "queued");
        this.queued = sQueued != null ? Instant.parse(sQueued) : ("queued".equals(this.status) ? Instant.now() : null);
        String sFinished = runProperties.get(prefix + "finished");
        this.finished = sFinished != null ? Instant.parse(sFinished) : null;
        String sWaitUntil = runProperties.get(prefix + "wait.until");
        this.waitUntil = sWaitUntil != null ? Instant.parse(sWaitUntil) : null;
        if (this.test != null) {
            if (this.gherkin != null) {
                this.bundleName = null;
                this.testName = null;
            } else {
                String[] split = this.test.split("/");
                this.bundleName = split[0];
                this.testName = split[1];
            }
        } else {
            this.bundleName = null;
            this.testName = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Instant getHeartbeat() {
        return this.heartbeat;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTest() {
        return this.test;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getRequestor() {
        return this.requestor;
    }

    @Override
    public String getStream() {
        return this.stream;
    }

    @Override
    public String getTestBundleName() {
        return this.bundleName;
    }

    @Override
    public String getTestClassName() {
        return this.testName;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public Instant getQueued() {
        return this.queued;
    }

    @Override
    public String getRepository() {
        return this.repo;
    }

    @Override
    public String getOBR() {
        return this.obr;
    }

    @Override
    public boolean isTrace() {
        return this.trace;
    }

    @Override
    public Instant getFinished() {
        return this.finished;
    }

    @Override
    public Instant getWaitUntil() {
        return this.waitUntil;
    }

    @Override
    public Run getSerializedRun() {
        return new Run(this.name, this.heartbeat, this.type, this.group, this.test, this.bundleName, this.testName, this.status, this.result, this.queued, this.finished, this.waitUntil, this.requestor, this.stream, this.repo, this.obr, this.local, this.trace, this.rasRunId);
    }

    @Override
    public String getResult() {
        return this.result;
    }

    @Override
    public boolean isSharedEnvironment() {
        return this.sharedEnvironment;
    }

    @Override
    public String getGherkin() {
        return this.gherkin;
    }

    public String getRasRunId() {
        return this.rasRunId;
    }
}

