/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.ResultArchiveStoreContentType;
import dev.galasa.SharedEnvironment;
import dev.galasa.Test;
import dev.galasa.framework.BundleManagement;
import dev.galasa.framework.FrameworkInitialisation;
import dev.galasa.framework.TestClassWrapper;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.TestRunHeartbeat;
import dev.galasa.framework.TestRunLifecycleStatus;
import dev.galasa.framework.TestRunManagers;
import dev.galasa.framework.maven.repository.spi.IMavenRepository;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.EventsException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.FrameworkResourceUnavailableException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.IResultArchiveStore;
import dev.galasa.framework.spi.IRun;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.SharedEnvironmentRunType;
import dev.galasa.framework.spi.events.TestHeartbeatStoppedEvent;
import dev.galasa.framework.spi.events.TestRunLifecycleStatusChangedEvent;
import dev.galasa.framework.spi.language.GalasaTest;
import dev.galasa.framework.spi.teststructure.TestStructure;
import dev.galasa.framework.spi.utils.DssUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={TestRunner.class})
public class TestRunner {
    private Log logger = LogFactory.getLog(TestRunner.class);
    private BundleContext bundleContext;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private RepositoryAdmin repositoryAdmin;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private IMavenRepository mavenRepository;
    private TestRunHeartbeat heartbeat;
    private IConfigurationPropertyStoreService cps;
    private IDynamicStatusStoreService dss;
    private IResultArchiveStore ras;
    private IRun run;
    private TestStructure testStructure = new TestStructure();
    private RunType runType;
    private boolean isRunOK = true;
    private boolean resourcesAvailable = true;
    private IFramework framework;
    private boolean produceEvents;

    public void runTest(Properties bootstrapProperties, Properties overrideProperties) throws TestRunException {
        TestClassWrapper testClassWrapper;
        Object msg;
        SharedEnvironment sharedEnvironmentAnnotation;
        Class<?> testClass;
        String testBundleName;
        IRun run;
        FrameworkInitialisation frameworkInitialisation;
        block76: {
            String overrideOBR;
            String overrideRepo;
            frameworkInitialisation = null;
            try {
                frameworkInitialisation = new FrameworkInitialisation(bootstrapProperties, overrideProperties, true);
                this.cps = frameworkInitialisation.getFramework().getConfigurationPropertyService("framework");
                this.dss = frameworkInitialisation.getFramework().getDynamicStatusStoreService("framework");
                this.run = frameworkInitialisation.getFramework().getTestRun();
                this.ras = frameworkInitialisation.getFramework().getResultArchiveStore();
            }
            catch (Exception e) {
                throw new TestRunException("Unable to initialise the Framework Services", e);
            }
            this.framework = frameworkInitialisation.getFramework();
            try {
                this.produceEvents = this.isProduceEventsFeatureFlagTrue();
            }
            catch (ConfigurationPropertyStoreException e) {
                throw new TestRunException("Problem reading the CPS property to check if framework event production has been activated.");
            }
            run = this.framework.getTestRun();
            if (run == null) {
                throw new TestRunException("Unable to locate run properties");
            }
            testBundleName = run.getTestBundleName();
            String testClassName = run.getTestClassName();
            try {
                String prefix = "run." + run.getName() + ".override.";
                Map<String, String> runOverrides = this.dss.getPrefix(prefix);
                for (Map.Entry<String, String> entry : runOverrides.entrySet()) {
                    String key = entry.getKey().substring(prefix.length());
                    String value = entry.getValue();
                    overrideProperties.put(key, value);
                }
            }
            catch (Exception e) {
                throw new TestRunException("Problem loading overrides from the run properties", e);
            }
            String testRepository = null;
            String testOBR = null;
            String stream = AbstractManager.nulled(run.getStream());
            this.testStructure.setRunName(run.getName());
            this.testStructure.setQueued(run.getQueued());
            this.testStructure.setStartTime(Instant.now());
            this.testStructure.setRequestor(AbstractManager.defaultString(run.getRequestor(), "unknown"));
            this.writeTestStructure();
            String rasRunId = this.ras.calculateRasRunId();
            try {
                this.dss.put("run." + run.getName() + ".rasrunid", rasRunId);
            }
            catch (DynamicStatusStoreException e) {
                throw new TestRunException("Failed to update rasrunid", e);
            }
            if (stream != null) {
                this.logger.debug((Object)("Loading test stream " + stream));
                try {
                    testRepository = this.cps.getProperty("test.stream", "repo", stream);
                    testOBR = this.cps.getProperty("test.stream", "obr", stream);
                    if (testRepository == null) {
                        testRepository = this.cps.getProperty("stream", "repo", stream);
                    }
                    if (testOBR == null) {
                        testOBR = this.cps.getProperty("stream", "obr", stream);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("Unable to load stream " + stream + " settings"), (Throwable)e);
                    this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                    frameworkInitialisation.shutdownFramework();
                    return;
                }
            }
            if ((overrideRepo = AbstractManager.nulled(run.getRepository())) != null) {
                testRepository = overrideRepo;
            }
            if ((overrideOBR = AbstractManager.nulled(run.getOBR())) != null) {
                testOBR = overrideOBR;
            }
            if (testRepository != null) {
                this.logger.debug((Object)("Loading test maven repository " + testRepository));
                try {
                    String[] repos;
                    for (String repo : repos = testRepository.split("\\,")) {
                        if ((repo = repo.trim()).isEmpty()) continue;
                        this.mavenRepository.addRemoteRepository(new URL(repo));
                    }
                }
                catch (MalformedURLException e) {
                    this.logger.error((Object)("Unable to add remote maven repository " + testRepository), (Throwable)e);
                    this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                    frameworkInitialisation.shutdownFramework();
                    return;
                }
            }
            if (testOBR != null) {
                this.logger.debug((Object)("Loading test obr repository " + testOBR));
                try {
                    String[] testOBRs;
                    for (String obr : testOBRs = testOBR.split("\\,")) {
                        if ((obr = obr.trim()).isEmpty()) continue;
                        this.repositoryAdmin.addRepository(obr);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("Unable to load specified OBR " + testOBR), (Throwable)e);
                    this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                    frameworkInitialisation.shutdownFramework();
                    return;
                }
            }
            try {
                BundleManagement.loadBundle(this.repositoryAdmin, this.bundleContext, testBundleName);
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to load the test bundle " + testBundleName), (Throwable)e);
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                frameworkInitialisation.shutdownFramework();
                return;
            }
            try {
                this.logger.debug((Object)("Loading test class... " + testClassName));
                testClass = this.getTestClass(testBundleName, testClassName);
                this.logger.debug((Object)("Test class " + testClassName + " loaded OK."));
            }
            catch (Throwable t) {
                this.logger.error((Object)("Problem locating test " + testBundleName + "/" + testClassName), t);
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                frameworkInitialisation.shutdownFramework();
                return;
            }
            this.logger.debug((Object)"Getting test annotations..");
            Test testAnnotation = testClass.getAnnotation(Test.class);
            this.logger.debug((Object)"Test annotations.. got");
            sharedEnvironmentAnnotation = testClass.getAnnotation(SharedEnvironment.class);
            this.logger.debug((Object)"Checking testAnnotation and sharedEnvironmentAnnotation");
            if (testAnnotation == null && sharedEnvironmentAnnotation == null) {
                this.logger.debug((Object)"Test annotation is null and it's not a shared environment. Throwing TestRunException...");
                throw new TestRunException("Class " + testBundleName + "/" + testClassName + " is not annotated with either the dev.galasa @Test or @SharedEnvironment annotations");
            }
            if (testAnnotation != null && sharedEnvironmentAnnotation != null) {
                this.logger.debug((Object)"Test annotation is non-null and shared environment annotation is non-null. Throwing TestRunException...");
                throw new TestRunException("Class " + testBundleName + "/" + testClassName + " is annotated with both the dev.galasa @Test and @SharedEnvironment annotations");
            }
            if (testAnnotation != null) {
                this.logger.info((Object)("Run test: " + testBundleName + "/" + testClassName));
                this.runType = RunType.TEST;
            } else {
                this.logger.info((Object)("Shared Environment class: " + testBundleName + "/" + testClassName));
            }
            if (sharedEnvironmentAnnotation != null) {
                try {
                    SharedEnvironmentRunType seType = this.framework.getSharedEnvironmentRunType();
                    if (seType != null) {
                        switch (seType) {
                            case BUILD: {
                                this.runType = RunType.SHARED_ENVIRONMENT_BUILD;
                                break;
                            }
                            case DISCARD: {
                                this.runType = RunType.SHARED_ENVIRONMENT_DISCARD;
                                break;
                            }
                            default: {
                                msg = "Unknown Shared Environment phase, '" + seType + "', needs to be BUILD or DISCARD";
                                this.logger.error(msg);
                                throw new TestRunException((String)msg);
                            }
                        }
                        break block76;
                    }
                    msg = "Unknown Shared Environment phase, needs to be BUILD or DISCARD";
                    this.logger.error(msg);
                    throw new TestRunException((String)msg);
                }
                catch (TestRunException e) {
                    msg = "TestRunException caught. " + e.getMessage() + " Re-throwing.";
                    this.logger.error(msg);
                    throw e;
                }
                catch (Exception e) {
                    msg = "Exception caught. " + e.getMessage() + " Re-throwing.";
                    this.logger.error(msg);
                    throw new TestRunException("Unable to determine the phase of the shared environment", e);
                }
            }
        }
        this.logger.debug((Object)("Test runType is " + this.runType.toString()));
        if (this.runType == RunType.TEST) {
            try {
                this.heartbeat = new TestRunHeartbeat(this.framework);
                this.logger.debug((Object)"starting heartbeat");
                this.heartbeat.start();
                this.logger.debug((Object)"heartbeat started ok");
            }
            catch (DynamicStatusStoreException e1) {
                msg = "DynamicStatusStoreException Exception caught. " + e1.getMessage() + " Shutting down and Re-throwing.";
                this.logger.error(msg);
                frameworkInitialisation.shutdownFramework();
                throw new TestRunException("Unable to initialise the heartbeat");
            }
            if (run.isLocal()) {
                this.logger.debug((Object)"It's a local test");
                DssUtils.incrementMetric(this.dss, "metrics.runs.local");
            } else {
                this.logger.debug((Object)"It's an automated test");
                DssUtils.incrementMetric(this.dss, "metrics.runs.automated");
            }
        } else if (this.runType == RunType.SHARED_ENVIRONMENT_BUILD) {
            int expireHours = sharedEnvironmentAnnotation.expireAfterHours();
            Instant expire = Instant.now().plus((long)expireHours, ChronoUnit.HOURS);
            try {
                this.dss.put("run." + this.run.getName() + ".shared.environment.expire", expire.toString());
            }
            catch (DynamicStatusStoreException e) {
                String msg2 = "DynamicStatusStoreException Exception caught. " + e.getMessage() + " Shutting down and Re-throwing.";
                this.logger.error((Object)msg2);
                this.deleteRunProperties(this.framework);
                frameworkInitialisation.shutdownFramework();
                throw new TestRunException("Unable to set the shared environment expire time", e);
            }
        }
        this.logger.debug((Object)"state changing to started.");
        this.updateStatus(TestRunLifecycleStatus.STARTED, "started");
        if (!BundleManagement.isBundleActive(this.bundleContext, "dev.galasa.core.manager")) {
            try {
                BundleManagement.loadBundle(this.repositoryAdmin, this.bundleContext, "dev.galasa.core.manager");
            }
            catch (FrameworkException e) {
                this.logger.warn((Object)"Tried to load the Core Manager bundle, but failed, test can continue without it", (Throwable)e);
            }
        }
        this.logger.debug((Object)"Bundle is loaded ok.");
        TestRunManagers managers = null;
        try {
            managers = new TestRunManagers(this.framework, new GalasaTest(testClass));
        }
        catch (FrameworkException e) {
            String msg3 = "FrameworkException Exception caught. " + e.getMessage() + " Shutting down and Re-throwing.";
            this.logger.error((Object)msg3);
            frameworkInitialisation.shutdownFramework();
            throw new TestRunException("Problem initialising the Managers for a test run", e);
        }
        this.logger.debug((Object)"Test managers ok.");
        try {
            if (managers.anyReasonTestClassShouldBeIgnored()) {
                this.logger.debug((Object)"managers.anyReasonTestClassShouldBeIgnored() is true. Shutting down.");
                this.stopHeartbeat();
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                frameworkInitialisation.shutdownFramework();
                return;
            }
        }
        catch (FrameworkException e) {
            String msg4 = "Problem asking Managers for an ignore reason";
            this.logger.error((Object)(msg4 + " " + e.getMessage()));
            throw new TestRunException(msg4, e);
        }
        this.logger.debug((Object)"Test class should not be ignored.");
        try {
            testClassWrapper = new TestClassWrapper(this, testBundleName, testClass, this.testStructure);
        }
        catch (ConfigurationPropertyStoreException e) {
            String msg5 = "Problem with the CPS when adding a wrapper";
            this.logger.error((Object)(msg5 + " " + e.getMessage()));
            throw new TestRunException(msg5, e);
        }
        this.logger.debug((Object)"Parsing test class...");
        testClassWrapper.parseTestClass();
        this.logger.debug((Object)"Instantiating test class...");
        testClassWrapper.instantiateTestClass();
        if (this.runType == RunType.SHARED_ENVIRONMENT_BUILD) {
            this.logger.debug((Object)"Checking active managers to see if they support shared env build...");
            boolean invalidManager = false;
            for (IManager manager : managers.getActiveManagers()) {
                if (manager.doYouSupportSharedEnvironments()) continue;
                this.logger.error((Object)("Manager " + manager.getClass().getName() + " does not support Shared Environments"));
                invalidManager = true;
            }
            if (invalidManager) {
                this.logger.error((Object)"There are Managers that do not support Shared Environment builds");
                testClassWrapper.setResult(Result.failed("Invalid Shared Environment build"));
                this.testStructure.setResult(testClassWrapper.getResult().getName());
                this.isRunOK = false;
            }
        }
        this.logger.debug((Object)("isRunOK: " + Boolean.toString(this.isRunOK)));
        this.logger.debug((Object)"Generating environment...");
        try {
            this.generateEnvironment(testClassWrapper, managers);
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Error within test runner", (Throwable)e);
            this.isRunOK = false;
        }
        this.logger.debug((Object)("isRunOK: " + Boolean.toString(this.isRunOK) + " runType: " + this.runType.toString()));
        if (!this.isRunOK || this.runType == RunType.TEST || this.runType == RunType.SHARED_ENVIRONMENT_DISCARD) {
            this.logger.debug((Object)("Test did not run OK... or runtype is not " + RunType.SHARED_ENVIRONMENT_BUILD.toString()));
            this.updateStatus(TestRunLifecycleStatus.ENDING, null);
            managers.endOfTestRun();
            boolean markedWaiting = false;
            if (!this.resourcesAvailable && !run.isLocal()) {
                this.markWaiting(this.framework);
                this.logger.info((Object)"Placing queue on the waiting list");
                markedWaiting = true;
            } else {
                if (this.runType == RunType.SHARED_ENVIRONMENT_DISCARD) {
                    this.testStructure.setResult("Discarded");
                    try {
                        this.dss.deletePrefix("run." + this.run.getName() + ".shared.environment");
                    }
                    catch (DynamicStatusStoreException e) {
                        this.logger.error((Object)"Problem cleaning shared environment properties", (Throwable)e);
                    }
                }
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
            }
            this.logger.debug((Object)"Stopping heartbeat...");
            this.stopHeartbeat();
            this.recordCPSProperties(frameworkInitialisation);
            if (!markedWaiting) {
                this.deleteRunProperties(this.framework);
            }
        } else if (this.runType == RunType.SHARED_ENVIRONMENT_BUILD) {
            this.recordCPSProperties(frameworkInitialisation);
            this.updateStatus(TestRunLifecycleStatus.UP, "built");
        } else {
            this.logger.error((Object)"Unrecognised end condition");
        }
        this.logger.debug((Object)"Cleaning up managers...");
        managers.shutdown();
        this.logger.debug((Object)"Cleaning up framework...");
        frameworkInitialisation.shutdownFramework();
    }

    private boolean isProduceEventsFeatureFlagTrue() throws ConfigurationPropertyStoreException {
        boolean produceEvents = false;
        String produceEventsProp = this.cps.getProperty("produce", "events", new String[0]);
        if (produceEventsProp != null) {
            this.logger.debug((Object)("CPS property framework.produce.events was found and is set to: " + produceEventsProp));
            produceEvents = Boolean.parseBoolean(produceEventsProp);
        }
        return produceEvents;
    }

    private void generateEnvironment(TestClassWrapper testClassWrapper, TestRunManagers managers) throws TestRunException {
        if (this.isRunOK) {
            try {
                this.updateStatus(TestRunLifecycleStatus.GENERATING, null);
                this.logger.info((Object)"Starting Provision Generate phase");
                managers.provisionGenerate();
                this.createEnvironment(testClassWrapper, managers);
            }
            catch (Exception e) {
                this.logger.info((Object)"Provision Generate failed", (Throwable)e);
                if (e instanceof FrameworkResourceUnavailableException) {
                    this.resourcesAvailable = false;
                }
                testClassWrapper.setResult(Result.envfail(e));
                if (this.resourcesAvailable) {
                    managers.testClassResult(testClassWrapper.getResult(), e);
                }
                this.testStructure.setResult(testClassWrapper.getResult().getName());
                this.isRunOK = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEnvironment(TestClassWrapper testClassWrapper, TestRunManagers managers) throws TestRunException {
        if (!this.isRunOK) {
            return;
        }
        try {
            if (this.runType == RunType.TEST || this.runType == RunType.SHARED_ENVIRONMENT_BUILD) {
                try {
                    this.updateStatus(TestRunLifecycleStatus.BUILDING, null);
                    this.logger.info((Object)"Starting Provision Build phase");
                    managers.provisionBuild();
                }
                catch (FrameworkException e) {
                    this.isRunOK = false;
                    this.logger.error((Object)"Provision build failed", (Throwable)e);
                    if (e instanceof FrameworkResourceUnavailableException) {
                        this.resourcesAvailable = false;
                    }
                    testClassWrapper.setResult(Result.envfail(e));
                    if (this.resourcesAvailable) {
                        managers.testClassResult(testClassWrapper.getResult(), e);
                    }
                    this.testStructure.setResult(testClassWrapper.getResult().getName());
                    this.discardEnvironment(managers);
                    return;
                }
            }
            this.runEnvironment(testClassWrapper, managers);
        }
        finally {
            this.discardEnvironment(managers);
        }
    }

    private void discardEnvironment(TestRunManagers managers) {
        if (this.runType != RunType.SHARED_ENVIRONMENT_BUILD) {
            this.logger.info((Object)"Starting Provision Discard phase");
            managers.provisionDiscard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEnvironment(TestClassWrapper testClassWrapper, TestRunManagers managers) throws TestRunException {
        if (this.isRunOK) {
            try {
                if (this.runType != RunType.SHARED_ENVIRONMENT_DISCARD) {
                    try {
                        this.updateStatus(TestRunLifecycleStatus.PROVSTART, null);
                        this.logger.info((Object)"Starting Provision Start phase");
                        managers.provisionStart();
                    }
                    catch (FrameworkException e) {
                        this.isRunOK = false;
                        this.logger.error((Object)"Provision start failed", (Throwable)e);
                        if (e instanceof FrameworkResourceUnavailableException) {
                            this.resourcesAvailable = false;
                        }
                        testClassWrapper.setResult(Result.envfail(e));
                        this.testStructure.setResult(testClassWrapper.getResult().getName());
                        this.stopEnvironment(managers);
                        return;
                    }
                }
                this.runTestClassWrapper(testClassWrapper, managers);
            }
            finally {
                this.stopEnvironment(managers);
            }
        }
    }

    private void stopEnvironment(TestRunManagers managers) {
        if (this.runType != RunType.SHARED_ENVIRONMENT_BUILD) {
            this.logger.info((Object)"Starting Provision Stop phase");
            managers.provisionStop();
        }
    }

    private void runTestClassWrapper(TestClassWrapper testClassWrapper, TestRunManagers managers) throws TestRunException {
        if (this.isRunOK && this.runType != RunType.SHARED_ENVIRONMENT_BUILD) {
            this.updateStatus(TestRunLifecycleStatus.RUNNING, null);
            try {
                this.logger.info((Object)"Running the test class");
                testClassWrapper.runTestMethods(managers, this.dss, this.run.getName());
            }
            finally {
                this.updateStatus(TestRunLifecycleStatus.RUNDONE, null);
            }
        }
    }

    private void markWaiting(@NotNull IFramework framework) throws TestRunException {
        int initialDelay = 600;
        int randomDelay = 180;
        DssUtils.incrementMetric(this.dss, "metrics.runs.made.to.wait");
        try {
            String sInitialDelay = AbstractManager.nulled(this.cps.getProperty("waiting.initial", "delay", new String[0]));
            String sRandomDelay = AbstractManager.nulled(this.cps.getProperty("waiting.random", "delay", new String[0]));
            if (sInitialDelay != null) {
                initialDelay = Integer.parseInt(sInitialDelay);
            }
            if (sRandomDelay != null) {
                randomDelay = Integer.parseInt(sRandomDelay);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Problem reading delay properties", (Throwable)e);
        }
        int totalDelay = initialDelay + framework.getRandom().nextInt(randomDelay);
        this.logger.info((Object)("Placing this run on waiting for " + totalDelay + " seconds"));
        Instant until = Instant.now();
        until = until.plus((long)totalDelay, ChronoUnit.SECONDS);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("run." + this.run.getName() + ".status", "waiting");
        properties.put("run." + this.run.getName() + ".wait.until", until.toString());
        try {
            this.dss.put(properties);
        }
        catch (DynamicStatusStoreException e) {
            throw new TestRunException("Unable to place run in waiting state", e);
        }
    }

    private void updateStatus(TestRunLifecycleStatus status, String timestamp) throws TestRunException {
        this.testStructure.setStatus(status.toString());
        if ("finished".equals(status.toString())) {
            this.updateResult();
            this.testStructure.setEndTime(Instant.now());
        }
        this.writeTestStructure();
        try {
            this.dss.put("run." + this.run.getName() + ".status", status.toString());
            if (timestamp != null) {
                this.dss.put("run." + this.run.getName() + "." + timestamp, Instant.now().toString());
            }
        }
        catch (DynamicStatusStoreException e) {
            throw new TestRunException("Failed to update status", e);
        }
        try {
            this.produceTestRunLifecycleStatusChangedEvent(status);
        }
        catch (TestRunException e) {
            this.logger.error((Object)"Unable to produce a test run lifecycle status changed event to the Events Service", (Throwable)e);
        }
    }

    private void produceTestRunLifecycleStatusChangedEvent(TestRunLifecycleStatus status) throws TestRunException {
        if (this.produceEvents) {
            this.logger.debug((Object)"Producing a test run lifecycle status change event.");
            String message = String.format("Galasa test run %s is now in status: %s.", this.framework.getTestRunName(), status.toString());
            TestRunLifecycleStatusChangedEvent testRunLifecycleStatusChangedEvent = new TestRunLifecycleStatusChangedEvent(this.cps, Instant.now().toString(), message);
            String topic = testRunLifecycleStatusChangedEvent.getTopic();
            if (topic != null) {
                try {
                    this.framework.getEventsService().produceEvent(topic, testRunLifecycleStatusChangedEvent);
                }
                catch (EventsException e) {
                    throw new TestRunException("Failed to publish a test run lifecycle status changed event to the Events Service", e);
                }
            }
        }
    }

    private void updateResult() throws TestRunException {
        try {
            if (this.testStructure.getResult() == null) {
                this.testStructure.setResult("UNKNOWN");
            }
            this.dss.put("run." + this.run.getName() + ".result", this.testStructure.getResult());
        }
        catch (DynamicStatusStoreException e) {
            throw new TestRunException("Failed to update result", e);
        }
    }

    private void stopHeartbeat() {
        if (this.heartbeat == null) {
            return;
        }
        this.heartbeat.shutdown();
        try {
            this.heartbeat.join(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dss.delete("run." + this.run.getName() + ".heartbeat");
        }
        catch (DynamicStatusStoreException e) {
            this.logger.error((Object)"Unable to delete heartbeat", (Throwable)e);
        }
        try {
            this.produceTestHeartbeatStoppedEvent();
        }
        catch (TestRunException e) {
            this.logger.error((Object)"Unable to produce a test heartbeat stopped event to the Events Service", (Throwable)e);
        }
    }

    private void produceTestHeartbeatStoppedEvent() throws TestRunException {
        if (this.produceEvents) {
            this.logger.debug((Object)"Producing a test heartbeat stopped event.");
            String message = String.format("Galasa test run %s's heartbeat has been stopped.", this.framework.getTestRunName());
            TestHeartbeatStoppedEvent testHeartbeatStoppedEvent = new TestHeartbeatStoppedEvent(this.cps, Instant.now().toString(), message);
            String topic = testHeartbeatStoppedEvent.getTopic();
            if (topic != null) {
                try {
                    this.framework.getEventsService().produceEvent(topic, testHeartbeatStoppedEvent);
                }
                catch (EventsException e) {
                    throw new TestRunException("Failed to publish a test heartbeat stopped event to the Events Service", e);
                }
            }
        }
    }

    private void writeTestStructure() {
        try {
            this.ras.updateTestStructure(this.testStructure);
        }
        catch (ResultArchiveStoreException e) {
            this.logger.warn((Object)"Unable to write the test structure to the RAS", (Throwable)e);
        }
    }

    private void deleteRunProperties(@NotNull IFramework framework) {
        IRun run = framework.getTestRun();
        if (!run.isLocal()) {
            return;
        }
        try {
            framework.getFrameworkRuns().delete(run.getName());
        }
        catch (FrameworkException e) {
            this.logger.error((Object)"Failed to delete run properties");
        }
    }

    private Class<?> getTestClass(String testBundleName, String testClassName) throws TestRunException {
        Class testClazz = null;
        Bundle[] bundles = this.bundleContext.getBundles();
        boolean bundleFound = false;
        for (Bundle bundle : bundles) {
            if (!bundle.getSymbolicName().equals(testBundleName)) continue;
            bundleFound = true;
            this.logger.trace((Object)("Found Bundle: " + testBundleName));
            try {
                testClazz = bundle.loadClass(testClassName);
            }
            catch (ClassNotFoundException e) {
                throw new TestRunException("Unable to load test class " + testClassName, e);
            }
            this.logger.trace((Object)("Found test class: " + testClazz.getName()));
            break;
        }
        if (!bundleFound) {
            throw new TestRunException("Unable to find test bundle " + testBundleName);
        }
        return testClazz;
    }

    @Activate
    public void activate(BundleContext context) {
        this.bundleContext = context;
    }

    protected IFramework getFramework() {
        return this.framework;
    }

    public IConfigurationPropertyStoreService getCPS() {
        return this.cps;
    }

    private void recordCPSProperties(FrameworkInitialisation frameworkInitialisation) {
        try {
            Properties record = this.framework.getRecordProperties();
            ArrayList<String> propertyNames = new ArrayList<String>();
            propertyNames.addAll(record.stringPropertyNames());
            Collections.sort(propertyNames);
            StringBuilder sb = new StringBuilder();
            String currentNamespace = null;
            for (String propertyName : propertyNames) {
                if ((propertyName = propertyName.trim()).isEmpty()) continue;
                String[] parts = propertyName.split("\\.");
                if (!parts[0].equals(currentNamespace)) {
                    if (currentNamespace != null) {
                        sb.append("\n");
                    }
                    currentNamespace = parts[0];
                }
                sb.append(propertyName);
                sb.append("=");
                sb.append(record.getProperty(propertyName));
                sb.append("\n");
            }
            IResultArchiveStore ras = this.framework.getResultArchiveStore();
            Path rasRoot = ras.getStoredArtifactsRoot();
            Path rasProperties = rasRoot.resolve("framework").resolve("cps_record.properties");
            Files.createFile(rasProperties, new FileAttribute[]{ResultArchiveStoreContentType.TEXT});
            Files.write(rasProperties, sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to save the recorded properties", (Throwable)e);
        }
    }

    private static enum RunType {
        TEST,
        SHARED_ENVIRONMENT_BUILD,
        SHARED_ENVIRONMENT_DISCARD;

    }
}

