/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.auth;

import dev.galasa.framework.spi.auth.AuthStoreException;
import dev.galasa.framework.spi.auth.IAuthStore;
import dev.galasa.framework.spi.auth.IAuthStoreService;
import dev.galasa.framework.spi.auth.IInternalAuthToken;
import dev.galasa.framework.spi.auth.IInternalUser;
import java.util.List;

public class FrameworkAuthStoreService
implements IAuthStoreService {
    private final IAuthStore authStore;

    public FrameworkAuthStoreService(IAuthStore authStore) {
        this.authStore = authStore;
    }

    @Override
    public List<IInternalAuthToken> getTokens() throws AuthStoreException {
        return this.authStore.getTokens();
    }

    @Override
    public IInternalAuthToken getToken(String tokenId) throws AuthStoreException {
        List<IInternalAuthToken> tokens = this.authStore.getTokens();
        IInternalAuthToken tokenToReturn = null;
        for (IInternalAuthToken token : tokens) {
            if (!token.getTokenId().equals(tokenId)) continue;
            tokenToReturn = token;
            break;
        }
        return tokenToReturn;
    }

    @Override
    public void storeToken(String clientId, String description, IInternalUser owner) throws AuthStoreException {
        this.authStore.storeToken(clientId, description, owner);
    }

    @Override
    public void deleteToken(String tokenId) throws AuthStoreException {
        this.authStore.deleteToken(tokenId);
    }
}

