/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.cps;

import dev.galasa.framework.internal.cps.FpfConfigurationPropertyStore;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreRegistration;
import dev.galasa.framework.spi.IFrameworkInitialisation;
import java.io.File;
import java.net.URI;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={IConfigurationPropertyStoreRegistration.class})
public class FpfConfigurationPropertyRegistration
implements IConfigurationPropertyStoreRegistration {
    @Override
    public void initialise(@NotNull IFrameworkInitialisation frameworkInitialisation) throws ConfigurationPropertyStoreException {
        URI cps = frameworkInitialisation.getBootstrapConfigurationPropertyStore();
        if (!cps.getScheme().equals("file")) {
            return;
        }
        File file = new File(cps);
        if (!file.exists()) {
            throw new ConfigurationPropertyStoreException("CPS file does not exist");
        }
        if (FpfConfigurationPropertyRegistration.isFileUri(cps)) {
            frameworkInitialisation.registerConfigurationPropertyStore(new FpfConfigurationPropertyStore(cps));
        }
    }

    public static boolean isFileUri(URI uri) {
        return "file".equals(uri.getScheme());
    }
}

