/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.cps;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.FrameworkPropertyFile;
import dev.galasa.framework.spi.FrameworkPropertyFileException;
import dev.galasa.framework.spi.IConfigurationPropertyStore;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

public class FpfConfigurationPropertyStore
implements IConfigurationPropertyStore {
    private FrameworkPropertyFile fpf;

    public FpfConfigurationPropertyStore(URI file) throws ConfigurationPropertyStoreException {
        try {
            this.fpf = new FrameworkPropertyFile(file);
        }
        catch (FrameworkPropertyFileException e) {
            throw new ConfigurationPropertyStoreException("Failed to create Framework property file", (Throwable)e);
        }
    }

    @Override
    @Null
    public String getProperty(@NotNull String key) throws ConfigurationPropertyStoreException {
        return this.fpf.get(key);
    }

    @Override
    @NotNull
    public Map<String, String> getPrefixedProperties(@NotNull String prefix) throws ConfigurationPropertyStoreException {
        return this.fpf.getPrefix(prefix);
    }

    @Override
    public void setProperty(@NotNull String key, @NotNull String value) throws ConfigurationPropertyStoreException {
        try {
            this.fpf.set(key, value);
        }
        catch (FrameworkPropertyFileException e) {
            throw new ConfigurationPropertyStoreException("Unable to set property value", (Throwable)e);
        }
    }

    @Override
    public void deleteProperty(@NotNull String key) throws ConfigurationPropertyStoreException {
        try {
            this.fpf.delete(key);
        }
        catch (FrameworkPropertyFileException e) {
            throw new ConfigurationPropertyStoreException("Unable to set property value", (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getPropertiesFromNamespace(String namespace) {
        return this.fpf.getPrefix(namespace);
    }

    public static boolean isFileUri(URI uri) {
        return "file".equals(uri.getScheme());
    }

    @Override
    public List<String> getNamespaces() {
        return this.fpf.getNamespaces();
    }

    @Override
    public void shutdown() throws ConfigurationPropertyStoreException {
        try {
            this.fpf.shutdown();
        }
        catch (FrameworkPropertyFileException e) {
            throw new ConfigurationPropertyStoreException("Problem shutting down the CPS File", (Throwable)e);
        }
    }
}

