/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.cps;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStore;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IFramework;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.NotNull;

public class FrameworkConfigurationPropertyService
implements IConfigurationPropertyStoreService {
    private String namespace;
    private Properties record;
    private Properties overrides;
    private IConfigurationPropertyStore cpsStore;

    public FrameworkConfigurationPropertyService(IFramework framework, IConfigurationPropertyStore cpsStore, Properties overrides, Properties record, String namespace) {
        this.namespace = namespace;
        this.record = record;
        this.overrides = overrides;
        this.cpsStore = cpsStore;
    }

    @Override
    public String getProperty(@NotNull String prefix, @NotNull String suffix, String ... infixes) throws ConfigurationPropertyStoreException {
        if (infixes == null) {
            infixes = new String[]{};
        }
        String[] keys = this.createOrderedKeyList(prefix, suffix, infixes);
        String value = null;
        for (String key : keys) {
            value = this.getValueAndMakeAccessRecord(key);
            if (value == null) continue;
            return value.trim();
        }
        return null;
    }

    @Override
    public Map<String, String> getAllProperties() throws ConfigurationPropertyStoreException {
        return this.cpsStore.getPropertiesFromNamespace(this.namespace);
    }

    @Override
    public void setProperty(@NotNull String name, @NotNull String value) throws ConfigurationPropertyStoreException {
        this.cpsStore.setProperty(this.namespace + "." + name, value);
    }

    @Override
    public void deleteProperty(@NotNull String name) throws ConfigurationPropertyStoreException {
        this.cpsStore.deleteProperty(this.namespace + "." + name);
    }

    @Override
    public String[] reportPropertyVariants(@NotNull String prefix, @NotNull String suffix, String ... infixes) {
        if (infixes == null) {
            infixes = new String[]{};
        }
        return this.createOrderedKeyList(prefix, suffix, infixes);
    }

    @Override
    public String reportPropertyVariantsString(@NotNull String prefix, @NotNull String suffix, String ... infixes) {
        String[] variants = this.reportPropertyVariants(prefix, suffix, infixes);
        StringBuilder sb = new StringBuilder();
        for (String variant : variants) {
            if (sb.length() == 0) {
                sb.append("[");
            } else {
                sb.append(",");
            }
            sb.append(variant);
        }
        sb.append("]");
        return sb.toString();
    }

    private String getValueAndMakeAccessRecord(String key) throws ConfigurationPropertyStoreException {
        String value = this.overrides.getProperty(key);
        if (value != null) {
            this.record.put(key, value);
            return value;
        }
        value = this.cpsStore.getProperty(key);
        if (value != null) {
            this.record.put(key, value);
            return value;
        }
        this.record.put(key, "*** MISSING ***");
        return null;
    }

    private String[] createOrderedKeyList(String prefix, String suffix, String ... infixes) {
        String[] keys = new String[infixes.length + 1];
        String[] infixOrder = this.getInfixOrder(infixes);
        for (int i = 0; i < infixOrder.length; ++i) {
            keys[i] = this.namespace + "." + prefix + infixOrder[i] + suffix;
        }
        keys[infixes.length] = this.namespace + "." + prefix + "." + suffix;
        return keys;
    }

    private String[] getInfixOrder(String ... infixes) {
        String[] infixOrderList = new String[infixes.length];
        for (int i = 0; i < infixes.length; ++i) {
            StringBuilder majorInfix = new StringBuilder();
            for (int j = 0; j < infixes.length - i; ++j) {
                majorInfix.append("." + infixes[j]);
            }
            majorInfix.append(".");
            infixOrderList[i] = majorInfix.toString();
        }
        return infixOrderList;
    }

    @Override
    public List<String> getCPSNamespaces() throws ConfigurationPropertyStoreException {
        return this.cpsStore.getNamespaces();
    }

    @Override
    public Map<String, String> getPrefixedProperties(@NotNull String prefix) throws ConfigurationPropertyStoreException {
        HashMap<String, String> returnValues = new HashMap<String, String>();
        String fullPrefix = this.namespace + "." + prefix;
        for (Map.Entry<Object, Object> entry : this.overrides.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(fullPrefix)) continue;
            this.record.setProperty(key, value);
            key = key.substring(this.namespace.length() + 1);
            returnValues.put(key, value);
        }
        Map<String, String> cpsEntries = this.cpsStore.getPrefixedProperties(fullPrefix);
        for (Map.Entry<String, String> entry : cpsEntries.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String unPrefixedKey = key.substring(this.namespace.length() + 1);
            if (returnValues.containsKey(unPrefixedKey)) continue;
            this.record.setProperty(key, value);
            returnValues.put(unPrefixedKey, value);
        }
        return returnValues;
    }
}

