/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.dss;

import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreMatchException;
import dev.galasa.framework.spi.IDssAction;
import dev.galasa.framework.spi.IDssResourceAction;
import dev.galasa.framework.spi.IDynamicStatusStore;
import dev.galasa.framework.spi.IDynamicStatusStoreKeyAccess;
import dev.galasa.framework.spi.IDynamicStatusStoreWatcher;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

public class FrameworkDynamicStoreKeyAccess
implements IDynamicStatusStoreKeyAccess {
    private final IDynamicStatusStore dssStore;
    private final String prefix;
    private final String namespace;

    public FrameworkDynamicStoreKeyAccess(IDynamicStatusStore dssStore, String prefix, String namespace) {
        Objects.requireNonNull(dssStore);
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(namespace);
        this.dssStore = dssStore;
        this.prefix = prefix;
        this.namespace = namespace;
    }

    protected IDynamicStatusStore getDssStore() {
        return this.dssStore;
    }

    @Override
    public void put(@NotNull String key, @NotNull String value) throws DynamicStatusStoreException {
        this.dssStore.put(this.prefixKey(key), value);
    }

    @Override
    public void put(@NotNull Map<String, String> keyValues) throws DynamicStatusStoreException {
        Objects.requireNonNull(keyValues);
        HashMap<String, String> newKeyValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            String oKey = entry.getKey();
            String oValue = entry.getValue();
            Objects.requireNonNull(oKey);
            Objects.requireNonNull(oValue);
            newKeyValues.put(this.prefixKey(oKey), oValue);
        }
        this.dssStore.put(newKeyValues);
    }

    @Override
    public boolean putSwap(@NotNull String key, String oldValue, @NotNull String newValue) throws DynamicStatusStoreException {
        Objects.requireNonNull(newValue);
        return this.dssStore.putSwap(this.prefixKey(key), oldValue, newValue);
    }

    @Override
    public boolean putSwap(@NotNull String key, String oldValue, @NotNull String newValue, @NotNull Map<String, String> others) throws DynamicStatusStoreException {
        Objects.requireNonNull(newValue);
        Objects.requireNonNull(others);
        HashMap<String, String> newOthers = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : others.entrySet()) {
            String oKey = entry.getKey();
            String oValue = entry.getValue();
            Objects.requireNonNull(oKey);
            Objects.requireNonNull(oValue);
            newOthers.put(this.prefixKey(oKey), oValue);
        }
        return this.dssStore.putSwap(this.prefixKey(key), oldValue, newValue, newOthers);
    }

    @Override
    @Null
    public String get(@NotNull String key) throws DynamicStatusStoreException {
        return this.dssStore.get(this.prefixKey(key));
    }

    @Override
    @NotNull
    public Map<String, String> getPrefix(@NotNull String keyPrefix) throws DynamicStatusStoreException {
        Map<String, String> gotSet = this.dssStore.getPrefix(this.prefixKey(keyPrefix));
        HashMap<String, String> returnSet = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : gotSet.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith(this.prefix)) {
                key = key.substring(this.prefix.length());
                returnSet.put(key, value);
                continue;
            }
            throw new DynamicStatusStoreException("Somehow we got keys with the wrong prefix");
        }
        return returnSet;
    }

    @Override
    public void delete(@NotNull String key) throws DynamicStatusStoreException {
        this.dssStore.delete(this.prefixKey(key));
    }

    @Override
    public void delete(@NotNull Set<String> keys) throws DynamicStatusStoreException {
        Objects.requireNonNull(keys);
        HashSet<String> newKeys = new HashSet<String>();
        for (String key : keys) {
            Objects.requireNonNull(key);
            newKeys.add(this.prefixKey(key));
        }
        this.dssStore.delete(newKeys);
    }

    @Override
    public void deletePrefix(@NotNull String keyPrefix) throws DynamicStatusStoreException {
        this.dssStore.deletePrefix(this.prefixKey(keyPrefix));
    }

    private String prefixKey(String key) {
        Objects.requireNonNull(key);
        return this.prefix + key;
    }

    @Override
    public UUID watch(IDynamicStatusStoreWatcher watcher, String key) throws DynamicStatusStoreException {
        return this.dssStore.watch(new PassthroughWatcher(watcher, this.prefix), this.prefixKey(key));
    }

    @Override
    public UUID watchPrefix(IDynamicStatusStoreWatcher watcher, String keyPrefix) throws DynamicStatusStoreException {
        return this.dssStore.watchPrefix(new PassthroughWatcher(watcher, this.prefix), this.prefixKey(keyPrefix));
    }

    @Override
    public void unwatch(UUID watchId) throws DynamicStatusStoreException {
        this.dssStore.unwatch(watchId);
    }

    @Override
    public void performActions(IDssAction ... actions) throws DynamicStatusStoreException, DynamicStatusStoreMatchException {
        IDssAction[] dssActions = new IDssAction[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            dssActions[i] = actions[i] instanceof IDssResourceAction ? actions[i].applyPrefix("dss.framework.resource." + this.namespace + ".") : actions[i].applyPrefix(this.prefix);
        }
        this.dssStore.performActions(dssActions);
    }

    private static class PassthroughWatcher
    implements IDynamicStatusStoreWatcher {
        private final String prefix;
        private final int offset;
        private final IDynamicStatusStoreWatcher watcher;

        private PassthroughWatcher(IDynamicStatusStoreWatcher watcher, String prefix) {
            this.prefix = prefix;
            this.offset = this.prefix.length();
            this.watcher = watcher;
        }

        @Override
        public void propertyModified(String key, IDynamicStatusStoreWatcher.Event event, String oldValue, String newValue) {
            key = key.substring(this.offset);
            this.watcher.propertyModified(key, event, oldValue, newValue);
        }
    }
}

