/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.ras.directory;

import java.io.IOException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;

public class DirectoryRASDirectoryStream
implements DirectoryStream<Path> {
    private final ArrayList<Path> directoryList = new ArrayList();
    private boolean closed = false;

    protected DirectoryRASDirectoryStream(FileSystem fileSystem, Path artifactRoot, Path realPath, DirectoryStream.Filter<? super Path> filter) throws IOException {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(realPath, filter);){
            for (Path child : ds) {
                Path newPath = fileSystem.getPath(artifactRoot.relativize(child).toString(), new String[0]).toAbsolutePath();
                this.directoryList.add(newPath);
            }
        }
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.closed) {
            throw new ClosedDirectoryStreamException();
        }
        return this.directoryList.iterator();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

