/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.ras.directory;

import dev.galasa.ResultArchiveStoreContentType;
import dev.galasa.ResultArchiveStoreFileAttributeView;
import dev.galasa.SetContentType;
import dev.galasa.framework.internal.ras.directory.DirectoryRASDirectoryStream;
import dev.galasa.framework.internal.ras.directory.DirectoryRASFileSystem;
import dev.galasa.framework.spi.ras.ResultArchiveStoreFileSystem;
import dev.galasa.framework.spi.ras.ResultArchiveStoreFileSystemProvider;
import dev.galasa.framework.spi.ras.ResultArchiveStorePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DirectoryRASFileSystemProvider
extends ResultArchiveStoreFileSystemProvider {
    private static final String RAS_CONTENT_TYPE = "ras:contentType";
    private final Path artifactDirectory;
    private final Path artifactPropertesFile;
    private final Properties contentTypeProperties = new Properties();

    protected DirectoryRASFileSystemProvider(Path runDirectory) throws IOException {
        super(runDirectory.getFileSystem().provider().getFileStore(runDirectory));
        this.artifactDirectory = runDirectory.resolve("artifacts");
        this.artifactPropertesFile = runDirectory.resolve("artifacts.properties");
        if (Files.exists(this.artifactPropertesFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(this.artifactPropertesFile, new OpenOption[0]);){
                this.contentTypeProperties.load(is);
            }
            catch (Exception e) {
                throw new IOException("Unable to read the artifacts contenttypes", e);
            }
        }
    }

    private void setContentType(Path path, ResultArchiveStoreContentType contentType) throws IOException {
        if (!path.isAbsolute()) {
            path = path.toAbsolutePath();
        }
        this.contentTypeProperties.setProperty(path.toString(), contentType.value());
        try (OutputStream os = Files.newOutputStream(this.artifactPropertesFile, new OpenOption[0]);){
            this.contentTypeProperties.store(os, null);
        }
        catch (Exception e) {
            throw new IOException("Unable to write the artifacts contenttypes", e);
        }
    }

    private ResultArchiveStoreContentType getContentType(Path path) {
        if (!path.isAbsolute()) {
            path = path.toAbsolutePath();
        }
        ResultArchiveStoreContentType contentType = null;
        String sContentType = this.contentTypeProperties.getProperty(path.toString());
        contentType = sContentType == null ? ResultArchiveStoreContentType.TEXT : new ResultArchiveStoreContentType(sContentType);
        return contentType;
    }

    @Override
    protected ResultArchiveStoreFileSystem createFileSystem() {
        return new DirectoryRASFileSystem(this);
    }

    @Override
    public String getScheme() {
        return "rasdir";
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Path realPath = this.getRealPath(path);
        if (!Files.exists(realPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(realPath.getParent(), new FileAttribute[0]);
        }
        HashSet<OpenOption> newOptions = new HashSet<OpenOption>();
        for (OpenOption openOption : options) {
            if (openOption instanceof SetContentType) {
                this.setContentType(path, ((SetContentType)openOption).getContentType());
                continue;
            }
            newOptions.add(openOption);
        }
        SeekableByteChannel byteChannel = Files.newByteChannel(realPath, newOptions, new FileAttribute[0]);
        for (FileAttribute<?> attr : attrs) {
            if (!(attr instanceof ResultArchiveStoreContentType)) continue;
            this.setContentType(path, (ResultArchiveStoreContentType)attr);
        }
        return byteChannel;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        boolean write = false;
        block5: for (AccessMode mode : modes) {
            switch (mode) {
                case EXECUTE: {
                    throw new IOException("Path '" + path.toString() + " is not available execute");
                }
                case READ: {
                    continue block5;
                }
                case WRITE: {
                    write = true;
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (write) {
            if (this.fileSystem.isReadOnly()) {
                throw new AccessDeniedException(path.toAbsolutePath().toString());
            }
            return;
        }
        Path realPath = this.getRealPath(path);
        if (!Files.exists(realPath, new LinkOption[0])) {
            throw new NoSuchFileException(path.toAbsolutePath().toString());
        }
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Path realPath = this.getRealPath(dir);
        if (Files.exists(dir, new LinkOption[0])) {
            throw new FileAlreadyExistsException(dir.toAbsolutePath().toString());
        }
        Files.createDirectory(realPath, new FileAttribute[0]);
    }

    private Path getRealPath(Path path) {
        if (!(path instanceof ResultArchiveStorePath)) {
            throw new ProviderMismatchException();
        }
        ResultArchiveStorePath rasPath = (ResultArchiveStorePath)path;
        if (rasPath.isAbsolute()) {
            rasPath = rasPath.unAbsolute();
        }
        return this.artifactDirectory.resolve(rasPath.toString());
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        Path realPath = this.getRealPath(path);
        if (type == BasicFileAttributeView.class) {
            return realPath.getFileSystem().provider().getFileAttributeView(realPath, type, options);
        }
        if (type == ResultArchiveStoreFileAttributeView.class) {
            return (V)new ResultArchiveStoreFileAttributeView(this.getContentType(path));
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Path realPath = this.getRealPath(path);
        if (type == BasicFileAttributes.class) {
            return realPath.getFileSystem().provider().readAttributes(realPath, type, options);
        }
        return null;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        HashMap<String, Object> returnAttrs = new HashMap<String, Object>();
        ResultArchiveStoreContentType contentType = this.getContentType(path);
        ArrayList<String> attrs = new ArrayList<String>(Arrays.asList(attributes.replaceAll(" ", "").split(",")));
        Iterator<String> it = attrs.iterator();
        while (it.hasNext()) {
            String attr = it.next();
            if ("*".equals(attr)) {
                returnAttrs.put(RAS_CONTENT_TYPE, contentType.value());
                continue;
            }
            int colon = attr.indexOf(58);
            if (colon != 3 || !"ras".equals(attr.substring(0, colon))) continue;
            it.remove();
            String attrName = attr.substring(colon + 1);
            if ("*".equals(attrName)) {
                returnAttrs.put(RAS_CONTENT_TYPE, contentType.value());
                continue;
            }
            if ("contentType".equals(attrName)) {
                returnAttrs.put(RAS_CONTENT_TYPE, contentType.value());
                continue;
            }
            throw new UnsupportedOperationException("Attribute ras:" + attrName + " is not available");
        }
        if (!attrs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String attr : attrs) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(attr);
            }
            Path realPath = this.getRealPath(path);
            returnAttrs.putAll(realPath.getFileSystem().provider().readAttributes(realPath, sb.toString(), options));
        }
        return returnAttrs;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Setting attributes in unsupported in Result Archive Store");
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return new DirectoryRASDirectoryStream(this.fileSystem, this.artifactDirectory, this.getRealPath(dir), filter);
    }
}

