/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.ras.directory;

import dev.galasa.framework.internal.ras.directory.DirectoryResultArchiveStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IFrameworkInitialisation;
import dev.galasa.framework.spi.IResultArchiveStoreRegistration;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={IResultArchiveStoreRegistration.class})
public class DirectoryResultArchiveStoreRegistration
implements IResultArchiveStoreRegistration {
    private DirectoryResultArchiveStoreService service;
    private URI rasUri;

    @Override
    public void initialise(@NotNull IFrameworkInitialisation frameworkInitialisation) throws ResultArchiveStoreException {
        IFramework framework = frameworkInitialisation.getFramework();
        List<URI> rasUris = frameworkInitialisation.getResultArchiveStoreUris();
        for (URI uri : rasUris) {
            if (!"file".equals(uri.getScheme())) continue;
            if (this.rasUri != null && !this.service.isShutdown()) {
                throw new ResultArchiveStoreException("The Directory RAS currently does not support multiple instances of itself");
            }
            this.rasUri = uri;
        }
        if (this.rasUri == null) {
            return;
        }
        this.service = new DirectoryResultArchiveStoreService(framework, this.rasUri);
        frameworkInitialisation.registerResultArchiveStoreService(this.service);
    }
}

