/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.rps;

import dev.galasa.framework.internal.rps.ICharacter;
import dev.galasa.framework.internal.rps.tree.ASTConstant;
import dev.galasa.framework.internal.rps.tree.ASTMultiRange;
import dev.galasa.framework.internal.rps.tree.ASTSingleRange;
import dev.galasa.framework.internal.rps.tree.ASTVariable;
import dev.galasa.framework.internal.rps.tree.SimpleNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class CharacterVariable
implements ICharacter {
    private char character;
    private Random random = new Random();
    public static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String NUMBERS = "0123456789";
    private ArrayList<Character> chars = new ArrayList();

    public CharacterVariable(SimpleNode child) {
        this.generateAcceptableChars((ASTVariable)child);
    }

    @Override
    public char getRandomChar() {
        this.character = this.chars.get(this.random.nextInt(this.chars.size())).charValue();
        return this.character;
    }

    @Override
    public char getNextChar() {
        int charIndex = this.chars.lastIndexOf(Character.valueOf(this.character));
        if (charIndex == this.chars.size() - 1) {
            this.character = this.chars.get(0).charValue();
            return this.character;
        }
        this.character = this.chars.get(charIndex + 1).charValue();
        return this.character;
    }

    @Override
    public char getChar() {
        return this.character;
    }

    @Override
    public char getFirstChar() {
        this.character = this.chars.get(0).charValue();
        return this.character;
    }

    @Override
    public char firstChar() {
        return this.chars.get(0).charValue();
    }

    @Override
    public int numberOfCombinations() {
        return this.chars.size();
    }

    private void generateAcceptableChars(ASTVariable variable) {
        for (int i = 0; i < variable.jjtGetNumChildren(); ++i) {
            SimpleNode child = (SimpleNode)variable.jjtGetChild(i);
            if (child instanceof ASTSingleRange) {
                String constant = (String)((ASTConstant)child.jjtGetChild(0)).jjtGetValue();
                String range = CharacterVariable.getAppropriateRange(constant);
                String firstCharacter = range.substring(0, 1);
                this.addCharacters(range, firstCharacter, constant);
                continue;
            }
            if (child instanceof ASTMultiRange) {
                String constantFrom = (String)((ASTConstant)child.jjtGetChild(0)).jjtGetValue();
                String constantTo = (String)((ASTConstant)child.jjtGetChild(1)).jjtGetValue();
                String range = CharacterVariable.getAppropriateRange(constantFrom);
                this.addCharacters(range, constantFrom, constantTo);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognised node " + child.getClass().getName());
        }
        Collections.sort(this.chars);
    }

    private void addCharacters(String range, String characterFrom, String characterTo) {
        int fromPos = range.indexOf(characterFrom);
        int toPos = range.indexOf(characterTo);
        if (toPos < 0) {
            throw new UnsupportedOperationException("To character not from the same range as the from character " + characterFrom + "-" + characterTo);
        }
        if (toPos < fromPos) {
            throw new UnsupportedOperationException("To character in range is before from character " + characterFrom + "-" + characterTo);
        }
        for (int i = fromPos; i <= toPos; ++i) {
            char c = range.charAt(i);
            if (this.chars.contains(Character.valueOf(c))) continue;
            this.chars.add(Character.valueOf(c));
        }
    }

    private static String getAppropriateRange(String character) {
        if (UPPERCASE.contains(character)) {
            return UPPERCASE;
        }
        if (LOWERCASE.contains(character)) {
            return LOWERCASE;
        }
        if (NUMBERS.contains(character)) {
            return NUMBERS;
        }
        throw new UnsupportedOperationException("Unknown character - '" + character + "'");
    }
}

