/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.rps;

import dev.galasa.framework.internal.rps.CharacterConstant;
import dev.galasa.framework.internal.rps.CharacterVariable;
import dev.galasa.framework.internal.rps.ICharacter;
import dev.galasa.framework.internal.rps.tree.ASTConstant;
import dev.galasa.framework.internal.rps.tree.ASTStart;
import dev.galasa.framework.internal.rps.tree.ASTVariable;
import dev.galasa.framework.internal.rps.tree.ParseException;
import dev.galasa.framework.internal.rps.tree.RpsResolver;
import dev.galasa.framework.internal.rps.tree.SimpleNode;
import dev.galasa.framework.spi.InsufficientResourcesAvailableException;
import dev.galasa.framework.spi.ResourcePoolingServiceException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;

public class ResourceString {
    private List<ICharacter> string = new ArrayList<ICharacter>();

    public ResourceString(String input) throws ResourcePoolingServiceException {
        ASTStart node;
        ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes());
        RpsResolver reslove = new RpsResolver(stream);
        try {
            node = reslove.Start();
        }
        catch (ParseException e) {
            throw new ResourcePoolingServiceException("Problem Parsing String", (Throwable)e);
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            if (child instanceof ASTConstant) {
                this.string.add(new CharacterConstant(child));
                continue;
            }
            if (!(child instanceof ASTVariable)) continue;
            this.string.add(new CharacterVariable(child));
        }
    }

    public String getFirstResource() {
        StringBuilder resource = new StringBuilder();
        for (ICharacter character : this.string) {
            resource.append(character.getFirstChar());
        }
        return resource.toString();
    }

    public String getRandomResource() {
        StringBuilder resource = new StringBuilder();
        for (ICharacter character : this.string) {
            resource.append(character.getRandomChar());
        }
        return resource.toString();
    }

    public String getNextResource() throws InsufficientResourcesAvailableException {
        StringBuilder builder = new StringBuilder();
        boolean stillIncrementing = true;
        boolean overflow = false;
        for (int i = this.string.size() - 1; i >= 0; --i) {
            ICharacter character = this.string.get(i);
            if (character instanceof CharacterVariable && stillIncrementing) {
                char nextChar = character.getNextChar();
                if (nextChar != character.firstChar()) {
                    stillIncrementing = false;
                    builder.append(nextChar);
                    overflow = false;
                    continue;
                }
                if (i != 0) {
                    overflow = true;
                }
                builder.append(nextChar);
                continue;
            }
            builder.append(character.getChar());
        }
        builder.reverse();
        if (overflow) {
            throw new InsufficientResourcesAvailableException("Not enough resources available, hit overflow.");
        }
        return builder.toString();
    }

    public int getNumberOfCombinations() {
        int combintations = 1;
        for (ICharacter c : this.string) {
            if (!(c instanceof CharacterVariable)) continue;
            combintations *= c.numberOfCombinations();
        }
        return combintations;
    }
}

