/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi;

import dev.galasa.ManagerException;
import dev.galasa.framework.spi.AnnotatedField;
import dev.galasa.framework.spi.GenerateAnnotatedField;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.ResourceUnavailableException;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.ValidAnnotatedFields;
import dev.galasa.framework.spi.language.GalasaMethod;
import dev.galasa.framework.spi.language.GalasaTest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractManager
implements IManager {
    private IFramework framework;
    private Class<?> testClass;
    private final HashMap<Field, Object> annotatedFields = new HashMap();
    private final Log logger = LogFactory.getLog(this.getClass());

    protected void registerAnnotatedField(Field field, Object value) {
        this.annotatedFields.put(field, value);
    }

    protected Object getAnnotatedField(Field field) {
        return this.annotatedFields.get(field);
    }

    protected List<AnnotatedField> findAnnotatedFields(Class<? extends Annotation> managerAnnotation) {
        ArrayList<AnnotatedField> foundFields = new ArrayList<AnnotatedField>();
        for (Class<?> lookClass = this.testClass; lookClass != null; lookClass = lookClass.getSuperclass()) {
            for (Field field : lookClass.getFields()) {
                ArrayList<Annotation> fieldAnnotations = new ArrayList<Annotation>();
                for (Annotation annotation : field.getAnnotations()) {
                    if (!annotation.annotationType().isAnnotationPresent(managerAnnotation)) continue;
                    ValidAnnotatedFields validClasses = annotation.annotationType().getAnnotation(ValidAnnotatedFields.class);
                    if (validClasses != null) {
                        boolean found = false;
                        for (Class<?> k : validClasses.value()) {
                            if (k != field.getType()) continue;
                            fieldAnnotations.add(annotation);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.logger.warn((Object)("Field " + field.getName() + " has an invalid type, ignoring"));
                        continue;
                    }
                    fieldAnnotations.add(annotation);
                }
                if (fieldAnnotations.isEmpty()) continue;
                foundFields.add(new AnnotatedField(field, fieldAnnotations));
            }
        }
        return foundFields;
    }

    protected void generateAnnotatedFields(Class<? extends Annotation> managerAnnotation) throws ResourceUnavailableException, ManagerException {
        List<AnnotatedField> foundAnnotatedFields = this.findAnnotatedFields(managerAnnotation);
        if (foundAnnotatedFields.isEmpty()) {
            return;
        }
        for (AnnotatedField entry : foundAnnotatedFields) {
            Field field = entry.getField();
            List<Annotation> annotations = entry.getAnnotations();
            if (this.annotatedFields.containsKey(field)) continue;
            try {
                for (Method method : this.getClass().getMethods()) {
                    Class<?>[] parameterTypes;
                    GenerateAnnotatedField genField = method.getAnnotation(GenerateAnnotatedField.class);
                    if (genField == null) continue;
                    boolean foundAnnotation = false;
                    for (Annotation annotation : annotations) {
                        if (annotation.annotationType() != genField.annotation()) continue;
                        foundAnnotation = true;
                        break;
                    }
                    if (!foundAnnotation || (parameterTypes = method.getParameterTypes()) == null || parameterTypes.length != 2 || parameterTypes[0] != Field.class || parameterTypes[1] != List.class || method.getReturnType() != field.getType()) continue;
                    try {
                        Object response = method.invoke((Object)this, field, annotations);
                        if (response == null) continue;
                        this.annotatedFields.put(field, response);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getTargetException() instanceof ResourceUnavailableException) {
                            throw (ResourceUnavailableException)e.getTargetException();
                        }
                        throw e;
                    }
                }
            }
            catch (ResourceUnavailableException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ManagerException("Problem generating Test Class fields", e);
            }
        }
    }

    @NotNull
    protected Set<String> findProvisionDependentAnnotatedFieldTags(@NotNull Class<? extends Annotation> managerAnnotation, @NotNull String attributeName) {
        HashSet<String> foundTags = new HashSet<String>();
        List<AnnotatedField> foundAnnotatedFields = this.findAnnotatedFields(managerAnnotation);
        for (AnnotatedField annotatedField : foundAnnotatedFields) {
            List<Annotation> annotations = annotatedField.getAnnotations();
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!annotationType.isAnnotationPresent(managerAnnotation)) continue;
                try {
                    Method methodImageTag = annotation.getClass().getMethod(attributeName, new Class[0]);
                    String tag = (String)methodImageTag.invoke((Object)annotation, new Object[0]);
                    if (tag == null || (tag = tag.trim()).isEmpty()) continue;
                    foundTags.add(tag.toUpperCase());
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Error processing a Manager dependency annotation on field " + annotatedField.getField().getName() + " for " + managerAnnotation.getName() + " attribute " + attributeName), (Throwable)e);
                }
            }
        }
        return foundTags;
    }

    @Override
    public List<String> extraBundles(@NotNull IFramework framework) throws ManagerException {
        return null;
    }

    @Override
    public void initialise(@NotNull IFramework framework, @NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        this.framework = framework;
        if (galasaTest.isJava().booleanValue()) {
            this.testClass = galasaTest.getJavaTestClass();
        }
    }

    public IFramework getFramework() {
        return this.framework;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public void youAreRequired(@NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
    }

    @Override
    public boolean areYouProvisionalDependentOn(@NotNull IManager otherManager) {
        return false;
    }

    @Override
    public String anyReasonTestClassShouldBeIgnored() throws ManagerException {
        return null;
    }

    @Override
    public void provisionGenerate() throws ManagerException, ResourceUnavailableException {
    }

    @Override
    public void provisionBuild() throws ManagerException, ResourceUnavailableException {
    }

    @Override
    public void provisionStart() throws ManagerException, ResourceUnavailableException {
    }

    @Override
    public void startOfTestClass() throws ManagerException {
    }

    @Override
    public void fillAnnotatedFields(Object instanstiatedTestClass) throws ManagerException {
        for (Map.Entry<Field, Object> annotatedField : this.annotatedFields.entrySet()) {
            Field field = annotatedField.getKey();
            Object value = annotatedField.getValue();
            try {
                field.set(instanstiatedTestClass, value);
            }
            catch (Throwable e) {
                throw new ManagerException("Unable to fill Test Class field " + field.getName(), e);
            }
        }
    }

    @Override
    public String anyReasonTestMethodShouldBeIgnored(@NotNull GalasaMethod galasaMethod) throws ManagerException {
        return null;
    }

    @Override
    public void startOfTestMethod(@NotNull GalasaMethod galasaMethod) throws ManagerException {
    }

    @Override
    public Result endOfTestMethod(@NotNull GalasaMethod galasaMethod, @NotNull Result currentResult, Throwable currentException) throws ManagerException {
        return null;
    }

    @Override
    public void testMethodResult(@NotNull String finalResult, Throwable finalException) throws ManagerException {
    }

    @Override
    public Result endOfTestClass(@NotNull Result currentResult, Throwable currentException) throws ManagerException {
        return null;
    }

    @Override
    public void testClassResult(@NotNull String finalResult, Throwable finalException) throws ManagerException {
    }

    @Override
    public void provisionStop() {
    }

    @Override
    public void provisionDiscard() {
    }

    @Override
    public void performFailureAnalysis() {
    }

    @Override
    public void endOfTestRun() {
    }

    protected <T> T addDependentManager(@NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest, @NotNull Class<T> dependentInterface) throws ManagerException {
        for (IManager manager : allManagers) {
            if (!dependentInterface.isAssignableFrom(manager.getClass())) continue;
            manager.youAreRequired(allManagers, activeManagers, galasaTest);
            return dependentInterface.cast(manager);
        }
        return null;
    }

    public static String nulled(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        return value;
    }

    public static List<String> split(String value) {
        String[] parts;
        ArrayList<String> values = new ArrayList<String>();
        if (value == null) {
            return values;
        }
        for (String part : parts = value.split(",")) {
            if ((part = part.trim()).isEmpty()) continue;
            values.add(part);
        }
        return values;
    }

    public static String defaultString(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    public static List<String> trim(String[] array) {
        ArrayList<String> trimmed = new ArrayList<String>();
        for (String s : array) {
            if (s == null || (s = s.trim()).isEmpty()) continue;
            trimmed.add(s);
        }
        return trimmed;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean doYouSupportSharedEnvironments() {
        return false;
    }
}

